/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.doi.osti;

import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.osti_elink.OSTIElinkErrorAgent;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OstiErrorEmailAgent
implements OSTIElinkErrorAgent {
    private static String emailPreamble = "Dear operators:\n\nMetacat got the following error message when it interacted with the OSTI ELink Service.\n\n";
    private static String mailSubject = "OSTI Errors";
    private static String timeFormatPattern = "EEE, d MMM yyyy HH:mm:ss z";
    private static Log logMetacat = LogFactory.getLog(OstiErrorEmailAgent.class);
    private static String server = null;
    private static String smtpHost = null;
    private static int port = 587;
    private static String toMail = null;
    private static String fromMail = null;
    private static Session session = null;
    private static SimpleDateFormat dateFormat = null;

    public OstiErrorEmailAgent() {
        try {
            server = PropertyService.getProperty("server.name");
            smtpHost = PropertyService.getProperty("guid.doi.mail.smtp.host");
            toMail = PropertyService.getProperty("guid.doi.mail.to");
            fromMail = PropertyService.getProperty("guid.doi.mail.from");
            port = new Integer(PropertyService.getProperty("guid.doi.mail.smtp.port"));
        }
        catch (PropertyNotFoundException e) {
            logMetacat.error((Object)("OstiEmailErorrAgent.constructor - can't find the property " + e.getMessage()));
        }
        catch (NumberFormatException e) {
            logMetacat.error((Object)("OstiEmailErorrAgent.constructor - can't transform the port configuration to a number: " + e.getMessage()));
        }
        Properties props = System.getProperties();
        props.put("mail.smtp.host", smtpHost);
        props.put("mail.smtp.port", (Object)port);
        session = Session.getDefaultInstance((Properties)props);
        dateFormat = new SimpleDateFormat(timeFormatPattern);
    }

    public void notify(String error) {
        try {
            String serverMessage = "Server: " + server + "\n\n";
            String body = emailPreamble + serverMessage + error;
            MimeMessage msg = new MimeMessage(session);
            msg.addHeader("Content-type", "text/HTML; charset=UTF-8");
            msg.addHeader("format", "flowed");
            msg.addHeader("Content-Transfer-Encoding", "8bit");
            msg.setFrom((Address)new InternetAddress(fromMail));
            msg.setSubject(mailSubject + " from " + server + " at " + dateFormat.format(new Date()), "UTF-8");
            msg.setText(body, "UTF-8");
            msg.setSentDate(new Date());
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)toMail, (boolean)false));
            Transport.send((Message)msg);
        }
        catch (Exception ee) {
            logMetacat.error((Object)("OstiEmailErorrAgent.notify - Metacat got the error message from OSTI: " + error));
            logMetacat.error((Object)("OstiEmailErorrAgent.notify - can't send out emails with the above message since " + ee.getMessage()));
        }
    }
}

