/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.lsid;

import com.ibm.lsid.LSID;
import com.ibm.lsid.MalformedLSIDException;
import com.ibm.lsid.MetadataResponse;
import com.ibm.lsid.server.LSIDMetadataService;
import com.ibm.lsid.server.LSIDRequestContext;
import com.ibm.lsid.server.LSIDServerException;
import com.ibm.lsid.server.LSIDServiceConfig;
import edu.ucsb.nceas.metacat.client.Metacat;
import edu.ucsb.nceas.metacat.client.MetacatFactory;
import edu.ucsb.nceas.metacat.client.MetacatInaccessibleException;
import edu.ucsb.nceas.metacat.lsid.LSIDDataLookup;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xalan.extensions.XSLProcessorContext;
import org.apache.xalan.templates.ElemExtensionCall;

public class LSIDAuthorityMetaData
implements LSIDMetadataService {
    private LSIDDataLookup lookup = null;
    private static Hashtable currentLSIDs = new Hashtable();
    private static Log logger = LogFactory.getLog((String)"edu.ucsb.nceas.metacat.lsid");
    private static final String RDF_NS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final String DC_NS = "http://purl.org/dc/elements/1.1/";
    private static final String I3CP_NS = "urn:lsid:i3c.org:predicates:";
    private static final String I3C_CONTENT = "urn:lsid:i3c.org:types:content";
    private static final String DEFAULT_STYLESHEET = "default.xslt";

    public void initService(LSIDServiceConfig cf) throws LSIDServerException {
        logger.info((Object)"Starting LSIDAuthorityMetadata.");
        this.lookup = new LSIDDataLookup();
    }

    public MetadataResponse getMetadata(LSIDRequestContext req, String[] formats) throws LSIDServerException {
        LSID lsid = req.getLsid();
        ByteArrayInputStream theMetadata = this.doMetadataRequest(lsid);
        return new MetadataResponse((Object)theMetadata, null, "application/xml+rdf");
    }

    private ByteArrayInputStream doMetadataRequest(LSID lsid) throws LSIDServerException {
        logger.debug((Object)("getting metadata for lsid " + lsid.getLsid()));
        try {
            LSIDDataLookup myLookup = new LSIDDataLookup();
            InputStream content = myLookup.lsidData(lsid);
            InputStream content2 = myLookup.lsidData(lsid);
            if (!this.isEML(content2)) {
                content = this.getEML(lsid);
            }
            content2.close();
            LSIDAuthorityMetaData.setCurrentLSID(lsid);
            String styleSheetName = null;
            String _docType = myLookup.getDocType(lsid);
            try {
                ResourceBundle rb = ResourceBundle.getBundle("metacat-lsid");
                styleSheetName = rb.getString(_docType.replaceAll(":", ""));
            }
            catch (MissingResourceException mre) {
                logger.warn((Object)("there is no style corresponding to: '" + _docType + "' -- using default"));
                styleSheetName = DEFAULT_STYLESHEET;
                mre.getMessage();
            }
            InputStream styleSheet = this.getClass().getResourceAsStream(styleSheetName);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(new StreamSource(styleSheet));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            transformer.transform(new StreamSource(content), new StreamResult(out));
            content.close();
            LSIDAuthorityMetaData.clearState();
            return new ByteArrayInputStream(out.toByteArray());
        }
        catch (Exception e) {
            throw new LSIDServerException(e, "Error transforming XML for: " + lsid);
        }
    }

    public static String getStringFromInputStream(InputStream input) {
        StringBuffer result = new StringBuffer();
        BufferedReader in = new BufferedReader(new InputStreamReader(input));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
        }
        catch (IOException e) {
            logger.error((Object)("IOexception " + e));
        }
        return result.toString();
    }

    private boolean isEML(InputStream input) {
        if (input == null) {
            return false;
        }
        boolean itIsEML = false;
        String line = "";
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(input));
            for (int loop = 0; loop < 20 && line != null && !itIsEML; ++loop) {
                line = in.readLine();
                if ((line = line.toLowerCase()).indexOf("eml:eml") == -1) continue;
                itIsEML = true;
            }
        }
        catch (IOException e) {
            logger.error((Object)("ioerror in LSIDAuthorityMetadata: " + e));
        }
        return itIsEML;
    }

    private InputStream getEML(LSID theLSID) {
        InputStream response = null;
        String theQuery = this.getMetaCatQuery(theLSID);
        Reader metaCatResponse = this.getMetaCatResponse(theQuery);
        response = this.parseMetaCatResponse(metaCatResponse, theLSID);
        return response;
    }

    private String getMetaCatQuery(LSID lsid) {
        logger.debug((Object)("getting Metacat Query for: " + lsid.toString()));
        String ns = lsid.getNamespace();
        String id = lsid.getObject();
        String ver = lsid.getRevision();
        String theName = ns + "." + id + "." + ver;
        String theQuery = null;
        theQuery = "<?xml version=\"1.0\"?>\n<pathquery version=\"1.2\">\n  <querytitle>" + theName + " search</querytitle>\n  <returnfield>dataset/docid</returnfield>\n  <returnfield>dataset/title</returnfield>\n  <querygroup operator=\"UNION\">\n    <queryterm searchmode=\"contains\" casesensitive=\"false\">\n      <value>" + theName + "</value>\n      <pathexpr>anyfield</pathexpr>\n    </queryterm>\n  </querygroup>\n<pathquery>\n";
        return theQuery;
    }

    private Reader getMetaCatResponse(String query) {
        logger.debug((Object)"Querying the metacat server.");
        ResourceBundle rb = ResourceBundle.getBundle("metacat-lsid");
        String url = rb.getString("metacatserver");
        Reader r = null;
        try {
            Metacat m = MetacatFactory.createMetacatConnection(url);
            r = m.query(new StringReader(query));
        }
        catch (MetacatInaccessibleException mie) {
            logger.error((Object)("Metacat Inaccessible:\n" + mie.getMessage()));
        }
        catch (Exception e) {
            logger.error((Object)("General exception:\n" + e.getMessage()));
        }
        return r;
    }

    private InputStream parseMetaCatResponse(Reader reader, LSID theLSID) {
        ByteArrayInputStream response = null;
        logger.debug((Object)"Parsing the metacat response.");
        String contents = this.getStringFromReader(reader);
        response = this.numberDocuments(contents) < 1 ? this.noMetaDataResponse(theLSID) : (this.numberDocuments(contents) > 1 ? this.metaDataList(contents, theLSID) : this.getMetaData(contents, theLSID));
        return response;
    }

    private ByteArrayInputStream noMetaDataResponse(LSID theLSID) {
        ResourceBundle rb = ResourceBundle.getBundle("metacat-lsid");
        String metadataLabels = rb.getString("metadatalabels");
        String result = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" \n\txmlns:dc=\"http://purl.org/dc/elements/1.1/\" \n\txmlns:pred=\"urn:lsid:i3c.org:predicates:\" xmlns=\"urn:lsid:" + metadataLabels + ":predicates:\"> \n<rdf:Description rdf:about=\"" + theLSID.getLsid() + "\"> \n\t<pred:title xmlns:pred=\"http://purl.org/dc/elements/1.1/\">There is no metadata for this LSID.</pred:title>\n</rdf:Description>\n</rdf:RDF>\n";
        ByteArrayInputStream resultBytes = null;
        try {
            resultBytes = new ByteArrayInputStream(result.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return resultBytes;
    }

    private ByteArrayInputStream metaDataList(String contents, LSID theLSID) {
        ResourceBundle rb = ResourceBundle.getBundle("metacat");
        String metadataLabels = rb.getString("metadatalabels");
        String result = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" \n\txmlns:dc=\"http://purl.org/dc/elements/1.1/\" \n\txmlns:pred=\"urn:lsid:i3c.org:predicates:\" xmlns=\"urn:lsid:" + metadataLabels + ":predicates:\"> \n<rdf:Description rdf:about=\"" + theLSID.getLsid() + "\"> \n\t<pred:title xmlns:pred=\"http://purl.org/dc/elements/1.1/\">There is more than one metadata document for this LSID - which confuses me right now.  Try again soon and I'll be less confused.</pred:title>\n</rdf:Description>\n</rdf:RDF>\n";
        ByteArrayInputStream resultBytes = null;
        try {
            resultBytes = new ByteArrayInputStream(result.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return resultBytes;
    }

    private ByteArrayInputStream getMetaData(String contents, LSID theLSID) {
        String paramString = "<param name=\"dataset/title\">";
        ByteArrayInputStream result = null;
        if (contents.indexOf(paramString) == -1) {
            return this.noMetaDataResponse(theLSID);
        }
        String[] parts = contents.split(paramString);
        String[] parts2 = parts[1].split("</param>");
        try {
            LSID newLSID = new LSID(parts2[0]);
            result = this.doMetadataRequest(newLSID);
        }
        catch (MalformedLSIDException e) {
            logger.error((Object)("problem generating LSID: " + (Object)((Object)e)));
            e.printStackTrace();
        }
        catch (LSIDServerException e) {
            logger.error((Object)("problem generating LSID: " + (Object)((Object)e)));
            e.printStackTrace();
        }
        return result;
    }

    private int numberDocuments(String contents) {
        String[] docSplit = contents.split("<document>");
        return docSplit.length - 1;
    }

    private String getStringFromReader(Reader reader) {
        StringBuffer response = new StringBuffer();
        try {
            BufferedReader bufReader = new BufferedReader(reader);
            String line = null;
            while ((line = bufReader.readLine()) != null) {
                response.append(line);
            }
            bufReader.close();
        }
        catch (IOException e) {
            logger.error((Object)("error getting string from reader " + e));
        }
        return response.toString();
    }

    static void setCurrentLSID(LSID lsid) {
        currentLSIDs.put(Thread.currentThread(), lsid);
    }

    static void clearState() {
        currentLSIDs.remove(Thread.currentThread());
    }

    public static String getLSID(XSLProcessorContext foo, ElemExtensionCall bar) throws MalformedLSIDException {
        return ((LSID)currentLSIDs.get(Thread.currentThread())).toString();
    }

    public static String getLSID() throws MalformedLSIDException {
        return ((LSID)currentLSIDs.get(Thread.currentThread())).toString();
    }
}

