/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.oaipmh.harvester;

import edu.ucsb.nceas.metacat.client.InsufficientKarmaException;
import edu.ucsb.nceas.metacat.client.Metacat;
import edu.ucsb.nceas.metacat.client.MetacatException;
import edu.ucsb.nceas.metacat.client.MetacatFactory;
import edu.ucsb.nceas.metacat.client.MetacatInaccessibleException;
import edu.ucsb.nceas.metacat.oaipmh.harvester.GetRecord;
import edu.ucsb.nceas.metacat.oaipmh.harvester.ListIdentifiers;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.BasicConfigurator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class OaipmhHarvester {
    private static final String METACAT_CONFIG_DIR = "../../build/war/WEB-INF";
    private static HashMap<String, String> metacatDatestamps = new HashMap();
    private static HashMap<String, Integer> metacatRevisions = new HashMap();
    private static Metacat metacatClient = null;
    private static String metacatURL = null;
    private static Log logger = LogFactory.getLog(OaipmhHarvester.class);
    private static final String METACAT_QUERY = "SELECT docid, rev, date_updated FROM xml_documents";

    private static String docidFromDryadIdentifier(String dryadID) {
        String docid = null;
        String scopeAndIdentifier = null;
        String scope = null;
        String identifier = null;
        StringTokenizer stringTokenizer = new StringTokenizer(dryadID, ":");
        String token = null;
        int tokenCount = stringTokenizer.countTokens();
        int i = 1;
        while (stringTokenizer.hasMoreTokens()) {
            token = stringTokenizer.nextToken();
            if (i == tokenCount) {
                scopeAndIdentifier = token;
            }
            ++i;
        }
        if (scopeAndIdentifier != null) {
            stringTokenizer = new StringTokenizer(scopeAndIdentifier, ".");
            tokenCount = stringTokenizer.countTokens();
            if (tokenCount == 2) {
                i = 1;
                while (stringTokenizer.hasMoreTokens()) {
                    token = stringTokenizer.nextToken();
                    if (i == tokenCount - 1) {
                        scope = token;
                    }
                    if (i == tokenCount) {
                        identifier = token;
                    }
                    ++i;
                }
            } else {
                logger.error((Object)("Error parsing Dryad identifier: " + dryadID));
            }
        }
        if (scope != null && identifier != null) {
            scope = scope.replace('/', '-');
            docid = scope + "." + identifier;
        }
        return docid;
    }

    private static String docidFromIdentifier(String identifier) {
        String docid = null;
        if (identifier != null) {
            if (identifier.startsWith("urn:lsid:")) {
                docid = OaipmhHarvester.docidFromLSID(identifier);
            } else if (identifier.contains("/dryad.")) {
                docid = OaipmhHarvester.docidFromDryadIdentifier(identifier);
            }
        }
        return docid;
    }

    private static String docidFromLSID(String lsidIdentifier) {
        String docid = null;
        String scope = null;
        String identifier = null;
        StringTokenizer stringTokenizer = new StringTokenizer(lsidIdentifier, ":");
        int tokenCount = stringTokenizer.countTokens();
        int i = 1;
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            if (i == tokenCount - 1) {
                scope = token;
            }
            if (i == tokenCount) {
                identifier = token;
            }
            ++i;
        }
        if (scope != null && identifier != null) {
            docid = scope + "." + identifier;
        }
        return docid;
    }

    private static String extractMetadata(String getRecordString) {
        String metadataString = null;
        StringBuffer stringBuffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        int metadataStartIndex = getRecordString.indexOf("<metadata>");
        int metadataEndIndex = getRecordString.indexOf("</metadata>");
        if (metadataStartIndex >= 0 && metadataEndIndex >= 0 && metadataStartIndex < metadataEndIndex) {
            int startPosition = metadataStartIndex + "<metadata>".length();
            int endPosition = metadataEndIndex;
            String docString = getRecordString.substring(startPosition, endPosition);
            stringBuffer.append(docString);
            stringBuffer.append("\n");
            metadataString = stringBuffer.toString();
        }
        return metadataString;
    }

    private static Connection getConnection() {
        Connection conn = null;
        String dbDriver = "";
        String defaultDB = null;
        String password = null;
        String user = null;
        if (conn == null) {
            try {
                dbDriver = PropertyService.getProperty("database.driver");
                defaultDB = PropertyService.getProperty("database.connectionURI");
                password = PropertyService.getProperty("database.password");
                user = PropertyService.getProperty("database.user");
            }
            catch (PropertyNotFoundException pnfe) {
                logger.error((Object)("Can't find database connection property " + (Object)((Object)pnfe)));
                System.exit(1);
            }
            try {
                Class.forName(dbDriver);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)("Can't load driver " + e));
                System.exit(1);
            }
            try {
                SQLWarning warn;
                conn = DriverManager.getConnection(defaultDB, user, password);
                if (warn != null) {
                    for (warn = conn.getWarnings(); warn != null; warn = warn.getNextWarning()) {
                        logger.warn((Object)("SQLState: " + warn.getSQLState()));
                        logger.warn((Object)("Message:  " + warn.getMessage()));
                        logger.warn((Object)("Vendor: " + warn.getErrorCode()));
                    }
                }
            }
            catch (SQLException e) {
                logger.error((Object)("Database access failed " + e));
                System.exit(1);
            }
        }
        return conn;
    }

    private static HashMap<String, String> getOptions(String[] args) {
        HashMap<String, String> options = new HashMap<String, String>();
        boolean foundDN = false;
        boolean foundPassword = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) != '-') {
                options.put("baseURL", args[i]);
                continue;
            }
            if (i + 1 < args.length) {
                if (args[i].equals("-dn")) {
                    foundDN = true;
                }
                if (args[i].equals("-password")) {
                    foundPassword = true;
                }
                options.put(args[i], args[++i]);
                continue;
            }
            throw new IllegalArgumentException();
        }
        if (!foundDN || !foundPassword) {
            throw new IllegalArgumentException();
        }
        return options;
    }

    private static boolean isDeletedRecord(String getRecordString) {
        boolean isDeleted = false;
        String DELETED_FLAG_1 = "status=\"deleted\"";
        String DELETED_FLAG_2 = "status='deleted'";
        if (getRecordString != null && (getRecordString.contains("status=\"deleted\"") || getRecordString.contains("status='deleted'")) && !getRecordString.contains("<metadata>")) {
            isDeleted = true;
        }
        return isDeleted;
    }

    private static void loadMetacatCatalog() {
        try {
            Connection conn = OaipmhHarvester.getConnection();
            if (conn != null) {
                Statement stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery(METACAT_QUERY);
                while (rs.next()) {
                    String docid = rs.getString("docid");
                    String dateUpdated = rs.getDate("date_updated").toString();
                    int rev = rs.getInt("rev");
                    Integer revInteger = new Integer(rev);
                    metacatDatestamps.put(docid, dateUpdated);
                    metacatRevisions.put(docid, revInteger);
                }
                stmt.close();
                conn.close();
            }
        }
        catch (SQLException e) {
            metacatDatestamps = null;
            metacatRevisions = null;
            logger.error((Object)("SQLException: " + e.getMessage()));
        }
    }

    private static void loadProperties(String metacatConfigDir) {
        try {
            PropertyService.getInstance(metacatConfigDir);
        }
        catch (ServiceException e) {
            logger.error((Object)("Error in loading properties: " + e.getMessage()));
        }
    }

    public static void main(String[] args) {
        try {
            HashMap<String, String> options = OaipmhHarvester.getOptions(args);
            String baseURL = options.get("baseURL");
            String dn = options.get("-dn");
            String password = options.get("-password");
            String from = options.get("-from");
            String until = options.get("-until");
            String metadataPrefix = options.get("-metadataPrefix");
            String metacatConfigDir = options.get("-metacatConfigDir");
            String setSpec = options.get("-setSpec");
            if (metadataPrefix == null) {
                metadataPrefix = "oai_dc";
            }
            if (metacatConfigDir == null) {
                metacatConfigDir = METACAT_CONFIG_DIR;
            }
            OaipmhHarvester.loadProperties(metacatConfigDir);
            metacatURL = SystemUtil.getServletURL();
            metacatClient = MetacatFactory.createMetacatConnection(metacatURL);
            OaipmhHarvester.loadMetacatCatalog();
            if (metacatURL != null && metacatClient != null && metacatDatestamps != null) {
                OaipmhHarvester.run(baseURL, dn, password, from, until, metadataPrefix, setSpec);
            } else {
                logger.error((Object)"Unable to load document catalog from Metacat database.");
            }
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)"OaipmhHarvester -dn distinguished_name -password password <-from date> <-until date> <-metadataPrefix prefix> <-setSpec setName> baseURL");
        }
        catch (MetacatInaccessibleException e) {
            logger.error((Object)("MetacatInaccessibleException:\n" + e.getMessage()));
        }
        catch (PropertyNotFoundException e) {
            logger.error((Object)"PropertyNotFoundException: unable to determine metacat URL from SystemUtil.getServletURL()");
        }
        catch (IOException e) {
            logger.error((Object)("Error reading EML document from metacat:\n" + e.getMessage()));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private static String metacatDatestamp(String docid) {
        String metacatDatestamp = metacatDatestamps.get(docid);
        return metacatDatestamp;
    }

    private static boolean metacatHasDocid(String docid) {
        boolean hadDocid = false;
        String metacatDatestamp = OaipmhHarvester.metacatDatestamp(docid);
        if (metacatDatestamp != null) {
            hadDocid = true;
        }
        return hadDocid;
    }

    private static boolean metacatLogin(String ldapDN, String ldapPwd) {
        boolean loginSuccess = false;
        try {
            logger.info((Object)("Logging in to Metacat: " + ldapDN));
            String response = metacatClient.login(ldapDN, ldapPwd);
            logger.info((Object)("Metacat login response: " + response));
            loginSuccess = true;
        }
        catch (MetacatInaccessibleException e) {
            logger.error((Object)("Metacat login failed." + e.getMessage()));
        }
        catch (Exception e) {
            logger.error((Object)("Metacat login failed." + e.getMessage()));
        }
        return loginSuccess;
    }

    private static void metacatLogout() {
        try {
            logger.info((Object)"Logging out from Metacat");
            metacatClient.logout();
        }
        catch (MetacatInaccessibleException e) {
            logger.error((Object)("Metacat inaccessible: " + e.getMessage()));
        }
        catch (MetacatException e) {
            logger.error((Object)("Metacat exception: " + e.getMessage()));
        }
    }

    private static Integer metacatRevision(String docid) {
        Integer metacatRevision = metacatRevisions.get(docid);
        return metacatRevision;
    }

    private static void processListIdentifiers(String baseURL, String from, String until, String metadataPrefix, String setSpec, String xmlString, String principal) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        StringReader stringReader = new StringReader(xmlString);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(stringReader);
            Document document = documentBuilder.parse(inputSource);
            Element rootElement = document.getDocumentElement();
            NodeList nodeList = rootElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element childElement;
                Node child = nodeList.item(i);
                if (!(child instanceof Element) || !(childElement = (Element)child).getTagName().equals("ListIdentifiers")) continue;
                NodeList listIdentifiersNodeList = childElement.getChildNodes();
                for (int j = 0; j < listIdentifiersNodeList.getLength(); ++j) {
                    Element listIdentifiersElement;
                    Node listIdentifiersNode = listIdentifiersNodeList.item(j);
                    if (!(listIdentifiersNode instanceof Element) || !(listIdentifiersElement = (Element)listIdentifiersNode).getTagName().equals("header")) continue;
                    NodeList headerNodeList = listIdentifiersElement.getChildNodes();
                    String identifier = null;
                    String datestamp = null;
                    for (int k = 0; k < headerNodeList.getLength(); ++k) {
                        Text textNode;
                        Node headerNode = headerNodeList.item(k);
                        if (!(headerNode instanceof Element)) continue;
                        Element headerElement = (Element)headerNode;
                        if (headerElement.getTagName().equals("identifier")) {
                            textNode = (Text)headerElement.getFirstChild();
                            identifier = textNode.getData().trim();
                            continue;
                        }
                        if (!headerElement.getTagName().equals("datestamp")) continue;
                        textNode = (Text)headerElement.getFirstChild();
                        datestamp = textNode.getData().trim();
                    }
                    if (identifier == null) continue;
                    String docid = OaipmhHarvester.docidFromIdentifier(identifier);
                    logger.debug((Object)("identifier: " + identifier + "; docid: " + docid + "; datestamp: " + datestamp));
                    if (docid != null) {
                        if (OaipmhHarvester.shouldHarvestDocument(docid, datestamp)) {
                            GetRecord getRecord = new GetRecord(baseURL, identifier, metadataPrefix);
                            getRecord.runVerb();
                            NodeList errors = getRecord.getErrors();
                            if (errors != null && errors.getLength() > 0) {
                                logger.error((Object)"Found errors in GetRecord results");
                                int length = errors.getLength();
                                for (int l = 0; l < length; ++l) {
                                    Node item = errors.item(l);
                                    logger.error((Object)item);
                                }
                                logger.error((Object)("Error record: " + getRecord.toString()));
                                continue;
                            }
                            String getRecordString = getRecord.toString();
                            boolean isDeleted = OaipmhHarvester.isDeletedRecord(getRecordString);
                            if (isDeleted) {
                                logger.info((Object)("GetRecord indicates deleted record: " + docid));
                                if (!OaipmhHarvester.metacatHasDocid(docid)) continue;
                                logger.info((Object)("Deleting " + docid + " from Metacat."));
                                String deleteReturnString = null;
                                deleteReturnString = metacatClient.delete(docid);
                                if (deleteReturnString == null || deleteReturnString.equals("")) continue;
                                logger.info((Object)deleteReturnString);
                                continue;
                            }
                            String metadataString = OaipmhHarvester.extractMetadata(getRecordString);
                            OaipmhHarvester.uploadToMetacat(docid, datestamp, metadataString, principal);
                            continue;
                        }
                        logger.info((Object)("Not harvesting docid '" + docid + "' from the OAI-PMH provider. Metacat already has this document at datestamp '" + datestamp + "' or higher."));
                        continue;
                    }
                    logger.warn((Object)("Unrecognized identifier format: " + identifier));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("General exception:\n" + e.getMessage()));
            e.printStackTrace();
        }
    }

    public static void run(String baseURL, String dn, String password, String from, String until, String metadataPrefix, String setSpec) throws IOException, ParserConfigurationException, SAXException, TransformerException, NoSuchFieldException {
        logger.info((Object)"Starting OAI-PMH Harvester.");
        if (dn != null && password != null) {
            boolean loginSuccess = OaipmhHarvester.metacatLogin(dn, password);
            if (!loginSuccess) {
                logger.warn((Object)"Terminating OAI-PMH Harvester execution due to login failure.");
                return;
            }
        } else {
            logger.error((Object)"Distinguished name (-dn) and/or password (-password) were not specified.");
            return;
        }
        ListIdentifiers listIdentifiers = new ListIdentifiers(baseURL, from, until, metadataPrefix, setSpec);
        listIdentifiers.runVerb();
        while (listIdentifiers != null) {
            NodeList errors = listIdentifiers.getErrors();
            if (errors != null && errors.getLength() > 0) {
                logger.error((Object)"Found errors in ListIdentifier results");
                int length = errors.getLength();
                for (int i = 0; i < length; ++i) {
                    Node item = errors.item(i);
                    logger.error((Object)item);
                }
                logger.error((Object)("Error record: " + listIdentifiers.toString()));
                break;
            }
            String xmlString = listIdentifiers.toString();
            OaipmhHarvester.processListIdentifiers(baseURL, from, until, metadataPrefix, setSpec, xmlString, dn);
            String resumptionToken = listIdentifiers.getResumptionToken();
            logger.debug((Object)("resumptionToken: " + resumptionToken));
            if (resumptionToken == null || resumptionToken.length() == 0) {
                listIdentifiers = null;
                continue;
            }
            listIdentifiers = new ListIdentifiers(baseURL, resumptionToken);
            listIdentifiers.runVerb();
        }
        OaipmhHarvester.metacatLogout();
        logger.info((Object)"Harvest completed. Shutting down OAI-PMH Harvester.");
    }

    private static boolean shouldHarvestDocument(String docid, String providerTimestamp) {
        String providerDatestamp;
        boolean shouldHarvest = false;
        String metacatDatestamp = OaipmhHarvester.metacatDatestamp(docid);
        if (providerTimestamp.contains("T")) {
            int tIndex = providerTimestamp.indexOf(84);
            providerDatestamp = providerTimestamp.substring(0, tIndex);
        } else {
            providerDatestamp = providerTimestamp;
        }
        if (metacatDatestamp == null) {
            shouldHarvest = true;
        } else if (metacatDatestamp.compareTo(providerDatestamp) < 0) {
            shouldHarvest = true;
        }
        return shouldHarvest;
    }

    private static boolean uploadToMetacat(String docid, String datestamp, String metadataString, String principal) {
        String docidFull = null;
        boolean success = true;
        String metacatDatestamp = OaipmhHarvester.metacatDatestamp(docid);
        Integer metacatRevision = OaipmhHarvester.metacatRevision(docid);
        boolean insert = false;
        StringReader stringReader = null;
        boolean update = false;
        if (metadataString != null) {
            int newRevision;
            stringReader = new StringReader(metadataString);
            if (metacatDatestamp == null) {
                insert = true;
                newRevision = 1;
                docidFull = docid + "." + newRevision;
            } else if (metacatDatestamp.compareTo(datestamp) < 0) {
                update = true;
                newRevision = metacatRevision + 1;
                docidFull = docid + "." + newRevision;
            } else if (metacatDatestamp.compareTo(datestamp) == 0) {
                logger.warn((Object)("Attempting to update " + docid + " to datestamp " + datestamp + ". Metacat has document at datestamp " + metacatDatestamp + "."));
            }
            if (insert || update) {
                String metacatReturnString = "";
                String accessReturnString = "";
                try {
                    if (insert) {
                        logger.info((Object)("Inserting document: " + docidFull));
                        metacatReturnString = metacatClient.insert(docidFull, stringReader, null);
                        String permission = "all";
                        String permType = "allow";
                        String permOrder = "allowFirst";
                        accessReturnString = metacatClient.setAccess(docid, principal, permission, permType, permOrder);
                        if (accessReturnString != null && !accessReturnString.equals("")) {
                            logger.info((Object)accessReturnString);
                        }
                        if ((accessReturnString = metacatClient.setAccess(docid, "public", permission = "read", permType, permOrder)) != null && !accessReturnString.equals("")) {
                            logger.info((Object)accessReturnString);
                        }
                    } else if (update) {
                        logger.info((Object)("Updating document: " + docidFull));
                        metacatReturnString = metacatClient.update(docidFull, stringReader, null);
                    }
                    if (metacatReturnString != null && !metacatReturnString.equals("")) {
                        logger.info((Object)metacatReturnString);
                    }
                }
                catch (MetacatInaccessibleException e) {
                    logger.error((Object)("MetacatInaccessibleException: " + e.getMessage()));
                }
                catch (InsufficientKarmaException e) {
                    logger.error((Object)("InsufficientKarmaException: " + e.getMessage()));
                }
                catch (MetacatException e) {
                    logger.error((Object)("MetacatException: " + e.getMessage()));
                }
                catch (IOException e) {
                    logger.error((Object)("IOException: " + e.getMessage()));
                }
            }
        }
        return success;
    }

    static {
        BasicConfigurator.configure();
    }
}

