/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.oaipmh.provider.server.catalog;

import ORG.oclc.oai.server.catalog.AbstractCatalog;
import ORG.oclc.oai.server.catalog.RecordFactory;
import ORG.oclc.oai.server.verb.BadResumptionTokenException;
import ORG.oclc.oai.server.verb.CannotDisseminateFormatException;
import ORG.oclc.oai.server.verb.IdDoesNotExistException;
import ORG.oclc.oai.server.verb.NoItemsMatchException;
import ORG.oclc.oai.server.verb.NoMetadataFormatsException;
import ORG.oclc.oai.server.verb.NoSetHierarchyException;
import ORG.oclc.oai.server.verb.OAIInternalServerError;
import edu.ucsb.nceas.metacat.client.DocumentNotFoundException;
import edu.ucsb.nceas.metacat.client.InsufficientKarmaException;
import edu.ucsb.nceas.metacat.client.Metacat;
import edu.ucsb.nceas.metacat.client.MetacatException;
import edu.ucsb.nceas.metacat.client.MetacatFactory;
import edu.ucsb.nceas.metacat.client.MetacatInaccessibleException;
import edu.ucsb.nceas.metacat.oaipmh.provider.server.OAIHandler;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.IOUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MetacatCatalog
extends AbstractCatalog {
    private static final Log logger = LogFactory.getLog(MetacatCatalog.class);
    private static String refreshDate = null;
    private static String metacatDBDriver;
    private static String metacatDBURL;
    private static String metacatDBUser;
    private static String metacatDBPassword;
    private static String metacatURL;
    protected String homeDir;
    private HashMap<String, String> dateMap = new HashMap();
    private HashMap<String, String> filteredDateMap = null;
    private HashMap<String, String> docTypeMap = new HashMap();
    private HashMap resumptionResults = new HashMap();
    private int maxListSize;
    private final String QUERY = "SELECT xd.docid, xd.doctype, xd.date_updated FROM xml_documents xd, identifier id WHERE xd.doctype like '%ecoinformatics.org/eml-2%'  AND xd.docid = id.docid  AND xd.rev = id.rev  AND id.guid IN      (SELECT guid      FROM xml_access \t\tWHERE lower(principal_name) = 'public'  \tAND perm_type = 'allow'  \tAND permission > 3\t\t)  AND id.guid NOT IN      (SELECT guid      FROM xml_access      WHERE lower(principal_name) = 'public' \t\tAND perm_type = 'deny' \t\tAND perm_order ='allowFirst' \t\tAND permission > 3      ) ";

    public MetacatCatalog(Properties properties) {
        String temp = properties.getProperty("oaipmh.maxListSize");
        if (temp == null) {
            String errorStr = "oaipmh.maxListSize is missing from the properties file";
            throw new IllegalArgumentException(errorStr);
        }
        this.maxListSize = Integer.parseInt(temp);
        metacatDBDriver = properties.getProperty("database.driver");
        metacatDBURL = properties.getProperty("database.connectionURI");
        metacatDBUser = properties.getProperty("database.user");
        metacatDBPassword = properties.getProperty("database.password");
        try {
            metacatURL = OAIHandler.isIntegratedWithMetacat() ? SystemUtil.getServletURL() : SystemUtil.getServletURL();
            logger.warn((Object)("metacatURL: " + metacatURL));
        }
        catch (PropertyNotFoundException e) {
            logger.error((Object)"PropertyNotFoundException: unable to determine metacat URL from SystemUtil.getServletURL()");
        }
        this.loadCatalog();
    }

    private static synchronized String getRSName() {
        Date now = new Date();
        return Long.toString(now.getTime());
    }

    public void close() {
    }

    private String constructRecord(HashMap nativeItem, String metadataPrefix) throws CannotDisseminateFormatException {
        String schemaURL = null;
        Iterator setSpecs = this.getSetSpecs(nativeItem);
        Iterator abouts = this.getAbouts(nativeItem);
        if (metadataPrefix != null && (schemaURL = this.getCrosswalks().getSchemaURL(metadataPrefix)) == null) {
            throw new CannotDisseminateFormatException(metadataPrefix);
        }
        RecordFactory recordFactory = this.getRecordFactory();
        String recordString = recordFactory.create((Object)nativeItem, schemaURL, metadataPrefix, setSpecs, abouts);
        return recordString;
    }

    private HashMap<String, String> filterDateMap(String from, String until, String metadataPrefix) {
        if (this.shouldRefreshCatalog()) {
            this.loadCatalog();
        }
        HashMap<String, String> aDateMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entryDateMap : this.dateMap.entrySet()) {
            String docid;
            HashMap<String, String> nativeHeader;
            String doctype;
            String dateUpdated = entryDateMap.getValue();
            if (dateUpdated.compareTo(from) < 0 || dateUpdated.compareTo(until) > 0 || !this.isIncludedDoctype(doctype = (nativeHeader = this.getNativeHeader(docid = entryDateMap.getKey())).get("doctype"), metadataPrefix)) continue;
            aDateMap.put(docid, dateUpdated);
        }
        return aDateMap;
    }

    private Iterator getAbouts(HashMap nativeItem) {
        return null;
    }

    public Connection getConnection() {
        Connection conn = null;
        try {
            Class.forName(metacatDBDriver);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("Can't load driver " + e));
            return conn;
        }
        try {
            SQLWarning warn;
            conn = DriverManager.getConnection(metacatDBURL, metacatDBUser, metacatDBPassword);
            if (warn != null) {
                for (warn = conn.getWarnings(); warn != null; warn = warn.getNextWarning()) {
                    logger.warn((Object)("SQLState: " + warn.getSQLState()));
                    logger.warn((Object)("Message:  " + warn.getMessage()));
                    logger.warn((Object)("Vendor: " + warn.getErrorCode()));
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Database access failed " + e));
        }
        return conn;
    }

    public String getMaxDateUpdated() {
        String maxDateUpdated = null;
        String query = "SELECT MAX(date_updated) AS max_date_updated FROM xml_documents";
        try {
            Connection conn = this.getConnection();
            if (conn != null) {
                Statement stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery(query);
                while (rs.next()) {
                    maxDateUpdated = rs.getDate("max_date_updated").toString();
                }
                stmt.close();
                conn.close();
            }
        }
        catch (SQLException e) {
            logger.error((Object)("SQLException: " + e.getMessage()));
        }
        return maxDateUpdated;
    }

    private HashMap<String, String> getMetacatDocument(String docid) throws IOException {
        HashMap<String, String> recordMap = this.getNativeHeader(docid);
        if (recordMap == null) {
            return null;
        }
        try {
            Metacat metacat = MetacatFactory.createMetacatConnection(metacatURL);
            InputStreamReader reader = new InputStreamReader(metacat.read(docid));
            StringBuffer stringBuffer = IOUtil.getAsStringBuffer((Reader)reader, (boolean)true);
            String emlString = stringBuffer.toString();
            recordMap.put("recordBytes", emlString);
        }
        catch (MetacatInaccessibleException e) {
            logger.error((Object)("MetacatInaccessibleException:\n" + e.getMessage()));
        }
        catch (MetacatException e) {
            logger.error((Object)("MetacatException:\n" + e.getMessage()));
        }
        catch (DocumentNotFoundException e) {
            logger.error((Object)("DocumentNotFoundException:\n" + e.getMessage()));
        }
        catch (InsufficientKarmaException e) {
            logger.error((Object)("InsufficientKarmaException:\n" + e.getMessage()));
        }
        catch (IOException e) {
            logger.error((Object)("Error reading EML document from metacat:\n" + e.getMessage()));
        }
        return recordMap;
    }

    private HashMap<String, String> getNativeHeader(String localIdentifier) {
        HashMap<String, String> recordMap = null;
        if (this.dateMap.containsKey(localIdentifier)) {
            recordMap = new HashMap<String, String>();
            recordMap.put("localIdentifier", localIdentifier);
            recordMap.put("lastModified", this.dateMap.get(localIdentifier));
            recordMap.put("doctype", this.docTypeMap.get(localIdentifier));
            return recordMap;
        }
        return recordMap;
    }

    public String getRecord(String oaiIdentifier, String metadataPrefix) throws IdDoesNotExistException, CannotDisseminateFormatException, OAIInternalServerError {
        HashMap<String, String> nativeItem = null;
        try {
            RecordFactory recordFactory = this.getRecordFactory();
            String localIdentifier = recordFactory.fromOAIIdentifier(oaiIdentifier);
            nativeItem = this.getMetacatDocument(localIdentifier);
            if (nativeItem == null) {
                throw new IdDoesNotExistException(oaiIdentifier);
            }
            return this.constructRecord(nativeItem, metadataPrefix);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new OAIInternalServerError("Database Failure");
        }
    }

    public Vector getSchemaLocations(String oaiIdentifier) throws IdDoesNotExistException, OAIInternalServerError, NoMetadataFormatsException {
        HashMap<String, String> nativeItem = null;
        try {
            String localIdentifier = this.getRecordFactory().fromOAIIdentifier(oaiIdentifier);
            nativeItem = this.getMetacatDocument(localIdentifier);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new OAIInternalServerError("Database Failure");
        }
        if (nativeItem != null) {
            RecordFactory recordFactory = this.getRecordFactory();
            return recordFactory.getSchemaLocations(nativeItem);
        }
        throw new IdDoesNotExistException(oaiIdentifier);
    }

    private Iterator getSetSpecs(HashMap nativeItem) {
        return null;
    }

    private boolean isIncludedDoctype(String doctype, String metadataPrefix) {
        boolean isIncluded = false;
        if (doctype != null && (metadataPrefix.equals("oai_dc") || doctype.contains("ecoinformatics.org/eml-") && doctype.endsWith(metadataPrefix))) {
            isIncluded = true;
        }
        return isIncluded;
    }

    protected boolean isMetadataFile(File child) {
        return true;
    }

    public Map listIdentifiers(String from, String until, String set, String metadataPrefix) throws NoItemsMatchException {
        int count;
        this.purge();
        HashMap<String, Object> listIdentifiersMap = new HashMap<String, Object>();
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> identifiers = new ArrayList<String>();
        this.filteredDateMap = this.filterDateMap(from, until, metadataPrefix);
        Iterator<Map.Entry<String, String>> iterator = this.filteredDateMap.entrySet().iterator();
        int numRows = this.filteredDateMap.entrySet().size();
        RecordFactory recordFactory = this.getRecordFactory();
        for (count = 0; count < this.maxListSize && iterator.hasNext(); ++count) {
            Map.Entry<String, String> entryDateMap = iterator.next();
            String dateUpdated = entryDateMap.getValue();
            String key = entryDateMap.getKey();
            HashMap<String, String> nativeHeader = this.getNativeHeader(key);
            String[] headerArray = recordFactory.createHeader(nativeHeader);
            String header = headerArray[0];
            headers.add(header);
            String identifier = headerArray[1];
            identifiers.add(identifier);
        }
        if (count == 0) {
            throw new NoItemsMatchException();
        }
        if (iterator.hasNext()) {
            String resumptionId = MetacatCatalog.getRSName();
            this.resumptionResults.put(resumptionId, iterator);
            StringBuffer resumptionTokenSb = new StringBuffer();
            resumptionTokenSb.append(resumptionId);
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(count));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(numRows));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(metadataPrefix);
            listIdentifiersMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), numRows, 0));
        }
        listIdentifiersMap.put("headers", headers.iterator());
        listIdentifiersMap.put("identifiers", identifiers.iterator());
        return listIdentifiersMap;
    }

    public Map listIdentifiers(String resumptionToken) throws BadResumptionTokenException {
        int count;
        String metadataPrefix;
        int numRows;
        int oldCount;
        String resumptionId;
        this.purge();
        HashMap<String, Object> listIdentifiersMap = new HashMap<String, Object>();
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> identifiers = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(resumptionToken, ":");
        try {
            resumptionId = tokenizer.nextToken();
            oldCount = Integer.parseInt(tokenizer.nextToken());
            numRows = Integer.parseInt(tokenizer.nextToken());
            metadataPrefix = tokenizer.nextToken();
        }
        catch (NoSuchElementException e) {
            throw new BadResumptionTokenException();
        }
        Iterator<Map.Entry<String, String>> iterator = (Iterator<Map.Entry<String, String>>)this.resumptionResults.remove(resumptionId);
        if (iterator == null) {
            System.out.println("MetacatCatalog.listIdentifiers(): reuse of old resumptionToken?");
            iterator = this.dateMap.entrySet().iterator();
            for (int i = 0; i < oldCount; ++i) {
                iterator.next();
            }
        }
        for (count = 0; count < this.maxListSize && iterator.hasNext(); ++count) {
            Map.Entry<String, String> entryDateMap = iterator.next();
            HashMap<String, String> nativeHeader = this.getNativeHeader(entryDateMap.getKey());
            String[] header = this.getRecordFactory().createHeader(nativeHeader);
            headers.add(header[0]);
            identifiers.add(header[1]);
        }
        if (iterator.hasNext()) {
            resumptionId = MetacatCatalog.getRSName();
            this.resumptionResults.put(resumptionId, iterator);
            StringBuffer resumptionTokenSb = new StringBuffer();
            resumptionTokenSb.append(resumptionId);
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(oldCount + count));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(numRows));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(metadataPrefix);
            listIdentifiersMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), numRows, oldCount));
        }
        listIdentifiersMap.put("headers", headers.iterator());
        listIdentifiersMap.put("identifiers", identifiers.iterator());
        return listIdentifiersMap;
    }

    public Map listRecords(String from, String until, String set, String metadataPrefix) throws CannotDisseminateFormatException, OAIInternalServerError, NoItemsMatchException {
        int count;
        this.purge();
        HashMap<String, Object> listRecordsMap = new HashMap<String, Object>();
        ArrayList<String> records = new ArrayList<String>();
        this.filteredDateMap = this.filterDateMap(from, until, metadataPrefix);
        Iterator<Map.Entry<String, String>> iterator = this.filteredDateMap.entrySet().iterator();
        int numRows = this.filteredDateMap.entrySet().size();
        for (count = 0; count < this.maxListSize && iterator.hasNext(); ++count) {
            Map.Entry<String, String> entryDateMap = iterator.next();
            try {
                String localIdentifier = entryDateMap.getKey();
                HashMap<String, String> nativeItem = this.getMetacatDocument(localIdentifier);
                String record = this.constructRecord(nativeItem, metadataPrefix);
                records.add(record);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new OAIInternalServerError(e.getMessage());
            }
        }
        if (count == 0) {
            throw new NoItemsMatchException();
        }
        if (iterator.hasNext()) {
            String resumptionId = MetacatCatalog.getRSName();
            this.resumptionResults.put(resumptionId, iterator);
            StringBuffer resumptionTokenSb = new StringBuffer();
            resumptionTokenSb.append(resumptionId);
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(count));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(numRows));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(metadataPrefix);
            listRecordsMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), numRows, 0));
        }
        listRecordsMap.put("records", records.iterator());
        return listRecordsMap;
    }

    public Map listRecords(String resumptionToken) throws BadResumptionTokenException {
        int count;
        String metadataPrefix;
        int numRows;
        int oldCount;
        String resumptionId;
        this.purge();
        HashMap<String, Object> listRecordsMap = new HashMap<String, Object>();
        ArrayList<String> records = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(resumptionToken, ":");
        try {
            resumptionId = tokenizer.nextToken();
            oldCount = Integer.parseInt(tokenizer.nextToken());
            numRows = Integer.parseInt(tokenizer.nextToken());
            metadataPrefix = tokenizer.nextToken();
        }
        catch (NoSuchElementException e) {
            throw new BadResumptionTokenException();
        }
        Iterator<Map.Entry<String, String>> iterator = (Iterator<Map.Entry<String, String>>)this.resumptionResults.remove(resumptionId);
        if (iterator == null) {
            System.out.println("MetacatCatalog.listRecords(): reuse of old resumptionToken?");
            iterator = this.dateMap.entrySet().iterator();
            for (int i = 0; i < oldCount; ++i) {
                iterator.next();
            }
        }
        for (count = 0; count < this.maxListSize && iterator.hasNext(); ++count) {
            Map.Entry<String, String> entryDateMap = iterator.next();
            try {
                String localIdentifier = entryDateMap.getKey();
                HashMap<String, String> nativeItem = this.getMetacatDocument(localIdentifier);
                String record = this.constructRecord(nativeItem, metadataPrefix);
                records.add(record);
                continue;
            }
            catch (CannotDisseminateFormatException e) {
                throw new BadResumptionTokenException();
            }
            catch (IOException e) {
                throw new BadResumptionTokenException();
            }
        }
        if (iterator.hasNext()) {
            resumptionId = MetacatCatalog.getRSName();
            this.resumptionResults.put(resumptionId, iterator);
            StringBuffer resumptionTokenSb = new StringBuffer();
            resumptionTokenSb.append(resumptionId);
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(oldCount + count));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(numRows));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(metadataPrefix);
            listRecordsMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), numRows, oldCount));
        }
        listRecordsMap.put("records", records.iterator());
        return listRecordsMap;
    }

    public Map listSets() throws NoSetHierarchyException {
        throw new NoSetHierarchyException();
    }

    public Map listSets(String resumptionToken) throws BadResumptionTokenException {
        throw new BadResumptionTokenException();
    }

    public void loadCatalog() {
        try {
            Connection conn = this.getConnection();
            if (conn != null) {
                Statement stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery("SELECT xd.docid, xd.doctype, xd.date_updated FROM xml_documents xd, identifier id WHERE xd.doctype like '%ecoinformatics.org/eml-2%'  AND xd.docid = id.docid  AND xd.rev = id.rev  AND id.guid IN      (SELECT guid      FROM xml_access \t\tWHERE lower(principal_name) = 'public'  \tAND perm_type = 'allow'  \tAND permission > 3\t\t)  AND id.guid NOT IN      (SELECT guid      FROM xml_access      WHERE lower(principal_name) = 'public' \t\tAND perm_type = 'deny' \t\tAND perm_order ='allowFirst' \t\tAND permission > 3      ) ");
                int documentCount = 0;
                while (rs.next()) {
                    ++documentCount;
                    String docid = rs.getString("docid");
                    String doctype = rs.getString("doctype");
                    String dateUpdated = rs.getDate("date_updated").toString();
                    this.docTypeMap.put(docid, doctype);
                    this.dateMap.put(docid, dateUpdated);
                }
                logger.info((Object)("Number of documents in catalog: " + documentCount));
                stmt.close();
                conn.close();
            }
            this.updateRefreshDate();
        }
        catch (SQLException e) {
            logger.error((Object)("SQLException: " + e.getMessage()));
        }
    }

    private void purge() {
        ArrayList<String> old = new ArrayList<String>();
        Date now = new Date();
        for (String key : this.resumptionResults.keySet()) {
            Date then = new Date(Long.parseLong(key) + (long)this.getMillisecondsToLive());
            if (!now.after(then)) continue;
            old.add(key);
        }
        for (String key : old) {
            this.resumptionResults.remove(key);
        }
    }

    private boolean shouldRefreshCatalog() {
        boolean shouldRefresh = false;
        String maxDateUpdated = this.getMaxDateUpdated();
        logger.info((Object)("refreshDate: " + refreshDate));
        logger.info((Object)("maxDateUpdated: " + maxDateUpdated));
        if (refreshDate == null || maxDateUpdated == null) {
            shouldRefresh = true;
        } else if (maxDateUpdated.compareTo(refreshDate) > 0) {
            shouldRefresh = true;
        }
        logger.info((Object)("shouldRefresh: " + shouldRefresh));
        return shouldRefresh;
    }

    private void updateRefreshDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date now = new Date();
        refreshDate = simpleDateFormat.format(now);
    }
}

