/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.restservice.multipart;

import edu.ucsb.nceas.metacat.restservice.multipart.CheckedFile;
import edu.ucsb.nceas.metacat.restservice.multipart.MultipartRequestWithSysmeta;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.configuration.Settings;
import org.dataone.exceptions.MarshallingException;
import org.dataone.mimemultipart.MultipartRequest;
import org.dataone.mimemultipart.MultipartRequestResolver;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v2.SystemMetadata;
import org.dataone.service.util.TypeMarshaller;

public class StreamingMultipartRequestResolver
extends MultipartRequestResolver {
    public static final String SYSMETA = "sysmeta";
    private static Log log = LogFactory.getLog(StreamingMultipartRequestResolver.class);
    private ServletFileUpload upload;
    private org.dataone.service.types.v1.SystemMetadata sysMeta = null;
    private String defaultAlgorithm = Settings.getConfiguration().getString("multipartresolver.checksum.algorithm.default", "MD5");
    private File tempDir = null;
    private static boolean deleteOnExit = Settings.getConfiguration().getBoolean("multipart.tempFile.deleteOnExit", false);

    public StreamingMultipartRequestResolver(String tmpUploadDir, int maxUploadSize) {
        super(tmpUploadDir, maxUploadSize);
        this.tempDir = new File(tmpUploadDir);
        this.upload = new ServletFileUpload();
        this.upload.setSizeMax((long)maxUploadSize);
    }

    public MultipartRequest resolveMultipart(HttpServletRequest request) throws IOException, FileUploadException, InstantiationException, IllegalAccessException, MarshallingException, NoSuchAlgorithmException {
        HashMap<String, List<String>> mpParams = new HashMap<String, List<String>>();
        HashMap<String, File> mpFiles = new HashMap<String, File>();
        MultipartRequestWithSysmeta multipartRequest = new MultipartRequestWithSysmeta(request, mpFiles, mpParams);
        if (!StreamingMultipartRequestResolver.isMultipartContent((HttpServletRequest)request)) {
            return multipartRequest;
        }
        long start = 0L;
        long end = 0L;
        String pid = null;
        FileItemIterator iter = this.upload.getItemIterator(request);
        boolean sysmetaFirst = false;
        while (iter.hasNext()) {
            FileItemStream item = iter.next();
            String name = item.getFieldName();
            InputStream stream = item.openStream();
            try {
                File newFile;
                if (item.isFormField()) {
                    String value = Streams.asString((InputStream)stream);
                    log.debug((Object)("StreamingMultipartRequestResolver.resoloveMulitpart - form field " + name + " with value " + value + " detected."));
                    if (mpParams.containsKey(name)) {
                        ((List)mpParams.get(name)).add(value);
                        continue;
                    }
                    ArrayList<String> values = new ArrayList<String>();
                    values.add(value);
                    mpParams.put(name, values);
                    continue;
                }
                log.debug((Object)("StreamingMultipartRequestResolver.resoloveMulitpart -File field " + name + " with file name " + item.getName() + " detected."));
                if (name.equals(SYSMETA)) {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)stream, (OutputStream)os);
                    byte[] sysmetaBytes = os.toByteArray();
                    os.close();
                    ByteArrayInputStream input = new ByteArrayInputStream(sysmetaBytes);
                    try {
                        SystemMetadata sysMeta2 = (SystemMetadata)TypeMarshaller.unmarshalTypeFromStream(SystemMetadata.class, (InputStream)input);
                        this.sysMeta = sysMeta2;
                    }
                    catch (Exception e) {
                        input.reset();
                        this.sysMeta = (org.dataone.service.types.v1.SystemMetadata)TypeMarshaller.unmarshalTypeFromStream(org.dataone.service.types.v1.SystemMetadata.class, (InputStream)input);
                        log.info((Object)("StreamingMultipartRequestResolver.resoloveMulitpart - the system metadata is v1 for the pid " + this.sysMeta.getIdentifier().getValue()));
                    }
                    if (this.sysMeta != null && this.sysMeta.getIdentifier() != null) {
                        pid = this.sysMeta.getIdentifier().getValue();
                    }
                    input.close();
                    multipartRequest.setSystemMetadata(this.sysMeta);
                    continue;
                }
                if (name.equals("object")) {
                    CheckedFile checkedFile;
                    start = System.currentTimeMillis();
                    if (this.sysMeta != null && this.sysMeta.getChecksum() != null && this.sysMeta.getChecksum().getAlgorithm() != null && !this.sysMeta.getChecksum().getAlgorithm().trim().equals("")) {
                        sysmetaFirst = true;
                        String algorithm = this.sysMeta.getChecksum().getAlgorithm();
                        log.info((Object)("StreamingMultipartRequestResolver.resoloveMulitpart - Metacat is handling the object stream AFTER handling the system metadata stream. StreamResolver will calculate the checksum using algorithm " + algorithm));
                        if (this.sysMeta != null && this.sysMeta.getIdentifier() != null) {
                            pid = this.sysMeta.getIdentifier().getValue();
                        }
                        if (pid == null || pid.trim().equals("")) {
                            pid = "UNKNOWN";
                        }
                        File newFile2 = this.generateTmpFile("checked-object");
                        checkedFile = StreamingMultipartRequestResolver.writeStreamToCheckedFile(newFile2, stream, algorithm, pid);
                        mpFiles.put(name, checkedFile);
                    } else {
                        log.info((Object)"StreamingMultipartRequestResolver.resoloveMulitpart - Metacat is handling the object stream before handling the system metadata stream. StreamResolver can NOT calculate the checksum since we don't know the algorithm.");
                        newFile = this.generateTmpFile("unchecked-object");
                        StreamingMultipartRequestResolver.writeStreamToFile(newFile, stream);
                        Checksum checksum = null;
                        checkedFile = new CheckedFile(newFile.getCanonicalPath(), checksum);
                        mpFiles.put(name, checkedFile);
                    }
                    end = System.currentTimeMillis();
                    continue;
                }
                newFile = this.generateTmpFile("other");
                StreamingMultipartRequestResolver.writeStreamToFile(newFile, stream);
                mpFiles.put(name, newFile);
            }
            catch (Exception e) {
                Set keys = mpFiles.keySet();
                for (String key : keys) {
                    File tempFile = (File)mpFiles.get(key);
                    StreamingMultipartRequestResolver.deleteTempFile(tempFile);
                    mpFiles.remove(key);
                }
                throw e;
            }
            finally {
                if (stream == null) continue;
                try {
                    stream.close();
                }
                catch (Exception e) {
                    log.warn((Object)("Couldn't close the stream since" + e.getMessage()));
                }
            }
        }
        if (end > start && pid != null) {
            String predicate = null;
            predicate = sysmetaFirst ? "with" : "without";
            log.info((Object)("MetacatPerformanceLog " + pid + " create/update method " + " Write the object file from the http multipart to the disk " + predicate + " calculating the checksum" + " duration " + (end - start) / 1000L));
        }
        return multipartRequest;
    }

    private File generateTmpFile(String prefix) throws IOException {
        String newPrefix = prefix + "-" + System.currentTimeMillis();
        String suffix = null;
        File newFile = null;
        try {
            newFile = File.createTempFile(newPrefix, suffix, this.tempDir);
        }
        catch (Exception e) {
            newFile = File.createTempFile(newPrefix, suffix, this.tempDir);
        }
        log.debug((Object)("StreamingMultiplePartRequestResolver.generateTmepFile - the new file  is " + newFile.getCanonicalPath()));
        return newFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CheckedFile writeStreamToCheckedFile(File file, InputStream dataStream, String checksumAlgorithm, String pid) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        Checksum checksum = null;
        log.debug((Object)("StreamingMultipartRequestResolver.writeStreamToCheckedFile - filename for writting is: " + file.getAbsolutePath() + " for the pid " + pid + " by the algorithm " + checksumAlgorithm));
        MessageDigest md = MessageDigest.getInstance(checksumAlgorithm);
        FilterOutputStream os = null;
        try {
            os = new DigestOutputStream(new FileOutputStream(file), md);
            long l = IOUtils.copyLarge((InputStream)dataStream, (OutputStream)os);
        }
        finally {
            if (os != null) {
                try {
                    os.flush();
                    os.close();
                }
                catch (Exception e) {
                    log.warn((Object)("StreamingMultipartRequestResolver.writeStreamToCheckedFile - couldn't close the file output stream since " + e.getMessage()));
                }
            }
        }
        String localChecksum = DatatypeConverter.printHexBinary((byte[])md.digest());
        checksum = new Checksum();
        checksum.setAlgorithm(checksumAlgorithm);
        checksum.setValue(localChecksum);
        log.info((Object)("StreamingMultipartRequestResolver.writeStreamToCheckedFile - the checksum calculated from the saved local file is " + localChecksum + " for the pid " + pid));
        CheckedFile checkedFile = new CheckedFile(file.getCanonicalPath(), checksum);
        return checkedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File writeStreamToFile(File file, InputStream dataStream) throws IOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            long l = IOUtils.copyLarge((InputStream)dataStream, (OutputStream)os);
        }
        finally {
            if (os != null) {
                try {
                    os.flush();
                    os.close();
                }
                catch (Exception e) {
                    log.warn((Object)("StreamingMultipartRequestResolver.writeStreamToFile - couldn't close the file output stream since " + e.getMessage()));
                }
            }
        }
        return file;
    }

    public org.dataone.service.types.v1.SystemMetadata getSystemMetadataPart() {
        return this.sysMeta;
    }

    public static void deleteTempFile(File temp) {
        if (temp != null) {
            try {
                if (deleteOnExit) {
                    temp.deleteOnExit();
                    log.debug((Object)"StreamingMultiPartHandler.deleteTempFile - marked the temp deleting on exit");
                } else {
                    temp.delete();
                    log.debug((Object)"StreamingMultiPartHandler.deleteTempFile - deleted the temp file immediately");
                }
            }
            catch (Exception e) {
                log.warn((Object)("StreamingMultiPartHandler.deleteTempFile - couldn't delete the temp file since " + e.getMessage()));
            }
        }
    }
}

