/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.util;

import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.service.SessionService;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.util.SessionData;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.dataone.portal.PortalCertificateManager;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.SubjectInfo;

public class RequestUtil {
    private static Log logMetacat = LogFactory.getLog(RequestUtil.class);
    private static String encoding = "UTF-8";

    private RequestUtil() {
    }

    public static void forwardRequest(HttpServletRequest request, HttpServletResponse response, String destinationUrl, Hashtable<String, String[]> params) throws MetacatUtilException {
        destinationUrl = destinationUrl + "?" + RequestUtil.paramsToQuery(params);
        logMetacat.debug((Object)("Forwarding request to " + destinationUrl));
        ServletContext servletContext = request.getSession().getServletContext();
        try {
            servletContext.getRequestDispatcher(destinationUrl).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (IOException ioe) {
            throw new MetacatUtilException("RequestUtil.forwardRequest - I/O error when forwarding to " + destinationUrl + " : " + ioe.getMessage());
        }
        catch (ServletException se) {
            throw new MetacatUtilException("RequestUtil.forwardRequest - Servlet error when forwarding to " + destinationUrl + " : " + se.getMessage());
        }
    }

    public static void forwardRequest(HttpServletRequest request, HttpServletResponse response, Hashtable<String, String[]> params) throws MetacatUtilException {
        String[] forwardTos = params.get("forwardto");
        if (forwardTos == null || forwardTos[0].equals("")) {
            throw new MetacatUtilException("RequestUtil.forwardRequest - forwardto must be set in parameters when forwarding.");
        }
        String forwardTo = forwardTos[0];
        String qformat = null;
        String[] qformats = params.get("qformat");
        if (qformats == null || qformats.length == 0) {
            try {
                qformat = PropertyService.getProperty("application.default-style");
            }
            catch (PropertyNotFoundException pnfe) {
                qformat = "default";
                logMetacat.warn((Object)"RequestUtil.forwardRequest - could not get property 'application.default-style'. Using 'default'");
            }
        } else {
            qformat = qformats[0];
        }
        String destinationUrl = "/style/skins/" + qformat + "/" + forwardTo;
        destinationUrl = destinationUrl + "?" + RequestUtil.paramsToQuery(params);
        logMetacat.debug((Object)("RequestUtil.forwardRequest - Forwarding request to " + destinationUrl));
        ServletContext servletContext = request.getSession().getServletContext();
        try {
            servletContext.getRequestDispatcher(destinationUrl).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (IOException ioe) {
            throw new MetacatUtilException("RequestUtil.forwardRequest - I/O error when forwarding to " + destinationUrl + " : " + ioe.getMessage());
        }
        catch (ServletException se) {
            throw new MetacatUtilException("RequestUtil.forwardRequest - Servlet error when forwarding to " + destinationUrl + " : " + se.getMessage());
        }
    }

    public static String post(HttpClient httpclient, String url, HashMap<String, String> paramMap) throws IOException, HttpException {
        httpclient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        httpclient.getParams().setParameter("http.protocol.content-charset", (Object)encoding);
        HttpPost post = new HttpPost(url);
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        for (String key : paramMap.keySet()) {
            String value = paramMap.get(key);
            BasicNameValuePair nvp = new BasicNameValuePair(key, value);
            nameValuePairs.add(nvp);
        }
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, encoding));
        HttpResponse httpResponse = httpclient.execute((HttpUriRequest)post);
        if (httpResponse.getStatusLine().getStatusCode() != -1) {
            InputStream result = httpResponse.getEntity().getContent();
            String contents = IOUtils.toString((InputStream)result, (String)encoding);
            return contents;
        }
        return null;
    }

    public static String get(String urlString, Hashtable<String, String[]> params) throws MetacatUtilException {
        try {
            String line;
            URL url = new URL(urlString);
            URLConnection urlConn = url.openConnection();
            urlConn.setDoOutput(true);
            PrintWriter pw = new PrintWriter(urlConn.getOutputStream());
            String queryString = RequestUtil.paramsToQuery(params);
            logMetacat.debug((Object)("Sending get request: " + urlString + "?" + queryString));
            pw.print(queryString);
            pw.close();
            BufferedReader in = new BufferedReader(new InputStreamReader(urlConn.getInputStream()));
            StringBuffer sb = new StringBuffer();
            while ((line = in.readLine()) != null) {
                sb.append(line);
            }
            in.close();
            return sb.toString();
        }
        catch (MalformedURLException mue) {
            throw new MetacatUtilException("URL error when contacting: " + urlString + " : " + mue.getMessage());
        }
        catch (IOException ioe) {
            throw new MetacatUtilException("I/O error when contacting: " + urlString + " : " + ioe.getMessage());
        }
    }

    public static Cookie getCookie(HttpServletRequest request, String cookieName) {
        Cookie[] sessionCookies = request.getCookies();
        if (sessionCookies == null) {
            return null;
        }
        for (int i = 0; i < sessionCookies.length; ++i) {
            if (!sessionCookies[i].getName().equals(cookieName)) continue;
            return sessionCookies[i];
        }
        return null;
    }

    public static SessionData getSessionData(HttpServletRequest request) {
        SessionData sessionData = null;
        String sessionId = null;
        sessionData = RequestUtil.getSessionDataFromToken(request);
        if (sessionData != null) {
            return sessionData;
        }
        Hashtable<String, String[]> params = RequestUtil.getParameters(request);
        if (params.containsKey("sessionid")) {
            sessionId = params.get("sessionid")[0];
            logMetacat.debug((Object)("session ID provided in request properties: " + sessionId));
        } else {
            Cookie sessionCookie;
            HttpSession session = request.getSession(true);
            if (session.isNew() && (sessionCookie = RequestUtil.getCookie(request, "JSESSIONID")) != null) {
                sessionId = sessionCookie.getValue();
                logMetacat.debug((Object)("session ID provided in request cookie: " + sessionId));
            }
            if (sessionId == null) {
                sessionId = session.getId();
                logMetacat.debug((Object)("session ID retrieved from request: " + sessionId));
            }
        }
        if (SessionService.getInstance().isSessionRegistered(sessionId)) {
            logMetacat.debug((Object)("retrieving session data from session service for session id " + sessionId));
            sessionData = SessionService.getInstance().getRegisteredSession(sessionId);
        } else {
            logMetacat.debug((Object)("using public session.  Given session id is registered: " + sessionId));
            sessionData = SessionService.getInstance().getPublicSession();
        }
        return sessionData;
    }

    public static SessionData getSessionDataFromToken(HttpServletRequest request) {
        SessionData sessionData = null;
        Session session = PortalCertificateManager.getInstance().getSession(request);
        if (session != null) {
            SubjectInfo subjectInfo = session.getSubjectInfo();
            String userName = session.getSubject().getValue();
            String id = request.getSession().getId();
            String password = null;
            String[] groupNames = null;
            String name = null;
            if (subjectInfo != null && subjectInfo.getPersonList() != null && subjectInfo.getPersonList().size() > 0) {
                name = subjectInfo.getPerson(0).getFamilyName();
                if (subjectInfo.getPerson(0).getGivenNameList() != null && subjectInfo.getPerson(0).getGivenNameList().size() > 0) {
                    name = subjectInfo.getPerson(0).getGivenName(0) + " " + name;
                }
                ArrayList<String> groups = new ArrayList<String>();
                if (subjectInfo.getPerson(0).getIsMemberOfList() != null) {
                    for (Subject group : subjectInfo.getPerson(0).getIsMemberOfList()) {
                        groups.add(group.getValue());
                    }
                    groupNames = groups.toArray(new String[0]);
                }
            }
            sessionData = new SessionData(id, userName, groupNames, password, name);
        }
        return sessionData;
    }

    public static Hashtable<String, String[]> getParameters(HttpServletRequest request) {
        Hashtable<String, String[]> params = new Hashtable<String, String[]>();
        Enumeration paramlist = request.getParameterNames();
        while (paramlist.hasMoreElements()) {
            String name = (String)paramlist.nextElement();
            String[] value = request.getParameterValues(name);
            params.put(name, value);
        }
        return params;
    }

    public static void setRequestErrors(HttpServletRequest request, Vector<String> errorVector) {
        request.setAttribute("formErrors", (Object)"true");
        request.setAttribute("processingErrors", errorVector);
    }

    public static void setRequestFormErrors(HttpServletRequest request, Vector<String> errorVector) {
        request.setAttribute("formErrors", (Object)"true");
        request.setAttribute("formFieldErrors", errorVector);
    }

    public static void setRequestSuccess(HttpServletRequest request, Vector<String> successVector) {
        request.setAttribute("formSuccess", (Object)"true");
        request.setAttribute("processingSuccess", successVector);
    }

    public static void setRequestMessage(HttpServletRequest request, Vector<String> messageVector) {
        request.setAttribute("formMessage", (Object)"true");
        request.setAttribute("processingMessage", messageVector);
    }

    public static void clearRequestMessages(HttpServletRequest request) {
        request.setAttribute("formMessage", null);
        request.setAttribute("formSuccess", null);
        request.setAttribute("formErrors", null);
        request.setAttribute("processingMessage", null);
        request.setAttribute("processingSuccess", null);
        request.setAttribute("formFieldErrors", null);
        request.setAttribute("processingErrors", null);
    }

    public static void setUserId(HttpServletRequest request, String userId) {
        request.getSession().setAttribute("userId", (Object)userId);
    }

    private static String paramsToQuery(Hashtable<String, String[]> params) {
        String query = "";
        if (params != null) {
            boolean firstParam = true;
            for (String paramName : params.keySet()) {
                if (firstParam) {
                    firstParam = false;
                } else {
                    query = query + "&";
                }
                query = query + paramName + "=" + params.get(paramName)[0];
            }
        }
        return query;
    }
}

