/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.geotools.data.AbstractFeatureSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.identity.FeatureId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFeatureStore
extends AbstractFeatureSource
implements FeatureStore<SimpleFeatureType, SimpleFeature> {
    protected Transaction transaction = Transaction.AUTO_COMMIT;

    public AbstractFeatureStore() {
    }

    public AbstractFeatureStore(Set hints) {
        super(hints);
    }

    @Override
    public Transaction getTransaction() {
        return this.transaction;
    }

    @Override
    public void modifyFeatures(AttributeDescriptor type, Object value, Filter filter) throws IOException {
        this.modifyFeatures(new AttributeDescriptor[]{type}, new Object[]{value}, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyFeatures(AttributeDescriptor[] type, Object[] value, Filter filter) throws IOException {
        String typeName = ((SimpleFeatureType)this.getSchema()).getTypeName();
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.getDataStore().getFeatureWriter(typeName, filter, this.getTransaction());
        try {
            while (writer.hasNext()) {
                SimpleFeature feature = writer.next();
                for (int i = 0; i < type.length; ++i) {
                    try {
                        feature.setAttribute(type[i].getLocalName(), value[i]);
                        continue;
                    }
                    catch (Exception e) {
                        throw new DataSourceException("Could not update feature " + feature.getID() + " with " + type[i].getLocalName() + "=" + value[i], e);
                    }
                }
                writer.write();
            }
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> addFeatures(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        HashSet<String> addedFids = new HashSet<String>();
        String typeName = ((SimpleFeatureType)this.getSchema()).getTypeName();
        SimpleFeature feature = null;
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.getDataStore().getFeatureWriterAppend(typeName, this.getTransaction());
        try {
            while (reader.hasNext()) {
                try {
                    feature = reader.next();
                }
                catch (Exception e) {
                    throw new DataSourceException("Could not add Features, problem with provided reader", e);
                }
                SimpleFeature newFeature = writer.next();
                try {
                    newFeature.setAttributes(feature.getAttributes());
                }
                catch (Exception writeProblem) {
                    throw new DataSourceException("Could not create " + typeName + " out of provided feature: " + feature.getID(), writeProblem);
                }
                writer.write();
                addedFids.add(newFeature.getID());
            }
        }
        finally {
            reader.close();
            writer.close();
        }
        return addedFids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FeatureId> addFeatures(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) throws IOException {
        LinkedList<FeatureId> addedFids = new LinkedList<FeatureId>();
        String typeName = ((SimpleFeatureType)this.getSchema()).getTypeName();
        SimpleFeature feature = null;
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.getDataStore().getFeatureWriterAppend(typeName, this.getTransaction());
        Iterator<SimpleFeature> iterator = collection.iterator();
        try {
            while (iterator.hasNext()) {
                feature = iterator.next();
                SimpleFeature newFeature = writer.next();
                try {
                    newFeature.setAttributes(feature.getAttributes());
                }
                catch (Exception writeProblem) {
                    throw new DataSourceException("Could not create " + typeName + " out of provided feature: " + feature.getID(), writeProblem);
                }
                writer.write();
                addedFids.add(newFeature.getIdentifier());
            }
        }
        finally {
            collection.close(iterator);
            writer.close();
        }
        return addedFids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFeatures(Filter filter) throws IOException {
        String typeName = ((SimpleFeatureType)this.getSchema()).getTypeName();
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.getDataStore().getFeatureWriter(typeName, filter, this.getTransaction());
        try {
            while (writer.hasNext()) {
                writer.next();
                writer.remove();
            }
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFeatures(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        String typeName = ((SimpleFeatureType)this.getSchema()).getTypeName();
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.getDataStore().getFeatureWriter(typeName, this.getTransaction());
        try {
            SimpleFeature feature;
            while (writer.hasNext()) {
                feature = writer.next();
                writer.remove();
            }
            while (reader.hasNext()) {
                try {
                    feature = reader.next();
                }
                catch (Exception readProblem) {
                    throw new DataSourceException("Could not add Features, problem with provided reader", readProblem);
                }
                SimpleFeature newFeature = writer.next();
                try {
                    newFeature.setAttributes(feature.getAttributes());
                }
                catch (IllegalAttributeException writeProblem) {
                    throw new DataSourceException("Could not create " + typeName + " out of provided feature: " + feature.getID(), (Throwable)((Object)writeProblem));
                }
                writer.write();
            }
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    @Override
    public void setTransaction(Transaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException("Transaction cannot be null, did you mean Transaction.AUTO_COMMIT?");
        }
        this.transaction = transaction;
    }
}

