/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.AuthInterface;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.util.AuthUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.net.ConnectException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthSession {
    private String authClass = null;
    private HttpSession session = null;
    private AuthInterface authService = null;
    private String statusMessage = null;
    private Map<String, String[]> synchronizedGroupsCacheMap = null;
    private static Log logMetacat = LogFactory.getLog(AuthSession.class);

    public AuthSession() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        try {
            this.authClass = PropertyService.getProperty("auth.class");
        }
        catch (PropertyNotFoundException e) {
            e.printStackTrace();
        }
        this.authService = (AuthInterface)AuthSession.createObject(this.authClass);
    }

    public AuthSession(int groupCacheSize) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        try {
            this.authClass = PropertyService.getProperty("auth.class");
        }
        catch (PropertyNotFoundException e) {
            logMetacat.error((Object)("AuthSession.constructor - " + e.getMessage()));
        }
        this.authService = (AuthInterface)AuthSession.createObject(this.authClass);
        LRUMap LRUMap2 = new LRUMap(groupCacheSize);
        this.synchronizedGroupsCacheMap = Collections.synchronizedMap(LRUMap2);
    }

    public HttpSession getSessions() {
        return this.session;
    }

    public boolean authenticate(HttpServletRequest request, String username, String password) {
        String message = null;
        try {
            if (this.authService.authenticate(username, password)) {
                String[][] groupsWithDescription = this.authService.getGroups(username, password, username);
                String[] groups = null;
                if (groupsWithDescription != null) {
                    groups = new String[groupsWithDescription.length];
                    for (int i = 0; i < groupsWithDescription.length; ++i) {
                        groups[i] = groupsWithDescription[i][0];
                    }
                }
                if (groups == null) {
                    groups = new String[]{};
                }
                String[] userInfo = null;
                try {
                    userInfo = this.authService.getUserInfo(username, password);
                }
                catch (ConnectException e) {
                    logMetacat.warn((Object)("AuthSession.authenticate - can't get the user info for user " + username + " since " + e.getMessage()));
                }
                this.session = this.createSession(request, username, password, groups, userInfo);
                String sessionId = this.session.getId();
                message = "Authentication successful for user: " + username;
                this.statusMessage = this.formatOutput("login", message, sessionId, username, groups, userInfo);
                return true;
            }
            message = "Authentication failed for user: " + username;
            this.statusMessage = this.formatOutput("unauth_login", message);
            return false;
        }
        catch (ConnectException ce) {
            message = "Connection to the authentication service failed in AuthSession.authenticate: " + ce.getMessage();
        }
        catch (IllegalStateException ise) {
            message = ise.getMessage();
        }
        this.statusMessage = this.formatOutput("error_login", message);
        return false;
    }

    private HttpSession createSession(HttpServletRequest request, String username, String password, String[] groups, String[] userInfo) throws IllegalStateException {
        HttpSession session = request.getSession(true);
        if (!session.isNew()) {
            logMetacat.info((Object)"in session is not new");
            logMetacat.info((Object)("the old session id is : " + session.getId()));
            logMetacat.info((Object)("the old session username : " + session.getAttribute("username")));
            session.invalidate();
            logMetacat.info((Object)"in session is not new");
            session = request.getSession(true);
        }
        session.setMaxInactiveInterval(-1);
        session.setAttribute("username", (Object)username);
        session.setAttribute("password", (Object)password);
        if (userInfo != null && userInfo.length == 3) {
            session.setAttribute("name", (Object)userInfo[0]);
            session.setAttribute("organization", (Object)userInfo[1]);
            session.setAttribute("email", (Object)userInfo[2]);
        }
        if (groups.length > 0) {
            session.setAttribute("groupnames", (Object)groups);
        }
        logMetacat.info((Object)("the new session id is : " + session.getId()));
        logMetacat.info((Object)("the new session username : " + session.getAttribute("username")));
        return session;
    }

    public String getMessage() {
        return this.statusMessage;
    }

    public String getPrincipals(String user, String password) throws ConnectException {
        return this.authService.getPrincipals(user, password);
    }

    public HashMap<String, Vector<String>> getAttributes(String foruser) throws ConnectException {
        return this.authService.getAttributes(foruser);
    }

    private String formatOutput(String tag, String message) {
        return this.formatOutput(tag, message, null, null, null, null);
    }

    private String formatOutput(String tag, String message, String sessionId, String username, String[] groups, String[] userInfo) {
        StringBuffer out = new StringBuffer();
        out.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        out.append("<" + tag + ">");
        out.append("\n  <message>" + message + "</message>\n");
        if (sessionId != null) {
            out.append("\n  <sessionId>" + sessionId + "</sessionId>\n");
            if (userInfo != null && userInfo[0] != null) {
                out.append("\n<name>\n");
                out.append(userInfo[0]);
                out.append("\n</name>\n");
            }
            if (userInfo != null && userInfo[1] != null) {
                out.append("\n<organization>\n");
                out.append(userInfo[1]);
                out.append("\n</organization>\n");
            }
            if (userInfo != null && userInfo[2] != null) {
                out.append("\n<email>\n");
                out.append(userInfo[2]);
                out.append("\n</email>\n");
            }
            try {
                if (AuthUtil.isAdministrator(username, groups)) {
                    out.append("\n  <isAdministrator></isAdministrator>\n");
                }
            }
            catch (MetacatUtilException ue) {
                logMetacat.error((Object)("Could not determine if user is administrator. Omitting from xml output: " + ue.getMessage()));
            }
            try {
                if (AuthUtil.isModerator(username, groups)) {
                    out.append("\n  <isModerator></isModerator>\n");
                }
            }
            catch (MetacatUtilException ue) {
                logMetacat.error((Object)("Could not determine if user is moderator. Omitting from xml output: " + ue.getMessage()));
            }
        }
        out.append("</" + tag + ">");
        return out.toString();
    }

    public String[] getGroups(String logInUserName, String logInUserPassword, String userDN) throws Exception {
        Object[] groups = null;
        boolean lookUpLDAP = true;
        if (this.synchronizedGroupsCacheMap != null && this.synchronizedGroupsCacheMap.containsKey(userDN)) {
            groups = this.synchronizedGroupsCacheMap.get(userDN);
            lookUpLDAP = false;
            logMetacat.debug((Object)("AuthSession.getGroups - get the group information for the user " + userDN + " from the cache and it has groups - " + Arrays.toString(groups)));
        }
        if (lookUpLDAP) {
            String[][] groupsWithDescription = this.authService.getGroups(logInUserName, logInUserPassword, userDN);
            if (groupsWithDescription != null) {
                groups = new String[groupsWithDescription.length];
                for (int i = 0; i < groupsWithDescription.length; ++i) {
                    groups[i] = groupsWithDescription[i][0];
                    logMetacat.debug((Object)("AuthSession.getGroups - found that user " + userDN + " is the member of the group " + (String)groups[i]));
                }
            }
            if (this.synchronizedGroupsCacheMap != null) {
                this.synchronizedGroupsCacheMap.put(userDN, (String[])groups);
                logMetacat.debug((Object)("AuthSession.getGroups - Metacat got the group information for the user " + userDN + " from LDAP and put " + Arrays.toString(groups) + " into the cache."));
            }
        }
        return groups;
    }

    private static Object createObject(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Object object = null;
        Class<?> classDefinition = Class.forName(className);
        object = classDefinition.newInstance();
        return object;
    }

    private static Object createObject(String className, String orgName) throws Exception {
        Object object = null;
        try {
            Class<?> classDefinition = Class.forName(className);
            object = classDefinition.newInstance();
        }
        catch (InstantiationException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        return object;
    }
}

