/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.properties.SkinPropertyService;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.SortedProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DBTransform {
    private static Map<String, Templates> TemplatesMap = new HashMap<String, Templates>();
    private static final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private static boolean forceRebuild = false;
    private String configDir = SystemUtil.getStyleSkinsDir();
    private String defaultStyle = PropertyService.getProperty("application.default-style");
    private static Log logMetacat = LogFactory.getLog(DBTransform.class);
    private String httpServer = SystemUtil.getServerURL();
    private String contextURL = SystemUtil.getContextURL();
    private String servletURL = SystemUtil.getServletURL();
    private String userManagementURL = PropertyService.getProperty("auth.userManagementUrl");
    private String internalContextURL = SystemUtil.getInternalContextURL();

    protected static synchronized Transformer getTransformer(String xslSystemId) throws TransformerConfigurationException {
        if (forceRebuild) {
            TemplatesMap.clear();
            forceRebuild = false;
            logMetacat.debug((Object)"DBTransform.getTransformer - clear the style sheet cache and will reload the style sheets from disk.");
        }
        if (!TemplatesMap.containsKey(xslSystemId)) {
            logMetacat.debug((Object)("DBTransform.getTransformer - Load the style sheets from disk for the id " + xslSystemId));
            Templates templates = transformerFactory.newTemplates(new StreamSource(xslSystemId));
            if (templates != null) {
                TemplatesMap.put(xslSystemId, templates);
            }
        } else {
            logMetacat.debug((Object)("DBTransform.getTransformer - Load the style sheets from the cache for the id " + xslSystemId));
        }
        logMetacat.info((Object)("DBTransform.getTransformer -  the tmplate is " + TemplatesMap.get(xslSystemId) + " for " + xslSystemId));
        if (TemplatesMap.get(xslSystemId) != null) {
            return TemplatesMap.get(xslSystemId).newTransformer();
        }
        return null;
    }

    public void transformXMLDocument(String doc, String sourceType, String targetType, String qformat, Writer w, Hashtable<String, String[]> param, String sessionid) {
        String xslSystemId = this.getStyleSystemId(qformat, sourceType, targetType);
        try {
            if (xslSystemId != null) {
                doc = this.removeDOCTYPE(doc);
                StreamSource xml = new StreamSource(new StringReader(doc));
                StreamResult result = new StreamResult(w);
                Transformer transformer = DBTransform.getTransformer(xslSystemId);
                if (transformer == null) {
                    this.internalContextURL = SystemUtil.getInternalContextURL();
                    xslSystemId = this.getStyleSystemId(qformat, sourceType, targetType);
                    transformer = DBTransform.getTransformer(xslSystemId);
                }
                this.doTransform(xml, result, transformer, param, qformat, sessionid);
            } else {
                w.write(doc);
            }
        }
        catch (Exception e) {
            try {
                String msg = xslSystemId + ": Error transforming document in DBTransform.transformXMLDocument: " + e.getMessage();
                w.write(msg);
                w.flush();
                logMetacat.error((Object)msg, (Throwable)e);
            }
            catch (IOException e1) {
                logMetacat.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
    }

    protected void doTransform(StreamSource xml, StreamResult resultOutput, Transformer transformer, Hashtable<String, String[]> param, String qformat, String sessionid) throws PropertyNotFoundException, TransformerException {
        if (transformer != null) {
            String value;
            String key;
            transformer.setParameter("qformat", qformat);
            logMetacat.info((Object)("DBTransform.doTransform - qformat: " + qformat));
            SortedProperties skinOptions = SkinPropertyService.getProperties(qformat);
            if (skinOptions != null) {
                for (Map.Entry entry : skinOptions.getProperties().entrySet()) {
                    key = (String)entry.getKey();
                    value = (String)entry.getValue();
                    if (key.indexOf(46) != -1) continue;
                    transformer.setParameter(key, value);
                }
            }
            if (sessionid != null && !sessionid.equals("null")) {
                transformer.setParameter("sessid", sessionid);
            }
            String cgiPrefix = SystemUtil.getCGI_URL();
            logMetacat.debug((Object)("DBTransform.doTransform - cgi-prefix: " + cgiPrefix));
            logMetacat.debug((Object)("DBTransform.doTransform - httpServer: " + this.httpServer));
            logMetacat.debug((Object)("DBTransform.doTransform - contextURL: " + this.contextURL));
            logMetacat.debug((Object)("DBTransform.doTransform - serletURL: " + this.servletURL));
            logMetacat.debug((Object)("DBTransform.doTransform - userManagementURL: " + this.userManagementURL));
            transformer.setParameter("cgi-prefix", cgiPrefix);
            transformer.setParameter("httpServer", this.httpServer);
            transformer.setParameter("contextURL", this.contextURL);
            transformer.setParameter("servletURL", this.servletURL);
            transformer.setParameter("userManagementURL", this.userManagementURL);
            if (param != null) {
                Enumeration<String> en = param.keys();
                while (en.hasMoreElements()) {
                    key = en.nextElement();
                    value = param.get(key)[0];
                    logMetacat.info((Object)("DBTransform.doTransform - param: " + key + " -- " + value));
                    transformer.setParameter(key, value);
                }
            }
            transformer.transform(xml, resultOutput);
        }
    }

    public static NodeList getPathContent(File f, String path) {
        InputSource in;
        FileInputStream fs;
        if (f == null) {
            return null;
        }
        DOMParser parser = new DOMParser();
        try {
            fs = new FileInputStream(f);
            in = new InputSource(fs);
        }
        catch (FileNotFoundException fnf) {
            fnf.printStackTrace();
            return null;
        }
        try {
            parser.parse(in);
            fs.close();
        }
        catch (Exception e1) {
            System.err.println("File: " + f.getPath() + " : parse threw: " + e1.toString());
            return null;
        }
        Document doc = parser.getDocument();
        try {
            NodeList docNodeList = XPathAPI.selectNodeList((Node)doc, (String)path);
            return docNodeList;
        }
        catch (Exception se) {
            System.err.println("file: " + f.getPath() + " : parse threw: " + se.toString());
            return null;
        }
    }

    private String getStyleSystemId(String qformat, String sourcetype, String targettype) {
        String systemId = null;
        if (qformat == null || qformat.equals("html")) {
            qformat = this.defaultStyle;
        }
        try {
            boolean breakflag = false;
            String filename = this.configDir + "/" + qformat + "/" + qformat + ".xml";
            logMetacat.info((Object)("DBTransform.getStyleSystemId - Trying style-set file: " + filename));
            File f = new File(filename);
            NodeList nlDoctype = DBTransform.getPathContent(f, "/style-set/doctype");
            NodeList nlDefault = DBTransform.getPathContent(f, "/style-set/default-style");
            Node nDefault = nlDefault.item(0);
            systemId = nDefault.getFirstChild().getNodeValue();
            for (int i = 0; i < nlDoctype.getLength(); ++i) {
                Node nDoctype = nlDoctype.item(i);
                NamedNodeMap atts = nDoctype.getAttributes();
                Node nAtt = atts.getNamedItem("publicid");
                String doctype = nAtt.getFirstChild().getNodeValue();
                if (doctype.equals(sourcetype)) {
                    NodeList nlChildren = nDoctype.getChildNodes();
                    for (int j = 0; j < nlChildren.getLength(); ++j) {
                        NamedNodeMap childAtts;
                        Node nTargetPublicId;
                        String target;
                        Node nChild = nlChildren.item(j);
                        String childName = nChild.getNodeName();
                        if (childName.equals("target") && (target = (nTargetPublicId = (childAtts = nChild.getAttributes()).getNamedItem("publicid")).getFirstChild().getNodeValue()).equals(targettype)) {
                            NodeList nlTarget = nChild.getChildNodes();
                            for (int k = 0; k < nlTarget.getLength(); ++k) {
                                Node nChildText = nlTarget.item(k);
                                if (nChildText.getNodeType() != 3) continue;
                                systemId = nChildText.getNodeValue();
                                breakflag = true;
                                break;
                            }
                        }
                        if (breakflag) break;
                    }
                }
                if (!breakflag) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.out.println("Error parsing style-set file: " + e.getMessage());
            e.printStackTrace();
        }
        if (systemId != null && !systemId.startsWith("http")) {
            systemId = this.internalContextURL + systemId;
        }
        logMetacat.info((Object)("DBTransform.getStyleSystemId - style system id is: " + systemId));
        return systemId;
    }

    private String removeDOCTYPE(String in) {
        String ret = "";
        int startpos = in.indexOf("<!DOCTYPE");
        if (startpos <= -1) {
            return in;
        }
        int stoppos = in.indexOf(">", startpos + 8);
        ret = in.substring(0, startpos) + in.substring(stoppos + 1, in.length());
        return ret;
    }

    public static void setForceRebuild(boolean forceBuild) {
        forceRebuild = forceBuild;
    }
}

