/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimerTask;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.client.v2.formats.ObjectFormatCache;
import org.dataone.service.types.v2.ObjectFormat;
import org.dataone.service.types.v2.ObjectFormatList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Sitemap
extends TimerTask {
    private static Log logMetacat = LogFactory.getLog(Sitemap.class);
    DocumentBuilderFactory documentBuilderFactory;
    DocumentBuilder documentBuilder;
    private File directory;
    private String locationBase;
    private String entryBase;
    private String portalBase;
    private List<String> portalFormats;
    static final int MAX_URLS_IN_FILE = 50000;
    static final String fileRoot = "sitemap";
    static final String indexFilename = "sitemap_index.xml";
    static final String lastModFormatFull = "yyyy-MM-dd H:mm:ss.S";
    static final String lastModFormatShort = "yyyy-MM-dd H:mm:ss";

    public Sitemap(File directory, String locationBase, String entryBase, String portalBase, List<String> portalFormats) {
        this.directory = directory;
        this.locationBase = locationBase;
        this.entryBase = entryBase;
        this.portalBase = portalBase;
        this.portalFormats = portalFormats;
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            this.documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            logMetacat.error((Object)e.getMessage());
        }
    }

    @Override
    public void run() {
        this.generateSitemaps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateSitemaps() {
        Date start = new Date();
        logMetacat.info((Object)("Running the Sitemap task. Directory is " + this.directory + " and locationBase is " + this.locationBase + "."));
        if (!this.directory.isDirectory()) {
            logMetacat.error((Object)("Sitemap.generateSitemaps(): Sitemap(s) not created because directory " + this.directory.getAbsolutePath() + " is not valid."));
            return;
        }
        if (this.documentBuilder == null) {
            logMetacat.error((Object)"Couldn't generate sitemaps because we didn't have a document builder instance.");
            return;
        }
        String query = "SELECT identifier.guid as pid, systemmetadata.series_id as sid, systemmetadata.date_modified as lastmod, systemmetadata.object_format as format FROM identifier LEFT JOIN systemmetadata on identifier.guid = systemmetadata.guid LEFT JOIN xml_access on identifier.guid = xml_access.guid WHERE systemmetadata.object_format in (" + this.getMetadataFormatsQueryString() + ") AND systemmetadata.obsoleted_by is NULL AND systemmetadata.archived = FALSE AND xml_access.principal_name = 'public' AND xml_access.perm_type = 'allow' ORDER BY systemmetadata.date_uploaded ASC;";
        DBConnection dbConn = null;
        int serialNumber = -1;
        try {
            Transformer tr;
            dbConn = DBConnectionPool.getDBConnection("Sitemap.generateSitemap()");
            serialNumber = dbConn.getCheckOutSerialNumber();
            PreparedStatement stmt = dbConn.prepareStatement(query);
            stmt.execute();
            ResultSet rs = stmt.getResultSet();
            File sitemapFile = null;
            OutputStreamWriter sitemapWriter = null;
            Document document = null;
            Node rootNode = null;
            int counter = 0;
            int fileNumber = 0;
            while (rs.next()) {
                if (counter % 50000 == 0) {
                    if (sitemapFile != null && sitemapFile.canWrite()) {
                        tr = TransformerFactory.newInstance().newTransformer();
                        tr.setOutputProperty("indent", "yes");
                        tr.setOutputProperty("method", "xml");
                        tr.setOutputProperty("encoding", "UTF-8");
                        tr.transform(new DOMSource(document), new StreamResult(sitemapWriter));
                    }
                    sitemapFile = new File(this.directory, fileRoot + ++fileNumber + ".xml");
                    sitemapWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(sitemapFile), Charset.forName("UTF-8"));
                    document = this.documentBuilder.newDocument();
                    rootNode = document.createElement("urlset");
                    rootNode.setAttribute("xmlns", "http://www.sitemaps.org/schemas/sitemap/0.9");
                    document.appendChild(rootNode);
                }
                Element urlElement = this.createSitemapEntry(document, rs.getString(1), rs.getString(2), rs.getString(3), rs.getString(4));
                rootNode.appendChild(urlElement);
                ++counter;
            }
            stmt.close();
            if (counter > 0) {
                if (sitemapFile != null && sitemapFile.canWrite()) {
                    tr = TransformerFactory.newInstance().newTransformer();
                    tr.setOutputProperty("indent", "yes");
                    tr.setOutputProperty("method", "xml");
                    tr.setOutputProperty("encoding", "UTF-8");
                    tr.transform(new DOMSource(document), new StreamResult(sitemapWriter));
                }
                this.writeSitemapIndex(fileNumber);
            }
            if (sitemapWriter != null) {
                sitemapWriter.close();
            }
        }
        catch (SQLException e) {
            logMetacat.warn((Object)("Error while writing to the sitemap file: " + e.getMessage()));
        }
        catch (IOException ioe) {
            logMetacat.warn((Object)("Could not open or write to the sitemap file: " + ioe.getMessage()));
        }
        catch (TransformerConfigurationException e) {
            logMetacat.warn((Object)("Could not transform (serialize) the sitemap file: " + e.getMessage()));
        }
        catch (TransformerException e) {
            logMetacat.warn((Object)("Could not transform (serialize) the sitemap file: " + e.getMessage()));
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        }
        logMetacat.info((Object)("sitemap task took " + (new Date().getTime() - start.getTime()) / 1000L + " seconds."));
    }

    private Element createSitemapEntry(Document document, String pid, String sid, String lastmod, String format) {
        Element urlElement = document.createElement("url");
        if (document == null || pid == null || this.entryBase == null) {
            return urlElement;
        }
        try {
            StringBuffer url = new StringBuffer();
            if (this.portalFormats.contains(format)) {
                url.append(this.portalBase);
                if (!this.portalBase.endsWith("/")) {
                    url.append("/");
                }
                if (sid != null) {
                    url.append(StringEscapeUtils.escapeXml((String)URLEncoder.encode(sid, "UTF-8")));
                } else {
                    url.append(StringEscapeUtils.escapeXml((String)URLEncoder.encode(pid, "UTF-8")));
                }
            } else {
                url.append(this.entryBase);
                if (!this.entryBase.endsWith("/")) {
                    url.append("/");
                }
                url.append(StringEscapeUtils.escapeXml((String)URLEncoder.encode(pid, "UTF-8")));
            }
            Element locElement = document.createElement("loc");
            locElement.setTextContent(url.toString());
            urlElement.appendChild(locElement);
            Date lastmodDate = this.tryParseLastModDateTime(lastmod);
            if (lastmodDate != null) {
                Element lastmodElement = document.createElement("lastmod");
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
                lastmodElement.setTextContent(fmt.format(lastmodDate));
                urlElement.appendChild(lastmodElement);
            }
            return urlElement;
        }
        catch (UnsupportedEncodingException e) {
            logMetacat.warn((Object)("Couldn't encode PID " + pid + " in UTF-8 so this entry will be skipped."));
            return urlElement;
        }
    }

    private void writeSitemapIndex(int totalFiles) {
        File sitemapIndexFile = new File(this.directory, indexFilename);
        OutputStreamWriter sitemapIndex = null;
        try {
            sitemapIndex = new OutputStreamWriter((OutputStream)new FileOutputStream(sitemapIndexFile), Charset.forName("UTF-8"));
            Document doc = this.documentBuilder.newDocument();
            Element root = doc.createElement("sitemapindex");
            root.setAttribute("xmlns", "http://www.sitemaps.org/schemas/sitemap/0.9");
            for (int fileNumber = 1; fileNumber <= totalFiles; ++fileNumber) {
                String filename = fileRoot + fileNumber + ".xml";
                Element entry = this.createSitemapIndexEntry(doc, filename);
                root.appendChild(entry);
            }
            Transformer tr = TransformerFactory.newInstance().newTransformer();
            tr.setOutputProperty("indent", "yes");
            tr.setOutputProperty("method", "xml");
            tr.setOutputProperty("encoding", "UTF-8");
            doc.appendChild(root);
            tr.transform(new DOMSource(doc), new StreamResult(sitemapIndex));
            if (sitemapIndex != null) {
                sitemapIndex.close();
            }
        }
        catch (IOException e) {
            logMetacat.warn((Object)("Could not open or write to the sitemap index file: " + e.getMessage()));
        }
        catch (TransformerException e) {
            logMetacat.warn((Object)("Could not transform (serialize) the index file:" + e.getMessage()));
        }
    }

    private Element createSitemapIndexEntry(Document document, String filename) {
        Element sitemapElement = document.createElement(fileRoot);
        if (filename == null || this.locationBase == null) {
            return sitemapElement;
        }
        Element loc = document.createElement("loc");
        StringBuffer url = new StringBuffer();
        url.append(this.locationBase);
        if (!this.locationBase.endsWith("/")) {
            url.append("/");
        }
        url.append(filename);
        loc.setTextContent(url.toString());
        Element lastmod = document.createElement("lastmod");
        Date now = new Date();
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
        lastmod.setTextContent(fmt.format(now));
        sitemapElement.appendChild(loc);
        sitemapElement.appendChild(lastmod);
        return sitemapElement;
    }

    private Date tryParseLastModDateTime(String lastmod) {
        Date lastmodDate = null;
        try {
            lastmodDate = new SimpleDateFormat(lastModFormatFull).parse(lastmod);
        }
        catch (ParseException e) {
            logMetacat.debug((Object)("Failed to parse " + lastmod + " with SimpleDateFormat of " + lastModFormatFull + " trying the next format."));
        }
        if (lastmodDate != null) {
            return lastmodDate;
        }
        try {
            lastmodDate = new SimpleDateFormat(lastModFormatShort).parse(lastmod);
        }
        catch (ParseException e) {
            logMetacat.debug((Object)("Failed to parse " + lastmod + " with SimpleDateFormat of " + lastModFormatShort + " a lastmod element won't be inserted for this sitemap entry."));
        }
        return lastmodDate;
    }

    public String getMetadataFormatsQueryString() {
        ObjectFormatList objectFormatList = ObjectFormatCache.getInstance().listFormats();
        StringBuilder sb = new StringBuilder();
        for (ObjectFormat fmt : objectFormatList.getObjectFormatList()) {
            if (!fmt.getFormatType().equals("METADATA")) continue;
            sb.append("'");
            sb.append(fmt.getFormatId().getValue());
            sb.append("'");
            sb.append(",");
        }
        sb.deleteCharAt(sb.lastIndexOf(","));
        return sb.toString();
    }
}

