/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.admin;

import edu.ucsb.nceas.metacat.admin.AdminException;
import edu.ucsb.nceas.metacat.admin.MetacatAdmin;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.util.RequestUtil;
import edu.ucsb.nceas.utilities.GeneralPropertyException;
import edu.ucsb.nceas.utilities.SortedProperties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EZIDAdmin
extends MetacatAdmin {
    private static EZIDAdmin ezidAdmin = null;
    private Log logMetacat = LogFactory.getLog(EZIDAdmin.class);

    private EZIDAdmin() throws AdminException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EZIDAdmin getInstance() throws AdminException {
        if (ezidAdmin != null) return ezidAdmin;
        Class<EZIDAdmin> clazz = EZIDAdmin.class;
        synchronized (EZIDAdmin.class) {
            if (ezidAdmin != null) return ezidAdmin;
            ezidAdmin = new EZIDAdmin();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ezidAdmin;
        }
    }

    public void configureEZID(HttpServletRequest request, HttpServletResponse response) throws AdminException {
        String processForm = request.getParameter("processForm");
        String bypass = request.getParameter("bypass");
        String formErrors = (String)request.getAttribute("formErrors");
        if (processForm == null || !processForm.equals("true") || formErrors != null) {
            try {
                String enablestr = PropertyService.getProperty("guid.doi.enabled");
                String doiPluginClass = PropertyService.getProperty("guid.doiservice.plugin.class");
                String username = PropertyService.getProperty("guid.doi.username");
                String password = PropertyService.getProperty("guid.doi.password");
                String baseurl = PropertyService.getProperty("guid.doi.baseurl");
                String doishoulder = PropertyService.getProperty("guid.doi.doishoulder.1");
                boolean enable = false;
                if (enablestr != null) {
                    enable = Boolean.parseBoolean(enablestr);
                }
                request.setAttribute("guid.doi.enabled", (Object)enable);
                request.setAttribute("guid.doiservice.plugin.class", (Object)doiPluginClass);
                request.setAttribute("guid.doi.username", (Object)username);
                request.setAttribute("guid.doi.password", (Object)password);
                request.setAttribute("guid.doi.baseurl", (Object)baseurl);
                request.setAttribute("guid.doi.doishoulder.1", (Object)doishoulder);
                SortedProperties backupProperties = null;
                backupProperties = PropertyService.getMainBackupProperties();
                if (backupProperties != null) {
                    Vector backupKeys = backupProperties.getPropertyNames();
                    for (String key : backupKeys) {
                        String value = backupProperties.getProperty(key);
                        if (key != null && value != null && key.equals("guid.doi.enabled")) {
                            enable = Boolean.parseBoolean(value);
                            request.setAttribute("guid.doi.enabled", (Object)enable);
                            continue;
                        }
                        if (value == null) continue;
                        request.setAttribute(key, (Object)value);
                    }
                }
                RequestUtil.forwardRequest(request, response, "/admin/ezid-configuration.jsp", null);
            }
            catch (GeneralPropertyException gpe) {
                throw new AdminException("EZIDAdmin.configureEZID - Problem getting or setting property while initializing system properties page: " + gpe.getMessage());
            }
            catch (MetacatUtilException mue) {
                throw new AdminException("EZIDAdmin.configureEZID- utility problem while initializing system properties page:" + mue.getMessage());
            }
        }
        if (bypass != null && bypass.equals("true")) {
            Vector<String> processingErrors = new Vector<String>();
            Vector<String> processingSuccess = new Vector<String>();
            try {
                PropertyService.setProperty("configutil.ezidConfigured", "bypassed");
            }
            catch (GeneralPropertyException gpe) {
                String errorMessage = "EZIDAdmin.configureEZID - Problem getting or setting property while processing system properties page: " + gpe.getMessage();
                this.logMetacat.error((Object)errorMessage);
                processingErrors.add(errorMessage);
            }
            try {
                if (processingErrors.size() > 0) {
                    RequestUtil.clearRequestMessages(request);
                    RequestUtil.setRequestErrors(request, processingErrors);
                    RequestUtil.forwardRequest(request, response, "/admin", null);
                }
                processingSuccess.add("EZID configuration successfully bypassed");
                RequestUtil.clearRequestMessages(request);
                RequestUtil.setRequestSuccess(request, processingSuccess);
                RequestUtil.forwardRequest(request, response, "/admin?configureType=configure&processForm=false", null);
            }
            catch (MetacatUtilException mue) {
                throw new AdminException("EZID.configureEZID - utility problem while processing ezid services ezidservices page: " + mue.getMessage());
            }
        } else {
            Vector<String> validationErrors = new Vector<String>();
            Vector<String> processingErrors = new Vector<String>();
            Vector<String> processingSuccess = new Vector<String>();
            try {
                validationErrors.addAll(this.validateOptions(request));
                String enablestr = request.getParameter("guid.doi.enabled");
                String pluginClass = request.getParameter("guid.doiservice.plugin.class");
                String username = request.getParameter("guid.doi.username");
                String password = request.getParameter("guid.doi.password");
                String baseurl = request.getParameter("guid.doi.baseurl");
                String doishoulder = request.getParameter("guid.doi.doishoulder.1");
                boolean enable = false;
                if (enablestr != null) {
                    enable = Boolean.parseBoolean(enablestr);
                }
                if (username == null || password == null) {
                    validationErrors.add("User Name and Password cannot be null");
                } else {
                    PropertyService.setPropertyNoPersist("guid.doi.enabled", Boolean.toString(enable));
                    PropertyService.setPropertyNoPersist("guid.doiservice.plugin.class", pluginClass);
                    PropertyService.setPropertyNoPersist("guid.doi.username", username);
                    PropertyService.setPropertyNoPersist("guid.doi.password", password);
                    PropertyService.setPropertyNoPersist("guid.doi.baseurl", baseurl);
                    PropertyService.setPropertyNoPersist("guid.doi.doishoulder.1", doishoulder);
                    PropertyService.persistProperties();
                    PropertyService.syncToSettings();
                    PropertyService.persistMainBackupProperties();
                }
            }
            catch (GeneralPropertyException gpe) {
                String errorMessage = "EZIDAdmin.configureEZID - Problem getting or setting property while processing system properties page: " + gpe.getMessage();
                this.logMetacat.error((Object)errorMessage);
                processingErrors.add(errorMessage);
            }
            try {
                if (validationErrors.size() > 0 || processingErrors.size() > 0) {
                    RequestUtil.clearRequestMessages(request);
                    RequestUtil.setRequestFormErrors(request, validationErrors);
                    RequestUtil.setRequestErrors(request, processingErrors);
                    RequestUtil.forwardRequest(request, response, "/admin", null);
                } else {
                    PropertyService.setProperty("configutil.ezidConfigured", "true");
                    processingSuccess.add("EZID successfully configured");
                    RequestUtil.clearRequestMessages(request);
                    RequestUtil.setRequestSuccess(request, processingSuccess);
                    RequestUtil.forwardRequest(request, response, "/admin?configureType=configure&processForm=false", null);
                }
            }
            catch (MetacatUtilException mue) {
                throw new AdminException("EZIDAdmin.configureEZID - utility problem while processing ezidservices ezidservices page: " + mue.getMessage());
            }
            catch (GeneralPropertyException gpe) {
                throw new AdminException("EZIDAdmin.configureEZID - problem with properties while processing ezidservices configuration page: " + gpe.getMessage());
            }
        }
    }

    @Override
    protected Vector<String> validateOptions(HttpServletRequest request) {
        Vector<String> errorVector = new Vector<String>();
        return errorVector;
    }
}

