/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.admin;

import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.utilities.GeneralPropertyException;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public abstract class MetacatAdmin {
    public static final String SUCCESS = "success";
    public static final String FAILURE = "failure";
    public static final String IN_PROGRESS = "in_progress";

    protected abstract Vector<String> validateOptions(HttpServletRequest var1);

    public static void updateUpgradeStatus(String propertyName, String status, boolean persist) throws GeneralPropertyException {
        PropertyService.setPropertyNoPersist(propertyName, status);
        if (status.equals(SUCCESS)) {
            Map<String, String> properties = PropertyService.getPropertiesByGroup("configutil.upgrade");
            Set<String> names = properties.keySet();
            boolean success = true;
            for (String name : names) {
                if (name.equals("configutil.upgrade.status") || name.equals(propertyName) || PropertyService.getProperty(name).equals(SUCCESS)) continue;
                success = false;
                break;
            }
            if (success) {
                PropertyService.setPropertyNoPersist("configutil.upgrade.status", SUCCESS);
            }
        } else if (status.equals(FAILURE) || status.equals(IN_PROGRESS)) {
            PropertyService.setPropertyNoPersist("configutil.upgrade.status", status);
        }
        if (persist) {
            PropertyService.persistProperties();
            PropertyService.syncToSettings();
        }
    }
}

