/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.admin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SolrVersionChecker {
    private static final String CONFDIR = "conf";
    private static final String CONFILE = "solrconfig.xml";
    private static final String LUCENEPATH = "//luceneMatchVersion";
    private static final String VERSION34 = "LUCENE_34";
    private DocumentBuilder builder = null;
    private Log logMetacat = LogFactory.getLog(SolrVersionChecker.class);

    public SolrVersionChecker() throws ParserConfigurationException {
        DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
        dFactory.setNamespaceAware(false);
        this.builder = dFactory.newDocumentBuilder();
    }

    public boolean isVersion_3_4(String solrHome) throws SAXException, IOException, TransformerException {
        boolean isVersion34 = false;
        String configFile = solrHome + File.separator + CONFDIR + File.separator + CONFILE;
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(configFile), "UTF-8");
        InputSource source = new InputSource(reader);
        Document doc = this.builder.parse(source);
        NodeList list = XPathAPI.selectNodeList((Node)doc, (String)LUCENEPATH);
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                Node textNode = node.getFirstChild();
                if (textNode.getNodeType() != 3) continue;
                String version = textNode.getNodeValue();
                this.logMetacat.info((Object)("SolrVersionChecker.isVersion_3_4 - the value for the path //luceneMatchVersion has been found and its value is " + version + " And our target value is " + VERSION34));
                if (version == null || !version.equals(VERSION34)) continue;
                isVersion34 = true;
            }
        }
        return isVersion34;
    }
}

