/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.admin.upgrade;

import edu.ucsb.nceas.metacat.IdentifierManager;
import edu.ucsb.nceas.metacat.admin.AdminException;
import edu.ucsb.nceas.metacat.admin.upgrade.UpgradeUtilityInterface;
import edu.ucsb.nceas.metacat.dataone.MNodeService;
import edu.ucsb.nceas.metacat.dataone.hazelcast.HazelcastService;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.utilities.SortedProperties;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wicket.protocol.http.mock.MockHttpServletRequest;
import org.dataone.service.types.v1.Event;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;

public class RemoveInvalidReplicas
implements UpgradeUtilityInterface {
    protected static Log log = LogFactory.getLog(RemoveInvalidReplicas.class);
    private String driver = null;
    private String url = null;
    private String user = null;
    private String password = null;
    private boolean dryRun = false;
    private int serverLocation = 0;

    public int getServerLocation() {
        return this.serverLocation;
    }

    public void setServerLocation(int serverLocation) {
        this.serverLocation = serverLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean upgrade() throws AdminException {
        boolean success = true;
        if (this.serverLocation == 1) {
            throw new AdminException("This is a DESTRUCTIVE action. Cannot remove original objects from home server: " + this.serverLocation);
        }
        Connection sqlca = null;
        PreparedStatement pstmt = null;
        try {
            log.debug((Object)("dryRun: " + this.dryRun));
            this.driver = PropertyService.getProperty("database.driver");
            this.url = PropertyService.getProperty("database.connectionURI");
            this.user = PropertyService.getProperty("database.user");
            this.password = PropertyService.getProperty("database.password");
            Driver d = (Driver)Class.forName(this.driver).newInstance();
            DriverManager.registerDriver(d);
            sqlca = DriverManager.getConnection(this.url, this.user, this.password);
            sqlca.setAutoCommit(true);
            ArrayList<String> invalidReplicas = new ArrayList<String>();
            pstmt = sqlca.prepareStatement("SELECT distinct guid FROM xml_documents xml, identifier id, access_log log WHERE id.docid = xml.docid AND id.rev = xml.rev AND log.docid = id.docid || '.' || id.rev AND xml.server_location = ? AND log.event = ? UNION SELECT distinct guid FROM xml_revisions xml, identifier id, access_log log WHERE id.docid = xml.docid AND id.rev = xml.rev AND log.docid = id.docid || '.' || id.rev AND xml.server_location = ? AND log.event = ? ");
            pstmt.setInt(1, this.serverLocation);
            pstmt.setString(2, Event.SYNCHRONIZATION_FAILED.xmlValue());
            pstmt.setInt(3, this.serverLocation);
            pstmt.setString(4, Event.SYNCHRONIZATION_FAILED.xmlValue());
            log.debug((Object)("Finding invalid (failed replicas with SQL: " + pstmt.toString()));
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                invalidReplicas.add(rs.getString(1));
            }
            log.debug((Object)("invalidReplicas count: " + invalidReplicas.size()));
            pstmt = sqlca.prepareStatement("DELETE FROM identifier WHERE guid = ? ");
            MockHttpServletRequest request = new MockHttpServletRequest(null, null, null);
            Session session = new Session();
            Subject subject = MNodeService.getInstance((HttpServletRequest)request).getCapabilities().getSubject(0);
            session.setSubject(subject);
            for (String identifier : invalidReplicas) {
                log.debug((Object)("Removing invalid replica: " + identifier));
                Identifier pid = new Identifier();
                pid.setValue(identifier);
                try {
                    if (this.dryRun) continue;
                    MNodeService.getInstance((HttpServletRequest)request).delete(session, pid);
                    log.debug((Object)("Deleted invalid replica object: " + pid.getValue()));
                    IdentifierManager.getInstance().deleteSystemMetadata(identifier);
                    log.debug((Object)("Deleted invalid replica SystemMetadata for: " + pid.getValue()));
                    if (IdentifierManager.getInstance().mappingExists(identifier)) {
                        String localId = IdentifierManager.getInstance().getLocalId(identifier);
                        IdentifierManager.getInstance().removeMapping(identifier, localId);
                        log.debug((Object)("Removed localId mapping: " + localId));
                    } else {
                        pstmt.setString(1, identifier);
                        int count = pstmt.executeUpdate();
                        log.debug((Object)("Removed identifier entry with SQL: " + pstmt.toString()));
                        if (count <= 0) {
                            log.warn((Object)("Delete returned unexpected count for pid: " + identifier));
                        }
                    }
                    HazelcastService.getInstance().getSystemMetadataMap().evict((Object)pid);
                    log.debug((Object)("Evicted identifier from HZ map: " + pid.getValue()));
                }
                catch (Exception e) {
                    log.error((Object)("Could not delete invalid replica: " + identifier), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            success = false;
        }
        finally {
            if (sqlca != null) {
                try {
                    sqlca.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        log.debug((Object)"Done removing failed/invalid replicas");
        return success;
    }

    public static void main(String[] args) {
        try {
            SortedProperties testProperties = new SortedProperties("test/test.properties");
            testProperties.load();
            String metacatContextDir = testProperties.getProperty("metacat.contextDir");
            PropertyService.getInstance(metacatContextDir + "/WEB-INF");
            RemoveInvalidReplicas upgrader = new RemoveInvalidReplicas();
            if (args.length > 0) {
                String serverLocation = args[0];
                upgrader.setServerLocation(Integer.parseInt(serverLocation));
            }
            upgrader.upgrade();
        }
        catch (Exception ex) {
            System.out.println("Exception:" + ex.getMessage());
            ex.printStackTrace();
        }
    }
}

