/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.advancedsearch;

import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Stylizer {
    private Log logMetacat = LogFactory.getLog(Stylizer.class);

    public String resultsetToHTML(String resultset, String sessionId, String metacatURL, String qformat, String xslPath) {
        String htmlString = "";
        StringWriter stringWriter = new StringWriter();
        File xsltFile = new File(xslPath);
        StringReader stringReader = new StringReader(resultset);
        StreamSource xmlSource = new StreamSource(stringReader);
        StreamSource xsltSource = new StreamSource(xsltFile);
        StreamResult result = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer(xsltSource);
            String contextURL = SystemUtil.getContextURL();
            transformer.setParameter("contextURL", contextURL);
            if (sessionId != null) {
                transformer.setParameter("sessid", sessionId);
            }
            transformer.setParameter("metacatURL", metacatURL);
            if (qformat != null && !qformat.equals("")) {
                transformer.setParameter("qformat", qformat);
            }
            transformer.transform(xmlSource, result);
            htmlString = stringWriter.toString();
        }
        catch (TransformerConfigurationException tce) {
            Throwable x = tce;
            if (tce.getException() != null) {
                x = tce.getException();
            }
            ((Throwable)x).printStackTrace();
        }
        catch (TransformerException te) {
            Throwable x = te;
            if (te.getException() != null) {
                x = te.getException();
            }
            ((Throwable)x).printStackTrace();
        }
        catch (PropertyNotFoundException pnfe) {
            pnfe.printStackTrace();
        }
        return htmlString;
    }
}

