/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.client.rest;

import edu.ucsb.nceas.metacat.client.DocumentNotFoundException;
import edu.ucsb.nceas.metacat.client.InsufficientKarmaException;
import edu.ucsb.nceas.metacat.client.MetacatAuthException;
import edu.ucsb.nceas.metacat.client.MetacatException;
import edu.ucsb.nceas.metacat.client.MetacatInaccessibleException;
import edu.ucsb.nceas.metacat.client.rest.MetacatRest;
import edu.ucsb.nceas.utilities.IOUtil;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MetacatRestClient
implements MetacatRest {
    private String sessionId;
    private String contextRootUrl;

    public MetacatRestClient(String contextRootUrl) {
        this.setContextRootUrl(contextRootUrl);
    }

    @Override
    public String login(String username, String password) throws MetacatAuthException, MetacatInaccessibleException {
        String urlParams = "op=login";
        String postData = "username=" + username + "&password=" + password;
        String response = null;
        try {
            response = this.sendData("session", "POST", urlParams, postData, "application/x-www-form-urlencoded", null, null);
        }
        catch (Exception e) {
            throw new MetacatInaccessibleException(e.getMessage());
        }
        if (response.indexOf("<login>") == -1) {
            this.setSessionId("");
            throw new MetacatAuthException(response);
        }
        int start = response.indexOf("<sessionId>") + 11;
        int end = response.indexOf("</sessionId>");
        if (start != -1 && end != -1) {
            this.setSessionId(response.substring(start, end));
        }
        return response;
    }

    @Override
    public String logout() throws MetacatInaccessibleException, MetacatException {
        String response;
        String urlParams = "op=logout";
        String postData = "sessionid=" + this.sessionId;
        try {
            response = this.sendData("session", "POST", urlParams, postData, "application/x-www-form-urlencoded", null, null);
        }
        catch (Exception e) {
            throw new MetacatInaccessibleException(e.getMessage());
        }
        return response;
    }

    @Override
    public Reader getObject(String docid, String outFile) throws InsufficientKarmaException, MetacatInaccessibleException, DocumentNotFoundException, MetacatException {
        String resource = "object/" + docid;
        try {
            String response = this.sendData(resource, "GET", null, null, null, null, outFile);
            if (response != null) {
                if (response != null && response.indexOf("<error>") != -1) {
                    if (response.indexOf("does not have permission") != -1) {
                        throw new InsufficientKarmaException(response);
                    }
                    if (response.indexOf("does not exist") != -1) {
                        throw new DocumentNotFoundException(response);
                    }
                    throw new MetacatException(response);
                }
                return new StringReader(response);
            }
            throw new MetacatException(response);
        }
        catch (IOException ioe) {
            throw new MetacatInaccessibleException(ioe.getMessage());
        }
    }

    @Override
    public Reader authenticatedGetObject(String docid, String outFile) throws InsufficientKarmaException, MetacatInaccessibleException, DocumentNotFoundException, MetacatException {
        String resource = "object/" + docid;
        try {
            String response = this.sendData(resource, "GET", "sessionid=" + this.sessionId, null, null, null, outFile);
            if (response != null) {
                if (response != null && response.indexOf("<error>") != -1) {
                    if (response.indexOf("does not have permission") != -1) {
                        throw new InsufficientKarmaException(response);
                    }
                    if (response.indexOf("does not exist") != -1) {
                        throw new DocumentNotFoundException(response);
                    }
                    throw new MetacatException(response);
                }
                return new StringReader(response);
            }
            throw new MetacatException(response);
        }
        catch (IOException ioe) {
            throw new MetacatInaccessibleException(ioe.getMessage());
        }
    }

    @Override
    public Reader query(Reader xmlQuery) throws MetacatInaccessibleException, IOException {
        String response = null;
        try {
            response = this.sendData("object", "POST", null, null, "text/xml", xmlQuery, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MetacatInaccessibleException(e.getMessage());
        }
        if (response != null) {
            return new StringReader(response);
        }
        return null;
    }

    @Override
    public Reader authenticatedQuery(Reader xmlQuery) throws MetacatInaccessibleException, IOException {
        String response = null;
        try {
            response = this.sendData("object", "POST", "sessionid=" + this.sessionId, null, "text/xml", xmlQuery, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MetacatInaccessibleException(e.getMessage());
        }
        if (response != null) {
            return new StringReader(response);
        }
        return null;
    }

    @Override
    public String create(String docid, Reader xmlDocument) throws InsufficientKarmaException, MetacatException, IOException, MetacatInaccessibleException {
        return this.putObject(docid, xmlDocument, true);
    }

    @Override
    public String update(String docid, Reader xmlDocument) throws InsufficientKarmaException, MetacatException, IOException, MetacatInaccessibleException {
        return this.putObject(docid, xmlDocument, false);
    }

    @Override
    public String deleteObject(String docid) throws InsufficientKarmaException, MetacatException, MetacatInaccessibleException {
        String resource = "object/" + docid;
        String urlParams = "sessionid=" + this.sessionId + "&";
        String response = null;
        try {
            response = this.sendData(resource, "DELETE", urlParams, null, null, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MetacatInaccessibleException(e.getMessage());
        }
        if (response.indexOf("<error>") != -1) {
            if (response.indexOf("does not have permission") != -1) {
                throw new InsufficientKarmaException(response);
            }
            throw new MetacatException(response);
        }
        return response;
    }

    @Override
    public String getNextObject(String scope) throws MetacatException {
        String lastIdentifier = "";
        String resource = "identifier";
        String urlParams = "op=getnextobject";
        if (scope != null) {
            urlParams = urlParams + "&scope=" + scope;
        }
        String response = null;
        try {
            response = this.sendData(resource, "GET", urlParams, null, null, null, null);
            if (response.indexOf("<error>") != -1) {
                throw new MetacatException(response);
            }
            StringReader responseReader = new StringReader(response);
            Node root = XMLUtilities.getXMLReaderAsDOMTreeRootNode((Reader)responseReader);
            Node docidNode = XMLUtilities.getNodeWithXPath((Node)root, (String)"/lastDocid/docid");
            lastIdentifier = docidNode.getFirstChild().getNodeValue();
        }
        catch (Exception e) {
            throw new MetacatException(e.getMessage());
        }
        return lastIdentifier;
    }

    @Override
    public int getNextRevision(String identifierId) throws MetacatException {
        int rev = 0;
        String resource = "identifier/" + identifierId;
        String urlParams = "op=getnextrevision";
        String response = null;
        try {
            response = this.sendData(resource, "GET", urlParams, null, null, null, null);
            if (response.indexOf("<error>") != -1) {
                throw new MetacatException(response);
            }
            StringReader responseReader = new StringReader(response);
            Node root = XMLUtilities.getXMLReaderAsDOMTreeRootNode((Reader)responseReader);
            Node docidNode = XMLUtilities.getNodeWithXPath((Node)root, (String)"/next-revision");
            rev = Integer.parseInt(docidNode.getFirstChild().getNodeValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MetacatException(e.getMessage());
        }
        return rev;
    }

    @Override
    public Vector<String> getAllDocids(String scope) throws MetacatException {
        Vector<String> resultVec = new Vector<String>();
        String resource = "identifier";
        String urlParams = "op=getalldocids";
        if (scope != null) {
            urlParams = urlParams + "&scope=" + scope;
        }
        String response = null;
        try {
            response = this.sendData(resource, "GET", urlParams, null, null, null, null);
            if (response.indexOf("<error>") != -1) {
                throw new MetacatException(response);
            }
            StringReader responseReader = new StringReader(response);
            Node root = XMLUtilities.getXMLReaderAsDOMTreeRootNode((Reader)responseReader);
            NodeList nlist = root.getChildNodes();
            for (int i = 0; i < nlist.getLength(); ++i) {
                Node n = nlist.item(i);
                if (!n.getNodeName().equals("docid")) continue;
                String nodeVal = n.getFirstChild().getNodeValue();
                resultVec.addElement(nodeVal);
            }
        }
        catch (Exception e) {
            throw new MetacatException(e.getMessage());
        }
        return resultVec;
    }

    @Override
    public boolean isRegistered(String identifierId) throws MetacatException {
        String resource = "identifier/" + identifierId;
        String urlParams = "op=isregistered";
        String response = null;
        try {
            response = this.sendData(resource, "GET", urlParams, null, null, null, null);
            if (response.indexOf("<error>") != -1) {
                throw new MetacatException(response);
            }
            StringReader responseReader = new StringReader(response);
            StringBuffer sb = new StringBuffer();
            char[] c = new char[1024];
            int numread = ((Reader)responseReader).read(c, 0, 1024);
            while (numread != -1) {
                sb.append(new String(c, 0, numread));
                numread = ((Reader)responseReader).read(c, 0, 1024);
            }
            String responseStr = sb.toString();
            return responseStr.indexOf("true") != -1;
        }
        catch (Exception e) {
            throw new MetacatException(e.getMessage());
        }
    }

    @Override
    public String addLSID(String identifierId) throws MetacatException {
        String resource = "identifier/" + identifierId;
        String response = null;
        try {
            response = this.sendData(resource, "PUT", null, null, null, null, null);
        }
        catch (Exception e) {
            throw new MetacatException(e.getMessage());
        }
        return response;
    }

    @Override
    public void setContextRootUrl(String contextRootUrl) {
        if (!contextRootUrl.endsWith("/")) {
            contextRootUrl = contextRootUrl + "/";
        }
        this.contextRootUrl = contextRootUrl;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    private String putObject(String docid, Reader xmlDocument, boolean isInsert) throws InsufficientKarmaException, MetacatException, IOException, MetacatInaccessibleException {
        String resource = "object/" + docid;
        String urlParams = "sessionid=" + this.sessionId + "&";
        urlParams = isInsert ? urlParams + "op=insert" : urlParams + "op=update";
        String response = null;
        try {
            response = this.sendData(resource, "PUT", urlParams, null, "text/xml", xmlDocument, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MetacatInaccessibleException(e.getMessage());
        }
        if (response.indexOf("<error>") != -1) {
            if (response.indexOf("does not have permission") != -1) {
                throw new InsufficientKarmaException(response);
            }
            throw new MetacatException(response);
        }
        return response;
    }

    private String sendData(String resource, String method, String urlParamaters, String postData, String contentType, Reader postFileReader, String outputFile) throws IOException {
        HttpURLConnection connection = null;
        String restURL = this.contextRootUrl + resource;
        if (urlParamaters != null) {
            if (restURL.indexOf("?") == -1) {
                restURL = restURL + "?";
            }
            restURL = restURL + urlParamaters;
        }
        URL u = new URL(restURL);
        URLConnection uc = u.openConnection();
        connection = (HttpURLConnection)uc;
        if (contentType != null) {
            connection.setRequestProperty("Content-Type", contentType);
        }
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestMethod(method);
        if (!method.equals("GET")) {
            if (postFileReader != null) {
                postData = IOUtil.getAsString((Reader)postFileReader, (boolean)true);
            }
            if (postData != null) {
                OutputStream out = connection.getOutputStream();
                OutputStreamWriter wout = new OutputStreamWriter(out);
                wout.write(postData);
                ((Writer)wout).flush();
                ((Writer)wout).close();
            }
        }
        return this.readStream(connection.getInputStream(), outputFile);
    }

    private String readStream(InputStream is, String writeFile) throws IOException {
        String inputLine;
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        StringBuffer b = new StringBuffer();
        FileWriter writer = null;
        if (writeFile != null) {
            writer = new FileWriter(writeFile);
        }
        while ((inputLine = in.readLine()) != null) {
            b.append(inputLine + "\n");
            if (writeFile == null) continue;
            writer.write(inputLine);
        }
        if (writeFile != null) {
            writer.flush();
            writer.close();
        }
        in.close();
        return b.toString();
    }
}

