/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.dataone;

import edu.ucsb.nceas.metacat.dataone.D1NodeService;
import edu.ucsb.nceas.metacat.dataone.MNodeService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.client.v2.CNode;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Group;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.NodeType;
import org.dataone.service.types.v1.Permission;
import org.dataone.service.types.v1.Replica;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.SubjectInfo;
import org.dataone.service.types.v1.util.AuthUtils;
import org.dataone.service.types.v2.Node;
import org.dataone.service.types.v2.NodeList;
import org.dataone.service.types.v2.SystemMetadata;
import org.dataone.service.types.v2.util.NodelistUtil;

public class D1AuthHelper {
    private static Log logMetacat = LogFactory.getLog(D1NodeService.class);
    private HttpServletRequest request;
    private String notAuthorizedCode;
    private String serviceFailureCode;
    private Identifier requestIdentifier;
    private static NodeList cnList = null;

    public D1AuthHelper(HttpServletRequest request, Identifier requestIdentifier, String notAuthorizedCode, String serviceFailureCode) {
        this.request = request;
        this.requestIdentifier = requestIdentifier;
        this.notAuthorizedCode = notAuthorizedCode;
        this.serviceFailureCode = serviceFailureCode;
    }

    public void doIsAuthorized(Session session, SystemMetadata sysmeta, Permission permission) throws ServiceFailure, NotAuthorized {
        if (session != null && session.getSubject() != null) {
            logMetacat.debug((Object)("D1AuthHepler.doIsAuthorzied - the session is " + session.getSubject().getValue()));
        }
        ArrayList<ServiceFailure> exceptions = new ArrayList<ServiceFailure>();
        if (this.isAuthorizedBySysMetaSubjects(session, sysmeta, permission)) {
            return;
        }
        try {
            if (this.isLocalNodeAdmin(session, null)) {
                return;
            }
        }
        catch (ServiceFailure e) {
            exceptions.add(e);
        }
        try {
            NodeList nodelist = this.getCNNodeList();
            if (this.isAuthoritativeMNodeAdmin(session, sysmeta.getAuthoritativeMemberNode(), nodelist)) {
                return;
            }
            if (this.isCNAdmin(session, nodelist)) {
                return;
            }
        }
        catch (ServiceFailure e) {
            exceptions.add(e);
        }
        try {
            if (this.checkExpandedPermissions(session, sysmeta, permission)) {
                return;
            }
        }
        catch (ServiceFailure e) {
            exceptions.add(e);
        }
        if (!exceptions.isEmpty()) {
            ServiceFailure sf = (ServiceFailure)((Object)exceptions.get(0));
            sf.setDetail_code(this.serviceFailureCode);
            throw sf;
        }
        this.prepareAndThrowNotAuthorized(session, this.requestIdentifier, permission, this.notAuthorizedCode);
    }

    public void doAuthoritativeMNAuthorization(Session session, SystemMetadata sysmeta) throws ServiceFailure, NotAuthorized {
        if (session != null && session.getSubject() != null) {
            logMetacat.debug((Object)("D1AuthHepler.doAuthoritativeMNAuthorization - the session is " + session.getSubject().getValue()));
        }
        ArrayList<ServiceFailure> exceptions = new ArrayList<ServiceFailure>();
        try {
            if (this.isLocalNodeAdmin(session, null)) {
                return;
            }
        }
        catch (ServiceFailure e) {
            exceptions.add(e);
        }
        try {
            NodeList nodelist = this.getCNNodeList();
            if (this.isAuthoritativeMNodeAdmin(session, sysmeta.getAuthoritativeMemberNode(), nodelist)) {
                return;
            }
        }
        catch (ServiceFailure e) {
            exceptions.add(e);
        }
        if (!exceptions.isEmpty()) {
            ServiceFailure sf = (ServiceFailure)((Object)exceptions.get(0));
            sf.setDetail_code(this.serviceFailureCode);
            throw sf;
        }
        this.prepareAndThrowNotAuthorized(session, this.requestIdentifier, null, this.notAuthorizedCode);
    }

    public void doUpdateAuth(Session session, SystemMetadata sysmeta, Permission permission, NodeReference localNodeId) throws NotAuthorized, ServiceFailure {
        if (session != null && session.getSubject() != null) {
            logMetacat.debug((Object)("D1AuthHepler.doUpdateAuth - the session is " + session.getSubject().getValue()));
        }
        boolean isAuthoritiveMN = true;
        ArrayList<ServiceFailure> exceptions = new ArrayList<ServiceFailure>();
        if (sysmeta.getAuthoritativeMemberNode().equals((Object)localNodeId) && StringUtils.isNotBlank((String)sysmeta.getAuthoritativeMemberNode().getValue())) {
            if (this.isAuthorizedBySysMetaSubjects(session, sysmeta, permission)) {
                return;
            }
            try {
                if (this.isLocalMNAdmin(session)) {
                    return;
                }
            }
            catch (ServiceFailure e) {
                exceptions.add(e);
            }
            try {
                if (this.checkExpandedPermissions(session, sysmeta, permission)) {
                    return;
                }
            }
            catch (ServiceFailure e) {
                exceptions.add(e);
            }
        } else {
            isAuthoritiveMN = false;
        }
        try {
            NodeList nodelist = this.getCNNodeList();
            if (this.isCNAdmin(session, nodelist)) {
                return;
            }
        }
        catch (ServiceFailure e) {
            exceptions.add(e);
        }
        String authoritiveMNMessage = "clients can only call the update/updateSystemMetadata request on an object when it locates on its authoritative memember node. However, the authoritative member node of the object " + sysmeta.getIdentifier().getValue() + " on your request is " + sysmeta.getAuthoritativeMemberNode().getValue() + ", which is differen to the current node " + localNodeId.getValue();
        if (exceptions.isEmpty()) {
            if (!isAuthoritiveMN) {
                logMetacat.warn((Object)authoritiveMNMessage);
                throw new NotAuthorized(this.notAuthorizedCode, authoritiveMNMessage);
            }
        } else {
            for (ServiceFailure sf : exceptions) {
                logMetacat.warn((Object)("For request [" + this.request + "]: ServiceFailure raised:" + sf.getDescription()), (Throwable)sf);
            }
            ServiceFailure sf = (ServiceFailure)((Object)exceptions.get(0));
            sf.setDetail_code(this.serviceFailureCode);
            throw sf;
        }
        this.prepareAndThrowNotAuthorized(session, this.requestIdentifier, permission, this.notAuthorizedCode);
    }

    public void doCNOnlyAuthorization(Session session) throws ServiceFailure, NotAuthorized {
        if (session != null && session.getSubject() != null) {
            logMetacat.debug((Object)("D1AuthHepler.doCNOnlyAuthorization - the session is " + session.getSubject().getValue()));
        }
        ArrayList<ServiceFailure> exceptions = new ArrayList<ServiceFailure>();
        try {
            if (this.isLocalNodeAdmin(session, NodeType.CN)) {
                return;
            }
        }
        catch (ServiceFailure e) {
            exceptions.add(e);
        }
        try {
            NodeList nodelist = this.getCNNodeList();
            if (this.isCNAdmin(session, nodelist)) {
                return;
            }
        }
        catch (ServiceFailure e) {
            exceptions.add(e);
        }
        if (!exceptions.isEmpty()) {
            ServiceFailure sf = (ServiceFailure)((Object)exceptions.get(0));
            sf.setDetail_code(this.serviceFailureCode);
            throw sf;
        }
        this.prepareAndThrowNotAuthorized(session, this.requestIdentifier, null, this.notAuthorizedCode);
    }

    public void doAdminAuthorization(Session session) throws ServiceFailure, NotAuthorized {
        if (session != null && session.getSubject() != null) {
            logMetacat.debug((Object)("D1AuthHepler.doAdminAuthorization - the session is " + session.getSubject().getValue()));
        }
        ArrayList<ServiceFailure> exceptions = new ArrayList<ServiceFailure>();
        try {
            if (this.isLocalNodeAdmin(session, null)) {
                return;
            }
        }
        catch (ServiceFailure e) {
            exceptions.add(e);
        }
        try {
            NodeList nodelist = this.getCNNodeList();
            if (this.isCNAdmin(session, nodelist)) {
                return;
            }
        }
        catch (ServiceFailure e) {
            exceptions.add(e);
        }
        if (!exceptions.isEmpty()) {
            ServiceFailure sf = (ServiceFailure)((Object)exceptions.get(0));
            sf.setDetail_code(this.serviceFailureCode);
            throw sf;
        }
        this.prepareAndThrowNotAuthorized(session, this.requestIdentifier, null, this.notAuthorizedCode);
    }

    public void doGetSysmetaAuthorization(Session session, SystemMetadata sysmeta, Permission permission) throws ServiceFailure, NotAuthorized {
        if (session != null && session.getSubject() != null) {
            logMetacat.debug((Object)("D1AuthHepler.doGetSysmetaAuthorization - the session is " + session.getSubject().getValue()));
        }
        ArrayList<ServiceFailure> exceptions = new ArrayList<ServiceFailure>();
        if (this.isAuthorizedBySysMetaSubjects(session, sysmeta, permission)) {
            return;
        }
        try {
            if (this.isLocalNodeAdmin(session, null)) {
                return;
            }
        }
        catch (ServiceFailure e) {
            exceptions.add(e);
        }
        try {
            NodeList nodelist = this.getCNNodeList();
            if (this.isAuthoritativeMNodeAdmin(session, sysmeta.getAuthoritativeMemberNode(), nodelist)) {
                return;
            }
            if (this.isCNAdmin(session, nodelist)) {
                return;
            }
            if (this.isReplicaMNodeAdmin(session, sysmeta, nodelist)) {
                return;
            }
        }
        catch (ServiceFailure e) {
            exceptions.add(e);
        }
        try {
            if (this.checkExpandedPermissions(session, sysmeta, permission)) {
                return;
            }
        }
        catch (ServiceFailure e) {
            exceptions.add(e);
        }
        if (!exceptions.isEmpty()) {
            ServiceFailure sf = (ServiceFailure)((Object)exceptions.get(0));
            sf.setDetail_code(this.serviceFailureCode);
            throw sf;
        }
        this.prepareAndThrowNotAuthorized(session, this.requestIdentifier, permission, this.notAuthorizedCode);
    }

    protected void prepareAndThrowNotAuthorized(Session session, Identifier pid, Permission permission, String detailCode) throws NotAuthorized {
        Set sessionSubjects = AuthUtils.authorizedClientSubjects((Session)session);
        StringBuffer includedSubjects = new StringBuffer();
        for (Subject s : sessionSubjects) {
            includedSubjects.append(s.getValue() + "; ");
        }
        String msg = String.format("%s not allowed on %s for subject[s]: %s", permission == null ? "Permission" : permission, pid == null ? null : pid.getValue(), includedSubjects.toString());
        logMetacat.warn((Object)msg);
        throw new NotAuthorized(detailCode, msg);
    }

    protected boolean checkExpandedPermissions(Session session, SystemMetadata sysmeta, Permission permission) throws ServiceFailure {
        boolean isAllowed = false;
        try {
            Set sessionSubjects = AuthUtils.authorizedClientSubjects((Session)session);
            for (Subject s : sessionSubjects) {
                if (s.getValue().equalsIgnoreCase("public") || !D1AuthHelper.expandRightsHolder(sysmeta.getRightsHolder(), s)) continue;
                isAllowed = true;
                break;
            }
        }
        catch (InvalidRequest | InvalidToken | NotImplemented e) {
            ServiceFailure sf = new ServiceFailure("1030", "Exception thrown from expandRightsHolder(): " + e.getClass().getCanonicalName() + ":: " + e.getDescription());
            sf.initCause(e);
            throw sf;
        }
        catch (NotAuthorized e) {
            isAllowed = false;
        }
        return isAllowed;
    }

    protected NodeList getCNNodeList() throws ServiceFailure {
        if (cnList != null && cnList.getNodeList() != null && cnList.getNodeList().size() > 0) {
            logMetacat.debug((Object)"D1AuthHelper.getCNNodeList - got the cn list from the cache.");
            return cnList;
        }
        try {
            CNode cn = D1Client.getCN();
            logMetacat.debug((Object)"D1AuthHelper.getCNNodeList - got CN instance and get the cn list from the network.");
            cnList = cn.listNodes();
            return cnList;
        }
        catch (NotImplemented e) {
            logMetacat.error((Object)"Unexpected Error getting NodeList from getCNNodeList().  Got 'NotImplemented' from the service call!", (Throwable)e);
            throw new ServiceFailure("", "Could not get NodeList from the CN. got 'NotImplemented' from the service call!");
        }
    }

    public static boolean expandRightsHolder(Subject rightHolder, Subject sessionSubject) throws ServiceFailure, NotImplemented, InvalidRequest, NotAuthorized, InvalidToken {
        boolean is = false;
        if (rightHolder != null && sessionSubject != null && rightHolder.getValue() != null && !rightHolder.getValue().trim().equals("") && sessionSubject.getValue() != null && !sessionSubject.getValue().trim().equals("")) {
            CNode cn = D1Client.getCN();
            logMetacat.debug((Object)("D1AuthorizationDelegate.expandRightHolder - at the start of method: after getting the cn node and cn node is " + cn.getNodeBaseServiceUrl()));
            String query = rightHolder.getValue();
            int start = 0;
            int count = 200;
            String status = null;
            Session session = null;
            SubjectInfo subjects = cn.listSubjects(session, query, status, Integer.valueOf(start), Integer.valueOf(count));
            while (subjects != null) {
                int totalSize;
                logMetacat.debug((Object)("D1AuthorizationDelegate.expandRightHolder - search the subject " + query + " in the cn and the returned result is not null"));
                List groups = subjects.getGroupList();
                is = D1AuthHelper.isInGroups(sessionSubject, rightHolder, groups);
                if (is) {
                    return is;
                }
                int sizeOfGroups = 0;
                if (groups != null) {
                    sizeOfGroups = groups.size();
                }
                List persons = subjects.getPersonList();
                int sizeOfPersons = 0;
                if (persons != null) {
                    sizeOfPersons = persons.size();
                }
                if ((totalSize = sizeOfGroups + sizeOfPersons) == count) {
                    logMetacat.debug((Object)("D1AuthorizationDelegate.expandRightHolder - search the subject " + query + " in the cn and the size of return result equals the count " + totalSize + " .And we didn't find the target in the this query. So we have to use the page query with the start number " + (start += count)));
                    subjects = cn.listSubjects(session, query, status, Integer.valueOf(start), Integer.valueOf(count));
                    continue;
                }
                if (totalSize < count) {
                    logMetacat.debug((Object)("D1AuthorizationDelegate.expandRightHolder - we are already at the end of the returned restult since the size of returned results " + totalSize + " is less than the count " + count + ". So we have to break the loop and finish the try."));
                    break;
                }
                if (totalSize <= count) continue;
                logMetacat.warn((Object)("D1AuthorizationDelegate.expandRightHolder - Something is wrong on the implementation of the method listSubject since the size of returned results " + totalSize + " is greater than the count " + count + ". So we have to break the loop and finish the try."));
                break;
            }
            if (!is) {
                logMetacat.debug((Object)("D1AuthorizationDelegate.expandRightHolder - We can NOT find any member in the group " + query + " (if it is a group) matches the user " + sessionSubject.getValue()));
            }
        } else {
            logMetacat.debug((Object)"D1AuthorizationDelegate.expandRightHolder - We can't determine if the use subject is a member of the right holder group since one of them is null or blank");
        }
        return is;
    }

    private static boolean isInGroups(Subject userSession, Subject rightHolder, List<Group> groups) {
        boolean is = false;
        if (groups != null) {
            logMetacat.debug((Object)("D1NodeService.isInGroups -  the given groups' (the returned result including groups) size is " + groups.size()));
            for (Group group : groups) {
                if (group == null || group.getSubject() == null || !group.getSubject().equals((Object)rightHolder)) continue;
                logMetacat.debug((Object)("D1NodeService.isInGroups - there is a group in the list having the subjecct " + group.getSubject().getValue() + " which matches the right holder's subject " + rightHolder.getValue()));
                List members = group.getHasMemberList();
                if (members != null) {
                    logMetacat.debug((Object)("D1NodeService.isInGroups - the group " + group.getSubject().getValue() + " in the cn has members"));
                    for (Subject member : members) {
                        logMetacat.debug((Object)("D1NodeService.isInGroups - compare the member " + member.getValue() + " with the user " + userSession.getValue()));
                        if (member.getValue() == null || member.getValue().trim().equals("") || userSession.getValue() == null || !member.getValue().equals(userSession.getValue())) continue;
                        logMetacat.debug((Object)("D1NodeService.isInGroups - Find it! The member " + member.getValue() + " in the group " + group.getSubject().getValue() + " matches the user " + userSession.getValue()));
                        is = true;
                        return is;
                    }
                }
                break;
            }
        } else {
            logMetacat.debug((Object)"D1NodeService.isInGroups -  the given group is null (the returned result does NOT have a group");
        }
        return is;
    }

    public boolean isLocalMNAdmin(Session session) throws ServiceFailure {
        return this.isLocalNodeAdmin(session, NodeType.MN);
    }

    public boolean isLocalCNAdmin(Session session) throws ServiceFailure {
        return this.isLocalNodeAdmin(session, NodeType.CN);
    }

    protected boolean isLocalNodeAdmin(Session session, NodeType nodeType) throws ServiceFailure {
        boolean allowed = false;
        if (session == null) {
            logMetacat.debug((Object)"In isLocalNodeAdmin(), session is null ");
            return false;
        }
        logMetacat.debug((Object)("In isLocalNodeAdmin(), MN authorization for the user " + session.getSubject().getValue()));
        Node node = MNodeService.getInstance(this.request).getCapabilities();
        NodeReference nodeReference = node.getIdentifier();
        logMetacat.debug((Object)("In isLocalNodeAdmin(), Node reference is: " + nodeReference.getValue()));
        Set sessionSubjects = AuthUtils.authorizedClientSubjects((Session)session);
        if (nodeType == null || node.getType() == nodeType) {
            List nodeSubjects = node.getSubjectList();
            if (sessionSubjects != null) {
                block0: for (Subject subject : sessionSubjects) {
                    for (Subject nodeSubject : nodeSubjects) {
                        logMetacat.debug((Object)("In isLocalNodeAdmin(), comparing subjects: " + nodeSubject.getValue() + " and the user" + subject.getValue()));
                        if (!nodeSubject.equals((Object)subject)) continue;
                        allowed = true;
                        break block0;
                    }
                }
            }
        }
        logMetacat.debug((Object)("In is isLocalNodeAdmin method. Is this a local node admin? " + allowed));
        return allowed;
    }

    protected boolean isAuthorizedBySysMetaSubjects(Session session, SystemMetadata sysmeta, Permission permission) {
        Set sessionSubjects = AuthUtils.authorizedClientSubjects((Session)session);
        if (logMetacat.isDebugEnabled() && sessionSubjects != null) {
            for (Subject subject : sessionSubjects) {
                logMetacat.debug((Object)("=================== The equalvent subject is " + subject.getValue()));
            }
        }
        return AuthUtils.isAuthorized((Collection)sessionSubjects, (Permission)permission, (org.dataone.service.types.v1.SystemMetadata)sysmeta);
    }

    protected boolean isReplicaMNodeAdmin(Session session, SystemMetadata sysmeta, NodeList nodelist) {
        Set nodeListBySubject;
        boolean isAuthorized = false;
        Subject subject = session == null ? null : session.getSubject();
        List replicaList = sysmeta.getReplicaList();
        NodeReference replicaNodeRef = null;
        if (replicaList != null && subject != null && (nodeListBySubject = NodelistUtil.selectNode((NodeList)nodelist, (Subject)subject)).size() > 0) {
            block0: for (Replica replica : replicaList) {
                replicaNodeRef = replica.getReplicaMemberNode();
                for (Node node : nodeListBySubject) {
                    if (!node.getIdentifier().equals((Object)replicaNodeRef)) continue;
                    isAuthorized = true;
                    break block0;
                }
            }
        }
        return isAuthorized;
    }

    protected boolean isAuthoritativeMNodeAdmin(Session session, NodeReference authoritativeMNode, NodeList nodelist) {
        boolean allowed = false;
        if (session == null) {
            return false;
        }
        if (authoritativeMNode == null) {
            return false;
        }
        if (nodelist == null) {
            return false;
        }
        Set sessionSubjects = AuthUtils.authorizedClientSubjects((Session)session);
        if (sessionSubjects == null) {
            return false;
        }
        Node node = NodelistUtil.findNode((NodeList)nodelist, (NodeReference)authoritativeMNode);
        if (node == null) {
            return false;
        }
        List nodeSubjects = node.getSubjectList();
        if (nodeSubjects != null) {
            block0: for (Subject nodeSubject : nodeSubjects) {
                for (Subject sessionSubject : sessionSubjects) {
                    logMetacat.debug((Object)("D1NodeService.isAuthoritativeMNodeAdmin(), comparing subjects: " + nodeSubject.getValue() + " and " + sessionSubject.getValue()));
                    if (nodeSubject == null || !nodeSubject.equals((Object)sessionSubject)) continue;
                    allowed = true;
                    break block0;
                }
            }
        }
        return allowed;
    }

    protected boolean isCNAdmin(Session session, NodeList nodelist) {
        boolean allowed = false;
        logMetacat.debug((Object)"D1NodeService.isCNAdmin - the beginning");
        if (session == null || session.getSubject() == null) {
            return false;
        }
        if (nodelist == null) {
            return false;
        }
        List nodes = nodelist.getNodeList();
        if (nodes == null || nodes.size() == 0) {
            return false;
        }
        Set sessionSubjects = AuthUtils.authorizedClientSubjects((Session)session);
        block0: for (Node node : nodes) {
            NodeReference nodeReference = node.getIdentifier();
            if (logMetacat.isDebugEnabled()) {
                logMetacat.debug((Object)("In isCNAdmin(), a Node reference from the CN node list is: " + nodeReference.getValue()));
            }
            if (node.getType() != NodeType.CN) continue;
            List nodeSubjects = node.getSubjectList();
            for (Subject nodeSubject : nodeSubjects) {
                if (sessionSubjects == null) continue;
                for (Subject subject : sessionSubjects) {
                    if (logMetacat.isDebugEnabled()) {
                        logMetacat.debug((Object)("In isCNAdmin(), comparing subjects: " + nodeSubject.getValue() + " and the user " + subject.getValue()));
                    }
                    if (!nodeSubject.equals((Object)subject)) continue;
                    allowed = true;
                    break block0;
                }
            }
        }
        if (logMetacat.isDebugEnabled()) {
            logMetacat.debug((Object)("D1NodeService.isCNAdmin. Is it a cn admin? " + allowed));
        }
        return allowed;
    }
}

