/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.dataone.quota;

import edu.ucsb.nceas.metacat.IdentifierManager;
import edu.ucsb.nceas.metacat.dataone.hazelcast.HazelcastService;
import edu.ucsb.nceas.metacat.dataone.quota.BookKeeperClient;
import edu.ucsb.nceas.metacat.dataone.quota.CreateUsageTask;
import edu.ucsb.nceas.metacat.dataone.quota.DeleteUsageTask;
import edu.ucsb.nceas.metacat.dataone.quota.UpdateUsageTask;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.bookkeeper.api.Quota;
import org.dataone.bookkeeper.api.Usage;
import org.dataone.configuration.Settings;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v2.SystemMetadata;

public abstract class QuotaService {
    private static Log logMetacat = LogFactory.getLog(QuotaService.class);
    public static String nodeId = Settings.getConfiguration().getString("dataone.nodeId");
    public static int DEFAULT_QUOTA_ID = -1;
    protected static ExecutorService executor = null;
    protected static BookKeeperClient client = null;

    public abstract void enforce(String var1, Subject var2, String var3, SystemMetadata var4, String var5) throws ServiceFailure, InvalidRequest, InsufficientResources, NotImplemented, NotFound, UnsupportedEncodingException;

    protected boolean isLastUnarchivedInChain(String pid, String sid) throws InvalidRequest, ServiceFailure {
        boolean lastOne = true;
        if (sid != null && !sid.trim().equals("") && pid != null && !pid.trim().equals("")) {
            try {
                List<String> guids = IdentifierManager.getInstance().getAllPidsInChain(sid);
                for (String guid : guids) {
                    if (guid.equals(pid)) continue;
                    Identifier identifier = new Identifier();
                    identifier.setValue(guid);
                    SystemMetadata sysmeta = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)identifier);
                    if (sysmeta.getArchived() != null && sysmeta.getArchived().booleanValue()) continue;
                    lastOne = false;
                    logMetacat.debug((Object)("QuotaService.isLastUnarchivedInChain - found the guid " + guid + " in the chain with sid " + sid + " hasn't been archived. So the whole chain hasn't been archived."));
                }
            }
            catch (SQLException e) {
                throw new ServiceFailure("1104", "QuotaService.isLastUnarchivedInChain - Can't get the pids list in the chain with the sid " + sid + " since " + e.getMessage());
            }
        } else {
            throw new InvalidRequest("1102", "QuotaService.isLastUnarchivedInChain - the pid or sid can't be null or blank for the portal quota.");
        }
        return lastOne;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isLastUndeletedInChain(String pid, String sid) throws InvalidRequest, ServiceFailure {
        boolean lastOne = false;
        if (sid == null || sid.trim().equals("") || pid == null || pid.trim().equals("")) throw new InvalidRequest("1102", "QuotaService.isLastUnDletedInChain - the pid or sid can't be null or blank for the portal quota.");
        try {
            String guid;
            List<String> guids = IdentifierManager.getInstance().getAllPidsInChain(sid);
            if (guids.size() != 1 || (guid = guids.get(0)) == null || !guid.equals(pid)) return lastOne;
            lastOne = true;
            logMetacat.debug((Object)("QuotaService.isLastUnDletedInChain - found the pid " + pid + " in the chain with sid " + sid + " is the only object which hasn't been deleted."));
            return lastOne;
        }
        catch (SQLException e) {
            throw new ServiceFailure("1104", "QuotaService.isLastUnDletedInChain - Can't get the pids list in the chain with the sid " + sid + " since " + e.getMessage());
        }
    }

    protected int checkQuota(boolean checkEnoughSpace, String quotaSubject, String requestor, String quotaType, double quantity, String instanceId) throws InvalidRequest, ServiceFailure, InsufficientResources, NotFound, UnsupportedEncodingException {
        int quotaId = DEFAULT_QUOTA_ID;
        boolean hasSpace = false;
        List<Quota> quotas = client.getInstance().listQuotas(quotaSubject, requestor, quotaType);
        for (Quota quota : quotas) {
            if (quota == null) continue;
            if (checkEnoughSpace) {
                Double existedUsagesObj;
                double hardLimit = 0.0;
                double existedUsages = 0.0;
                Double hardLimitObj = quota.getHardLimit();
                if (hardLimitObj != null) {
                    hardLimit = hardLimitObj;
                }
                if ((existedUsagesObj = quota.getTotalUsage()) != null) {
                    existedUsages = existedUsagesObj;
                }
                logMetacat.debug((Object)("QuotaService.lookUpQuotaId - need to check space: the hardLimit in the quota with the quota subject " + quotaSubject + " with the type " + quotaType + "is " + hardLimit + ", the existed usages is " + existedUsages + " and the request amount of usage is " + quantity + " for the instance id " + instanceId));
                if (!(hardLimit >= existedUsages + quantity)) continue;
                quotaId = quota.getId();
                hasSpace = true;
                logMetacat.debug((Object)("QuotaService.lookUpQuotaId - the hardLimit in the quota is " + hardLimit + " and it is greater than or equals the request amount of usage " + quantity + " plus existed usage " + existedUsages + ". So the request is granted for the instance id " + instanceId));
                break;
            }
            logMetacat.debug((Object)("QuotaService.lookUpQuotaId - do NOT need to check space: found a quota with the quota subject " + quotaSubject + " with the type " + quotaType + " for the instance id " + instanceId));
            quotaId = quota.getId();
            hasSpace = true;
            logMetacat.debug((Object)("QuotaService.lookUpQuotaId - do NOT need to check space: found a quota with the quota id " + quotaId + " with the quota subject " + quotaSubject + " with the type " + quotaType + " for the instance id " + instanceId));
            break;
        }
        if (!hasSpace) {
            throw new InsufficientResources("1160", "The quota subject " + quotaSubject + " doesn't have enough " + quotaType + " quota to fullfill the request for the instance id " + instanceId + ". Please contact " + quotaSubject + " to request more quota.");
        }
        return quotaId;
    }

    void createUsage(int quotaId, String instanceId, double quantity) {
        logMetacat.debug((Object)("QuotaService.createUsage - create a usage for the instance id " + instanceId + " for the qutantity " + quantity + " with quota id " + quotaId));
        Usage usage = new Usage();
        usage.setObject("usage");
        usage.setQuotaId(Integer.valueOf(quotaId));
        usage.setInstanceId(instanceId);
        usage.setQuantity(Double.valueOf(quantity));
        usage.setStatus("active");
        usage.setNodeId(nodeId);
        CreateUsageTask task = new CreateUsageTask(usage, client);
        executor.submit(task);
    }

    protected void updateUsage(int quotaId, String instanceId, double quantity) {
        logMetacat.debug((Object)("QuotaService.updateUsage - update a usage with the instance id " + instanceId + " and quota id " + quotaId + " for the qutantity " + quantity));
        Usage usage = new Usage();
        usage.setObject("usage");
        usage.setQuotaId(Integer.valueOf(quotaId));
        usage.setInstanceId(instanceId);
        usage.setQuantity(Double.valueOf(quantity));
        usage.setStatus("inactive");
        usage.setNodeId(nodeId);
        UpdateUsageTask task = new UpdateUsageTask(usage, client);
        executor.submit(task);
    }

    protected void deleteUsage(int quotaId, String instanceId, double quantity) {
        logMetacat.debug((Object)("QuotaService.deleteUsage - delete a usage with the instance id " + instanceId + " and quota id " + quotaId + " for the qutantity " + quantity));
        Usage usage = new Usage();
        usage.setObject("usage");
        usage.setQuotaId(Integer.valueOf(quotaId));
        usage.setInstanceId(instanceId);
        usage.setQuantity(Double.valueOf(quantity));
        usage.setNodeId(nodeId);
        usage.setStatus("deleted");
        DeleteUsageTask task = new DeleteUsageTask(usage, client);
        executor.submit(task);
    }
}

