/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.dataone.quota;

import edu.ucsb.nceas.metacat.dataone.quota.BookKeeperClient;
import edu.ucsb.nceas.metacat.dataone.quota.FailedReportingAttemptChecker;
import edu.ucsb.nceas.metacat.dataone.quota.PortalQuotaService;
import edu.ucsb.nceas.metacat.dataone.quota.QuotaTypeDeterminer;
import edu.ucsb.nceas.metacat.replication.ReplicationHandler;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.configuration.Settings;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v2.SystemMetadata;

public class QuotaServiceManager {
    public static final String USAGE = "usage";
    public static final String ACTIVE = "active";
    public static final String INACTIVE = "inactive";
    public static final String DELETED = "deleted";
    public static final String CREATEMETHOD = "create";
    public static final String UPDATEMETHOD = "update";
    public static final String ARCHIVEMETHOD = "archive";
    public static final String DELETEMETHOD = "delete";
    public static final String PROPERTYNAMEOFPORTALNAMESPACE = "dataone.quotas.portal.namespaces";
    public static final String QUOTASUBJECTHEADER = "X-DataONE-Quota-Subject";
    private static boolean storageEnabled = Settings.getConfiguration().getBoolean("dataone.quotas.storage.enabled", false);
    private static boolean portalEnabled = Settings.getConfiguration().getBoolean("dataone.quotas.portals.enabled", false);
    private static boolean replicationEnabled = Settings.getConfiguration().getBoolean("dataone.quotas.replication.enabled", false);
    private static int NUMOFTHREADS = Settings.getConfiguration().getInt("dataone.quotas.reportingThreadPoolSize", 5);
    private static boolean enabled = false;
    private static ExecutorService executor = null;
    private static Log logMetacat = LogFactory.getLog(QuotaServiceManager.class);
    private static QuotaServiceManager service = null;
    private static BookKeeperClient client = null;
    private List<String> portalNameSpaces = null;
    private static boolean timerStarted = false;

    private QuotaServiceManager() throws ServiceFailure {
        if (enabled) {
            client = BookKeeperClient.getInstance();
            executor = Executors.newFixedThreadPool(NUMOFTHREADS);
            this.portalNameSpaces = QuotaServiceManager.retrievePortalNameSpaces();
        }
    }

    static List<String> retrievePortalNameSpaces() {
        return Settings.getConfiguration().getList(PROPERTYNAMEOFPORTALNAMESPACE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QuotaServiceManager getInstance() throws ServiceFailure {
        boolean bl = enabled = storageEnabled || portalEnabled || replicationEnabled;
        if (service != null) return service;
        Class<QuotaServiceManager> clazz = QuotaServiceManager.class;
        synchronized (QuotaServiceManager.class) {
            if (service != null) return service;
            service = new QuotaServiceManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public boolean isEnabled() {
        return enabled;
    }

    public synchronized void startDailyCheck() {
        if (enabled && !timerStarted) {
            Object date;
            String startTimeStr = Settings.getConfiguration().getString("dataone.quotas.dailyReportingUsagesTime");
            logMetacat.debug((Object)("QuotaServiceManager.startDailCheck - the property value of dataone.quotas.dailyReportingUsagesTime is " + startTimeStr));
            Date startTime = null;
            try {
                startTime = ReplicationHandler.combinateCurrentDateAndGivenTime(startTimeStr);
            }
            catch (Exception e) {
                logMetacat.error((Object)("QuotaServiceManager.startDailyCheck - Metacat can't figure out the time setting as the value of the property dataone.quotas.dailyReportingUsagesTime in the metacat.propertis since " + e.getMessage() + " So Metacat will use the default time 11.00 PM for reporting usages to the book keeper server every day."));
                date = new GregorianCalendar();
                ((Calendar)date).set(11, 23);
                ((Calendar)date).set(12, 0);
                ((Calendar)date).set(13, 0);
                ((Calendar)date).set(14, 0);
                startTime = ((Calendar)date).getTime();
            }
            SimpleDateFormat format = new SimpleDateFormat();
            date = format.format(startTime);
            logMetacat.info((Object)("QuotaServiceManager.startDailyCheck------------------------the timer will start to check and report un-reported usages at " + (String)date + " at daily base. This message should only be shown once."));
            Timer timer = new Timer();
            timer.scheduleAtFixedRate((TimerTask)new FailedReportingAttemptChecker(executor, client), startTime, 86400000L);
            timerStarted = true;
        }
    }

    public void enforce(String quotaSubject, Subject requestor, SystemMetadata sysmeta, String method) throws InsufficientResources, InvalidRequest, ServiceFailure, NotImplemented, NotFound {
        long start = System.currentTimeMillis();
        if (enabled) {
            try {
                if (requestor == null) {
                    throw new InvalidRequest("1102", "The quota requestor can't be null");
                }
                if (quotaSubject == null || quotaSubject.trim().equals("")) {
                    quotaSubject = requestor.getValue();
                }
                QuotaTypeDeterminer determiner = new QuotaTypeDeterminer(this.portalNameSpaces);
                determiner.determine(sysmeta);
                String quotaType = determiner.getQuotaType();
                if (quotaType != null && quotaType.equals("portal")) {
                    String instanceId = determiner.getInstanceId();
                    logMetacat.debug((Object)("QuotaServiceManager.enforce - handle the portal quota service with instance id " + instanceId + " and pid " + sysmeta.getIdentifier().getValue()));
                    this.enforcePortalQuota(quotaSubject, requestor, instanceId, sysmeta, method);
                    this.enforceStorageQuota(quotaSubject, requestor, sysmeta, method);
                }
                if (quotaType != null && quotaType.equals("storage")) {
                    this.enforceStorageQuota(quotaSubject, requestor, sysmeta, method);
                }
                throw new InvalidRequest("1102", "QuotaServiceManager.enforce - Metacat doesn't support the quota type " + quotaType + " for the pid " + sysmeta.getIdentifier().getValue());
            }
            catch (UnsupportedEncodingException e) {
                throw new ServiceFailure("1190", "QuotaServiceManager.enforce - Metacat doesn't support the encoding format " + e.getMessage() + " for the pid " + sysmeta.getIdentifier().getValue());
            }
        } else {
            logMetacat.info((Object)"QuotaServiceManager.enforce - the quota services are disabled");
        }
        long end = System.currentTimeMillis();
        logMetacat.info((Object)("QuotaServiceManager.enforce - checking quota and reporting usage took " + (end - start) / 1000L + " seconds."));
    }

    private void enforcePortalQuota(String quotaSubject, Subject requestor, String instanceId, SystemMetadata sysmeta, String method) throws InvalidRequest, ServiceFailure, InsufficientResources, NotImplemented, NotFound, UnsupportedEncodingException {
        if (portalEnabled) {
            PortalQuotaService.getInstance(executor, client).enforce(quotaSubject, requestor, instanceId, sysmeta, method);
        } else {
            logMetacat.info((Object)"QuotaServiceManager.enforcePrtaolQuota - the portal quota service is disabled");
        }
    }

    private void enforceStorageQuota(String quotaSubject, Subject requestor, SystemMetadata sysmeta, String method) throws NotImplemented {
        if (storageEnabled) {
            throw new NotImplemented("0000", "The storage quota service hasn't been implemented yet.");
        }
        logMetacat.info((Object)"QuotaServiceManager.enforceStorageQuota - the storage quota service is disabled");
    }
}

