/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.doi.ezid;

import edu.ucsb.nceas.ezid.EZIDClient;
import edu.ucsb.nceas.ezid.EZIDException;
import edu.ucsb.nceas.ezid.EZIDService;
import edu.ucsb.nceas.ezid.profile.DataCiteProfile;
import edu.ucsb.nceas.ezid.profile.ErcMissingValueCode;
import edu.ucsb.nceas.ezid.profile.InternalProfile;
import edu.ucsb.nceas.ezid.profile.InternalProfileValues;
import edu.ucsb.nceas.metacat.dataone.MNodeService;
import edu.ucsb.nceas.metacat.doi.DOIException;
import edu.ucsb.nceas.metacat.doi.DOIService;
import edu.ucsb.nceas.metacat.doi.datacite.DataCiteMetadataFactory;
import edu.ucsb.nceas.metacat.doi.datacite.DefaultDataCiteFactory;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.StringUtil;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.IdentifierNotUnique;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidSystemMetadata;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v2.Node;
import org.dataone.service.types.v2.ObjectFormat;
import org.dataone.service.types.v2.SystemMetadata;

public class EzidDOIService
extends DOIService {
    public static final String DATACITE = "datacite";
    private static final int MAX_ATTEMPT = 2;
    private Log logMetacat = LogFactory.getLog(EzidDOIService.class);
    private EZIDClient ezid = null;
    private EZIDService ezidService = null;
    private Date lastLogin = null;
    private long loginPeriod = 86400000L;
    private Vector<DataCiteMetadataFactory> dataCiteFactories = new Vector();

    public EzidDOIService() {
        this.ezid = new EZIDClient(serviceBaseUrl);
        this.ezidService = new EZIDService(serviceBaseUrl);
        this.initDataCiteFactories();
    }

    private void initDataCiteFactories() {
        String factoriesStr = null;
        try {
            factoriesStr = PropertyService.getProperty("guid.ezid.datacite.factories");
        }
        catch (PropertyNotFoundException pnfe) {
            this.logMetacat.warn((Object)("DOIService.generateDataCiteXML - could not get a metacat property - guid.ezid.datacite.factories in the metacat.properties file - " + pnfe.getMessage() + ". So only the default factory will be used."));
            return;
        }
        Vector factoryClasses = null;
        if (factoriesStr != null && !factoriesStr.trim().equals("") && (factoryClasses = StringUtil.toVector((String)factoriesStr, (char)';')) != null) {
            for (String factoryClass : factoryClasses) {
                try {
                    Class<?> classDefinition = Class.forName(factoryClass);
                    DataCiteMetadataFactory factory = (DataCiteMetadataFactory)classDefinition.newInstance();
                    this.dataCiteFactories.add(factory);
                    this.logMetacat.debug((Object)("DOIService.initDataCiteFactories - the DataCiteFactory " + factoryClass + " was initialized."));
                }
                catch (Exception e) {
                    this.logMetacat.warn((Object)("DOIService.initDataCiteFactories - can't initialize the class " + factoryClass + " since " + e.getMessage()));
                }
            }
        }
    }

    private void refreshLogin() throws EZIDException {
        Date now = Calendar.getInstance().getTime();
        if (this.lastLogin == null || now.getTime() - this.lastLogin.getTime() > this.loginPeriod) {
            this.ezid.login(username, password);
            this.lastLogin = now;
        }
    }

    @Override
    protected void submitDOIMetadata(Identifier identifier, SystemMetadata sysMeta) throws InvalidRequest, DOIException, NotImplemented, ServiceFailure, InterruptedException, InvalidToken, NotAuthorized, NotFound, IOException {
        HashMap<String, String> metadata = new HashMap<String, String>();
        Node node = MNodeService.getInstance(null).getCapabilities();
        String target = node.getBaseURL() + "/v1/object/" + identifier.getValue();
        String uriTemplate = null;
        String uriTemplateKey = "guid.doi.uritemplate.data";
        ObjectFormat objectFormat = null;
        try {
            objectFormat = D1Client.getCN().getFormat(sysMeta.getFormatId());
        }
        catch (BaseException e1) {
            this.logMetacat.warn((Object)("Could not check format type for: " + sysMeta.getFormatId()));
        }
        if (objectFormat != null && objectFormat.getFormatType().equals("METADATA")) {
            uriTemplateKey = "guid.doi.uritemplate.metadata";
        }
        try {
            uriTemplate = PropertyService.getProperty(uriTemplateKey);
            target = SystemUtil.getSecureServerURL() + uriTemplate.replaceAll("<IDENTIFIER>", identifier.getValue());
        }
        catch (PropertyNotFoundException e) {
            this.logMetacat.warn((Object)("No target URI template found in the configuration for: " + uriTemplateKey));
        }
        String status = InternalProfileValues.UNAVAILABLE.toString();
        String export = InternalProfileValues.NO.toString();
        if (autoPublishDOI) {
            status = InternalProfileValues.PUBLIC.toString();
            export = InternalProfileValues.YES.toString();
            metadata.put(InternalProfile.STATUS.toString(), status);
            metadata.put(InternalProfile.EXPORT.toString(), export);
            this.logMetacat.debug((Object)("EzidDOIService.submitDOIMetadata - since it is auto-publish, the status will always set publis and the acutal value is" + status));
        } else {
            HashMap existingMetadata = null;
            try {
                existingMetadata = this.ezidService.getMetadata(identifier.getValue());
            }
            catch (EZIDException e) {
                throw new DOIException(e.getMessage());
            }
            if (existingMetadata == null || existingMetadata.isEmpty()) {
                status = InternalProfileValues.RESERVED.toString();
                metadata.put(InternalProfile.STATUS.toString(), status);
                metadata.put(InternalProfile.EXPORT.toString(), export);
                this.logMetacat.debug((Object)("EzidDOIService.submitDOIMetadata - since it is NOT auto-publish and the identifier " + identifier.getValue() + " doesn't exist. The status will always set reserved. And actual value is " + status));
            } else {
                this.logMetacat.debug((Object)"EzidDOIService.submitDOIMetadata - since it is NOT auto-publish and the identifier exists, we don't need to send any status information again.");
            }
        }
        String dataCiteXML = this.generateDataCiteXML(identifier.getValue(), sysMeta);
        metadata.put(DATACITE, dataCiteXML);
        metadata.put(InternalProfile.TARGET.toString(), target);
        for (int i = 1; i <= 2; ++i) {
            this.logMetacat.debug((Object)("EzidDOIService.submitDOIMetadata - the " + i + " time try to set the metadata for " + identifier.getValue()));
            try {
                this.refreshLogin();
                this.ezid.createOrUpdate(identifier.getValue(), metadata);
                break;
            }
            catch (EZIDException e) {
                if (i == 2) {
                    throw new DOIException(e.getMessage());
                }
                this.logMetacat.debug((Object)("EzidDOIService.submitDOIMetadata - the " + i + " time setting the metadata for " + identifier.getValue() + " failed since a DOIExcpetion " + e.getMessage() + ". Metacat is going to log-in the EZID service and try to set it again."));
                this.ezid.login(username, password);
                this.lastLogin = Calendar.getInstance().getTime();
                continue;
            }
        }
    }

    private String generateDataCiteXML(String identifier, SystemMetadata sysMeta) throws InvalidRequest, ServiceFailure {
        Identifier id = new Identifier();
        id.setValue(identifier);
        for (DataCiteMetadataFactory factory : this.dataCiteFactories) {
            if (factory == null || !factory.canProcess(sysMeta.getFormatId().getValue())) continue;
            return factory.generateMetadata(id, sysMeta);
        }
        DefaultDataCiteFactory defaultFactory = new DefaultDataCiteFactory();
        return defaultFactory.generateMetadata(id, sysMeta);
    }

    @Override
    public Identifier generateDOI() throws DOIException, InvalidRequest {
        Identifier doi = null;
        for (int i = 1; i <= 2; ++i) {
            this.logMetacat.debug((Object)("EzidDOIService.generateDOI - the " + i + " time try to generate a DOI."));
            try {
                doi = this.generateDOIFromEZID();
                break;
            }
            catch (DOIException e) {
                if (i == 2) {
                    throw e;
                }
                this.logMetacat.debug((Object)("EzidDOIService.generateDOI - the " + i + " time generating a DOI failed since a DOIExcpetion " + e.getMessage() + ". Metacat is going to log-in the EZID service and try to generate a DOI again."));
                this.ezid.login(username, password);
                this.lastLogin = Calendar.getInstance().getTime();
                continue;
            }
            catch (InvalidRequest e) {
                if (i == 2) {
                    throw e;
                }
                this.logMetacat.debug((Object)("EzidDOIService.generateDOI - the " + i + " time generating a DOI failed since a InvalidRequest " + e.getMessage() + ". Metacat is going to log-in the EZID service and try to generate a DOI again."));
                this.ezid.login(username, password);
                this.lastLogin = Calendar.getInstance().getTime();
            }
        }
        return doi;
    }

    private Identifier generateDOIFromEZID() throws DOIException, InvalidRequest {
        Identifier identifier = new Identifier();
        try {
            if (!doiEnabled) {
                throw new InvalidRequest("2193", "DOI scheme is not enabled at this node.");
            }
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put(DataCiteProfile.TITLE.toString(), ErcMissingValueCode.UNKNOWN.toString());
            metadata.put(DataCiteProfile.CREATOR.toString(), ErcMissingValueCode.UNKNOWN.toString());
            metadata.put(DataCiteProfile.PUBLISHER.toString(), ErcMissingValueCode.UNKNOWN.toString());
            metadata.put(DataCiteProfile.PUBLICATION_YEAR.toString(), ErcMissingValueCode.UNKNOWN.toString());
            metadata.put(InternalProfile.STATUS.toString(), InternalProfileValues.RESERVED.toString());
            metadata.put(InternalProfile.EXPORT.toString(), InternalProfileValues.NO.toString());
            this.refreshLogin();
            if (!shoulderMap.containsKey(new Integer(1))) {
                throw new InvalidRequest("2193", "DOI scheme is not enabled at this node because primary shoulder unconfigured.");
            }
            String doi = this.ezid.mintIdentifier((String)shoulderMap.get(new Integer(1)), metadata);
            identifier.setValue(doi);
        }
        catch (EZIDException e) {
            throw new DOIException(e.getMessage());
        }
        return identifier;
    }

    @Override
    public void publishIdentifier(Session session, Identifier identifier) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, InvalidRequest, NotFound, IdentifierNotUnique, UnsupportedType, InsufficientResources, InvalidSystemMetadata, DOIException {
        if (!doiEnabled) {
            throw new InvalidRequest("2193", "DOI scheme is not enabled at this node.");
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put(InternalProfile.STATUS.toString(), InternalProfileValues.PUBLIC.toString());
        metadata.put(InternalProfile.EXPORT.toString(), InternalProfileValues.YES.toString());
        for (int i = 1; i <= 2; ++i) {
            this.logMetacat.debug((Object)("EzidDOIService.publishIdentifier - the " + i + " time try to publish " + identifier.getValue()));
            try {
                this.refreshLogin();
                this.ezid.setMetadata(identifier.getValue(), metadata);
                break;
            }
            catch (EZIDException e) {
                if (i == 2) {
                    throw new DOIException(e.getMessage());
                }
                this.logMetacat.debug((Object)("EzidDOIService.publishIdentifier - the " + i + " time publishing the " + identifier.getValue() + " failed since a DOIExcpetion " + e.getMessage() + ". Metacat is going to log-in the EZID service and try to publish it again."));
                this.ezid.login(username, password);
                this.lastLogin = Calendar.getInstance().getTime();
                continue;
            }
            catch (InterruptedException e) {
                if (i == 2) {
                    throw new ServiceFailure("3196", "Can't publish the identifier since " + e.getMessage());
                }
                this.logMetacat.debug((Object)("EzidDOIService.publishIdentifier - the " + i + " time publishing the " + identifier.getValue() + " failed since " + e.getMessage() + ". Metacat is going to log-in the EZID service and try to publish it again."));
                this.ezid.login(username, password);
                this.lastLogin = Calendar.getInstance().getTime();
            }
        }
    }
}

