/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.doi.osti;

import edu.ucsb.nceas.metacat.dataone.MNodeService;
import edu.ucsb.nceas.metacat.doi.DOIException;
import edu.ucsb.nceas.metacat.doi.DOIService;
import edu.ucsb.nceas.metacat.doi.osti.OstiErrorEmailAgent;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.osti_elink.OSTIElinkClient;
import edu.ucsb.nceas.osti_elink.OSTIElinkErrorAgent;
import edu.ucsb.nceas.osti_elink.OSTIElinkException;
import edu.ucsb.nceas.utilities.FileUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wicket.protocol.http.mock.MockHttpServletRequest;
import org.dataone.service.exceptions.IdentifierNotUnique;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidSystemMetadata;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v2.SystemMetadata;

public class OstiDOIService
extends DOIService {
    private static Log logMetacat = LogFactory.getLog(OstiDOIService.class);
    private static Templates eml2osti = null;
    private static final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private OSTIElinkClient ostiClient = null;
    private OSTIElinkErrorAgent errorAgent = null;

    public OstiDOIService() {
        try {
            if (doiEnabled) {
                this.errorAgent = new OstiErrorEmailAgent();
                this.ostiClient = new OSTIElinkClient(username, password, serviceBaseUrl, this.errorAgent);
                String ostiPath = SystemUtil.getContextDir() + FileUtil.getFS() + "style" + FileUtil.getFS() + "common" + FileUtil.getFS() + "osti" + FileUtil.getFS() + "eml2osti.xsl";
                logMetacat.debug((Object)("OstiDOIService.OstiDOIService - the osti xsl file path is " + ostiPath));
                eml2osti = transformerFactory.newTemplates(new StreamSource(ostiPath));
            }
        }
        catch (PropertyNotFoundException e) {
            logMetacat.warn((Object)"OstiDOIService.OstiDOIService -DOI support is not configured at this node.", (Throwable)e);
            return;
        }
        catch (TransformerConfigurationException e) {
            logMetacat.error((Object)"OstiDOIService.OstiDOIService - Metacat can't generate the style sheet to transform eml objects to OSTI documents: ", (Throwable)e);
            return;
        }
    }

    @Override
    public Identifier generateDOI() throws DOIException, InvalidRequest {
        if (!doiEnabled) {
            throw new InvalidRequest("2193", "DOI scheme is not enabled at this node.");
        }
        try {
            String doiStr = this.ostiClient.mintIdentifier(null);
            Identifier doi = new Identifier();
            doi.setValue(doiStr);
            return doi;
        }
        catch (OSTIElinkException e) {
            throw new DOIException(e.getMessage());
        }
    }

    @Override
    protected void submitDOIMetadata(Identifier identifier, SystemMetadata sysMeta) throws InvalidRequest, DOIException, NotImplemented, ServiceFailure, InterruptedException, InvalidToken, NotFound, IOException, NotAuthorized {
        MockHttpServletRequest request = new MockHttpServletRequest(null, null, null);
        Session session = new Session();
        Subject subject = MNodeService.getInstance((HttpServletRequest)request).getCapabilities().getSubject(0);
        session.setSubject(subject);
        try (InputStream object = MNodeService.getInstance((HttpServletRequest)request).get(session, identifier);){
            try {
                String siteUrl = null;
                if (autoPublishDOI) {
                    siteUrl = this.getLandingPage(identifier);
                    logMetacat.debug((Object)("OstiDOIService.submitDOIMetadata - The system is configured to auto publish doi. The site url will be used for pid " + identifier.getValue() + " is: " + siteUrl));
                } else {
                    String status = null;
                    try {
                        status = this.ostiClient.getStatus(identifier.getValue());
                    }
                    catch (OSTIElinkException ee) {
                        if (this.errorAgent != null) {
                            this.errorAgent.notify("OstiDOIService.submitDOIMetadata - can't get the OSTI status of id " + identifier.getValue() + " since:\n " + ee.getMessage());
                        }
                        throw new DOIException(ee.getMessage());
                    }
                    logMetacat.debug((Object)("OstiDOIService.submitDOIMetadata - The system is configured NOT to auto publish doi and the current status is " + status + " for the identifier " + identifier.getValue()));
                    if (status != null && status.equalsIgnoreCase("Saved")) {
                        siteUrl = null;
                        logMetacat.debug((Object)("OstiDOIService.submitDOIMetadata - The system is configured NOT to auto publish doi. The site url will be used for pid " + identifier.getValue() + " should be null since its current status is Saved."));
                    } else {
                        siteUrl = this.getLandingPage(identifier);
                        logMetacat.debug((Object)("OstiDOIService.submitDOIMetadata - The system is configured NOT to auto publish doi. The site url will be used for pid " + identifier.getValue() + " is: " + siteUrl + " since the status is " + status));
                    }
                }
                String ostiMeta = this.generateOstiMetadata(object, siteUrl);
                this.ostiClient.setMetadata(identifier.getValue(), ostiMeta);
            }
            catch (TransformerException e) {
                throw new ServiceFailure("1030", e.getMessage());
            }
            catch (InterruptedException e) {
                throw new ServiceFailure("1030", e.getMessage());
            }
        }
    }

    @Override
    public void publishIdentifier(Session session, Identifier identifier) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, InvalidRequest, NotFound, IdentifierNotUnique, UnsupportedType, InsufficientResources, InvalidSystemMetadata {
        if (!doiEnabled) {
            throw new InvalidRequest("2193", "DOI scheme is not enabled at this node.");
        }
        String siteUrl = this.getLandingPage(identifier);
        logMetacat.debug((Object)("OstiDOIService.publishIdentifier - The site url for pid " + identifier.getValue() + " is: " + siteUrl));
        try {
            String ostiMeta = this.generateXMLWithSiteURL(siteUrl);
            this.ostiClient.setMetadata(identifier.getValue(), ostiMeta);
        }
        catch (InterruptedException e) {
            throw new ServiceFailure("1030", e.getMessage());
        }
    }

    protected String generateXMLWithSiteURL(String siteURL) {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><records><record><site_url>";
        xml = xml + StringEscapeUtils.escapeXml((String)siteURL);
        xml = xml + "</site_url></record></records>";
        logMetacat.debug((Object)("OstiDOIService.generateXMLWithSiteUR - the metadata is: " + xml));
        return xml;
    }

    protected String generateOstiMetadata(InputStream eml, String siteUrl) throws TransformerException {
        String meta = null;
        Transformer transformer = eml2osti.newTransformer();
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        if (siteUrl != null && !siteUrl.trim().equals("")) {
            transformer.setParameter("site_url", siteUrl);
        }
        transformer.transform(new StreamSource(eml), result);
        meta = writer.toString();
        return meta;
    }

    public String getMetadata(Identifier doi) throws OSTIElinkException, InvalidRequest {
        if (!doiEnabled) {
            throw new InvalidRequest("2193", "DOI scheme is not enabled at this node.");
        }
        return this.ostiClient.getMetadata(doi.getValue());
    }
}

