/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.download;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.client.v2.formats.ObjectFormatCache;
import org.dataone.client.v2.formats.ObjectFormatInfo;
import org.dataone.exceptions.MarshallingException;
import org.dataone.ore.ResourceMapFactory;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v2.SystemMetadata;
import org.dataone.service.util.TypeMarshaller;
import org.dataone.speedbagit.SpeedBagException;
import org.dataone.speedbagit.SpeedBagIt;
import org.dspace.foresite.ORESerialiserException;
import org.dspace.foresite.ResourceMap;

public class PackageDownloaderV2 {
    private List<Identifier> coreMetadataIdentifiers;
    private List<Identifier> scienceMetadataIdentifiers = new ArrayList<Identifier>();
    private ResourceMap resourceMap;
    private SystemMetadata resourceMapSystemMetadata;
    private Map<String, String> _filePathMap;
    private List<Pair<SystemMetadata, InputStream>> scienceMetadatas = new ArrayList<Pair<SystemMetadata, InputStream>>();
    public SpeedBagIt speedBag = null;
    private Log logMetacat = LogFactory.getLog(this.getClass());

    public PackageDownloaderV2(Identifier pid, ResourceMap resourceMap, SystemMetadata resourceMapSystemMetadata) throws ServiceFailure {
        this.resourceMap = resourceMap;
        this.resourceMapSystemMetadata = resourceMapSystemMetadata;
        this.coreMetadataIdentifiers = new ArrayList<Identifier>();
        this._filePathMap = new HashMap<String, String>();
        try {
            this.speedBag = new SpeedBagIt(1.0, "MD5");
        }
        catch (IOException e) {
            this.logMetacat.error((Object)"There was an error creating the speedbag");
            throw new ServiceFailure("", e.getMessage());
        }
        this.addCoreMetadataIdentifier(pid);
        this.getObjectLocations();
        this.getScienceMetadataIds();
    }

    public List<Identifier> getCoreMetadataIdentifiers() {
        return this.coreMetadataIdentifiers;
    }

    private void addCoreMetadataIdentifier(Identifier id) {
        this.coreMetadataIdentifiers.add(id);
    }

    public void addScienceSystemMetadata(Identifier scienceMetadataIdentifier) {
        this.scienceMetadataIdentifiers.add(scienceMetadataIdentifier);
    }

    public List<Identifier> getScienceMetadataIdentifiers() {
        return this.scienceMetadataIdentifiers;
    }

    public void addScienceMetadata(SystemMetadata sysMeta, InputStream inputStream) {
        this.scienceMetadatas.add((Pair<SystemMetadata, InputStream>)new MutablePair((Object)sysMeta, (Object)inputStream));
    }

    public void addDataFile(SystemMetadata systemMetadata, InputStream inputStream) throws ServiceFailure {
        String objectFormatType = null;
        try {
            objectFormatType = ObjectFormatCache.getInstance().getFormat(systemMetadata.getFormatId()).getFormatType();
        }
        catch (NotFound e) {
            this.logMetacat.error((Object)"Failed to find the format type of the data object.", (Throwable)e);
            objectFormatType = "data";
        }
        Identifier objectSystemMetadataID = systemMetadata.getIdentifier();
        String dataObjectFileName = this.sanitizeFilename(objectSystemMetadataID.getValue()) + "-" + objectFormatType;
        try {
            String extension = ObjectFormatInfo.instance().getExtension(systemMetadata.getFormatId().getValue());
            dataObjectFileName = dataObjectFileName + extension;
        }
        catch (Exception extension) {
            // empty catch block
        }
        if (systemMetadata.getFileName() != null) {
            this.logMetacat.debug((Object)"Failed to find any filename in the system metadata.");
            dataObjectFileName = this.sanitizeFilename(systemMetadata.getFileName());
        }
        this.logMetacat.debug((Object)"Determining if file has a record in the resource map");
        String dataPath = this._filePathMap.get(objectSystemMetadataID.getValue());
        try {
            String bagDataFilePath;
            String dataDirectory = PropertyService.getProperty("package.download.bag.directory.data");
            if (dataPath == null) {
                bagDataFilePath = dataObjectFileName;
                dataPath = Paths.get(dataDirectory, dataObjectFileName).toString();
            } else {
                bagDataFilePath = dataPath = this.sanitizeFilepath(dataPath);
                dataPath = Paths.get(dataDirectory, dataPath).toString();
            }
            if (this.speedBag.getDataFiles().containsKey(dataPath)) {
                Path path = Paths.get(bagDataFilePath, new String[0]);
                Path parentPath = path.getParent();
                String dataFilePath = parentPath == null ? "" : parentPath.toString();
                int index = 0;
                String duplicateDataPath = dataPath;
                while (this.speedBag.getDataFiles().containsKey(duplicateDataPath)) {
                    duplicateDataPath = Paths.get(dataDirectory, dataFilePath, index++ + "-duplicate-" + path.getFileName()).toString();
                }
                this.logMetacat.warn((Object)("Duplicate data filename (" + dataPath + ") was renamed..."));
                dataPath = duplicateDataPath;
            }
            this.logMetacat.debug((Object)("Adding data file to the bag at " + dataPath));
            this.speedBag.addFile(inputStream, dataPath, false);
        }
        catch (SpeedBagException e) {
            throw new ServiceFailure("There was an error creating the BagIt bag.", e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServiceFailure("There was an error creating the BagIt bag.", e.getMessage());
        }
        catch (PropertyNotFoundException e) {
            throw new ServiceFailure("There was an error creating the BagIt bag.", e.getMessage());
        }
    }

    public void addScienceMetadatas() throws NoSuchAlgorithmException, ServiceFailure {
        int metadata_count = 0;
        for (Pair<SystemMetadata, InputStream> scienceMetadata : this.scienceMetadatas) {
            String filePath;
            String filename;
            try {
                filename = PropertyService.getProperty("package.download.file.science-metadata");
            }
            catch (PropertyNotFoundException e) {
                this.logMetacat.error((Object)"Failed to find the science metadata name property.", (Throwable)e);
                filename = "science-metadata.xml";
            }
            if (metadata_count > 0) {
                filename = FilenameUtils.getPath((String)filename) + FilenameUtils.getBaseName((String)filename) + '(' + metadata_count + ')' + '.' + FilenameUtils.getExtension((String)filename);
            }
            try {
                filePath = Paths.get(PropertyService.getProperty("package.download.bag.directory.metadata"), filename).toString();
            }
            catch (PropertyNotFoundException e) {
                filePath = Paths.get("metadata", filename).toString();
            }
            this.logMetacat.debug((Object)("Adding metadata file to the bag as " + filePath));
            try {
                this.speedBag.addFile((InputStream)scienceMetadata.getValue(), filePath, true);
                this.addSystemMetadata((SystemMetadata)scienceMetadata.getKey());
            }
            catch (SpeedBagException e) {
                e.printStackTrace();
                ServiceFailure sf = new ServiceFailure("1030", "Error while adding science metadata to the bag. " + e.getMessage());
                sf.initCause((Throwable)e);
                throw sf;
            }
            ++metadata_count;
        }
    }

    public void addResourceMap() throws NoSuchAlgorithmException, ServiceFailure {
        this.addSystemMetadata(this.resourceMapSystemMetadata);
        String resmapPath = "";
        try {
            resmapPath = Paths.get(PropertyService.getProperty("package.download.bag.directory.metadata"), PropertyService.getProperty("package.download.file.resource-map")).toString();
        }
        catch (PropertyNotFoundException e) {
            resmapPath = Paths.get("metadata", "oai-ore.xml").toString();
        }
        String resMapString = "";
        try {
            resMapString = ResourceMapFactory.getInstance().serializeResourceMap(this.resourceMap);
        }
        catch (ORESerialiserException e) {
            this.logMetacat.error((Object)"Failed to de-serialize the resource map and write it to disk.", (Throwable)e);
        }
        this.logMetacat.debug((Object)("Adding resource map to " + resmapPath));
        try {
            this.speedBag.addFile((InputStream)new ByteArrayInputStream(resMapString.getBytes()), resmapPath, true);
        }
        catch (SpeedBagException e) {
            e.printStackTrace();
            ServiceFailure sf = new ServiceFailure("1030", "Error while adding resource map to the bag. " + e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
    }

    public void addSystemMetadata(SystemMetadata systemMetadata) throws NoSuchAlgorithmException {
        String systemMetadataFilename = null;
        try {
            systemMetadataFilename = PropertyService.getProperty("package.download.file.sysmeta-prepend") + systemMetadata.getIdentifier().getValue() + PropertyService.getProperty("package.download.file.sysmeta-extension");
        }
        catch (PropertyNotFoundException e) {
            this.logMetacat.error((Object)"Failed to find the system metadata name property.", (Throwable)e);
            systemMetadataFilename = "system-metadata-" + systemMetadata.getIdentifier().getValue() + ".xml";
        }
        this.logMetacat.debug((Object)("Sanitizing the system metadata filename: " + systemMetadataFilename));
        systemMetadataFilename = this.sanitizeFilename(systemMetadataFilename);
        this.logMetacat.debug((Object)("Sanitized the system metadata filename: " + systemMetadataFilename));
        try {
            ByteArrayOutputStream sysMetaOutputstream = new ByteArrayOutputStream();
            TypeMarshaller.marshalTypeToOutputStream((Object)systemMetadata, (OutputStream)sysMetaOutputstream);
            ByteArrayInputStream sysMetaInputstream = new ByteArrayInputStream(sysMetaOutputstream.toString().getBytes("UTF-8"));
            String systemMetaPath = "";
            try {
                systemMetaPath = Paths.get(PropertyService.getProperty("package.download.bag.directory.metadata"), PropertyService.getProperty("package.download.bag.directory.sysmeta"), systemMetadataFilename).toString();
            }
            catch (PropertyNotFoundException e) {
                systemMetaPath = Paths.get("metadata", "sysmeta", systemMetadataFilename).toString();
            }
            this.speedBag.addFile((InputStream)sysMetaInputstream, systemMetaPath, true);
        }
        catch (SpeedBagException e) {
            this.logMetacat.error((Object)("Failed to add sysmeta to the BagIt bag. ID: " + systemMetadata.getIdentifier().getValue()), (Throwable)e);
        }
        catch (MarshallingException e) {
            this.logMetacat.error((Object)("There was an error converting the metadata document. ID: " + systemMetadata.getIdentifier().getValue()), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            this.logMetacat.error((Object)("Failed to find the temporary file when writing object. ID: " + systemMetadata.getIdentifier().getValue()), (Throwable)e);
        }
        catch (IOException e) {
            this.logMetacat.error((Object)("Failed to write to temporary file when writing object. ID: " + systemMetadata.getIdentifier().getValue()), (Throwable)e);
        }
    }

    public InputStream download() throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented {
        try {
            this.addResourceMap();
            this.addScienceMetadatas();
            return this.speedBag.stream();
        }
        catch (IOException e) {
            e.printStackTrace();
            ServiceFailure sf = new ServiceFailure("1030", "There was an i/o error while streaming the downloaded data package. " + e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            ServiceFailure sf = new ServiceFailure("1030", "There was an error while streaming the downloaded data package. " + e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            ServiceFailure sf = new ServiceFailure("1030", "While creating the package download, an unsupported checksumming algorithm was encountered. " + e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
    }

    public void getScienceMetadataIds() {
        String rdfQuery = "PREFIX cito: <http://purl.org/spar/cito/>\n\nSELECT ?science_metadata\nWHERE {\n\n?science_metadata cito:documents ?data_object .\n}";
        try {
            this.logMetacat.debug((Object)"Getting science metadata identifiers");
            ResultSet queryResults = this.selectQuery(rdfQuery);
            while (queryResults.hasNext()) {
                QuerySolution currentResult = queryResults.next();
                RDFNode subjectNode = currentResult.get("science_metadata");
                String subjectStr = subjectNode.toString();
                this.logMetacat.debug((Object)("Found the subject, " + subjectStr));
                if (subjectStr == null) {
                    this.logMetacat.warn((Object)"Failed to find any science metadata documents during package download.");
                    continue;
                }
                String id = StringUtils.substringAfterLast((String)subjectStr, (String)"resolve/");
                id = URLDecoder.decode(id, "UTF-8");
                Identifier identifier = new Identifier();
                identifier.setValue(id);
                this.addCoreMetadataIdentifier(identifier);
                this.addScienceSystemMetadata(identifier);
            }
        }
        catch (UnsupportedEncodingException e) {
            this.logMetacat.error((Object)"There was an error with decoding the identifier.", (Throwable)e);
        }
    }

    private ResultSet selectQuery(String rdfQuery) {
        String resMapString = null;
        InputStream targetStream = null;
        try {
            resMapString = ResourceMapFactory.getInstance().serializeResourceMap(this.resourceMap);
            targetStream = IOUtils.toInputStream((String)resMapString, (String)"UTF-8");
        }
        catch (IOException e) {
            this.logMetacat.error((Object)"There was an I/O error while serializing the resource map.", (Throwable)e);
        }
        catch (ORESerialiserException e) {
            this.logMetacat.error((Object)"Problem serializing the resource map.", (Throwable)e);
        }
        if (targetStream == null) {
            try {
                targetStream.close();
            }
            catch (IOException e) {
                this.logMetacat.error((Object)"Failed to close the resource map InputStream", (Throwable)e);
            }
            this.logMetacat.error((Object)"There was an error while serializing the resource map");
        }
        Model model = ModelFactory.createDefaultModel();
        model.read(targetStream, null);
        Query query = QueryFactory.create((String)rdfQuery);
        QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)model);
        ResultSet queryResults = qexec.execSelect();
        return queryResults;
    }

    private void getObjectLocations() {
        String rdfQuery = "      PREFIX prov:    <http://www.w3.org/ns/prov#>\n                PREFIX dcterms: <http://purl.org/dc/terms/>\n\n                SELECT *\n                WHERE {\n\n                    ?subject prov:atLocation ?prov_atLocation .\n                    ?subject dcterms:identifier ?pidValue .\n                }";
        try {
            ResultSet queryResults = this.selectQuery(rdfQuery);
            while (queryResults.hasNext()) {
                QuerySolution currentResult = queryResults.next();
                RDFNode subjectNode = currentResult.get("pidValue");
                RDFNode locationNode = currentResult.get("prov_atLocation");
                String subjectStr = subjectNode.toString();
                String locationStr = locationNode.toString();
                if (locationStr == null || subjectStr == null) {
                    this.logMetacat.debug((Object)"Failed to find any location values");
                    continue;
                }
                locationStr = FilenameUtils.separatorsToSystem((String)locationNode.toString());
                subjectStr = StringUtils.substringBefore((String)subjectStr, (String)"^^");
                this._filePathMap.put(subjectStr, locationStr);
            }
        }
        catch (Exception e) {
            this.logMetacat.error((Object)"There was an error while parsing an atLocation field.", (Throwable)e);
        }
    }

    String sanitizeFilename(String filename) {
        return filename.replaceAll("[^a-zA-Z0-9\\-\\.]", "_");
    }

    String sanitizeFilepath(String filename) {
        return filename.replaceAll("[^a-zA-Z0-9\\-\\.\\/_ ]", "");
    }
}

