/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.properties;

import edu.ucsb.nceas.metacat.properties.PropertiesInterface;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.shared.BaseService;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.utilities.GeneralPropertyException;
import edu.ucsb.nceas.utilities.PropertiesMetaData;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.SortedProperties;
import java.io.IOException;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleProperties
extends BaseService
implements PropertiesInterface {
    private static SortedProperties sortedProperties = null;
    private static Log logMetacat = LogFactory.getLog(SimpleProperties.class);

    protected SimpleProperties() throws ServiceException {
        this._serviceName = "SimpleProperties";
        this.initialize();
    }

    @Override
    public boolean refreshable() {
        return true;
    }

    @Override
    public void doRefresh() throws ServiceException {
        this.initialize();
    }

    @Override
    public void stop() throws ServiceException {
    }

    private void initialize() throws ServiceException {
        logMetacat.debug((Object)"Initializing SimpleProperties");
        String mainConfigFilePath = PropertyService.CONFIG_FILE_PATH;
        sortedProperties = new SortedProperties(mainConfigFilePath);
        try {
            sortedProperties.load();
        }
        catch (IOException ioe) {
            throw new ServiceException("I/O problem while loading properties: " + ioe.getMessage());
        }
    }

    @Override
    public String getProperty(String propertyName) throws PropertyNotFoundException {
        return sortedProperties.getProperty(propertyName);
    }

    @Override
    public Vector<String> getPropertyNames() {
        return sortedProperties.getPropertyNames();
    }

    @Override
    public Vector<String> getPropertyNamesByGroup(String groupName) {
        return sortedProperties.getPropertyNamesByGroup(groupName);
    }

    @Override
    public Map<String, String> getPropertiesByGroup(String groupName) throws PropertyNotFoundException {
        return sortedProperties.getPropertiesByGroup(groupName);
    }

    @Override
    public void addProperty(String propertyName, String value) throws GeneralPropertyException {
        sortedProperties.addProperty(propertyName, value);
        sortedProperties.store();
    }

    @Override
    public void setProperty(String propertyName, String newValue) throws GeneralPropertyException {
        sortedProperties.setProperty(propertyName, newValue);
        sortedProperties.store();
    }

    @Override
    public void setPropertyNoPersist(String propertyName, String newValue) throws GeneralPropertyException {
        sortedProperties.setPropertyNoPersist(propertyName, newValue);
    }

    @Override
    public void persistProperties() throws GeneralPropertyException {
        sortedProperties.store();
    }

    @Override
    public boolean checkAndSetProperty(HttpServletRequest request, String propertyName) throws GeneralPropertyException {
        boolean changed = false;
        String value = this.getProperty(propertyName);
        String newValue = request.getParameter(propertyName);
        if (newValue != null && !newValue.trim().equals(value)) {
            this.setPropertyNoPersist(propertyName, newValue.trim());
            changed = true;
        }
        return changed;
    }

    @Override
    public SortedProperties getMainBackupProperties() {
        return sortedProperties;
    }

    @Override
    public SortedProperties getAuthBackupProperties() throws GeneralPropertyException {
        throw new GeneralPropertyException("SimpleProperties.getAuthBackupProperties - SimpleProperties does not support backup properties");
    }

    @Override
    public PropertiesMetaData getMainMetaData() throws GeneralPropertyException {
        throw new GeneralPropertyException("SimpleProperties.getMainMetaData - SimpleProperties does not support metadata");
    }

    @Override
    public PropertiesMetaData getAuthMetaData() throws GeneralPropertyException {
        throw new GeneralPropertyException("SimpleProperties.getAuthMetaData - SimpleProperties does not support auth metadata");
    }

    @Override
    public void persistMainBackupProperties() throws GeneralPropertyException {
        throw new GeneralPropertyException("SimpleProperties.persistMainBackupProperties - SimpleProperties does not support backup properties");
    }

    @Override
    public void persistAuthBackupProperties(ServletContext servletContext) throws GeneralPropertyException {
        throw new GeneralPropertyException("SimpleProperties.persistAuthBackupProperties - SimpleProperties does not support backup properties");
    }

    @Override
    public boolean arePropertiesConfigured() throws GeneralPropertyException {
        return true;
    }

    @Override
    public boolean doBypass() throws GeneralPropertyException {
        throw new GeneralPropertyException("SimpleProperties.doBypass - SimpleProperties does not support doBypass method.");
    }

    @Override
    public void bypassConfiguration() throws GeneralPropertyException {
        throw new GeneralPropertyException("SimpleProperties.doBypass - SimpleProperties does not support bypassConfiguration method.");
    }
}

