/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.util;

import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.StringUtil;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SkinUtil {
    private static Log logMetacat = LogFactory.getLog(SkinUtil.class);
    private static Vector<String> skinNames = null;

    private SkinUtil() {
    }

    public static boolean areSkinsConfigured() throws MetacatUtilException {
        try {
            return !PropertyService.getProperty("configutil.skinsConfigured").equals("false");
        }
        catch (PropertyNotFoundException pnfe) {
            throw new MetacatUtilException("Could not determine if database is configured: " + pnfe.getMessage());
        }
    }

    public static Vector<String> getSkinNames() throws PropertyNotFoundException {
        if (skinNames == null || skinNames.isEmpty()) {
            String skinStringList = PropertyService.getProperty("skin.names");
            skinNames = StringUtil.toVector((String)skinStringList, (char)',');
        }
        return skinNames;
    }

    public static void setSkinName(Vector<String> names) {
        skinNames = names;
    }
}

