/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph.index;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.index.EdgeSetIntersector;
import com.vividsolutions.jts.geomgraph.index.SegmentIntersector;
import java.util.Iterator;
import java.util.List;

public class SimpleEdgeSetIntersector
extends EdgeSetIntersector {
    int nOverlaps;

    public void computeIntersections(List edges, SegmentIntersector si, boolean testAllSegments) {
        this.nOverlaps = 0;
        Iterator i0 = edges.iterator();
        while (i0.hasNext()) {
            Edge edge0 = (Edge)i0.next();
            Iterator i1 = edges.iterator();
            while (i1.hasNext()) {
                Edge edge1 = (Edge)i1.next();
                if (!testAllSegments && edge0 == edge1) continue;
                this.computeIntersects(edge0, edge1, si);
            }
        }
    }

    public void computeIntersections(List edges0, List edges1, SegmentIntersector si) {
        this.nOverlaps = 0;
        Iterator i0 = edges0.iterator();
        while (i0.hasNext()) {
            Edge edge0 = (Edge)i0.next();
            Iterator i1 = edges1.iterator();
            while (i1.hasNext()) {
                Edge edge1 = (Edge)i1.next();
                this.computeIntersects(edge0, edge1, si);
            }
        }
    }

    private void computeIntersects(Edge e0, Edge e1, SegmentIntersector si) {
        Coordinate[] pts0 = e0.getCoordinates();
        Coordinate[] pts1 = e1.getCoordinates();
        for (int i0 = 0; i0 < pts0.length - 1; ++i0) {
            for (int i1 = 0; i1 < pts1.length - 1; ++i1) {
                si.addIntersections(e0, i0, e1, i1);
            }
        }
    }
}

