/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.asserting;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.codecs.asserting.AssertingCodec;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.TestUtil;

public class AssertingStoredFieldsFormat
extends StoredFieldsFormat {
    private final StoredFieldsFormat in = TestUtil.getDefaultCodec().storedFieldsFormat();

    public StoredFieldsReader fieldsReader(Directory directory, SegmentInfo si, FieldInfos fn, IOContext context) throws IOException {
        return new AssertingStoredFieldsReader(this.in.fieldsReader(directory, si, fn, context), si.maxDoc(), false);
    }

    public StoredFieldsWriter fieldsWriter(Directory directory, SegmentInfo si, IOContext context) throws IOException {
        return new AssertingStoredFieldsWriter(this.in.fieldsWriter(directory, si, context));
    }

    static class AssertingStoredFieldsWriter
    extends StoredFieldsWriter {
        private final StoredFieldsWriter in;
        private int numWritten;
        private Status docStatus;

        AssertingStoredFieldsWriter(StoredFieldsWriter in) {
            this.in = in;
            this.docStatus = Status.UNDEFINED;
        }

        public void startDocument() throws IOException {
            assert (this.docStatus != Status.STARTED);
            this.in.startDocument();
            ++this.numWritten;
            this.docStatus = Status.STARTED;
        }

        public void finishDocument() throws IOException {
            assert (this.docStatus == Status.STARTED);
            this.in.finishDocument();
            this.docStatus = Status.FINISHED;
        }

        public void writeField(FieldInfo info, IndexableField field) throws IOException {
            assert (this.docStatus == Status.STARTED);
            this.in.writeField(info, field);
        }

        public void finish(FieldInfos fis, int numDocs) throws IOException {
            assert (this.docStatus == (numDocs > 0 ? Status.FINISHED : Status.UNDEFINED));
            this.in.finish(fis, numDocs);
            assert (numDocs == this.numWritten);
        }

        public void close() throws IOException {
            this.in.close();
            this.in.close();
        }

        public long ramBytesUsed() {
            return this.in.ramBytesUsed();
        }

        public Collection<Accountable> getChildResources() {
            return this.in.getChildResources();
        }
    }

    static enum Status {
        UNDEFINED,
        STARTED,
        FINISHED;

    }

    static class AssertingStoredFieldsReader
    extends StoredFieldsReader {
        private final StoredFieldsReader in;
        private final int maxDoc;
        private final boolean merging;
        private final Thread creationThread;

        AssertingStoredFieldsReader(StoredFieldsReader in, int maxDoc, boolean merging) {
            this.in = in;
            this.maxDoc = maxDoc;
            this.merging = merging;
            this.creationThread = Thread.currentThread();
            assert (this.toString() != null);
            assert (this.ramBytesUsed() >= 0L);
            assert (this.getChildResources() != null);
        }

        public void close() throws IOException {
            this.in.close();
            this.in.close();
        }

        public void visitDocument(int n, StoredFieldVisitor visitor) throws IOException {
            AssertingCodec.assertThread("StoredFieldsReader", this.creationThread);
            assert (n >= 0 && n < this.maxDoc);
            this.in.visitDocument(n, visitor);
        }

        public StoredFieldsReader clone() {
            assert (!this.merging) : "Merge instances do not support cloning";
            return new AssertingStoredFieldsReader(this.in.clone(), this.maxDoc, false);
        }

        public long ramBytesUsed() {
            long v = this.in.ramBytesUsed();
            assert (v >= 0L);
            return v;
        }

        public Collection<Accountable> getChildResources() {
            Collection res = this.in.getChildResources();
            TestUtil.checkReadOnly(res);
            return res;
        }

        public void checkIntegrity() throws IOException {
            this.in.checkIntegrity();
        }

        public StoredFieldsReader getMergeInstance() {
            return new AssertingStoredFieldsReader(this.in.getMergeInstance(), this.maxDoc, true);
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.in.toString() + ")";
        }
    }
}

