/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.DBQuery;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.utilities.FileUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.File;
import java.util.Hashtable;

public class DocumentIdQuery {
    public static Hashtable createDocidQueryParams(String[] docidList, Hashtable params) {
        params = DocumentIdQuery.getDefaultQueryParams();
        if (docidList != null) {
            params.put("/eml/@packageId", docidList);
        }
        return params;
    }

    public static String createDocidQuery(String[] docidList) throws PropertyNotFoundException {
        String pathQuery = "";
        Hashtable params = DocumentIdQuery.getDefaultQueryParams();
        if (docidList != null) {
            params.put("/eml/@packageId", docidList);
        }
        pathQuery = DBQuery.createSQuery(params);
        return pathQuery;
    }

    public static Hashtable getDefaultQueryParams() {
        Hashtable<String, String[]> params = new Hashtable<String, String[]>();
        String[] operator = new String[]{"UNION"};
        params.put("operator", operator);
        String[] doctypes = new String[]{"eml://ecoinformatics.org/eml-2.0.1", "eml://ecoinformatics.org/eml-2.0.0", "eml://ecoinformatics.org/eml-2.1.0", "eml://ecoinformatics.org/eml-2.1.1", "-//ecoinformatics.org//eml-dataset-2.0.0beta6//EN", "-//ecoinformatics.org//eml-dataset-2.0.0beta4//EN", "metadata", "https://eml.ecoinformatics.org/eml-2.2.0"};
        params.put("returndoctype", doctypes);
        String[] fields = new String[]{"originator/individualName/surName", "originator/individualName/givenName", "creator/individualName/surName", "creator/individualName/givenName", "originator/organizationName", "creator/organizationName", "dataset/title", "keyword", "idinfo/citation/citeinfo/title", "idinfo/citation/citeinfo/origin", "idinfo/keywords/theme/themekey", "dataset/pubDate"};
        params.put("returnfield", fields);
        return params;
    }

    public static void main(String[] args) {
        String CONFIG_DIR = "lib";
        File dirPath = new File(CONFIG_DIR);
        try {
            PropertyService.getInstance(dirPath.getPath() + FileUtil.getFS() + "metacat.properties");
        }
        catch (ServiceException ioe) {
            System.err.println("Error in loading properties: " + ioe.getMessage());
        }
        String[] ids = new String[]{"ces_dataset.23.1", "knb-lter-vcr.97.1", "obfs.400.1"};
        String pathquery = null;
        try {
            pathquery = DocumentIdQuery.createDocidQuery(ids);
        }
        catch (PropertyNotFoundException pnfe) {
            System.out.println("Could not create doc id query: " + pnfe.getMessage());
        }
        System.out.println(pathquery);
    }
}

