/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import java.sql.PreparedStatement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EML201DocumentCorrector {
    private Log logMetacat = LogFactory.getLog(EML201DocumentCorrector.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run() {
        DBConnection dbconn = null;
        boolean success = false;
        int serialNumber = 0;
        try {
            dbconn = DBConnectionPool.getDBConnection("EML201DocumentCorrector.run");
            serialNumber = dbconn.getCheckOutSerialNumber();
            PreparedStatement deletingStatement = null;
            String deletingIndex = this.generateXML_IndexDeletingSQL();
            this.logMetacat.debug((Object)("EML201DocumentCorrector.run - deleting the records in xml_index table with sql: " + deletingIndex));
            deletingStatement = dbconn.prepareStatement(deletingIndex);
            deletingStatement.execute();
            deletingStatement.close();
            String deletingNode = this.generateXML_NodeDeletingSQL();
            this.logMetacat.debug((Object)("EML201DocumentCorrector.run - deleting the records in xml_nodes table with sql: " + deletingNode));
            deletingStatement = dbconn.prepareStatement(deletingNode);
            deletingStatement.execute();
            deletingStatement.close();
            String deletingNodeRevision = this.generateXML_Node_RevisionsDeletingSQL();
            this.logMetacat.debug((Object)("EML201DocumentCorrector.run - deleting the records in xml_nodes_revisions table with sql: " + deletingNodeRevision));
            deletingStatement = dbconn.prepareStatement(deletingNodeRevision);
            deletingStatement.execute();
            deletingStatement.close();
            success = true;
        }
        catch (Exception ee) {
            this.logMetacat.error((Object)("EML201DocumentCorrector.run: " + ee.getMessage()));
            ee.printStackTrace();
        }
        finally {
            DBConnectionPool.returnDBConnection(dbconn, serialNumber);
        }
        return success;
    }

    private String generateXML_NodeDeletingSQL() {
        String sql = "delete from xml_nodes where nodetype='ATTRIBUTE' and nodename='system' and parentnodeid in (select nodeid from xml_nodes where  nodetype='ELEMENT' and nodename='references') and docid in (select docid from xml_documents where doctype ='eml://ecoinformatics.org/eml-2.0.1')";
        return sql;
    }

    private String generateXML_Node_RevisionsDeletingSQL() {
        String sql = "delete from xml_nodes_revisions where nodetype='ATTRIBUTE' and nodename='system' and parentnodeid in (select nodeid from xml_nodes_revisions where  nodetype='ELEMENT' and nodename='references') and docid in (select docid from xml_revisions where doctype ='eml://ecoinformatics.org/eml-2.0.1')";
        return sql;
    }

    private String generateXML_IndexDeletingSQL() {
        String sql = "delete from xml_index where doctype ='eml://ecoinformatics.org/eml-2.0.1' AND nodeid in (select nodeid from xml_index where path ='references/@system')";
        return sql;
    }

    public static void main(String[] args) throws Exception {
        PropertyService.getInstance(args[0]);
        DBConnectionPool connPool = DBConnectionPool.getInstance();
        EML201DocumentCorrector correct = new EML201DocumentCorrector();
        correct.run();
    }
}

