/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.shared.AccessException;
import edu.ucsb.nceas.metacat.shared.BaseAccess;
import edu.ucsb.nceas.utilities.BaseDAO;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XMLQueryresultAccess
extends BaseAccess {
    private Log logMetacat = LogFactory.getLog(XMLQueryresultAccess.class);

    public void deleteXMLQueryresulForDoc(String docId) throws AccessException {
        if (docId == null) {
            throw new AccessException("XMLQueryresultAccess.deleteXMLQueryresulForDoc - docid is required when deleting XML access record");
        }
        PreparedStatement pstmt = null;
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            conn = DBConnectionPool.getDBConnection("XMLQueryresultAccess.deleteXMLQueryresulForDoc");
            serialNumber = conn.getCheckOutSerialNumber();
            String sql = "DELETE FROM xml_queryresult WHERE docid = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, docId);
            String sqlReport = "XMLQueryresultAccess.deleteXMLQueryresulForDoc - SQL: " + sql;
            sqlReport = sqlReport + " [" + docId + "]";
            this.logMetacat.info((Object)sqlReport);
            pstmt.execute();
        }
        catch (SQLException sqle) {
            try {
                throw new AccessException("XMLQueryresultAccess.deleteXMLQueryresulForDoc - SQL error when deletingxml query result for doc id: " + docId + ":" + sqle.getMessage());
            }
            catch (Throwable throwable) {
                this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
                throw throwable;
            }
        }
        this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
    }

    @Override
    protected BaseDAO populateDAO(ResultSet resultSet) throws SQLException {
        return null;
    }
}

