/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.admin;

import edu.ucsb.nceas.metacat.AuthSession;
import edu.ucsb.nceas.metacat.admin.AdminException;
import edu.ucsb.nceas.metacat.admin.MetacatAdmin;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.util.RequestUtil;
import edu.ucsb.nceas.utilities.GeneralPropertyException;
import edu.ucsb.nceas.utilities.MetaDataProperty;
import edu.ucsb.nceas.utilities.PropertiesMetaData;
import edu.ucsb.nceas.utilities.SortedProperties;
import edu.ucsb.nceas.utilities.StringUtil;
import java.net.ConnectException;
import java.util.Set;
import java.util.SortedMap;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthAdmin
extends MetacatAdmin {
    private static AuthAdmin authAdmin = null;
    private static Log logMetacat = LogFactory.getLog(AuthAdmin.class);
    private static final String AUTHCLASSKEY = "auth.class";
    public static final String FILECLASS = "edu.ucsb.nceas.metacat.authentication.AuthFile";
    public static final String LDAPCLASS = "edu.ucsb.nceas.metacat.AuthLdap";

    private AuthAdmin() {
    }

    public static AuthAdmin getInstance() {
        if (authAdmin == null) {
            authAdmin = new AuthAdmin();
        }
        return authAdmin;
    }

    public void configureAuth(HttpServletRequest request, HttpServletResponse response) throws AdminException {
        String errorMessage;
        String processForm = request.getParameter("processForm");
        String formErrors = (String)request.getAttribute("formErrors");
        if (processForm == null || !processForm.equals("true") || formErrors != null) {
            try {
                PropertiesMetaData metadata = PropertyService.getAuthMetaData();
                request.setAttribute("metadata", (Object)metadata);
                request.setAttribute("groupMap", (Object)metadata.getGroups());
                Vector<String> propertyNames = PropertyService.getPropertyNamesByGroup("auth");
                for (String string : propertyNames) {
                    request.setAttribute(string, (Object)PropertyService.getProperty(string));
                }
                Vector<String> orgPropertyNames = PropertyService.getPropertyNamesByGroup("organization");
                for (String name : orgPropertyNames) {
                    request.setAttribute(name, (Object)PropertyService.getProperty(name));
                }
                SortedProperties sortedProperties = PropertyService.getAuthBackupProperties();
                if (sortedProperties != null) {
                    Vector backupKeys = sortedProperties.getPropertyNames();
                    for (String key : backupKeys) {
                        String value = sortedProperties.getProperty(key);
                        if (value == null) continue;
                        request.setAttribute(key, (Object)value);
                    }
                }
                RequestUtil.forwardRequest(request, response, "/admin/auth-configuration.jsp", null);
            }
            catch (GeneralPropertyException gpe) {
                throw new AdminException("AuthAdmin.configureAuth - Problem getting property while initializing LDAP properties page: " + gpe.getMessage());
            }
            catch (MetacatUtilException mue) {
                throw new AdminException("AuthAdmin.configureAuth - Utility problem while initializing LDAP properties page:" + mue.getMessage());
            }
        }
        Vector<String> processingSuccess = new Vector<String>();
        Vector<String> processingErrors = new Vector<String>();
        Vector<String> validationErrors = new Vector<String>();
        try {
            PropertiesMetaData propertiesMetaData = PropertyService.getAuthMetaData();
            SortedMap globalPropertyMap = propertiesMetaData.getPropertiesInGroup(1);
            Set globalPropertyIndexes = globalPropertyMap.keySet();
            for (Integer globalPropertyIndex : globalPropertyIndexes) {
                String globalPropertyKey = ((MetaDataProperty)globalPropertyMap.get(globalPropertyIndex)).getKey();
                PropertyService.checkAndSetProperty(request, globalPropertyKey);
            }
            SortedMap filePropertyMap = propertiesMetaData.getPropertiesInGroup(2);
            Set filePropertyIndexes = filePropertyMap.keySet();
            for (Integer filePropertyIndex : filePropertyIndexes) {
                String filePropertyKey = ((MetaDataProperty)filePropertyMap.get(filePropertyIndex)).getKey();
                PropertyService.checkAndSetProperty(request, filePropertyKey);
            }
            SortedMap ldapPropertyMap = propertiesMetaData.getPropertiesInGroup(3);
            Set ldapPropertyIndexes = ldapPropertyMap.keySet();
            for (Integer ldapPropertyIndex : ldapPropertyIndexes) {
                String ldapPropertyKey = ((MetaDataProperty)ldapPropertyMap.get(ldapPropertyIndex)).getKey();
                PropertyService.checkAndSetProperty(request, ldapPropertyKey);
            }
            PropertyService.persistProperties();
            PropertyService.syncToSettings();
            validationErrors.addAll(this.validateOptions(request));
            String backupDir = PropertyService.getProperty("application.backupDir");
            if (backupDir != null) {
                PropertyService.persistAuthBackupProperties(request.getSession().getServletContext());
            }
        }
        catch (GeneralPropertyException generalPropertyException) {
            errorMessage = "AuthAdmin.configureAuth - Problem getting or setting property while processing LDAP properties page: " + generalPropertyException.getMessage();
            logMetacat.error((Object)errorMessage);
            processingErrors.add(errorMessage);
        }
        try {
            if (validationErrors.size() > 0 || processingErrors.size() > 0) {
                RequestUtil.clearRequestMessages(request);
                RequestUtil.setRequestFormErrors(request, validationErrors);
                RequestUtil.setRequestErrors(request, processingErrors);
                RequestUtil.forwardRequest(request, response, "/admin", null);
            } else {
                PropertyService.setProperty("configutil.authConfigured", "true");
                processingSuccess.add("Authentication successfully configured");
                RequestUtil.clearRequestMessages(request);
                RequestUtil.setRequestSuccess(request, processingSuccess);
                RequestUtil.forwardRequest(request, response, "/admin?configureType=configure&processForm=false", null);
            }
        }
        catch (MetacatUtilException metacatUtilException) {
            throw new AdminException("AuthAdmin.configureAuth - utility problem forwarding request while processing LDAP properties page: " + metacatUtilException.getMessage());
        }
        catch (GeneralPropertyException generalPropertyException) {
            errorMessage = "AuthAdmin.configureAuth - Problem getting or setting property while processing Authentication properties page: " + generalPropertyException.getMessage();
            logMetacat.error((Object)errorMessage);
            processingErrors.add(errorMessage);
        }
    }

    @Override
    protected Vector<String> validateOptions(HttpServletRequest request) {
        Vector<String> errorVector = new Vector<String>();
        String adminUsers = request.getParameter("auth.administrators");
        Vector adminUserList = StringUtil.toVector((String)adminUsers, (char)':');
        try {
            AuthSession authSession = new AuthSession();
            for (String adminUser : adminUserList) {
                try {
                    authSession.getAttributes(adminUser);
                }
                catch (ConnectException ce) {
                    if (ce.getMessage() != null && ce.getMessage().contains("NameNotFoundException")) {
                        errorVector.add("User : " + adminUser + " is not in the specified identity service. If you chose to use the AuthFile as the authentication class, please add the user to the password file first.");
                        continue;
                    }
                    errorVector.add("Connection error while verifying Metacat Administrators : " + ce.getMessage());
                }
            }
        }
        catch (InstantiationException ie) {
            errorVector.add("AuthAdmin.validateOptions - InstantiationException while verifying Metacat Administrators : " + ie.getMessage());
        }
        catch (IllegalAccessException e) {
            errorVector.add("AuthAdmin.validateOptions - IllegalAccessException : " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            errorVector.add("AuthAdmin.validateOptions - ClassNotFoundException : " + e.getMessage());
        }
        catch (Exception e) {
            errorVector.add("AuthAdmin.validateOptions - An exception : " + e.getMessage());
        }
        return errorVector;
    }
}

