/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.admin.upgrade.solr;

import edu.ucsb.nceas.metacat.admin.AdminException;
import edu.ucsb.nceas.metacat.admin.upgrade.solr.SolrSchemaModificationException;
import edu.ucsb.nceas.metacat.admin.upgrade.solr.SolrSchemaUpgrader;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.service.ServiceService;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.utilities.FileUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.StringUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.util.ChecksumUtil;

public class SolrConfigUpgrader {
    private static Log logMetacat = LogFactory.getLog(SolrSchemaUpgrader.class);
    private static final String CONFIGFILERELATIVEPATH = "/conf/solrconfig.xml";
    private static final String MD5 = "MD5";
    private Vector<String> releasedConfigHashList = new Vector();
    private String solrHomePath = null;
    private String metacatIndexSolrHome = null;
    private String currentHash = null;

    public SolrConfigUpgrader() throws PropertyNotFoundException, ServiceException {
        String hashString = null;
        try {
            hashString = PropertyService.getProperty("index.configFile.released.hash");
            this.solrHomePath = PropertyService.getProperty("solr.homeDir");
            String indexContext = PropertyService.getProperty("index.context");
            this.currentHash = PropertyService.getProperty("index.configFile.current.hash");
            logMetacat.info((Object)("the current hash is ================== " + this.currentHash));
            String metacatWebInf = ServiceService.getRealConfigDir();
            this.metacatIndexSolrHome = metacatWebInf + "/../../" + indexContext + "/WEB-INF/classes/solr-home";
        }
        catch (PropertyNotFoundException pnfe) {
            throw new PropertyNotFoundException("SolrConfigUpdator.Constructor - could not get a metacat property in the metacat.properties file - " + pnfe.getMessage());
        }
        this.releasedConfigHashList = StringUtil.toVector((String)hashString, (char)';');
        logMetacat.info((Object)("the released hash is ================== " + this.releasedConfigHashList));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void upgrade() throws AdminException, IOException, NoSuchAlgorithmException, SolrSchemaModificationException {
        boolean solrHomeExists = new File(this.solrHomePath).exists();
        if (!solrHomeExists) {
            try {
                File sourceDir = new File(this.metacatIndexSolrHome);
                if (!sourceDir.exists()) return;
                FileUtil.createDirectory((String)this.solrHomePath);
                OrFileFilter fileFilter = new OrFileFilter();
                fileFilter.addFileFilter(DirectoryFileFilter.DIRECTORY);
                fileFilter.addFileFilter((IOFileFilter)new WildcardFileFilter("*"));
                FileUtils.copyDirectory((File)new File(this.metacatIndexSolrHome), (File)new File(this.solrHomePath), (FileFilter)fileFilter);
                return;
            }
            catch (Exception ue) {
                String errorString = "SolrConfigUpdator.update - Could not initialize directory: " + this.solrHomePath + " : " + ue.getMessage();
                throw new AdminException(errorString);
            }
        }
        if (!FileUtil.isDirectory((String)this.solrHomePath)) {
            String errorString = "SolrConfigUpdator.update - SOLR home is not a directory: " + this.solrHomePath;
            throw new AdminException(errorString);
        }
        File metacatIndexConfigFile = new File(this.metacatIndexSolrHome + CONFIGFILERELATIVEPATH);
        File configFile = new File(this.solrHomePath + CONFIGFILERELATIVEPATH);
        if (!metacatIndexConfigFile.exists()) return;
        if (!configFile.exists()) {
            FileUtils.copyFile((File)metacatIndexConfigFile, (File)configFile);
            return;
        }
        FileInputStream configInputStream = new FileInputStream(configFile);
        Checksum checkSum = null;
        try {
            checkSum = ChecksumUtil.checksum((InputStream)configInputStream, (String)MD5);
            if (configInputStream != null) {
                IOUtils.closeQuietly((InputStream)configInputStream);
            }
        }
        finally {
            if (configInputStream != null) {
                IOUtils.closeQuietly((InputStream)configInputStream);
            }
        }
        String error1 = "Metacat couldn't determine if the solrconfig.xml in the " + this.solrHomePath + "/conf was modified or not. We backup the file to solrconfig.xml.org. If you did modify it, please manually merge the change back to the file solrconfig.xml at " + this.solrHomePath + "/conf.";
        String error3 = "Metacat determined the solrconfig.xml in the " + this.solrHomePath + "/conf was customized. Metacat backuped the file to solrconfig.xml.org. You have to manually fix the issue - merge the change back to the solrconfig.xml in the " + this.solrHomePath + "/conf. You may click the OK button when you finish the merging. ";
        if (checkSum == null) {
            File backupFile = new File(this.solrHomePath + CONFIGFILERELATIVEPATH + ".org");
            FileUtils.copyFile((File)configFile, (File)backupFile);
            FileUtils.copyFile((File)metacatIndexConfigFile, (File)configFile);
            throw new SolrSchemaModificationException(error1);
        }
        String checksumValue = checkSum.getValue();
        logMetacat.info((Object)("the existing schema.xml in the solr home has the checksum ================== " + checksumValue));
        if (checksumValue == null) {
            File backupFile = new File(this.solrHomePath + CONFIGFILERELATIVEPATH + ".org");
            FileUtils.copyFile((File)configFile, (File)backupFile);
            FileUtils.copyFile((File)metacatIndexConfigFile, (File)configFile);
            throw new SolrSchemaModificationException(error1);
        }
        if (checksumValue.equals(this.currentHash)) {
            logMetacat.info((Object)"=====the existing config.xml in the solr home has the same checksum as our current release, do nothing");
            return;
        }
        boolean found = false;
        for (String value : this.releasedConfigHashList) {
            if (!value.equals(checksumValue)) continue;
            found = true;
            break;
        }
        if (found) {
            FileUtils.copyFile((File)metacatIndexConfigFile, (File)configFile);
            return;
        }
        File backupFile = new File(this.solrHomePath + CONFIGFILERELATIVEPATH + ".org");
        FileUtils.copyFile((File)configFile, (File)backupFile);
        FileUtils.copyFile((File)metacatIndexConfigFile, (File)configFile);
        throw new SolrSchemaModificationException(error3);
    }
}

