/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.dataone;

import edu.ucsb.nceas.metacat.AccessionNumber;
import edu.ucsb.nceas.metacat.AccessionNumberException;
import edu.ucsb.nceas.metacat.DBTransform;
import edu.ucsb.nceas.metacat.DocumentImpl;
import edu.ucsb.nceas.metacat.EventLog;
import edu.ucsb.nceas.metacat.EventLogData;
import edu.ucsb.nceas.metacat.IdentifierManager;
import edu.ucsb.nceas.metacat.McdbDocNotFoundException;
import edu.ucsb.nceas.metacat.MetacatHandler;
import edu.ucsb.nceas.metacat.client.InsufficientKarmaException;
import edu.ucsb.nceas.metacat.common.query.stream.ContentTypeByteArrayInputStream;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.dataone.D1AuthHelper;
import edu.ucsb.nceas.metacat.dataone.hazelcast.HazelcastService;
import edu.ucsb.nceas.metacat.dataone.quota.QuotaServiceManager;
import edu.ucsb.nceas.metacat.index.MetacatSolrIndex;
import edu.ucsb.nceas.metacat.object.handler.NonXMLMetadataHandler;
import edu.ucsb.nceas.metacat.object.handler.NonXMLMetadataHandlers;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.properties.SkinPropertyService;
import edu.ucsb.nceas.metacat.replication.ForceReplicationHandler;
import edu.ucsb.nceas.metacat.restservice.multipart.DetailedFileInputStream;
import edu.ucsb.nceas.metacat.restservice.multipart.StreamingMultipartRequestResolver;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.metacat.util.AuthUtil;
import edu.ucsb.nceas.metacat.util.SkinUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.dataone.client.v2.CNode;
import org.dataone.client.v2.formats.ObjectFormatCache;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.IdentifierNotUnique;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidSystemMetadata;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.types.v1.AccessPolicy;
import org.dataone.service.types.v1.AccessRule;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.DescribeResponse;
import org.dataone.service.types.v1.Event;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.ObjectList;
import org.dataone.service.types.v1.Permission;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.SystemMetadata;
import org.dataone.service.types.v1.util.AuthUtils;
import org.dataone.service.types.v2.Log;
import org.dataone.service.types.v2.Node;
import org.dataone.service.types.v2.NodeList;
import org.dataone.service.types.v2.ObjectFormat;
import org.dataone.service.types.v2.OptionList;

public abstract class D1NodeService {
    public static final String DELETEDMESSAGE = "The object with the PID has been deleted from the node.";
    public static final String METADATA = "METADATA";
    private static org.apache.commons.logging.Log logMetacat = LogFactory.getLog(D1NodeService.class);
    protected HttpServletRequest request;
    protected String ipAddress = null;
    protected String userAgent = null;
    protected static MetacatHandler handler = new MetacatHandler();
    protected static int MAXIMUM_DB_RECORD_COUNT = 7000;
    protected Session session2;

    public D1NodeService(HttpServletRequest request) {
        this.request = request;
    }

    public Session getSession() {
        return this.session2;
    }

    public void setSession(Session session) {
        this.session2 = session;
    }

    protected NodeList getCNNodeList() throws ServiceFailure, NotImplemented {
        CNode cn = D1Client.getCN();
        logMetacat.debug((Object)"getCNNodeList - got CN instance");
        return cn.listNodes();
    }

    public DescribeResponse describe(Session session, Identifier id) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        org.dataone.service.types.v2.SystemMetadata sysmeta = this.getSystemMetadata(session, id);
        DescribeResponse describeResponse = new DescribeResponse(sysmeta.getFormatId(), sysmeta.getSize(), sysmeta.getDateSysMetadataModified(), sysmeta.getChecksum(), sysmeta.getSerialVersion());
        return describeResponse;
    }

    public Identifier delete(String username, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        String localId = null;
        if (pid == null || pid.getValue().trim().equals("")) {
            throw new ServiceFailure("1350", "The provided identifier was invalid.");
        }
        try {
            localId = IdentifierManager.getInstance().getLocalId(pid.getValue());
        }
        catch (McdbDocNotFoundException e) {
            block19: {
                logMetacat.warn((Object)("D1NodeService.delete - the object itself with the provided identifier " + pid.getValue() + " doesn't exist in the system. But we will continute to delete the system metadata of the object."));
                Lock lock = null;
                try {
                    lock = HazelcastService.getInstance().getLock(pid.getValue());
                    lock.lock();
                    logMetacat.debug((Object)("Locked identifier " + pid.getValue()));
                    org.dataone.service.types.v2.SystemMetadata sysMeta = (org.dataone.service.types.v2.SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)pid);
                    if (sysMeta != null) {
                        HazelcastService.getInstance().getSystemMetadataMap().remove((Object)pid);
                        HazelcastService.getInstance().getIdentifiers().remove((Object)pid);
                        try {
                            MetacatSolrIndex.getInstance().submitDeleteTask(pid, sysMeta);
                        }
                        catch (Exception ee) {
                            logMetacat.warn((Object)("D1NodeService.delete - the object with the provided identifier " + pid.getValue() + " was deleted. But the MN solr index can't be deleted."));
                        }
                        EventLog.getInstance().log(this.request.getRemoteAddr(), this.request.getHeader("User-Agent"), username, pid.getValue(), Event.DELETE.xmlValue());
                        break block19;
                    }
                    throw new ServiceFailure("1350", "Couldn't delete the object " + pid.getValue() + ". Couldn't obtain the system metadata record.");
                }
                catch (RuntimeException re) {
                    throw new ServiceFailure("1350", "Couldn't delete " + pid.getValue() + ". The error message was: " + re.getMessage());
                }
                finally {
                    if (lock != null) {
                        lock.unlock();
                        logMetacat.debug((Object)("Unlocked identifier " + pid.getValue()));
                    }
                }
            }
            return pid;
        }
        catch (SQLException e) {
            throw new ServiceFailure("1350", "The object with the provided identifier " + pid.getValue() + " couldn't be identified since " + e.getMessage());
        }
        try {
            DocumentImpl.delete(localId, null, null, null, true);
            EventLog.getInstance().log(this.request.getRemoteAddr(), this.request.getHeader("User-Agent"), username, localId, Event.DELETE.xmlValue());
        }
        catch (McdbDocNotFoundException e) {
            throw new NotFound("1340", "The provided identifier was invalid.");
        }
        catch (SQLException e) {
            throw new ServiceFailure("1350", "There was a problem deleting the object.The error message was: " + e.getMessage());
        }
        catch (InsufficientKarmaException e) {
            if (logMetacat.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new NotAuthorized("1320", "The provided identity does not have permission to DELETE objects on the Member Node.");
        }
        catch (Exception e) {
            throw new ServiceFailure("1350", "There was a problem deleting the object.The error message was: " + e.getMessage());
        }
        return pid;
    }

    public Date ping() throws NotImplemented, ServiceFailure, InsufficientResources {
        int serialNumber = -1;
        DBConnection dbConn = null;
        try {
            dbConn = DBConnectionPool.getDBConnection("MNodeService.ping");
            serialNumber = dbConn.getCheckOutSerialNumber();
        }
        catch (SQLException e) {
            ServiceFailure sf = new ServiceFailure("", e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        }
        return Calendar.getInstance().getTime();
    }

    public Identifier create(Session session, Identifier pid, InputStream object, org.dataone.service.types.v2.SystemMetadata sysmeta) throws InvalidToken, ServiceFailure, NotAuthorized, IdentifierNotUnique, UnsupportedType, InsufficientResources, InvalidSystemMetadata, NotImplemented, InvalidRequest {
        Identifier resultPid = null;
        String localId = null;
        if (session == null) {
            throw new InvalidToken("4894", "Session is required to WRITE to the Node.");
        }
        Subject subject = session.getSubject();
        Subject publicSubject = new Subject();
        publicSubject.setValue("public");
        if (subject == null || subject.getValue() == null || subject.equals((Object)publicSubject)) {
            throw new NotAuthorized("1100", "The provided identity does not have permission to WRITE to the Node.");
        }
        logMetacat.debug((Object)("Comparing pid|sysmeta_pid: " + pid.getValue() + "|" + sysmeta.getIdentifier().getValue()));
        if (!pid.getValue().equals(sysmeta.getIdentifier().getValue())) {
            throw new InvalidSystemMetadata("1180", "The supplied system metadata is invalid. The identifier " + pid.getValue() + " does not match identifierin the system metadata identified by " + sysmeta.getIdentifier().getValue() + ".");
        }
        if (sysmeta.getChecksum() == null) {
            logMetacat.error((Object)("D1NodeService.create - the checksum object from the system metadata shouldn't be null for the object " + pid.getValue()));
            throw new InvalidSystemMetadata("1180", "The checksum object from the system metadata shouldn't be null.");
        }
        try {
            HazelcastService.getInstance().getSystemMetadataMap().put((Object)sysmeta.getIdentifier(), (Object)sysmeta);
        }
        catch (Exception e) {
            logMetacat.error((Object)("D1Node.create - There was problem to save the system metadata: " + pid.getValue()), (Throwable)e);
            throw new ServiceFailure("1190", "There was problem to save the system metadata: " + pid.getValue() + " since " + e.getMessage());
        }
        boolean isScienceMetadata = false;
        if (D1NodeService.isScienceMetadata(sysmeta)) {
            isScienceMetadata = true;
            try {
                NonXMLMetadataHandler handler = NonXMLMetadataHandlers.newNonXMLMetadataHandler(sysmeta.getFormatId());
                if (handler != null) {
                    if (this.ipAddress == null) {
                        this.ipAddress = this.request.getRemoteAddr();
                    }
                    if (this.userAgent == null) {
                        this.userAgent = this.request.getHeader("User-Agent");
                    }
                    EventLogData event = new EventLogData(this.ipAddress, this.userAgent, null, null, "create");
                    localId = handler.save(object, (SystemMetadata)sysmeta, session, event);
                }
                String formatId = null;
                if (sysmeta.getFormatId() != null) {
                    formatId = sysmeta.getFormatId().getValue();
                }
                localId = this.insertOrUpdateDocument(object, "UTF-8", pid, session, "insert", formatId, sysmeta.getChecksum());
            }
            catch (IOException e) {
                this.removeSystemMetaAndIdentifier(pid);
                String msg = "The Node is unable to create the object " + pid.getValue() + " There was a problem converting the object to XML";
                logMetacat.error((Object)msg, (Throwable)e);
                throw new ServiceFailure("1190", msg + ": " + e.getMessage());
            }
            catch (ServiceFailure e) {
                this.removeSystemMetaAndIdentifier(pid);
                logMetacat.error((Object)("D1NodeService.create - the node couldn't create the object " + pid.getValue() + " since " + e.getMessage()), (Throwable)e);
                throw e;
            }
            catch (InvalidRequest e) {
                this.removeSystemMetaAndIdentifier(pid);
                logMetacat.error((Object)("D1NodeService.create - the node couldn't create the object " + pid.getValue() + " since " + e.getMessage()), (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                this.removeSystemMetaAndIdentifier(pid);
                logMetacat.error((Object)("The node is unable to create the object: " + pid.getValue() + " since " + e.getMessage()), (Throwable)e);
                throw new ServiceFailure("1190", "The node is unable to create the object: " + pid.getValue() + " since " + e.getMessage());
            }
        } else {
            try {
                if (this.ipAddress == null) {
                    this.ipAddress = this.request.getRemoteAddr();
                }
                if (this.userAgent == null) {
                    this.userAgent = this.request.getHeader("User-Agent");
                }
                EventLogData event = new EventLogData(this.ipAddress, this.userAgent, null, null, "create");
                localId = this.insertDataObject(object, pid, session, sysmeta.getChecksum(), event);
            }
            catch (ServiceFailure e) {
                this.removeSystemMetaAndIdentifier(pid);
                throw e;
            }
            catch (InvalidSystemMetadata e) {
                this.removeSystemMetaAndIdentifier(pid);
                throw e;
            }
            catch (NotAuthorized e) {
                this.removeSystemMetaAndIdentifier(pid);
                throw e;
            }
            catch (Exception e) {
                this.removeSystemMetaAndIdentifier(pid);
                throw new ServiceFailure("1190", "The node is unable to create the object " + pid.getValue() + " since " + e.getMessage());
            }
        }
        logMetacat.debug((Object)("Done inserting new object: " + pid.getValue()));
        try {
            if (localId == null || !IdentifierManager.getInstance().objectFileExists(localId, isScienceMetadata)) {
                this.removeSystemMetaAndIdentifier(pid);
                throw new ServiceFailure("1190", "The Node is unable to create the object. " + pid.getValue());
            }
        }
        catch (PropertyNotFoundException e) {
            this.removeSystemMetaAndIdentifier(pid);
            throw new ServiceFailure("1190", "The Node is unable to create the object. " + pid.getValue() + " since " + e.getMessage());
        }
        try {
            MetacatSolrIndex.getInstance().submit(sysmeta.getIdentifier(), sysmeta, null, false);
        }
        catch (Exception e) {
            logMetacat.warn((Object)("Couldn't create solr index for object " + pid.getValue()));
        }
        resultPid = pid;
        logMetacat.info((Object)("create() complete for object: " + pid.getValue()));
        return resultPid;
    }

    protected static void objectExists(Identifier id) throws ServiceFailure, IdentifierNotUnique {
        boolean idExists = false;
        if (id == null) {
            throw new IdentifierNotUnique("1120", "The requested identifier can't be null.");
        }
        logMetacat.debug((Object)("Checking if identifier exists: " + id.getValue()));
        try {
            idExists = IdentifierManager.getInstance().identifierExists(id.getValue());
        }
        catch (SQLException e) {
            throw new ServiceFailure("1190", "The requested identifier " + id.getValue() + " couldn't be determined if it is unique since : " + e.getMessage());
        }
        if (idExists) {
            throw new IdentifierNotUnique("1120", "The requested identifier " + id.getValue() + " is already used by another object and  therefore can not be used for this object. Clients should choosea new identifier that is unique and retry the operation or use CN.reserveIdentifier() to reserve one.");
        }
    }

    protected void removeSystemMetaAndIdentifier(Identifier id) {
        if (id != null) {
            logMetacat.debug((Object)("D1NodeService.removeSystemMeta - the system metadata of object " + id.getValue() + " will removed from both hazelcast and db tables since the object creation failed"));
            HazelcastService.getInstance().getSystemMetadataMap().remove((Object)id);
            logMetacat.info((Object)("D1NodeService.removeSystemMeta - the system metadata of object " + id.getValue() + " has been removed from both hazelcast and db tables since the object creation failed"));
            try {
                if (IdentifierManager.getInstance().mappingExists(id.getValue())) {
                    String localId = IdentifierManager.getInstance().getLocalId(id.getValue());
                    IdentifierManager.getInstance().removeMapping(id.getValue(), localId);
                    logMetacat.info((Object)("D1NodeService.removeSystemMeta - the identifier " + id.getValue() + " and local id " + localId + " have been removed from the identifier table since the object creation failed"));
                }
            }
            catch (Exception e) {
                logMetacat.warn((Object)("D1NodeService.removeSysteMeta - can't decide if the mapping of  the pid " + id.getValue() + " exists on the identifier table."));
            }
        }
    }

    protected void removeSolrIndex(org.dataone.service.types.v2.SystemMetadata sysMeta) {
        sysMeta.setSerialVersion(sysMeta.getSerialVersion().add(BigInteger.ONE));
        sysMeta.setArchived(Boolean.valueOf(true));
        sysMeta.setDateSysMetadataModified(Calendar.getInstance().getTime());
        try {
            MetacatSolrIndex.getInstance().submitDeleteTask(sysMeta.getIdentifier(), sysMeta);
        }
        catch (Exception e) {
            logMetacat.warn((Object)("Can't remove the solr index for pid " + sysMeta.getIdentifier().getValue()));
        }
    }

    protected static void removeIdFromIdentifierTable(Identifier id) {
        if (id != null) {
            try {
                if (IdentifierManager.getInstance().mappingExists(id.getValue())) {
                    String localId = IdentifierManager.getInstance().getLocalId(id.getValue());
                    IdentifierManager.getInstance().removeMapping(id.getValue(), localId);
                    logMetacat.info((Object)("MNodeService.removeIdFromIdentifierTable - the identifier " + id.getValue() + " and local id " + localId + " have been removed from the identifier table since the object creation failed"));
                }
            }
            catch (Exception e) {
                logMetacat.warn((Object)("MNodeService.removeIdFromIdentifierTable - can't decide if the mapping of  the pid " + id.getValue() + " exists on the identifier table."));
            }
        }
    }

    public Log getLogRecords(Session session, Date fromDate, Date toDate, String event, String pidFilter, Integer start, Integer count) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented {
        D1AuthHelper authDel = new D1AuthHelper(this.request, null, "1460", "1490");
        authDel.doAdminAuthorization(session);
        Log log = new Log();
        IdentifierManager im = IdentifierManager.getInstance();
        EventLog el = EventLog.getInstance();
        if (fromDate == null) {
            logMetacat.debug((Object)"setting fromdate from null");
            fromDate = new Date(1L);
        }
        if (toDate == null) {
            logMetacat.debug((Object)"setting todate from null");
            toDate = new Date();
        }
        if (start == null) {
            start = 0;
        }
        if (count == null) {
            count = 1000;
        }
        if (count > MAXIMUM_DB_RECORD_COUNT) {
            count = MAXIMUM_DB_RECORD_COUNT;
        }
        String[] filterDocid = null;
        if (pidFilter != null && !pidFilter.trim().equals("")) {
            Identifier pid = new Identifier();
            pid.setValue(pidFilter);
            String serviceFailureCode = "1490";
            Identifier headPid = this.getPIDForSID(pid, serviceFailureCode);
            if (headPid != null) {
                pidFilter = headPid.getValue();
            }
            try {
                String localId = im.getLocalId(pidFilter);
                filterDocid = new String[]{localId};
            }
            catch (Exception ex) {
                String msg = "Could not find localId for given pidFilter '" + pidFilter + "'";
                logMetacat.warn((Object)msg, (Throwable)ex);
                return log;
            }
        }
        logMetacat.debug((Object)("fromDate: " + fromDate));
        logMetacat.debug((Object)("toDate: " + toDate));
        log = el.getD1Report(null, null, filterDocid, event, new Timestamp(fromDate.getTime()), new Timestamp(toDate.getTime()), false, start, count);
        logMetacat.info((Object)"getLogRecords");
        return log;
    }

    public InputStream get(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        String localId;
        String serviceFailureCode = "1030";
        String notFoundCode = "1020";
        Identifier headPID = this.getPIDForSID(pid, notFoundCode);
        if (headPID != null) {
            pid = headPID;
        }
        InputStream inputStream = null;
        boolean allowed = false;
        try {
            localId = IdentifierManager.getInstance().getLocalId(pid.getValue());
        }
        catch (McdbDocNotFoundException e) {
            throw new NotFound("1020", "The object specified by " + pid.getValue() + " does not exist at this node.");
        }
        catch (SQLException e) {
            throw new ServiceFailure("1030", "The object specified by " + pid.getValue() + " couldn't be identified at this node since " + e.getMessage());
        }
        try {
            allowed = this.isAuthorized(session, pid, Permission.READ);
        }
        catch (InvalidRequest e) {
            throw new ServiceFailure("1030", e.getDescription());
        }
        if (allowed) {
            org.dataone.service.types.v2.SystemMetadata sm = (org.dataone.service.types.v2.SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)pid);
            ObjectFormat objectFormat = null;
            String type = null;
            try {
                objectFormat = ObjectFormatCache.getInstance().getFormat(sm.getFormatId());
            }
            catch (BaseException be) {
                logMetacat.warn((Object)("Could not lookup ObjectFormat for: " + sm.getFormatId()), (Throwable)be);
            }
            if (objectFormat != null) {
                type = objectFormat.getFormatType();
            }
            logMetacat.info((Object)("D1NodeService.get - the data type for the object " + pid.getValue() + " is " + type));
            try {
                inputStream = MetacatHandler.read(localId, type);
            }
            catch (McdbDocNotFoundException de) {
                String error = "";
                try {
                    if (IdentifierManager.getInstance().existsInIdentifierTable(pid)) {
                        error = DELETEDMESSAGE;
                    }
                }
                catch (Exception e) {
                    logMetacat.warn((Object)("Can't determine if the pid " + pid.getValue() + " is deleted or not."));
                }
                throw new NotFound("1020", "The object specified by " + pid.getValue() + " does not exist at this node. " + error);
            }
            catch (Exception e) {
                throw new ServiceFailure("1030", "The object specified by " + pid.getValue() + " could not be returned due to error: " + e.getMessage() + ". ");
            }
        }
        if (inputStream == null) {
            String error = "";
            try {
                if (IdentifierManager.getInstance().existsInIdentifierTable(pid)) {
                    error = DELETEDMESSAGE;
                }
            }
            catch (Exception e) {
                logMetacat.warn((Object)("Can't determine if the pid " + pid.getValue() + " is deleted or not."));
            }
            throw new NotFound("1020", "The object specified by " + pid.getValue() + " does not exist at this node. " + error);
        }
        String principal = "public";
        if (session != null && session.getSubject() != null) {
            principal = session.getSubject().getValue();
        }
        EventLog.getInstance().log(this.request.getRemoteAddr(), this.request.getHeader("User-Agent"), principal, localId, "read");
        return inputStream;
    }

    public org.dataone.service.types.v2.SystemMetadata getSystemMetadata(Session session, Identifier id) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        String serviceFailureCode = "1090";
        String notFoundCode = "1420";
        String notAuthorizedCode = "1040";
        String invalidTokenCode = "1050";
        boolean needDeleteInfo = true;
        Identifier HeadOfSid = this.getPIDForSID(id, serviceFailureCode);
        if (HeadOfSid != null) {
            id = HeadOfSid;
        }
        org.dataone.service.types.v2.SystemMetadata sysmeta = null;
        try {
            sysmeta = this.getSystemMetadataForPID(id, serviceFailureCode, invalidTokenCode, notFoundCode, needDeleteInfo);
        }
        catch (InvalidRequest e) {
            throw new InvalidToken(invalidTokenCode, e.getMessage());
        }
        D1AuthHelper authDel = new D1AuthHelper(this.request, id, notAuthorizedCode, serviceFailureCode);
        authDel.doGetSysmetaAuthorization(session, sysmeta, Permission.READ);
        return sysmeta;
    }

    public boolean isAuthorized(Session session, Identifier id, Permission permission) throws ServiceFailure, InvalidToken, NotFound, NotAuthorized, NotImplemented, InvalidRequest {
        if (permission == null) {
            throw new InvalidRequest("1761", "Permission was not provided or is invalid");
        }
        String serviceFailureCode = "1760";
        String notFoundCode = "1800";
        String notAuthorizedCode = "1820";
        String invalidRequestCode = "1761";
        boolean needDeleteInfo = true;
        Identifier HeadOfSid = this.getPIDForSID(id, serviceFailureCode);
        if (HeadOfSid != null) {
            id = HeadOfSid;
        }
        org.dataone.service.types.v2.SystemMetadata sysmeta = this.getSystemMetadataForPID(id, serviceFailureCode, invalidRequestCode, notFoundCode, needDeleteInfo);
        D1AuthHelper authDel = new D1AuthHelper(this.request, id, notAuthorizedCode, serviceFailureCode);
        authDel.doIsAuthorized(session, sysmeta, permission);
        return true;
    }

    private String getLogEntryField(String fieldname, String entry) {
        String begin = "<" + fieldname + ">";
        String end = "</" + fieldname + ">";
        String s = entry.substring(entry.indexOf(begin) + begin.length(), entry.indexOf(end));
        logMetacat.debug((Object)("entry " + fieldname + " : " + s));
        return s;
    }

    public static boolean isScienceMetadata(org.dataone.service.types.v2.SystemMetadata sysmeta) {
        ObjectFormat objectFormat = null;
        boolean isScienceMetadata = false;
        try {
            objectFormat = ObjectFormatCache.getInstance().getFormat(sysmeta.getFormatId());
            if (objectFormat.getFormatType().equals(METADATA)) {
                isScienceMetadata = true;
            }
        }
        catch (NotFound e) {
            logMetacat.debug((Object)("There was a problem determining if the object identified by" + sysmeta.getIdentifier().getValue() + " is science metadata: " + e.getMessage()));
        }
        return isScienceMetadata;
    }

    public static boolean isValidIdentifier(Identifier pid) {
        boolean valid = true;
        if (pid != null && pid.getValue() != null && pid.getValue().length() > 0) {
            for (int i = 0; i < pid.getValue().length(); ++i) {
                char ch = pid.getValue().charAt(i);
                if (!Character.isWhitespace(ch)) continue;
                valid = false;
                break;
            }
        } else {
            valid = false;
        }
        return valid;
    }

    public String insertOrUpdateDocument(InputStream xmlStream, String encoding, Identifier pid, Session session, String insertOrUpdate, String formatId, Checksum checksum) throws ServiceFailure, IOException, PropertyNotFoundException, InvalidSystemMetadata {
        logMetacat.debug((Object)"Starting to insert xml document...");
        IdentifierManager im = IdentifierManager.getInstance();
        String checksumValue = checksum.getValue();
        logMetacat.info((Object)("D1NodeService.insertOrUpdateDocument - the checksum value from the system metadata is " + checksumValue + " for the metdata object " + pid.getValue()));
        if (checksumValue == null || checksumValue.trim().equals("")) {
            logMetacat.error((Object)("D1NodeService.insertOrUpdateDocument - the checksum value from the system metadata shouldn't be null or blank for the metadata object " + pid.getValue()));
            throw new InvalidSystemMetadata("1180", "The checksum value from the system metadata shouldn't be null or blank for the ojbect " + pid.getValue());
        }
        String algorithm = checksum.getAlgorithm();
        logMetacat.info((Object)("D1NodeService.insertOrUpdateDocument - the algorithm to calculate the checksum from the system metadata is " + algorithm + " for the metadata object " + pid.getValue()));
        if (algorithm == null || algorithm.trim().equals("")) {
            logMetacat.error((Object)("D1NodeService.insertOrUpdateDocument - the algorithm to calculate the checksum from the system metadata shouldn't be null or blank for the metadata object " + pid.getValue()));
            throw new InvalidSystemMetadata("1180", "The algorithm to calculate the checksum from the system metadata shouldn't be null or blank for the metadata object " + pid.getValue());
        }
        File tempFile = null;
        if (xmlStream instanceof DetailedFileInputStream) {
            logMetacat.info((Object)"D1NodeService.insertOrUpdateDocument - in the detailedFileInputstream branch");
            boolean checksumMatched = false;
            DetailedFileInputStream stream = (DetailedFileInputStream)xmlStream;
            tempFile = stream.getFile();
            Checksum expectedChecksum = stream.getExpectedChecksum();
            if (expectedChecksum != null) {
                String expectedAlgorithm = expectedChecksum.getAlgorithm();
                String expectedChecksumValue = expectedChecksum.getValue();
                if (expectedAlgorithm != null && expectedAlgorithm.equalsIgnoreCase(algorithm)) {
                    if (expectedChecksumValue != null && expectedChecksumValue.equalsIgnoreCase(checksumValue)) {
                        logMetacat.info((Object)("D1NodeService.insertOrUpdateDocument - Metacat already verified the checksum of the object " + pid.getValue()));
                        checksumMatched = true;
                    } else {
                        logMetacat.error((Object)("D1NodeService.insertOrUpdateDocument - the check sum calculated from the saved local file is " + expectedChecksumValue + ". But it doesn't match the value from the system metadata " + checksumValue + " for the object " + pid.getValue()));
                        throw new InvalidSystemMetadata("1180", "D1NodeService.insertOrUpdateDocument - the check sum calculated from the saved local file is " + expectedChecksumValue + ". But it doesn't match the value from the system metadata " + checksumValue + " for the object " + pid.getValue());
                    }
                }
            }
            if (!checksumMatched && tempFile != null) {
                logMetacat.info((Object)"D1NodeService.insertOrUpdateDocument - mark the temp file to be deleted on exist.");
                StreamingMultipartRequestResolver.deleteTempFile(tempFile);
                tempFile = null;
            }
        }
        String localId = null;
        byte[] xmlBytes = IOUtils.toByteArray((InputStream)xmlStream);
        IOUtils.closeQuietly((InputStream)xmlStream);
        String xmlStr = new String(xmlBytes, encoding);
        if (insertOrUpdate.equals("insert")) {
            localId = im.generateLocalId(pid.getValue(), 1);
        } else {
            try {
                logMetacat.debug((Object)("Updating pid " + pid.getValue()));
                logMetacat.debug((Object)("looking in identifier table for pid " + pid.getValue()));
                localId = im.getLocalId(pid.getValue());
                logMetacat.debug((Object)("localId: " + localId));
                String docid = localId.substring(0, localId.lastIndexOf("."));
                String revS = localId.substring(localId.lastIndexOf(".") + 1, localId.length());
                int rev = new Integer(revS);
                localId = docid = docid + "." + ++rev;
                logMetacat.debug((Object)("incremented localId: " + localId));
            }
            catch (McdbDocNotFoundException e) {
                throw new ServiceFailure("1030", "D1NodeService.insertOrUpdateDocument(): pid " + pid.getValue() + " should have been in the identifier table, but it wasn't: " + e.getMessage());
            }
            catch (SQLException e) {
                throw new ServiceFailure("1030", "D1NodeService.insertOrUpdateDocument() - couldn't identify if the pid " + pid.getValue() + " is in the identifier table since " + e.getMessage());
            }
        }
        Hashtable<String, String[]> params = new Hashtable<String, String[]>();
        String[] action = new String[]{insertOrUpdate};
        params.put("action", action);
        String[] docid = new String[]{localId};
        params.put("docid", docid);
        String[] doctext = new String[]{xmlStr};
        params.put("doctext", doctext);
        String username = "public";
        String[] groupnames = null;
        if (session != null) {
            username = session.getSubject().getValue();
            Set otherSubjects = AuthUtils.authorizedClientSubjects((Session)session);
            if (otherSubjects != null) {
                groupnames = new String[otherSubjects.size()];
                int i = 0;
                Iterator iter = otherSubjects.iterator();
                while (iter.hasNext()) {
                    groupnames[i] = ((Subject)iter.next()).getValue();
                    ++i;
                }
            }
        }
        if (this.ipAddress == null) {
            this.ipAddress = this.request.getRemoteAddr();
        }
        if (this.userAgent == null) {
            this.userAgent = this.request.getHeader("User-Agent");
        }
        long start = System.currentTimeMillis();
        String result = handler.handleInsertOrUpdateAction(this.ipAddress, this.userAgent, null, null, params, username, groupnames, false, false, xmlBytes, formatId, checksum, tempFile);
        long end = System.currentTimeMillis();
        logMetacat.info((Object)("MetacatPerformanceLog " + pid.getValue() + " create/update method " + " Parse and write the metadata object into database (if the multiparts handler hasn't calculated the checksum, it will write the content to the disk again)" + " duration " + (end - start) / 1000L));
        boolean isScienceMetadata = true;
        if (result.indexOf("<error>") != -1 || !IdentifierManager.getInstance().objectFileExists(localId, isScienceMetadata)) {
            String detailCode = "";
            if (insertOrUpdate.equals("insert")) {
                im.removeMapping(pid.getValue(), localId);
                detailCode = "1190";
            } else if (insertOrUpdate.equals("update")) {
                detailCode = "1310";
            }
            logMetacat.error((Object)("D1NodeService.insertOrUpdateDocument - Error inserting or updating document: " + pid.getValue() + " since " + result));
            throw new ServiceFailure(detailCode, "Error inserting or updating document: " + pid.getValue() + " since " + result);
        }
        logMetacat.info((Object)("D1NodeService.insertOrUpdateDocument - Finsished inserting xml document with local id " + localId + " and its pid is " + pid.getValue()));
        return localId;
    }

    protected String insertDataObject(InputStream object, Identifier pid, Session session, Checksum checksum) throws ServiceFailure, InvalidSystemMetadata, NotAuthorized {
        if (this.ipAddress == null) {
            this.ipAddress = this.request.getRemoteAddr();
        }
        if (this.userAgent == null) {
            this.userAgent = this.request.getHeader("User-Agent");
        }
        EventLogData event = new EventLogData(this.ipAddress, this.userAgent, null, null, "create");
        return this.insertDataObject(object, pid, session, checksum, event);
    }

    protected String insertDataObject(InputStream object, Identifier pid, Session session, Checksum checksum, EventLogData event) throws ServiceFailure, InvalidSystemMetadata, NotAuthorized {
        String dataFilePath = null;
        try {
            dataFilePath = PropertyService.getProperty("application.datafilepath");
        }
        catch (PropertyNotFoundException e) {
            ServiceFailure sf = new ServiceFailure("1190", "Lookup data file path" + e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
        return D1NodeService.insertObject(object, "BIN", pid, dataFilePath, session, checksum, event);
    }

    public static String insertObject(InputStream object, String docType, Identifier pid, String fileDirectory, Session session, Checksum checksum, EventLogData event) throws ServiceFailure, InvalidSystemMetadata, NotAuthorized {
        String username = "public";
        String[] groupnames = null;
        if (session != null) {
            username = session.getSubject().getValue();
            Set otherSubjects = AuthUtils.authorizedClientSubjects((Session)session);
            if (otherSubjects != null) {
                groupnames = new String[otherSubjects.size()];
                int i = 0;
                Iterator iter = otherSubjects.iterator();
                while (iter.hasNext()) {
                    groupnames[i] = ((Subject)iter.next()).getValue();
                    ++i;
                }
            }
        }
        boolean inWhitelist = false;
        try {
            inWhitelist = AuthUtil.canInsertOrUpdate(username, groupnames);
        }
        catch (Exception e) {
            ServiceFailure sf = new ServiceFailure("1190", "Could not determinte if the user is allowed to upload data objects to this Metacat:" + e.getMessage());
            logMetacat.error((Object)("D1NodeService.insertDataObject Could not determinte if the user is allowed to upload data objects to this Metacat: - " + e.getMessage()), (Throwable)e);
            throw sf;
        }
        if (!inWhitelist) {
            logMetacat.error((Object)("D1NodeService.insertDataObject - The provided identity " + username + " does not have permission to WRITE to the Node."));
            throw new NotAuthorized("1100", "The provided identity " + username + " does not have permission to WRITE to the Node.");
        }
        String localId = null;
        try {
            logMetacat.debug((Object)"Generating a pid/localId mapping");
            IdentifierManager im = IdentifierManager.getInstance();
            localId = im.generateLocalId(pid.getValue(), 1);
            logMetacat.debug((Object)"Case DATA: starting to write to disk.");
            File dataDirectory = new File(fileDirectory);
            dataDirectory.mkdirs();
            File newFile = D1NodeService.writeStreamToFile(dataDirectory, localId, object, checksum, pid);
            try {
                logMetacat.debug((Object)"Registering document...");
                DocumentImpl.registerDocument(localId, docType, localId, username, groupnames);
                logMetacat.debug((Object)"Registration step completed.");
            }
            catch (SQLException e) {
                logMetacat.debug((Object)("SQLE: " + e.getMessage()));
                e.printStackTrace(System.out);
                throw new ServiceFailure("1190", "Registration failed: " + e.getMessage());
            }
            catch (AccessionNumberException e) {
                logMetacat.debug((Object)("ANE: " + e.getMessage()));
                e.printStackTrace(System.out);
                throw new ServiceFailure("1190", "Registration failed: " + e.getMessage());
            }
            catch (Exception e) {
                logMetacat.debug((Object)("Exception: " + e.getMessage()));
                e.printStackTrace(System.out);
                throw new ServiceFailure("1190", "Registration failed: " + e.getMessage());
            }
            try {
                logMetacat.debug((Object)"Logging the creation event.");
                EventLog.getInstance().log(event.getIpAddress(), event.getUserAgent(), username, localId, event.getEvent());
            }
            catch (Exception e) {
                logMetacat.warn((Object)("D1NodeService.insertDataObject - can't log the create event for the object " + pid.getValue()));
            }
            logMetacat.debug((Object)"Scheduling replication.");
            boolean isMeta = true;
            if (docType != null && docType.equals("BIN")) {
                isMeta = false;
            }
            String replicationNotificationServer = "localhost";
            ForceReplicationHandler forceReplicationHandler = new ForceReplicationHandler(localId, "insert", isMeta, replicationNotificationServer);
        }
        catch (ServiceFailure sfe) {
            D1NodeService.removeIdFromIdentifierTable(pid);
            throw sfe;
        }
        catch (InvalidSystemMetadata ise) {
            D1NodeService.removeIdFromIdentifierTable(pid);
            throw ise;
        }
        return localId;
    }

    public void insertSystemMetadata(org.dataone.service.types.v2.SystemMetadata sysmeta) throws ServiceFailure {
        logMetacat.debug((Object)"Starting to insert SystemMetadata...");
        sysmeta.setDateSysMetadataModified(Calendar.getInstance().getTime());
        logMetacat.debug((Object)("Inserting new system metadata with modified date " + sysmeta.getDateSysMetadataModified()));
        try {
            HazelcastService.getInstance().getSystemMetadataMap().put((Object)sysmeta.getIdentifier(), (Object)sysmeta);
            MetacatSolrIndex.getInstance().submit(sysmeta.getIdentifier(), sysmeta, null, false);
        }
        catch (Exception e) {
            throw new ServiceFailure("1190", e.getMessage());
        }
    }

    public ObjectList listObjects(Session session, Date startTime, Date endTime, ObjectFormatIdentifier objectFormatId, Identifier identifier, NodeReference nodeId, Integer start, Integer count) throws NotAuthorized, InvalidRequest, NotImplemented, ServiceFailure, InvalidToken {
        ObjectList objectList = null;
        try {
            if (count == null || count > MAXIMUM_DB_RECORD_COUNT) {
                count = MAXIMUM_DB_RECORD_COUNT;
            }
            boolean isSid = false;
            if (identifier != null) {
                isSid = IdentifierManager.getInstance().systemMetadataSIDExists(identifier);
            }
            objectList = IdentifierManager.getInstance().querySystemMetadata(startTime, endTime, objectFormatId, nodeId, start, count, identifier, isSid);
        }
        catch (Exception e) {
            throw new ServiceFailure("1580", "Error querying system metadata: " + e.getMessage());
        }
        return objectList;
    }

    protected void updateSystemMetadata(org.dataone.service.types.v2.SystemMetadata sysMeta) throws ServiceFailure {
        logMetacat.debug((Object)"D1NodeService.updateSystemMetadata() called.");
        try {
            HazelcastService.getInstance().getSystemMetadataMap().lock((Object)sysMeta.getIdentifier());
            boolean needUpdateModificationDate = true;
            this.updateSystemMetadataWithoutLock(sysMeta, needUpdateModificationDate);
        }
        catch (Exception e) {
            throw new ServiceFailure("4862", e.getMessage());
        }
        finally {
            HazelcastService.getInstance().getSystemMetadataMap().unlock((Object)sysMeta.getIdentifier());
        }
    }

    private void updateSystemMetadataWithoutLock(org.dataone.service.types.v2.SystemMetadata sysMeta, boolean needUpdateModificationDate) throws ServiceFailure {
        logMetacat.debug((Object)"D1NodeService.updateSystemMetadataWithoutLock() called.");
        if (needUpdateModificationDate) {
            logMetacat.debug((Object)"D1NodeService.updateSystemMetadataWithoutLock() - update the modification date.");
            sysMeta.setDateSysMetadataModified(new Date());
        }
        try {
            HazelcastService.getInstance().getSystemMetadataMap().put((Object)sysMeta.getIdentifier(), (Object)sysMeta);
            boolean isSysmetaChangeOnly = true;
            MetacatSolrIndex.getInstance().submit(sysMeta.getIdentifier(), sysMeta, isSysmetaChangeOnly, null, false);
        }
        catch (Exception e) {
            throw new ServiceFailure("4862", e.getMessage());
        }
    }

    protected boolean updateSystemMetadata(Session session, Identifier pid, org.dataone.service.types.v2.SystemMetadata sysmeta, boolean needUpdateModificationDate, org.dataone.service.types.v2.SystemMetadata currentSysmeta, boolean fromCN) throws NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, InvalidSystemMetadata, InvalidToken {
        Object lock = null;
        if (sysmeta.getIdentifier() == null) {
            throw new InvalidRequest("4863", "The identifier in the system metadata shouldn't be null");
        }
        if (!pid.getValue().equals(sysmeta.getIdentifier().getValue())) {
            throw new InvalidRequest("4863", "The identifier in method call (" + pid.getValue() + ") does not match identifier in system metadata (" + sysmeta.getIdentifier().getValue() + ").");
        }
        logMetacat.debug((Object)("The current dateUploaded is ============" + currentSysmeta.getDateUploaded()));
        logMetacat.debug((Object)("the dateUploaded in the new system metadata is " + sysmeta.getDateUploaded()));
        if (currentSysmeta == null) {
            logMetacat.warn((Object)("D1NodeService.updateSystemMetadata: Currently there is no system metadata in this node associated with the pid " + pid.getValue()));
        } else {
            String obsoletedBy;
            String obsoletes;
            Identifier newSid;
            Identifier currentSid = currentSysmeta.getSeriesId();
            if (currentSid != null) {
                logMetacat.debug((Object)("In the branch that the sid is not null in the current system metadata and the current sid is " + currentSid.getValue()));
                newSid = sysmeta.getSeriesId();
                if (!D1NodeService.isValidIdentifier(newSid)) {
                    throw new InvalidRequest("4869", "The series id in the system metadata is invalid in the request.");
                }
                if (!newSid.getValue().equals(currentSid.getValue())) {
                    throw new InvalidRequest("4869", "The series id " + newSid.getValue() + " in the system metadata doesn't match the current sid " + currentSid.getValue());
                }
            } else {
                newSid = sysmeta.getSeriesId();
                if (newSid != null) {
                    this.checkSidInModifyingSystemMetadata(sysmeta, "4956", "4868");
                }
            }
            if (sysmeta.getFormatId() == null) {
                throw new InvalidRequest("4869", "The formatId field is requried and shouldn't be null on the new system metadata of the object " + sysmeta.getIdentifier().getValue());
            }
            if (sysmeta.getRightsHolder() == null) {
                throw new InvalidRequest("4869", "The rightsHolder field is requried and shouldn't be null on the new system metadata of the object " + sysmeta.getIdentifier().getValue());
            }
            this.checkModifiedImmutableFields(currentSysmeta, sysmeta);
            this.checkOneTimeSettableSysmMetaFields(currentSysmeta, sysmeta);
            if (currentSysmeta.getObsoletes() == null && sysmeta.getObsoletes() != null && (obsoletes = this.existsInObsoletes(sysmeta.getObsoletes())) != null) {
                throw new InvalidSystemMetadata("4956", "There is an object with id " + obsoletes + " already obsoletes the pid " + sysmeta.getObsoletes().getValue() + ". You can't set the object " + pid.getValue() + " to obsolete the pid " + sysmeta.getObsoletes().getValue() + " again.");
            }
            this.checkCircularObsoletesChain(sysmeta);
            if (currentSysmeta.getObsoletedBy() == null && sysmeta.getObsoletedBy() != null && (obsoletedBy = this.existsInObsoletedBy(sysmeta.getObsoletedBy())) != null) {
                throw new InvalidSystemMetadata("4956", "There is an object with id " + obsoletedBy + " already is obsoleted by the pid " + sysmeta.getObsoletedBy().getValue() + ". You can't set the pid " + pid.getValue() + " to be obsoleted by the pid " + sysmeta.getObsoletedBy().getValue() + " again.");
            }
            this.checkCircularObsoletedByChain(sysmeta);
        }
        if (sysmeta.getArchived() != null && sysmeta.getArchived().booleanValue() && (currentSysmeta.getArchived() != null && !currentSysmeta.getArchived().booleanValue() || currentSysmeta.getArchived() == null)) {
            boolean logArchive = false;
            if (fromCN) {
                logMetacat.debug((Object)("D1Node.update - this is to archive a cn object " + pid.getValue()));
                try {
                    this.archiveCNObject(logArchive, session, pid, sysmeta, needUpdateModificationDate);
                }
                catch (NotFound e) {
                    throw new InvalidRequest("4869", "Can't find the pid " + pid.getValue() + " for archive.");
                }
            } else {
                logMetacat.debug((Object)("D1Node.update - this is to archive a MN object " + pid.getValue()));
                try {
                    String quotaSubject = this.request.getHeader("X-DataONE-Quota-Subject");
                    QuotaServiceManager.getInstance().enforce(quotaSubject, session.getSubject(), sysmeta, "archive");
                    this.archiveObject(logArchive, session, pid, sysmeta, needUpdateModificationDate);
                }
                catch (NotFound e) {
                    throw new InvalidRequest("4869", "Can't find the pid " + pid.getValue() + " for archive.");
                }
                catch (InsufficientResources e) {
                    throw new InvalidRequest("4869", "The user doesn't have enough quota to archive the pid " + pid.getValue() + " since " + e.getMessage());
                }
            }
        } else {
            logMetacat.debug((Object)("D1Node.update - regularly update the system metadata of the pid " + pid.getValue()));
            this.updateSystemMetadataWithoutLock(sysmeta, needUpdateModificationDate);
        }
        try {
            String localId = IdentifierManager.getInstance().getLocalId(pid.getValue());
            EventLog.getInstance().log(this.request.getRemoteAddr(), this.request.getHeader("User-Agent"), session.getSubject().getValue(), localId, "updateSystemMetadata");
        }
        catch (McdbDocNotFoundException e) {
            logMetacat.warn((Object)("Could not log 'updateSystemMetadata' event because no localId was found for pid: " + pid.getValue()));
        }
        catch (SQLException e) {
            logMetacat.warn((Object)("Could not log 'updateSystemMetadata' event because the localId couldn't be identified for the pid: " + pid.getValue()));
        }
        return true;
    }

    private void checkModifiedImmutableFields(org.dataone.service.types.v2.SystemMetadata orgMeta, org.dataone.service.types.v2.SystemMetadata newMeta) throws InvalidRequest {
        logMetacat.debug((Object)"in the start of the checkModifiedImmutableFields method");
        if (orgMeta != null && newMeta != null) {
            logMetacat.debug((Object)"in the checkModifiedImmutableFields method when the org and new system metadata is not null");
            if (newMeta.getIdentifier() == null) {
                throw new InvalidRequest("4869", "The new version of the system metadata is invalid since the identifier is null");
            }
            if (!orgMeta.getIdentifier().equals((Object)newMeta.getIdentifier())) {
                throw new InvalidRequest("4869", "The request is trying to modify an immutable field in the SystemMeta: the new system meta's identifier " + newMeta.getIdentifier().getValue() + " is different to the orginal one " + orgMeta.getIdentifier().getValue());
            }
            if (newMeta.getSize() == null) {
                throw new InvalidRequest("4869", "The new version of the system metadata is invalid since the size is null");
            }
            if (!orgMeta.getSize().equals(newMeta.getSize())) {
                throw new InvalidRequest("4869", "The request is trying to modify an immutable field in the SystemMeta: the new system meta's size " + newMeta.getSize().longValue() + " is different to the orginal one " + orgMeta.getSize().longValue());
            }
            if (newMeta.getChecksum() != null && orgMeta.getChecksum() != null) {
                if (!orgMeta.getChecksum().getValue().equals(newMeta.getChecksum().getValue())) {
                    logMetacat.error((Object)("The request is trying to modify an immutable field in the SystemMeta: the new system meta's checksum " + newMeta.getChecksum().getValue() + " is different to the orginal one " + orgMeta.getChecksum().getValue()));
                    throw new InvalidRequest("4869", "The request is trying to modify an immutable field in the SystemMeta: the new system meta's checksum " + newMeta.getChecksum().getValue() + " is different to the orginal one " + orgMeta.getChecksum().getValue());
                }
                if (!orgMeta.getChecksum().getAlgorithm().equals(newMeta.getChecksum().getAlgorithm())) {
                    logMetacat.error((Object)("The request is trying to modify an immutable field in the SystemMeta: the new system meta's checksum algorithm " + newMeta.getChecksum().getAlgorithm() + " is different to the orginal one " + orgMeta.getChecksum().getAlgorithm()));
                    throw new InvalidRequest("4869", "The request is trying to modify an immutable field in the SystemMeta: the new system meta's checksum algorithm " + newMeta.getChecksum().getAlgorithm() + " is different to the orginal one " + orgMeta.getChecksum().getAlgorithm());
                }
            } else if (orgMeta.getChecksum() != null && newMeta.getChecksum() == null) {
                throw new InvalidRequest("4869", "The request is trying to modify an immutable field in the SystemMeta: the new system meta's checksum is null and it is different to the orginal one " + orgMeta.getChecksum().getValue());
            }
            if (orgMeta.getSubmitter() != null) {
                logMetacat.debug((Object)("in the checkModifiedImmutableFields method and orgMeta.getSubmitter is not null and the orginal submiter is " + orgMeta.getSubmitter().getValue()));
            }
            if (newMeta.getSubmitter() != null) {
                logMetacat.debug((Object)("in the checkModifiedImmutableFields method and newMeta.getSubmitter is not null and the submiter in the new system metadata is " + newMeta.getSubmitter().getValue()));
            }
            if (orgMeta.getSubmitter() != null && newMeta.getSubmitter() != null && !orgMeta.getSubmitter().equals((Object)newMeta.getSubmitter())) {
                throw new InvalidRequest("4869", "The request is trying to modify an immutable field in the SystemMeta: the new system meta's submitter " + newMeta.getSubmitter().getValue() + " is different to the orginal one " + orgMeta.getSubmitter().getValue());
            }
            if (orgMeta.getSubmitter() != null && newMeta.getSubmitter() == null) {
                throw new InvalidRequest("4869", "The request is trying to modify an immutable field in the SystemMeta: the new system meta's submitter is null and it is different to the orginal one " + orgMeta.getSubmitter().getValue());
            }
            if (orgMeta.getDateUploaded() != null && newMeta.getDateUploaded() != null && orgMeta.getDateUploaded().getTime() != newMeta.getDateUploaded().getTime()) {
                throw new InvalidRequest("4869", "The request is trying to modify an immutable field in the SystemMeta: the new system meta's date of uploaded " + newMeta.getDateUploaded() + " is different to the orginal one " + orgMeta.getDateUploaded());
            }
            if (orgMeta.getDateUploaded() != null && newMeta.getDateUploaded() == null) {
                throw new InvalidRequest("4869", "The request is trying to modify an immutable field in the SystemMeta: the new system meta's date of uploaded is null and it is different to the orginal one " + orgMeta.getDateUploaded());
            }
            if (orgMeta.getOriginMemberNode() != null && newMeta.getOriginMemberNode() != null && !orgMeta.getOriginMemberNode().equals((Object)newMeta.getOriginMemberNode())) {
                throw new InvalidRequest("4869", "The request is trying to modify an immutable field in the SystemMeta: the new system meta's orginal member node  " + newMeta.getOriginMemberNode().getValue() + " is different to the orginal one " + orgMeta.getOriginMemberNode().getValue());
            }
            if (orgMeta.getOriginMemberNode() != null && newMeta.getOriginMemberNode() == null) {
                throw new InvalidRequest("4869", "The request is trying to modify an immutable field in the SystemMeta: the new system meta's orginal member node is null and it  is different to the orginal one " + orgMeta.getOriginMemberNode().getValue());
            }
            if (orgMeta.getSeriesId() != null && newMeta.getSeriesId() != null && !orgMeta.getSeriesId().equals((Object)newMeta.getSeriesId())) {
                throw new InvalidRequest("4869", "The request is trying to modify an immutable field in the SystemMeta: the new system meta's series id  " + newMeta.getSeriesId().getValue() + " is different to the orginal one " + orgMeta.getSeriesId().getValue());
            }
            if (orgMeta.getSeriesId() != null && newMeta.getSeriesId() == null) {
                throw new InvalidRequest("4869", "The request is trying to modify an immutable field in the SystemMeta: the new system meta's series id is null and it is different to the orginal one " + orgMeta.getSeriesId().getValue());
            }
        }
    }

    private void checkOneTimeSettableSysmMetaFields(org.dataone.service.types.v2.SystemMetadata orgMeta, org.dataone.service.types.v2.SystemMetadata newMeta) throws InvalidRequest {
        if (!(orgMeta.getObsoletedBy() == null || newMeta.getObsoletedBy() != null && orgMeta.getObsoletedBy().equals((Object)newMeta.getObsoletedBy()))) {
            throw new InvalidRequest("4869", "The request is trying to reset the obsoletedBy field in the System Metadata of the Object " + orgMeta.getIdentifier().getValue() + ". This is illegal since the obsoletedBy field is already set and cannot be changed once set.");
        }
        if (!(orgMeta.getObsoletes() == null || newMeta.getObsoletes() != null && orgMeta.getObsoletes().equals((Object)newMeta.getObsoletes()))) {
            throw new InvalidRequest("4869", "The request is trying to reset the obsoletes field in the System Metadata of the Object " + orgMeta.getIdentifier().getValue() + ". This is illegal since the obsoletes field is already set and cannot be changed once set.");
        }
    }

    private void checkCircularObsoletesChain(org.dataone.service.types.v2.SystemMetadata sys) throws InvalidRequest {
        if (sys != null && sys.getObsoletes() != null && sys.getObsoletes().getValue() != null && !sys.getObsoletes().getValue().trim().equals("")) {
            logMetacat.debug((Object)("D1NodeService.checkCircularObsoletesChain - the object " + sys.getIdentifier().getValue() + " obsoletes " + sys.getObsoletes().getValue()));
            if (sys.getObsoletes().getValue().equals(sys.getIdentifier().getValue())) {
                throw new InvalidRequest("4869", "The obsoletes field and identifier of the system metadata has the same value " + sys.getObsoletes().getValue() + ". This creates a circular chain and it is illegal.");
            }
            Vector<Identifier> pidList = new Vector<Identifier>();
            pidList.add(sys.getIdentifier());
            org.dataone.service.types.v2.SystemMetadata obsoletesSym = (org.dataone.service.types.v2.SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)sys.getObsoletes());
            while (obsoletesSym != null && obsoletesSym.getObsoletes() != null && obsoletesSym.getObsoletes().getValue() != null && !obsoletesSym.getObsoletes().getValue().trim().equals("")) {
                pidList.add(obsoletesSym.getIdentifier());
                logMetacat.debug((Object)("D1NodeService.checkCircularObsoletesChain - the object " + obsoletesSym.getIdentifier().getValue() + " obsoletes " + obsoletesSym.getObsoletes().getValue()));
                if (pidList.contains(obsoletesSym.getObsoletes())) {
                    logMetacat.error((Object)("D1NodeService.checkCircularObsoletesChain - when Metacat updated the system metadata of object " + sys.getIdentifier().getValue() + ", it found the obsoletes field value " + sys.getObsoletes().getValue() + " in its new system metadata creating a circular chain at the object " + obsoletesSym.getObsoletes().getValue() + ". This is illegal"));
                    throw new InvalidRequest("4869", "When Metacat updated the system metadata of object " + sys.getIdentifier().getValue() + ", it found the obsoletes field value " + sys.getObsoletes().getValue() + " in its new system metadata creating a circular chain at the object " + obsoletesSym.getObsoletes().getValue() + ". This is illegal");
                }
                obsoletesSym = (org.dataone.service.types.v2.SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)obsoletesSym.getObsoletes());
            }
        }
    }

    private void checkCircularObsoletedByChain(org.dataone.service.types.v2.SystemMetadata sys) throws InvalidRequest {
        if (sys != null && sys.getObsoletedBy() != null && sys.getObsoletedBy().getValue() != null && !sys.getObsoletedBy().getValue().trim().equals("")) {
            logMetacat.debug((Object)("D1NodeService.checkCircularObsoletedByChain - the object " + sys.getIdentifier().getValue() + " is obsoletedBy " + sys.getObsoletedBy().getValue()));
            if (sys.getObsoletedBy().getValue().equals(sys.getIdentifier().getValue())) {
                throw new InvalidRequest("4869", "The obsoletedBy field and identifier of the system metadata has the same value " + sys.getObsoletedBy().getValue() + ". This creates a circular chain and it is illegal.");
            }
            Vector<Identifier> pidList = new Vector<Identifier>();
            pidList.add(sys.getIdentifier());
            org.dataone.service.types.v2.SystemMetadata obsoletedBySym = (org.dataone.service.types.v2.SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)sys.getObsoletedBy());
            while (obsoletedBySym != null && obsoletedBySym.getObsoletedBy() != null && obsoletedBySym.getObsoletedBy().getValue() != null && !obsoletedBySym.getObsoletedBy().getValue().trim().equals("")) {
                pidList.add(obsoletedBySym.getIdentifier());
                logMetacat.debug((Object)("D1NodeService.checkCircularObsoletedByChain - the object " + obsoletedBySym.getIdentifier().getValue() + " is obsoletedBy " + obsoletedBySym.getObsoletedBy().getValue()));
                if (pidList.contains(obsoletedBySym.getObsoletedBy())) {
                    logMetacat.error((Object)("D1NodeService.checkCircularObsoletedByChain - When Metacat updated the system metadata of object " + sys.getIdentifier().getValue() + ", it found the obsoletedBy field value " + sys.getObsoletedBy().getValue() + " in its new system metadata creating a circular chain at the object " + obsoletedBySym.getObsoletedBy().getValue() + ". This is illegal"));
                    throw new InvalidRequest("4869", "When Metacat updated the system metadata of object " + sys.getIdentifier().getValue() + ", it found the obsoletedBy field value " + sys.getObsoletedBy().getValue() + " in its new system metadata creating a circular chain at the object " + obsoletedBySym.getObsoletedBy().getValue() + ". This is illegal");
                }
                obsoletedBySym = (org.dataone.service.types.v2.SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)obsoletedBySym.getObsoletedBy());
            }
        }
    }

    protected static List<Permission> expandPermissions(Permission permission) {
        ArrayList<Permission> expandedPermissions = new ArrayList<Permission>();
        if (permission.equals((Object)Permission.READ)) {
            expandedPermissions.add(Permission.READ);
        }
        if (permission.equals((Object)Permission.WRITE)) {
            expandedPermissions.add(Permission.READ);
            expandedPermissions.add(Permission.WRITE);
        }
        if (permission.equals((Object)Permission.CHANGE_PERMISSION)) {
            expandedPermissions.add(Permission.READ);
            expandedPermissions.add(Permission.WRITE);
            expandedPermissions.add(Permission.CHANGE_PERMISSION);
        }
        return expandedPermissions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File writeStreamToFile(File dir, String localId, InputStream dataStream, Checksum checksum, Identifier pid) throws ServiceFailure, InvalidSystemMetadata {
        File newFile = null;
        boolean locked = false;
        try {
            locked = DocumentImpl.getDataFileLockGrant(localId);
        }
        catch (Exception e) {
            ServiceFailure sf = new ServiceFailure("1190", "Could not lock file for writing:" + e.getMessage());
            sf.initCause((Throwable)e);
            throw sf;
        }
        logMetacat.debug((Object)"Case DATA: starting to write to disk.");
        if (locked) {
            newFile = new File(dir, localId);
            File tempFile = null;
            logMetacat.debug((Object)("Filename for write is: " + newFile.getAbsolutePath() + " for the data object pid " + pid.getValue()));
            try {
                String checksumValue = checksum.getValue();
                logMetacat.info((Object)("D1NodeService.writeStreamToFile - the checksum value from the system metadata is " + checksumValue + " for the data object " + pid.getValue()));
                if (checksumValue == null || checksumValue.trim().equals("")) {
                    logMetacat.error((Object)("D1NodeService.writeStreamToFile - the checksum value from the system metadata shouldn't be null or blank for the data object " + pid.getValue()));
                    throw new InvalidSystemMetadata("1180", "The checksum value from the system metadata shouldn't be null or blank.");
                }
                String algorithm = checksum.getAlgorithm();
                logMetacat.info((Object)("D1NodeService.writeStreamToFile - the algorithm to calculate the checksum from the system metadata is " + algorithm + " for the data object " + pid.getValue()));
                if (algorithm == null || algorithm.trim().equals("")) {
                    logMetacat.error((Object)("D1NodeService.writeStreamToFile - the algorithm to calculate the checksum from the system metadata shouldn't be null or blank for the data object " + pid.getValue()));
                    throw new InvalidSystemMetadata("1180", "The algorithm to calculate the checksum from the system metadata shouldn't be null or blank.");
                }
                long start = System.currentTimeMillis();
                if (dataStream instanceof DetailedFileInputStream) {
                    DetailedFileInputStream stream = (DetailedFileInputStream)dataStream;
                    tempFile = stream.getFile();
                    Checksum expectedChecksum = stream.getExpectedChecksum();
                    if (expectedChecksum != null) {
                        String expectedAlgorithm = expectedChecksum.getAlgorithm();
                        String expectedChecksumValue = expectedChecksum.getValue();
                        if (expectedAlgorithm != null && expectedAlgorithm.equalsIgnoreCase(algorithm)) {
                            if (expectedChecksumValue != null && expectedChecksumValue.equalsIgnoreCase(checksumValue)) {
                                FileUtils.moveFile((File)tempFile, (File)newFile);
                                long end = System.currentTimeMillis();
                                logMetacat.info((Object)("D1NodeService.writeStreamToFile - Metacat only needs the move the data file from temporary location to the permanent location for the object " + pid.getValue()));
                                logMetacat.info((Object)("MetacatPerformanceLog " + pid.getValue() + " create/update method " + " Only move the data file from the temporary location to the permanent location since the multiparts handler has calculated the checksum" + " duration " + (end - start) / 1000L));
                                File file = newFile;
                                return file;
                            }
                            logMetacat.error((Object)("D1NodeService.writeStreamToFile - the check sum calculated from the saved local file is " + expectedChecksumValue + ". But it doesn't match the value from the system metadata " + checksumValue + " for the object " + pid.getValue()));
                            throw new InvalidSystemMetadata("1180", "D1NodeService.writeStreamToFile - the check sum calculated from the saved local file is " + expectedChecksumValue + ". But it doesn't match the value from the system metadata " + checksumValue + " for the object " + pid.getValue());
                        }
                        logMetacat.info((Object)("D1NodeService.writeStreamToFile - the checksum algorithm which the multipart handler used is " + expectedAlgorithm + " and it is different to one on the system metadata " + algorithm + ". So we have to calculate again."));
                    }
                }
                MessageDigest md = MessageDigest.getInstance(algorithm);
                DigestOutputStream os = new DigestOutputStream(new FileOutputStream(newFile), md);
                long length = IOUtils.copyLarge((InputStream)dataStream, (OutputStream)os);
                os.flush();
                os.close();
                String localChecksum = DatatypeConverter.printHexBinary((byte[])md.digest());
                logMetacat.info((Object)("D1NodeService.writeStreamToFile - the check sum calculated from the saved local file is " + localChecksum));
                if (localChecksum == null || localChecksum.trim().equals("") || !localChecksum.equalsIgnoreCase(checksumValue)) {
                    logMetacat.error((Object)("D1NodeService.writeStreamToFile - the check sum calculated from the saved local file is " + localChecksum + ". But it doesn't match the value from the system metadata " + checksumValue + " for the object " + pid.getValue()));
                    boolean success = newFile.delete();
                    logMetacat.info((Object)("delete the file " + newFile.getAbsolutePath() + " for the object " + pid.getValue() + " sucessfully?" + success));
                    throw new InvalidSystemMetadata("1180", "The checksum calculated from the saved local file is " + localChecksum + ". But it doesn't match the value from the system metadata " + checksumValue + ".");
                }
                long end = System.currentTimeMillis();
                logMetacat.info((Object)("MetacatPerformanceLog " + pid.getValue() + " create/update method " + " Need to read the data file from the temporary location and write it to the permanent location since the multiparts handler has NOT calculated the checksum" + " duration " + (end - start) / 1000L));
                if (tempFile == null) return newFile;
                StreamingMultipartRequestResolver.deleteTempFile(tempFile);
                return newFile;
            }
            catch (FileNotFoundException e) {
                logMetacat.error((Object)("FNF: " + e.getMessage() + " for the data object " + pid.getValue()), (Throwable)e);
                throw new ServiceFailure("1190", "File not found: " + localId + " " + e.getMessage());
            }
            catch (IOException e) {
                logMetacat.error((Object)("IOE: " + e.getMessage() + " for the data object " + pid.getValue()), (Throwable)e);
                throw new ServiceFailure("1190", "File was not written: " + localId + " " + e.getMessage());
            }
            catch (NoSuchAlgorithmException e) {
                logMetacat.error((Object)("D1NodeService.writeStreamToFile - no such checksum algorithm exception " + e.getMessage() + " for the data object " + pid.getValue()), (Throwable)e);
                throw new ServiceFailure("1190", "No such checksum algorithm:  " + e.getMessage());
            }
            finally {
                IOUtils.closeQuietly((InputStream)dataStream);
            }
        } else {
            logMetacat.error((Object)("D1NodeService.writeStreamToFile - Metacat cannot lock the file " + localId));
            throw new ServiceFailure("1190", "D1NodeService.writeStreamToFile - Metacat cannot lock the file " + localId);
        }
    }

    protected List<Node> listNodesBySubject(Subject subject, NodeList nodelist) throws ServiceFailure, NotImplemented {
        ArrayList<Node> nodeList = new ArrayList<Node>();
        List nodes = nodelist.getNodeList();
        for (Node node : nodes) {
            List nodeSubjects = node.getSubjectList();
            if (nodeSubjects == null) continue;
            for (Subject nodeSubject : nodeSubjects) {
                if (!nodeSubject.equals((Object)subject)) continue;
                nodeList.add(node);
            }
        }
        return nodeList;
    }

    protected Identifier archiveObject(boolean log, Session session, Identifier pid, org.dataone.service.types.v2.SystemMetadata sysMeta, boolean needModifyDate) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        String localId = null;
        boolean allowed = false;
        String username = "public";
        if (session == null) {
            throw new InvalidToken("1330", "No session has been provided");
        }
        username = session.getSubject().getValue();
        if (pid == null || pid.getValue().trim().equals("")) {
            throw new ServiceFailure("1350", "The provided identifier was invalid.");
        }
        if (sysMeta == null) {
            throw new NotFound("2911", "There is no system metadata associated with " + pid.getValue());
        }
        try {
            localId = IdentifierManager.getInstance().getLocalId(pid.getValue());
        }
        catch (McdbDocNotFoundException e) {
            throw new NotFound("1340", "The object with the provided identifier was not found.");
        }
        catch (SQLException e) {
            throw new ServiceFailure("1350", "The object with the provided identifier " + pid.getValue() + " couldn't be identified since " + e.getMessage());
        }
        try {
            boolean ignoreRev = false;
            DocumentImpl.delete(localId, ignoreRev, null, null, null, false);
            if (log) {
                try {
                    EventLog.getInstance().log(this.request.getRemoteAddr(), this.request.getHeader("User-Agent"), username, localId, Event.DELETE.xmlValue());
                }
                catch (Exception e) {
                    logMetacat.warn((Object)("D1NodeService.archiveObject - can't log the delete event since " + e.getMessage()));
                }
            }
            sysMeta.setArchived(Boolean.valueOf(true));
            if (needModifyDate) {
                sysMeta.setDateSysMetadataModified(Calendar.getInstance().getTime());
                sysMeta.setSerialVersion(sysMeta.getSerialVersion().add(BigInteger.ONE));
            }
            HazelcastService.getInstance().getSystemMetadataMap().put((Object)pid, (Object)sysMeta);
        }
        catch (McdbDocNotFoundException e) {
            try {
                AccessionNumber acc = new AccessionNumber(localId, "NOACTION");
                String docid = acc.getDocid();
                int rev = 1;
                if (acc.getRev() != null) {
                    rev = new Integer(acc.getRev());
                }
                if (IdentifierManager.getInstance().existsInXmlLRevisionTable(docid, rev)) {
                    sysMeta.setArchived(Boolean.valueOf(true));
                    if (needModifyDate) {
                        sysMeta.setDateSysMetadataModified(Calendar.getInstance().getTime());
                        sysMeta.setSerialVersion(sysMeta.getSerialVersion().add(BigInteger.ONE));
                    }
                } else {
                    throw new NotFound("1340", "The provided identifier " + pid.getValue() + " is invalid");
                }
                HazelcastService.getInstance().getSystemMetadataMap().put((Object)pid, (Object)sysMeta);
            }
            catch (SQLException ee) {
                ee.printStackTrace();
                throw new NotFound("1340", "The provided identifier " + pid.getValue() + " is invalid");
            }
            catch (AccessionNumberException ee) {
                ee.printStackTrace();
                throw new NotFound("1340", "The provided identifier " + pid.getValue() + " is invalid");
            }
        }
        catch (SQLException e) {
            throw new ServiceFailure("1350", "There was a problem archiving the object.The error message was: " + e.getMessage());
        }
        catch (InsufficientKarmaException e) {
            throw new NotAuthorized("1320", "The provided identity does not have permission to archive this object.");
        }
        catch (Exception e) {
            throw new ServiceFailure("1350", "There was a problem archiving the object.The error message was: " + e.getMessage());
        }
        return pid;
    }

    protected void archiveCNObject(boolean log, Session session, Identifier pid, org.dataone.service.types.v2.SystemMetadata sysMeta, boolean needModifyDate) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        String localId = null;
        try {
            localId = IdentifierManager.getInstance().getLocalId(pid.getValue());
            this.archiveObject(log, session, pid, sysMeta, needModifyDate);
        }
        catch (McdbDocNotFoundException e) {
            try {
                if (sysMeta != null) {
                    sysMeta.setArchived(Boolean.valueOf(true));
                    if (needModifyDate) {
                        sysMeta.setSerialVersion(sysMeta.getSerialVersion().add(BigInteger.ONE));
                        sysMeta.setDateSysMetadataModified(Calendar.getInstance().getTime());
                    }
                } else {
                    throw new ServiceFailure("4972", "Couldn't archive the object " + pid.getValue() + ". Couldn't obtain the system metadata record.");
                }
                HazelcastService.getInstance().getSystemMetadataMap().put((Object)pid, (Object)sysMeta);
            }
            catch (RuntimeException re) {
                throw new ServiceFailure("4972", "Couldn't archive " + pid.getValue() + ". The error message was: " + re.getMessage());
            }
        }
        catch (SQLException e) {
            throw new ServiceFailure("4972", "Couldn't archive the object " + pid.getValue() + ". The local id of the object with the identifier can't be identified since " + e.getMessage());
        }
    }

    public void checkV1SystemMetaPidExist(Identifier identifier, String serviceFailureCode, String serviceFailureMessage, String noFoundCode, String notFoundMessage) throws ServiceFailure, NotFound {
        boolean exists = false;
        try {
            exists = IdentifierManager.getInstance().systemMetadataPIDExists(identifier);
        }
        catch (SQLException e) {
            throw new ServiceFailure(serviceFailureCode, serviceFailureMessage + " since " + e.getMessage());
        }
        if (!exists) {
            try {
                boolean existsIndentifierTable = IdentifierManager.getInstance().existsInIdentifierTable(identifier);
                if (existsIndentifierTable) {
                    notFoundMessage = notFoundMessage + " " + DELETEDMESSAGE;
                }
            }
            catch (Exception e) {
                logMetacat.info((Object)("Couldn't determine if the not-found identifier " + identifier.getValue() + " was deleted since " + e.getMessage()));
            }
            throw new NotFound(noFoundCode, notFoundMessage);
        }
    }

    protected Identifier getPIDForSID(Identifier sid, String serviceFailureCode) throws ServiceFailure {
        Identifier id;
        block5: {
            id = null;
            String serviceFailureMessage = "The PID couldn't be identified for the sid " + sid.getValue();
            if (sid != null && sid.getValue() != null && !HazelcastService.getInstance().getSystemMetadataMap().containsKey((Object)sid)) {
                try {
                    if (!IdentifierManager.getInstance().systemMetadataSIDExists(sid)) break block5;
                    try {
                        id = IdentifierManager.getInstance().getHeadPID(sid);
                    }
                    catch (SQLException sqle) {
                        throw new ServiceFailure(serviceFailureCode, serviceFailureMessage + " since " + sqle.getMessage());
                    }
                }
                catch (SQLException e) {
                    throw new ServiceFailure(serviceFailureCode, serviceFailureMessage + " since " + e.getMessage());
                }
            }
        }
        return id;
    }

    protected org.dataone.service.types.v2.SystemMetadata getSystemMetadataForPID(Identifier pid, String serviceFailureCode, String invalidRequestCode, String notFoundCode, boolean needDeleteInfo) throws ServiceFailure, InvalidRequest, NotFound {
        org.dataone.service.types.v2.SystemMetadata sysmeta = null;
        if (pid == null || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{pid.getValue()})) {
            throw new InvalidRequest(invalidRequestCode, "The passed-in Identifier cannot be null or blank!!");
        }
        try {
            sysmeta = (org.dataone.service.types.v2.SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)pid);
        }
        catch (Exception e) {
            logMetacat.error((Object)("An error occurred while getting system metadata for identifier " + pid.getValue() + ". The error message was: " + e.getMessage()), (Throwable)e);
            throw new ServiceFailure(serviceFailureCode, "Can't get the system metadata for " + pid.getValue() + " since " + e.getMessage());
        }
        if (sysmeta == null) {
            String error = "No system metadata could be found for given PID: " + pid.getValue();
            if (needDeleteInfo) {
                boolean existsInIdentifierTable = false;
                try {
                    existsInIdentifierTable = IdentifierManager.getInstance().existsInIdentifierTable(pid);
                }
                catch (Exception e) {
                    logMetacat.warn((Object)("Couldn't determine if the pid " + pid.getValue() + " exists in the identifier table. We assume it doesn't"));
                }
                if (existsInIdentifierTable) {
                    error = error + ". " + DELETEDMESSAGE;
                }
            }
            throw new NotFound(notFoundCode, error);
        }
        return sysmeta;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean checkSidInModifyingSystemMetadata(org.dataone.service.types.v2.SystemMetadata sysmeta, String invalidSystemMetadataCode, String serviceFailureCode) throws InvalidSystemMetadata, ServiceFailure {
        boolean pass = false;
        if (sysmeta == null) {
            throw new InvalidSystemMetadata(invalidSystemMetadataCode, "The system metadata is null in the request.");
        }
        Identifier sid = sysmeta.getSeriesId();
        if (sid == null) return true;
        if (!D1NodeService.isValidIdentifier(sid)) {
            throw new InvalidSystemMetadata(invalidSystemMetadataCode, "The series id in the system metadata is invalid in the request.");
        }
        Identifier pid = sysmeta.getIdentifier();
        if (!D1NodeService.isValidIdentifier(pid)) {
            throw new InvalidSystemMetadata(invalidSystemMetadataCode, "The pid in the system metadata is invalid in the request.");
        }
        if (sid.getValue().equals(pid.getValue())) {
            throw new InvalidSystemMetadata(invalidSystemMetadataCode, "The series id " + sid.getValue() + " in the system metadata shouldn't have the same value of the pid.");
        }
        try {
            if (!IdentifierManager.getInstance().identifierExists(sid.getValue())) return true;
            if (sysmeta.getObsoletes() != null) {
                org.dataone.service.types.v2.SystemMetadata obsoletesSysmeta = (org.dataone.service.types.v2.SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)sysmeta.getObsoletes());
                if (obsoletesSysmeta != null) {
                    Identifier obsoletesSid = obsoletesSysmeta.getSeriesId();
                    if (obsoletesSid != null && obsoletesSid.getValue() != null && !obsoletesSid.getValue().trim().equals("") && sid.getValue().equals(obsoletesSid.getValue())) {
                        return true;
                    }
                } else {
                    logMetacat.warn((Object)("D1NodeService.checkSidInModifyingSystemMetacat - Can't find the system metadata for the pid " + sysmeta.getObsoletes().getValue() + " which is the value of the obsoletes. So we can't check if the sid " + sid.getValue() + " is legitimate "));
                }
            }
            if (!pass && sysmeta.getObsoletedBy() != null) {
                org.dataone.service.types.v2.SystemMetadata obsoletedBySysmeta = (org.dataone.service.types.v2.SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)sysmeta.getObsoletedBy());
                if (obsoletedBySysmeta != null) {
                    Identifier obsoletedBySid = obsoletedBySysmeta.getSeriesId();
                    if (obsoletedBySid != null && obsoletedBySid.getValue() != null && !obsoletedBySid.getValue().trim().equals("") && sid.getValue().equals(obsoletedBySid.getValue())) {
                        return true;
                    }
                } else {
                    logMetacat.warn((Object)("D1NodeService.checkSidInModifyingSystemMetacat - Can't find the system metadata for the pid " + sysmeta.getObsoletes().getValue() + " which is the value of the obsoletedBy. So we can't check if the sid " + sid.getValue() + " is legitimate."));
                }
            }
            if (pass) return pass;
            throw new InvalidSystemMetadata(invalidSystemMetadataCode, "The series id " + sid.getValue() + " in the system metadata exists in the system. And it doesn't match either previous object's sid or the next object's sid.");
        }
        catch (SQLException e) {
            throw new ServiceFailure(serviceFailureCode, "Can't determine if the sid in the system metadata is unique or not since " + e.getMessage());
        }
    }

    public OptionList listViews(Session arg0) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented {
        OptionList views = new OptionList();
        views.setKey("views");
        views.setDescription("List of views for objects on the node");
        Vector<String> skinNames = null;
        try {
            skinNames = SkinUtil.getSkinNames();
        }
        catch (PropertyNotFoundException e) {
            throw new ServiceFailure("2841", e.getMessage());
        }
        for (String skinName : skinNames) {
            views.addOption(skinName);
        }
        return views;
    }

    public OptionList listViews() throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented {
        return this.listViews(null);
    }

    public InputStream view(Session session, String format, Identifier id) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented, NotFound {
        InputStream resultInputStream;
        block10: {
            resultInputStream = null;
            String serviceFailureCode = "2831";
            String notFoundCode = "2835";
            String invalidRequestCode = "2833";
            boolean needDeleteInfo = false;
            Identifier HeadOfSid = this.getPIDForSID(id, serviceFailureCode);
            if (HeadOfSid != null) {
                id = HeadOfSid;
            }
            org.dataone.service.types.v2.SystemMetadata sysmeta = this.getSystemMetadataForPID(id, serviceFailureCode, invalidRequestCode, notFoundCode, needDeleteInfo);
            InputStream object = this.get(session, sysmeta.getIdentifier());
            try {
                ObjectFormat objectFormat = ObjectFormatCache.getInstance().getFormat(sysmeta.getFormatId());
                if (objectFormat.getFormatType().equals(METADATA)) {
                    DBTransform transformer = new DBTransform();
                    String documentContent = IOUtils.toString((InputStream)object, (String)"UTF-8");
                    String sourceType = objectFormat.getFormatId().getValue();
                    String targetType = "-//W3C//HTML//EN";
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, "UTF-8");
                    Hashtable<String, String[]> params = new Hashtable<String, String[]>();
                    String localId = null;
                    try {
                        localId = IdentifierManager.getInstance().getLocalId(id.getValue());
                    }
                    catch (McdbDocNotFoundException e) {
                        throw new NotFound("1020", e.getMessage());
                    }
                    params.put("qformat", new String[]{format});
                    params.put("docid", new String[]{localId});
                    params.put("pid", new String[]{id.getValue()});
                    D1NodeService.addParamsFromSkinProperties(params, format);
                    transformer.transformXMLDocument(documentContent, sourceType, targetType, format, writer, params, null);
                    resultInputStream = new ContentTypeByteArrayInputStream(baos.toByteArray());
                    ((ContentTypeByteArrayInputStream)resultInputStream).setContentType("text/html");
                    break block10;
                }
                resultInputStream = object;
            }
            catch (IOException e) {
                ServiceFailure sf = new ServiceFailure("1030", e.getMessage());
                sf.initCause((Throwable)e);
                throw sf;
            }
            catch (PropertyNotFoundException e) {
                ServiceFailure sf = new ServiceFailure("1030", e.getMessage());
                sf.initCause((Throwable)e);
                throw sf;
            }
            catch (SQLException e) {
                ServiceFailure sf = new ServiceFailure("1030", e.getMessage());
                sf.initCause((Throwable)e);
                throw sf;
            }
            catch (ClassNotFoundException e) {
                ServiceFailure sf = new ServiceFailure("1030", e.getMessage());
                sf.initCause((Throwable)e);
                throw sf;
            }
            catch (ServiceException e) {
                ServiceFailure sf = new ServiceFailure("1030", e.getMessage());
                sf.initCause((Throwable)e);
                throw sf;
            }
        }
        return resultInputStream;
    }

    static void addParamsFromSkinProperties(Hashtable<String, String[]> params, String format) throws ServiceException, PropertyNotFoundException {
        SkinPropertyService skinPropService = SkinPropertyService.getInstance();
        Vector<String> propertiesNames = SkinPropertyService.getPropertyNamesByGroup(format, "stylesheet.parameters");
        logMetacat.debug((Object)("D1NodeService.addParasFromSkinProperties - the names of properties  are " + propertiesNames));
        if (propertiesNames != null && !propertiesNames.isEmpty()) {
            String name = null;
            String value = null;
            for (String property : propertiesNames) {
                if (property.contains("name")) {
                    name = SkinPropertyService.getProperty(format, property);
                    continue;
                }
                if (!property.contains("value")) continue;
                try {
                    PropertyService.getInstance();
                    value = PropertyService.getProperty(SkinPropertyService.getProperty(format, property));
                }
                catch (Exception e) {
                    value = SkinPropertyService.getProperty(format, property);
                }
                logMetacat.debug((Object)("D1NodeService.addParasFromSkinProperties - add the pair name " + name + " and its value " + value + " the style sheet parameters list"));
                params.put(name, new String[]{value});
            }
        }
    }

    protected String existsInObsoletes(Identifier id) throws InvalidRequest, ServiceFailure {
        String guid = this.existsInFields("obsoletes", id);
        return guid;
    }

    protected String existsInObsoletedBy(Identifier id) throws InvalidRequest, ServiceFailure {
        String guid = this.existsInFields("obsoleted_by", id);
        return guid;
    }

    private String existsInFields(String column, Identifier id) throws InvalidRequest, ServiceFailure {
        String guid = null;
        if (id == null) {
            throw new InvalidRequest("4863", "The given identifier is null and we can't determine if the guid exists in the field " + column + " in the systemmetadata table");
        }
        String sql = "SELECT guid FROM systemmetadata WHERE " + column + " = ?";
        int serialNumber = -1;
        DBConnection dbConn = null;
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            dbConn = DBConnectionPool.getDBConnection("D1NodeService.existsInFields");
            serialNumber = dbConn.getCheckOutSerialNumber();
            stmt = dbConn.prepareStatement(sql);
            stmt.setString(1, id.getValue());
            result = stmt.executeQuery();
            if (result.next()) {
                guid = result.getString(1);
            }
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new ServiceFailure("4862", "We can't determine if the id " + id.getValue() + " exists in field " + column + " in the systemmetadata table since " + e.getMessage());
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logMetacat.warn((Object)("We can close the PreparedStatment in D1NodeService.existsInFields since " + e.getMessage()));
                }
            }
        }
        return guid;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public static boolean isAccessControlDirty(org.dataone.service.types.v2.SystemMetadata originalSysmeta, org.dataone.service.types.v2.SystemMetadata newSysmeta) {
        boolean dirty = true;
        if (originalSysmeta == null && newSysmeta == null) {
            dirty = false;
            logMetacat.debug((Object)("D1NodeService.isAccessControlDirty - is access control dirty?(both system metadata objects are null) - " + dirty));
        } else if (originalSysmeta != null && newSysmeta != null) {
            Subject originalRightsHolder = originalSysmeta.getRightsHolder();
            Subject newRigthsHolder = newSysmeta.getRightsHolder();
            if (originalRightsHolder == null && newRigthsHolder == null) {
                dirty = false;
                logMetacat.debug((Object)("D1NodeService.isAccessControlDirty - is the right holder dirty?(both right holder objects are null) - " + dirty));
            } else if (originalRightsHolder != null && newRigthsHolder != null) {
                dirty = originalRightsHolder.compareTo((Object)newRigthsHolder) != 0;
                logMetacat.debug((Object)("D1NodeService.isAccessControlDirty - is the right holder dirty?(both right holder objects are not null) - " + dirty + " since the original right holder is " + originalRightsHolder.getValue() + " and the new rights holder is  " + newRigthsHolder.getValue()));
            } else {
                dirty = true;
                logMetacat.debug((Object)("D1NodeService.isAccessControlDirty - is the rights holder dirty?(one rights holder object is null; another is not) - " + dirty));
            }
            if (!dirty) {
                boolean isAccessPolicyEqual = D1NodeService.equals(originalSysmeta.getAccessPolicy(), newSysmeta.getAccessPolicy());
                logMetacat.debug((Object)("D1NodeService.isAccessControlDirty - do the access policies equal?(we need to compare access policy since the rights hloders are same) - " + isAccessPolicyEqual));
                dirty = !isAccessPolicyEqual;
            }
            logMetacat.debug((Object)("D1NodeService.isAccessControlDirty - is access control dirty?(both system metadata objects are not null) - " + dirty));
        } else {
            dirty = true;
            logMetacat.debug((Object)("D1NodeService.isAccessControlDirty - is access control dirty?(one system metadata object is null; another is not) - " + dirty));
        }
        return dirty;
    }

    public static boolean equals(AccessPolicy ap1, AccessPolicy ap2) {
        boolean equal = false;
        if (ap1 == null && ap2 == null) {
            equal = true;
        } else if (ap1 == null && ap2 != null) {
            if (ap2.getAllowList() == null || ap2.getAllowList().isEmpty()) {
                equal = true;
            }
        } else if (ap2 == null && ap1 != null) {
            if (ap1.getAllowList() == null || ap1.getAllowList().isEmpty()) {
                equal = true;
            }
        } else {
            List list1 = ap1.getAllowList();
            List list2 = ap2.getAllowList();
            if (list1 == null && list2 == null) {
                equal = true;
            } else if (list1 == null && list2 != null) {
                if (list2.isEmpty()) {
                    equal = true;
                }
            } else if (list2 == null && list1 != null) {
                if (list1.isEmpty()) {
                    equal = true;
                }
            } else {
                Map<String, List<Permission>> map1 = D1NodeService.consolidateAccessRules(list1);
                Map<String, List<Permission>> map2 = D1NodeService.consolidateAccessRules(list2);
                if (map1.size() == map2.size()) {
                    block0: for (String subject : map1.keySet()) {
                        if (map2.get(subject) == null) {
                            logMetacat.debug((Object)("D1NodeService.equals - found the subject " + subject + " does exist in the first AccessPolicy but does not exist in the second AccessPolicy. So they do not equal."));
                            break;
                        }
                        List<Permission> permissions1 = map1.get(subject);
                        List<Permission> permissions2 = map2.get(subject);
                        for (Permission permission1 : permissions1) {
                            if (!permissions2.contains(permission1)) break block0;
                            permissions2.remove(permission1);
                        }
                        if (!permissions2.isEmpty()) break;
                        map2.remove(subject);
                    }
                    if (map2.isEmpty()) {
                        equal = true;
                        logMetacat.debug((Object)"D1NodeService.equals - all access rules are matched. So they equal.");
                    }
                }
            }
        }
        logMetacat.debug((Object)("D1NodeService.equals - does the two access policy object equal? - " + equal));
        return equal;
    }

    private static Map<String, List<Permission>> consolidateAccessRules(List<AccessRule> rules) {
        HashMap<String, List<Permission>> consolidatedMap = new HashMap<String, List<Permission>>();
        for (AccessRule rule : rules) {
            if (rule == null) continue;
            List subjects = rule.getSubjectList();
            List permissions = rule.getPermissionList();
            if (subjects == null || permissions == null) continue;
            for (Subject subject : subjects) {
                if (subject == null || subject.getValue() == null || subject.getValue().trim().equals("")) continue;
                for (Permission permission : permissions) {
                    if (permission == null || permission.toString().trim().equals("")) continue;
                    List<Permission> expandedPermissions = D1NodeService.expandPermissions(permission);
                    logMetacat.debug((Object)("D1NodeService.consolidateAccessRules - the expanded permission is " + expandedPermissions + " for the permission " + permission));
                    if (!consolidatedMap.containsKey(subject.getValue())) {
                        consolidatedMap.put(subject.getValue(), expandedPermissions);
                        logMetacat.debug((Object)("D1NodeService.consolidateAccessRules - put the subject " + subject.getValue() + " and the permissions " + expandedPermissions + " into the map"));
                        continue;
                    }
                    List existedPermissions = (List)consolidatedMap.get(subject.getValue());
                    for (Permission expandedPermission : expandedPermissions) {
                        if (existedPermissions.contains(expandedPermission)) continue;
                        existedPermissions.add(expandedPermission);
                        logMetacat.debug((Object)("D1NodeService.consolidateAccessRules - add a new permssion " + permission.toString() + " for the subject " + subject.getValue() + " into the map "));
                    }
                }
            }
        }
        return consolidatedMap;
    }

    static {
        try {
            MAXIMUM_DB_RECORD_COUNT = Integer.valueOf(PropertyService.getProperty("database.webResultsetSize"));
        }
        catch (Exception e) {
            logMetacat.warn((Object)"Could not set MAXIMUM_DB_RECORD_COUNT", (Throwable)e);
        }
    }
}

