/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.dataone.resourcemap;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Subject;
import org.dataone.vocabulary.CITO;
import org.dataone.vocabulary.DC_TERMS;

public class ResourceMapModifier {
    public static final String DEFAULT_CN_URI = "https://cn.dataone.org/cn";
    public static final String SLASH = "/";
    public static final String RESOLVE = "v2/resolve/";
    public static final String TERM_NAMESPACE = "http://purl.org/dc/terms/";
    public static final String CITO_NAMESPACE = "http://purl.org/spar/cito/";
    public static final String ORE_TER_NAMESPACE = "http://www.openarchives.org/ore/terms/";
    public static final String RDF_NAMESPACE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String AGGREGATION = "#aggregation";
    public static final String AGENT_URI = "http://purl.org/dc/terms/Agent";
    private static Log log = LogFactory.getLog(ResourceMapModifier.class);
    private Identifier oldResourceMapId = null;
    private Identifier newResourceMapId = null;
    private Model model = ModelFactory.createDefaultModel();
    public static String baseURI = null;

    public ResourceMapModifier(Identifier oldResourceMapId, InputStream originalResourceMap, Identifier newResourceMapId) {
        this.oldResourceMapId = oldResourceMapId;
        this.newResourceMapId = newResourceMapId;
        this.model.read(originalResourceMap, null);
    }

    public void replaceObsoletedId(Identifier obsoletedId, Identifier newId, OutputStream newResourceMap, Subject subject) throws UnsupportedEncodingException {
        Vector<String> oldURIs = new Vector<String>();
        Vector<String> newURIs = new Vector<String>();
        if (obsoletedId != null && newId != null) {
            Vector<Statement> needToRemove = new Vector<Statement>();
            Resource newResource = ResourceMapModifier.getResource(this.model, newId.getValue());
            if (newResource == null) {
                newResource = ResourceMapModifier.generateNewComponent(this.model, newId.getValue());
            }
            newURIs.add(newResource.getURI());
            Resource oldResource = ResourceMapModifier.getResource(this.model, obsoletedId.getValue());
            oldURIs.add(oldResource.getURI());
            if (oldResource != null) {
                RDFNode node = null;
                Property nullPredicate = null;
                SimpleSelector selector = new SimpleSelector(oldResource, nullPredicate, node);
                StmtIterator iterator = this.model.listStatements((Selector)selector);
                while (iterator.hasNext()) {
                    Statement statement = iterator.nextStatement();
                    RDFNode object = statement.getObject();
                    Property predicate = statement.getPredicate();
                    log.debug((Object)("ResourceMapModifer.replaceObsoletedIds - the statement with the predicate " + predicate.getLocalName() + " before replace"));
                    if (predicate == null || !predicate.equals(DC_TERMS.identifier)) {
                        Resource objResource;
                        if (object.isResource() && (objResource = (Resource)object).getURI().equals(oldResource.getURI())) {
                            object = newResource;
                        }
                        log.debug((Object)("ResourceMapModifer.replaceObsoletedIds - the statement with the predicate " + predicate.getLocalName() + " has been replaced"));
                        Statement newStatement = ResourceFactory.createStatement((Resource)newResource, (Property)predicate, (RDFNode)object);
                        this.model.add(newStatement);
                    }
                    needToRemove.add(statement);
                }
                Resource nullSubject = null;
                selector = new SimpleSelector(nullSubject, nullPredicate, (RDFNode)oldResource);
                iterator = this.model.listStatements((Selector)selector);
                while (iterator.hasNext()) {
                    Statement statement = iterator.nextStatement();
                    Resource subj = statement.getSubject();
                    Property predicate = statement.getPredicate();
                    if (subj.getURI().equals(oldResource.getURI())) {
                        subj = newResource;
                    }
                    Statement newStatement = ResourceFactory.createStatement((Resource)subj, (Property)predicate, (RDFNode)newResource);
                    this.model.add(newStatement);
                    needToRemove.add(statement);
                }
                for (Statement oldStatement : needToRemove) {
                    this.model.remove(oldStatement);
                }
            }
        }
        Resource newOreResource = ResourceMapModifier.generateNewOREResource(this.model, subject, this.newResourceMapId);
        Resource oldOreResource = ResourceMapModifier.getResource(this.model, this.oldResourceMapId.getValue());
        this.replaceAggregations(this.model, oldOreResource, newOreResource, oldURIs, newURIs);
        this.model.write(newResourceMap);
    }

    public static Resource generateNewOREResource(Model model, Subject subject, Identifier newId) throws UnsupportedEncodingException {
        String escapedNewOreId = URLEncoder.encode(newId.getValue(), "UTF-8");
        String uri = baseURI + escapedNewOreId;
        Resource resource = model.createResource(uri);
        Property identifierPred = DC_TERMS.identifier;
        Literal identifierObj = ResourceFactory.createPlainLiteral((String)newId.getValue());
        Statement state = ResourceFactory.createStatement((Resource)resource, (Property)identifierPred, (RDFNode)identifierObj);
        model.add(state);
        Property modificationPred = DC_TERMS.modified;
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        Literal modificationObj = ResourceFactory.createTypedLiteral((String)format.format(date), (RDFDatatype)XSDDatatype.XSDdateTime);
        Statement state2 = ResourceFactory.createStatement((Resource)resource, (Property)modificationPred, (RDFNode)modificationObj);
        model.add(state2);
        Property describesPred = ResourceFactory.createProperty((String)ORE_TER_NAMESPACE, (String)"describes");
        Resource describesObj = ResourceFactory.createResource((String)(uri + AGGREGATION));
        Statement state3 = ResourceFactory.createStatement((Resource)resource, (Property)describesPred, (RDFNode)describesObj);
        model.add(state3);
        Property typePred = ResourceFactory.createProperty((String)RDF_NAMESPACE, (String)"type");
        Resource typeObj = ResourceFactory.createResource((String)"http://www.openarchives.org/ore/terms/ResourceMap");
        Statement state4 = ResourceFactory.createStatement((Resource)resource, (Property)typePred, (RDFNode)typeObj);
        model.add(state4);
        Property creator = ResourceFactory.createProperty((String)"http://purl.org/dc/elements/1.1/", (String)"creator");
        Resource agent = ResourceMapModifier.generateAgentResource(subject, model);
        Statement creatorState = ResourceFactory.createStatement((Resource)resource, (Property)creator, (RDFNode)agent);
        model.add(creatorState);
        return resource;
    }

    public static Resource generateAgentResource(Subject subject, Model model) {
        Statement statement;
        String name = "Metacat";
        if (subject != null && subject.getValue() != null && !subject.getValue().trim().equals("")) {
            name = subject.getValue();
        }
        Resource creator = null;
        Property type = ResourceFactory.createProperty((String)RDF_NAMESPACE, (String)"type");
        Resource typeObj = ResourceFactory.createResource((String)AGENT_URI);
        Resource nullSubject = null;
        Property namePred = ResourceFactory.createProperty((String)"http://xmlns.com/foaf/0.1/", (String)"name");
        Literal nameObj = ResourceFactory.createPlainLiteral((String)name);
        SimpleSelector selector = new SimpleSelector(nullSubject, namePred, (RDFNode)nameObj);
        StmtIterator iterator = model.listStatements((Selector)selector);
        while (iterator.hasNext()) {
            statement = iterator.nextStatement();
            Resource subj = statement.getSubject();
            if (subj == null) continue;
            log.debug((Object)("ResourceMapModifier.generateAgentResource - found an existing agent with the name " + name + ". But we need to check if it has the type - http://purl.org/dc/terms/Agent."));
            if (!subj.hasProperty(type)) continue;
            log.debug((Object)("ResourceMapModifier.generateAgentResource - found an existing agent with the name " + name + " and it has the type we want."));
            creator = subj;
            break;
        }
        if (creator == null) {
            log.debug((Object)("ResourceMapModifier.generateAgentResource - didn't find an existing agent with the name " + name + " and a new one will be generated."));
            creator = model.createResource(AnonId.create());
            statement = ResourceFactory.createStatement((Resource)creator, (Property)type, (RDFNode)typeObj);
            model.add(statement);
            Statement nameState = ResourceFactory.createStatement((Resource)creator, (Property)namePred, (RDFNode)nameObj);
            model.add(nameState);
        }
        return creator;
    }

    private void replaceAggregations(Model model, Resource oldOREResource, Resource newOREResource, Vector<String> oldURIs, Vector<String> newURIs) {
        Statement newStatement;
        Resource newAggregation = ResourceFactory.createResource((String)(newOREResource.getURI() + AGGREGATION));
        Property predicate = ResourceFactory.createProperty((String)ORE_TER_NAMESPACE, (String)"isDescribedBy");
        Statement statement = ResourceFactory.createStatement((Resource)newAggregation, (Property)predicate, (RDFNode)newOREResource);
        model.add(statement);
        Vector<Object> needToRemove = new Vector<Object>();
        Resource oldOreAggregation = model.getResource(oldOREResource.getURI() + AGGREGATION);
        RDFNode nullNode = null;
        predicate = ResourceFactory.createProperty((String)ORE_TER_NAMESPACE, (String)"aggregates");
        SimpleSelector selector = new SimpleSelector(oldOreAggregation, predicate, nullNode);
        StmtIterator iterator = model.listStatements((Selector)selector);
        while (iterator.hasNext()) {
            Resource resource;
            Statement aggregatesState = iterator.nextStatement();
            RDFNode object = aggregatesState.getObject();
            needToRemove.add(aggregatesState);
            if (object.isResource() && oldURIs != null && oldURIs.contains((resource = (Resource)object).getURI())) continue;
            Statement statement2 = ResourceFactory.createStatement((Resource)newAggregation, (Property)predicate, (RDFNode)object);
            model.add(statement2);
        }
        if (newURIs != null) {
            for (String uri : newURIs) {
                Resource resource = model.getResource(uri);
                if (resource == null) continue;
                newStatement = ResourceFactory.createStatement((Resource)newAggregation, (Property)predicate, (RDFNode)resource);
                model.add(newStatement);
            }
        }
        Resource nullSubject = null;
        predicate = ResourceFactory.createProperty((String)ORE_TER_NAMESPACE, (String)"isAggregatedBy");
        selector = new SimpleSelector(nullSubject, predicate, (RDFNode)oldOreAggregation);
        iterator = model.listStatements((Selector)selector);
        while (iterator.hasNext()) {
            Resource subjResource;
            Statement aggregatedBystatement = iterator.nextStatement();
            Resource resource = aggregatedBystatement.getSubject();
            needToRemove.add(aggregatedBystatement);
            if (resource.isResource() && oldURIs != null && oldURIs.contains((subjResource = resource).getURI())) continue;
            newStatement = ResourceFactory.createStatement((Resource)resource, (Property)predicate, (RDFNode)newAggregation);
            model.add(newStatement);
        }
        if (newURIs != null) {
            for (String string : newURIs) {
                Resource newResource = model.getResource(string);
                if (newResource == null) continue;
                Statement newStatement3 = ResourceFactory.createStatement((Resource)newResource, (Property)predicate, (RDFNode)newAggregation);
                model.add(newStatement3);
            }
        }
        for (Statement statement3 : needToRemove) {
            model.remove(statement3);
        }
        SimpleSelector delSelector = new SimpleSelector(oldOreAggregation, null, nullNode);
        StmtIterator stmtIterator = model.listStatements((Selector)delSelector);
        model.remove(stmtIterator);
        delSelector = new SimpleSelector(oldOREResource, null, nullNode);
        StmtIterator stmtIterator2 = model.listStatements((Selector)delSelector);
        model.remove(stmtIterator2);
    }

    public static Resource generateNewComponent(Model model, String id) throws UnsupportedEncodingException {
        String escapedNewId = URLEncoder.encode(id, "UTF-8");
        String uri = baseURI + escapedNewId;
        Resource resource = model.createResource(uri);
        Property identifierPred = DC_TERMS.identifier;
        Literal identifierObj = ResourceFactory.createPlainLiteral((String)id);
        Statement state = ResourceFactory.createStatement((Resource)resource, (Property)identifierPred, (RDFNode)identifierObj);
        model.add(state);
        return resource;
    }

    public static Resource getResource(Model model, String id) {
        Resource resource = null;
        if (id != null && !id.trim().equals("")) {
            Resource subject = null;
            Property predicate = DC_TERMS.identifier;
            Literal object = ResourceFactory.createPlainLiteral((String)id);
            SimpleSelector selector = new SimpleSelector(subject, predicate, (RDFNode)object);
            StmtIterator iterator = model.listStatements((Selector)selector);
            while (iterator.hasNext()) {
                Statement statement = iterator.nextStatement();
                resource = statement.getSubject();
                if (resource == null) continue;
                log.debug((Object)("ResourceMapModifier.getResource - get the resource " + resource.getURI() + " with the identifier " + id));
                break;
            }
        }
        return resource;
    }

    public List<Identifier> getSubjectsOfDocumentedBy(Identifier metadataId) {
        return ResourceMapModifier.getSubjectsOfDocumentedBy(metadataId, this.model);
    }

    public static List<Identifier> getSubjectsOfDocumentedBy(Identifier metadataId, Model dataModel) {
        ArrayList<Identifier> subjects = new ArrayList<Identifier>();
        Resource nullSubject = null;
        Resource object = null;
        String objectId = null;
        if (metadataId != null) {
            objectId = metadataId.getValue();
            object = ResourceMapModifier.getResource(dataModel, objectId);
            log.debug((Object)("ResourceMapModifier.getSubjectsOfDocumentedBy - the object's uri is " + object.getURI() + " for the id " + objectId));
        }
        SimpleSelector selector = new SimpleSelector(nullSubject, CITO.isDocumentedBy, object);
        StmtIterator iterator = dataModel.listStatements((Selector)selector);
        while (iterator.hasNext()) {
            Literal idValue;
            String idStr;
            Statement statement = iterator.nextStatement();
            Resource subject = statement.getSubject();
            Statement idStatement = subject.getProperty(DC_TERMS.identifier);
            RDFNode idResource = idStatement.getObject();
            log.debug((Object)("ResourceMapModifier.getSubjectsOfDocumentedBy - get the identifier RDF " + idResource.toString() + " . Is the RDF literal? " + idResource.isLiteral()));
            if (idResource == null || !idResource.isLiteral() || (idStr = (idValue = (Literal)idResource).getString()) == null) continue;
            log.debug((Object)("ResourceMapModifier.getSubjectsOfDocumentedBy - add the " + idStr + " into the return list for given metadata id " + objectId));
            Identifier identifier = new Identifier();
            identifier.setValue(idStr);
            subjects.add(identifier);
        }
        return subjects;
    }

    static {
        try {
            String cnUrl = PropertyService.getProperty("D1Client.CN_URL");
            baseURI = cnUrl.endsWith(SLASH) ? cnUrl + RESOLVE : cnUrl + SLASH + RESOLVE;
        }
        catch (Exception e) {
            log.warn((Object)"ResourceMapModifier.ResourceMapModifier - couldn't get the value of the property D1Client.CN_URL and Metacat will the default production cn url as the URI base");
            baseURI = "https://cn.dataone.org/cn/v2/resolve/";
        }
    }
}

