/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.oaipmh.provider.server;

import ORG.oclc.oai.server.catalog.AbstractCatalog;
import ORG.oclc.oai.server.verb.BadVerb;
import ORG.oclc.oai.server.verb.GetRecord;
import ORG.oclc.oai.server.verb.Identify;
import ORG.oclc.oai.server.verb.ListIdentifiers;
import ORG.oclc.oai.server.verb.ListMetadataFormats;
import ORG.oclc.oai.server.verb.ListRecords;
import ORG.oclc.oai.server.verb.ListSets;
import ORG.oclc.oai.server.verb.OAIInternalServerError;
import ORG.oclc.oai.server.verb.ServerVerb;
import edu.ucsb.nceas.metacat.oaipmh.provider.server.crosswalk.Eml2oai_dc;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.SocketException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OAIHandler
extends HttpServlet {
    private static final Log log = LogFactory.getLog(OAIHandler.class);
    private static final long serialVersionUID = 1L;
    private static final String VERSION = "1.5.57";
    private static boolean debug = false;
    private static boolean integratedWithMetacat = true;
    protected HashMap attributesMap = new HashMap();
    private final String CONFIG_DIR = "WEB-INF";
    private final String CONFIG_NAME = "metacat.properties";
    private final String XSLT_DIR = "oaipmh";

    public static String getVERSION() {
        return VERSION;
    }

    public static boolean isIntegratedWithMetacat() {
        return integratedWithMetacat;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ServletConfig servletConfig = this.getServletConfig();
        String pathInfo = request.getPathInfo();
        HashMap attributes = this.getAttributes(pathInfo);
        if (!this.filterRequest(request, response)) {
            return;
        }
        log.debug((Object)("attributes=" + attributes));
        Properties properties = (Properties)attributes.get("OAIHandler.properties");
        boolean monitor = false;
        if (properties.getProperty("OAIHandler.monitor") != null) {
            monitor = true;
        }
        boolean serviceUnavailable = this.isServiceUnavailable(properties);
        HashMap serverVerbs = ServerVerb.getVerbs((Properties)properties);
        Transformer transformer = (Transformer)attributes.get("OAIHandler.transformer");
        boolean forceRender = false;
        if ("true".equals(properties.getProperty("OAIHandler.forceRender"))) {
            forceRender = true;
        }
        request.setCharacterEncoding("UTF-8");
        Date then = null;
        if (monitor) {
            then = new Date();
        }
        if (debug) {
            Enumeration headerNames = request.getHeaderNames();
            System.out.println("OAIHandler.doGet: ");
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                System.out.print(headerName);
                System.out.print(": ");
                System.out.println(request.getHeader(headerName));
            }
        }
        if (serviceUnavailable) {
            response.sendError(503, "Sorry. This server is down for maintenance");
        } else {
            try {
                String userAgent = request.getHeader("User-Agent");
                userAgent = userAgent == null ? "" : userAgent.toLowerCase();
                Transformer serverTransformer = null;
                if (transformer != null && (forceRender || userAgent.indexOf("opera") != -1 || userAgent.startsWith("mozilla") && userAgent.indexOf("msie 6") == -1)) {
                    serverTransformer = transformer;
                }
                String result = OAIHandler.getResult(attributes, request, response, serverTransformer, serverVerbs);
                Writer out = OAIHandler.getWriter(request, response);
                out.write(result);
                out.close();
            }
            catch (FileNotFoundException e) {
                if (debug) {
                    e.printStackTrace();
                    System.out.println("SC_NOT_FOUND: " + e.getMessage());
                }
                response.sendError(404, e.getMessage());
            }
            catch (TransformerException e) {
                response.sendError(500, e.getMessage());
            }
            catch (OAIInternalServerError e) {
                response.sendError(500, e.getMessage());
            }
            catch (SocketException e) {
                System.out.println(e.getMessage());
                response.sendError(500, e.getMessage());
            }
            catch (Throwable e) {
                e.printStackTrace();
                response.sendError(500, e.getMessage());
            }
        }
        if (monitor) {
            StringBuffer reqUri = new StringBuffer(request.getRequestURI().toString());
            String queryString = request.getQueryString();
            if (queryString != null) {
                reqUri.append("?").append(queryString);
            }
            Runtime rt = Runtime.getRuntime();
            System.out.println(rt.freeMemory() + "/" + rt.totalMemory() + " " + (new Date().getTime() - then.getTime()) + "ms: " + reqUri.toString());
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGet(request, response);
    }

    protected boolean filterRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    public HashMap getAttributes(Properties properties) throws Throwable {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Enumeration attrNames = this.getServletContext().getAttributeNames();
        while (attrNames.hasMoreElements()) {
            String attrName = (String)attrNames.nextElement();
            Object attrValue = this.getServletContext().getAttribute(attrName);
            attributes.put(attrName, attrValue);
        }
        attributes.put("OAIHandler.properties", properties);
        String missingVerbClassName = properties.getProperty("OAIHandler.missingVerbClassName", "ORG.oclc.oai.server.verb.BadVerb");
        Class<?> missingVerbClass = Class.forName(missingVerbClassName);
        attributes.put("OAIHandler.missingVerbClass", missingVerbClass);
        String serviceUnavailable = properties.getProperty("OAIHandler.serviceUnavailable");
        if (!"true".equals(serviceUnavailable)) {
            attributes.put("OAIHandler.version", VERSION);
            AbstractCatalog metacatCatalog = AbstractCatalog.factory((Properties)properties);
            attributes.put("OAIHandler.catalog", metacatCatalog);
        }
        boolean forceRender = false;
        if ("true".equals(properties.getProperty("OAIHandler.forceRender"))) {
            forceRender = true;
        }
        String styleSheet = properties.getProperty("OAIHandler.styleSheet");
        String appBase = properties.getProperty("OAIHandler.appBase");
        if (appBase == null) {
            appBase = "webapps";
        }
        String render = properties.getProperty("OAIHandler.renderForOldBrowsers");
        if (styleSheet != null && ("true".equalsIgnoreCase(render) || forceRender)) {
            FileInputStream is;
            try {
                is = new FileInputStream(appBase + "/" + styleSheet);
            }
            catch (FileNotFoundException e) {
                is = new FileInputStream(this.getServletContext().getRealPath(styleSheet.substring(styleSheet.indexOf("/", 1) + 1)));
            }
            StreamSource xslSource = new StreamSource(is);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(xslSource);
            attributes.put("OAIHandler.transformer", transformer);
            ((InputStream)is).close();
        }
        return attributes;
    }

    public HashMap getAttributes(String pathInfo) {
        HashMap attributes = null;
        log.debug((Object)("pathInfo=" + pathInfo));
        if (pathInfo != null && pathInfo.length() > 0) {
            if (this.attributesMap.containsKey(pathInfo)) {
                log.debug((Object)"attributesMap containsKey");
                attributes = (HashMap)this.attributesMap.get(pathInfo);
            } else {
                log.debug((Object)"!attributesMap containsKey");
                try {
                    String fileName = pathInfo.substring(1) + ".properties";
                    log.debug((Object)("attempting load of " + fileName));
                    Thread thread = Thread.currentThread();
                    ClassLoader classLoader = thread.getContextClassLoader();
                    InputStream in = classLoader.getResourceAsStream(fileName);
                    if (in != null) {
                        log.debug((Object)"file found");
                        Properties properties = new Properties();
                        properties.load(in);
                        attributes = this.getAttributes(properties);
                    } else {
                        log.debug((Object)"file not found");
                    }
                    this.attributesMap.put(pathInfo, attributes);
                }
                catch (Throwable e) {
                    log.debug((Object)"Couldn't load file", e);
                }
            }
        }
        if (attributes == null) {
            log.debug((Object)"use global attributes");
        }
        attributes = (HashMap)this.attributesMap.get("global");
        return attributes;
    }

    public static String getResult(HashMap attributes, HttpServletRequest request, HttpServletResponse response, Transformer serverTransformer, HashMap serverVerbs) throws Throwable {
        String verb = request.getParameter("verb");
        log.debug((Object)("verb: " + verb));
        String result = null;
        result = verb != null ? (verb.equals("GetRecord") ? GetRecord.construct((HashMap)attributes, (HttpServletRequest)request, (HttpServletResponse)response, (Transformer)serverTransformer) : (verb.equals("Identify") ? Identify.construct((HashMap)attributes, (HttpServletRequest)request, (HttpServletResponse)response, (Transformer)serverTransformer) : (verb.equals("ListIdentifiers") ? ListIdentifiers.construct((HashMap)attributes, (HttpServletRequest)request, (HttpServletResponse)response, (Transformer)serverTransformer) : (verb.equals("ListMetadataFormats") ? ListMetadataFormats.construct((HashMap)attributes, (HttpServletRequest)request, (HttpServletResponse)response, (Transformer)serverTransformer) : (verb.equals("ListRecords") ? ListRecords.construct((HashMap)attributes, (HttpServletRequest)request, (HttpServletResponse)response, (Transformer)serverTransformer) : (verb.equals("ListSets") ? ListSets.construct((HashMap)attributes, (HttpServletRequest)request, (HttpServletResponse)response, (Transformer)serverTransformer) : BadVerb.construct((HashMap)attributes, (HttpServletRequest)request, (HttpServletResponse)response, (Transformer)serverTransformer))))))) : BadVerb.construct((HashMap)attributes, (HttpServletRequest)request, (HttpServletResponse)response, (Transformer)serverTransformer);
        return result;
    }

    public static Writer getWriter(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Writer out;
        String encodings = request.getHeader("Accept-Encoding");
        if (debug) {
            System.out.println("encodings=" + encodings);
        }
        if (encodings != null && encodings.indexOf("gzip") != -1) {
            response.setHeader("Content-Encoding", "gzip");
            out = new OutputStreamWriter((OutputStream)new GZIPOutputStream((OutputStream)response.getOutputStream()), "UTF-8");
        } else if (encodings != null && encodings.indexOf("deflate") != -1) {
            response.setHeader("Content-Encoding", "deflate");
            out = new OutputStreamWriter((OutputStream)new DeflaterOutputStream((OutputStream)response.getOutputStream()), "UTF-8");
        } else {
            out = response.getWriter();
        }
        return out;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (OAIHandler.isIntegratedWithMetacat()) {
            try {
                PropertyService.getInstance();
            }
            catch (ServiceException se) {
                System.err.println("Error in loading properties: " + se.getMessage());
            }
        }
        ServletContext servletContext = config.getServletContext();
        String configDirPath = servletContext.getRealPath("WEB-INF");
        String configPath = configDirPath + "/" + "metacat.properties";
        String xsltDirPath = servletContext.getRealPath("oaipmh");
        Eml2oai_dc.setDirPath(xsltDirPath);
        InputStream in = null;
        try {
            HashMap attributes = null;
            Properties properties = null;
            try {
                log.debug((Object)("configPath=" + configPath));
                in = new FileInputStream(configPath);
            }
            catch (FileNotFoundException e) {
                log.debug((Object)("configPath not found. Try the classpath: " + configPath));
                Thread thread = Thread.currentThread();
                ClassLoader classLoader = thread.getContextClassLoader();
                in = classLoader.getResourceAsStream(configPath);
            }
            if (in != null) {
                log.debug((Object)("configPath '" + configPath + "' found. Loading properties"));
                properties = new Properties();
                properties.load(in);
                attributes = this.getAttributes(properties);
            }
            this.attributesMap.put("global", attributes);
            in.close();
        }
        catch (FileNotFoundException e) {
            try {
                e.printStackTrace();
                throw new ServletException(e.getMessage());
                catch (ClassNotFoundException e2) {
                    e2.printStackTrace();
                    throw new ServletException(e2.getMessage());
                }
                catch (IllegalArgumentException e3) {
                    e3.printStackTrace();
                    throw new ServletException(e3.getMessage());
                }
                catch (IOException e4) {
                    e4.printStackTrace();
                    throw new ServletException(e4.getMessage());
                }
                catch (Throwable e5) {
                    e5.printStackTrace();
                    throw new ServletException(e5.getMessage());
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    protected boolean isServiceUnavailable(Properties properties) {
        return properties.getProperty("OAIHandler.serviceUnavailable") != null;
    }
}

