/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.properties;

import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.service.ServiceService;
import edu.ucsb.nceas.metacat.shared.BaseService;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.metacat.util.SkinUtil;
import edu.ucsb.nceas.utilities.FileUtil;
import edu.ucsb.nceas.utilities.GeneralPropertyException;
import edu.ucsb.nceas.utilities.MetaDataProperty;
import edu.ucsb.nceas.utilities.PropertiesMetaData;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.SortedProperties;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SkinPropertyService
extends BaseService {
    private static SkinPropertyService skinService = null;
    private static boolean bypassAlreadyChecked = false;
    private static String BACKUP_DIR = null;
    private static Vector<String> skinNames = null;
    private static HashMap<String, SortedProperties> skinPropertiesMap = null;
    private static HashMap<String, SortedProperties> skinBackupPropertiesMap = null;
    private static HashMap<String, PropertiesMetaData> skinMetaDataMap = null;
    private static Log logMetacat = LogFactory.getLog(SkinPropertyService.class);

    private SkinPropertyService() throws ServiceException {
        try {
            this._serviceName = "SkinPropertyService";
            this.initialize();
        }
        catch (GeneralPropertyException gpe) {
            throw new ServiceException("Properties problem while initializing SkinPropertyService: " + gpe.getMessage());
        }
        catch (IOException ioe) {
            throw new ServiceException("I/O Problem while initializing SkinPropertyService: " + ioe.getMessage());
        }
    }

    public static SkinPropertyService getInstance() throws ServiceException {
        if (skinService == null) {
            skinService = new SkinPropertyService();
        }
        return skinService;
    }

    @Override
    public boolean refreshable() {
        return true;
    }

    @Override
    public void doRefresh() throws ServiceException {
        try {
            this.initialize();
        }
        catch (IOException ioe) {
            throw new ServiceException("Could not refresh SkinPropertyService due to I/O error: " + ioe.getMessage());
        }
        catch (GeneralPropertyException gpe) {
            throw new ServiceException("Could not refresh SkinPropertyService due to property error: " + gpe.getMessage());
        }
    }

    @Override
    public void stop() throws ServiceException {
    }

    private void initialize() throws IOException, GeneralPropertyException, ServiceException {
        logMetacat.debug((Object)"Initializing SkinService");
        BACKUP_DIR = PropertyService.getProperty("application.backupDir");
        skinNames = SkinUtil.getSkinNames();
        skinPropertiesMap = new HashMap();
        skinBackupPropertiesMap = new HashMap();
        skinMetaDataMap = new HashMap();
        try {
            for (String skinName : skinNames) {
                String propertyFilePath = ServiceService.getRealSkinDir() + FileUtil.getFS() + skinName + FileUtil.getFS() + skinName + ".properties";
                if (FileUtil.getFileStatus((String)propertyFilePath) < FileUtil.EXISTS_READ_WRITABLE) {
                    logMetacat.error((Object)("Skin property file: " + propertyFilePath + " does not exist read/writable. This skin will not be available."));
                    continue;
                }
                SortedProperties skinProperties = new SortedProperties(propertyFilePath);
                skinProperties.load();
                skinPropertiesMap.put(skinName, skinProperties);
                String metaDataFilePath = ServiceService.getRealSkinDir() + FileUtil.getFS() + skinName + FileUtil.getFS() + skinName + ".properties.metadata.xml";
                if (FileUtil.getFileStatus((String)metaDataFilePath) <= FileUtil.DOES_NOT_EXIST) {
                    skinPropertiesMap.remove(skinName);
                    logMetacat.error((Object)("Could not find skin property metadata file for skin: " + skinName + " at: " + metaDataFilePath + ". This skin will not be available."));
                    continue;
                }
                PropertiesMetaData skinMetaData = new PropertiesMetaData(metaDataFilePath);
                skinMetaDataMap.put(skinName, skinMetaData);
                String backupPropertyFilePath = BACKUP_DIR + FileUtil.getFS() + skinName + ".properties.backup";
                if (FileUtil.getFileStatus((String)backupPropertyFilePath) > FileUtil.DOES_NOT_EXIST) {
                    SortedProperties skinBackupProperties = new SortedProperties(backupPropertyFilePath);
                    skinBackupProperties.load();
                    skinBackupPropertiesMap.put(skinName, skinBackupProperties);
                    continue;
                }
                logMetacat.warn((Object)("Could not find backup properties for skin: " + skinName + " at: " + backupPropertyFilePath));
            }
        }
        catch (TransformerException te) {
            throw new GeneralPropertyException(te.getMessage());
        }
    }

    public static String getProperty(String skinName, String propertyName) throws PropertyNotFoundException {
        SortedProperties skinProperties = skinPropertiesMap.get(skinName);
        if (skinProperties == null) {
            throw new PropertyNotFoundException("There is not property map for " + skinName);
        }
        return skinProperties.getProperty(propertyName);
    }

    public static Vector<String> getPropertyNames(String skinName) throws PropertyNotFoundException {
        SortedProperties skinProperties = skinPropertiesMap.get(skinName);
        if (skinProperties == null) {
            throw new PropertyNotFoundException("There is not property map for " + skinName);
        }
        return skinProperties.getPropertyNames();
    }

    public static Vector<String> getPropertyNamesByGroup(String skinName, String groupName) throws PropertyNotFoundException {
        SortedProperties skinProperties = skinPropertiesMap.get(skinName);
        if (skinProperties == null) {
            throw new PropertyNotFoundException("There is not property map for " + skinName);
        }
        return skinProperties.getPropertyNamesByGroup(groupName);
    }

    public static HashMap<String, SortedProperties> getProperties() {
        return skinPropertiesMap;
    }

    public static SortedProperties getProperties(String skinName) {
        return skinPropertiesMap.get(skinName);
    }

    public static HashMap<String, SortedProperties> getBackupProperties() {
        return skinBackupPropertiesMap;
    }

    public static SortedProperties getBackupProperties(String skinName) {
        return skinBackupPropertiesMap.get(skinName);
    }

    public static HashMap<String, PropertiesMetaData> getMetaData() {
        return skinMetaDataMap;
    }

    public static PropertiesMetaData getMetaData(String skinName) {
        return skinMetaDataMap.get(skinName);
    }

    public static void setProperty(String skinName, String propertyName, String newValue) throws IOException, GeneralPropertyException {
        SortedProperties skinProperties = skinPropertiesMap.get(skinName);
        if (skinProperties == null) {
            throw new GeneralPropertyException("There is not property map for " + skinName);
        }
        skinProperties.setProperty(propertyName, newValue);
        skinProperties.store();
    }

    public static void setPropertyNoPersist(String skinName, String propertyName, String newValue) throws GeneralPropertyException {
        SortedProperties skinProperties = skinPropertiesMap.get(skinName);
        if (skinProperties == null) {
            throw new GeneralPropertyException("There is not property map for " + skinName);
        }
        skinProperties.setPropertyNoPersist(propertyName, newValue);
    }

    public static void persistProperties(String skinName) throws IOException, GeneralPropertyException {
        SortedProperties skinProperties = skinPropertiesMap.get(skinName);
        if (skinProperties == null) {
            throw new GeneralPropertyException("There is not property map for " + skinName);
        }
        skinProperties.store();
    }

    public static void persistAllProperties() throws IOException, GeneralPropertyException {
        for (String skinName : skinNames) {
            SkinPropertyService.persistProperties(skinName);
        }
    }

    public static void persistBackupProperties(String skinName) throws GeneralPropertyException {
        try {
            String metaDataFilePath = ServiceService.getRealSkinDir() + FileUtil.getFS() + skinName + FileUtil.getFS() + skinName + ".properties.metadata.xml";
            String backupPropertyFilePath = BACKUP_DIR + FileUtil.getFS() + skinName + ".properties.backup";
            SortedProperties backupProperties = new SortedProperties(backupPropertyFilePath);
            PropertiesMetaData skinMetadata = new PropertiesMetaData(metaDataFilePath);
            Map skinKeyMap = skinMetadata.getProperties();
            Set skinKeySet = skinKeyMap.keySet();
            for (String propertyKey : skinKeySet) {
                MetaDataProperty metaData = (MetaDataProperty)skinKeyMap.get(propertyKey);
                if (metaData.getFieldType().equals("password")) continue;
                backupProperties.addProperty(propertyKey, SkinPropertyService.getProperty(skinName, propertyKey));
            }
            backupProperties.store();
        }
        catch (TransformerException te) {
            throw new GeneralPropertyException("Could not transform backup properties xml: " + te.getMessage());
        }
        catch (IOException ioe) {
            throw new GeneralPropertyException("Could not backup configurable properties: " + ioe.getMessage());
        }
        catch (ServiceException se) {
            throw new GeneralPropertyException("Could not get skins property file: " + se.getMessage());
        }
    }

    public static boolean areSkinsConfigured() throws MetacatUtilException {
        try {
            return !PropertyService.getProperty("configutil.skinsConfigured").equals("false");
        }
        catch (PropertyNotFoundException pnfe) {
            throw new MetacatUtilException("Could not determine if skins are configured: " + pnfe.getMessage());
        }
    }

    public static void checkAndSetProperty(HttpServletRequest request, String skinName, String propertyName) throws GeneralPropertyException {
        String newValue = request.getParameter(skinName + "." + propertyName);
        SkinPropertyService.checkAndSetProperty(newValue, skinName, propertyName);
    }

    public static void checkAndSetProperty(String newValue, String skinName, String propertyName) throws GeneralPropertyException {
        String oldValue = SkinPropertyService.getProperty(skinName, propertyName);
        if (newValue != null && !newValue.equals(oldValue)) {
            SkinPropertyService.setPropertyNoPersist(skinName, propertyName, newValue);
        }
    }

    public static boolean bypassConfiguration() {
        boolean bypass = false;
        if (bypassAlreadyChecked) {
            return bypass;
        }
        try {
            String strRunConfiguration = PropertyService.getProperty("dev.runConfiguration");
            boolean bl = bypass = !Boolean.parseBoolean(strRunConfiguration);
            if (!bypass) {
                bypassAlreadyChecked = true;
                return false;
            }
            for (String skinName : skinNames) {
                SortedProperties backupProperties = SkinPropertyService.getBackupProperties(skinName);
                Vector backupPropertyNames = backupProperties.getPropertyNames();
                for (String backupPropertyName : backupPropertyNames) {
                    String value = backupProperties.getProperty(backupPropertyName);
                    backupProperties.setPropertyNoPersist(backupPropertyName, value);
                }
                backupProperties.store();
            }
        }
        catch (PropertyNotFoundException pnfe) {
            logMetacat.error((Object)("Could not find property: " + pnfe.getMessage()));
        }
        catch (GeneralPropertyException gpe) {
            logMetacat.error((Object)("General property error: " + gpe.getMessage()));
        }
        bypassAlreadyChecked = true;
        return bypass;
    }
}

