/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.legacy;

import org.apache.lucene.document.DoubleDocValuesField;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.queries.function.FunctionMatchQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.lucene.spatial.query.UnsupportedSpatialOperation;
import org.apache.solr.legacy.DistanceValueSource;
import org.apache.solr.legacy.LegacyDoubleField;
import org.apache.solr.legacy.LegacyFieldType;
import org.apache.solr.legacy.LegacyNumericRangeQuery;
import org.apache.solr.legacy.LegacyNumericType;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;

public class PointVectorStrategy
extends SpatialStrategy {
    public static FieldType DEFAULT_FIELDTYPE;
    @Deprecated
    public static LegacyFieldType LEGACY_FIELDTYPE;
    public static final String SUFFIX_X = "__x";
    public static final String SUFFIX_Y = "__y";
    private final String fieldNameX;
    private final String fieldNameY;
    private final int fieldsLen;
    private final boolean hasStored;
    private final boolean hasDocVals;
    private final boolean hasPointVals;
    private final LegacyFieldType legacyNumericFieldType;

    public static PointVectorStrategy newInstance(SpatialContext ctx, String fieldNamePrefix) {
        return new PointVectorStrategy(ctx, fieldNamePrefix, DEFAULT_FIELDTYPE);
    }

    @Deprecated
    public static PointVectorStrategy newLegacyInstance(SpatialContext ctx, String fieldNamePrefix) {
        return new PointVectorStrategy(ctx, fieldNamePrefix, LEGACY_FIELDTYPE);
    }

    public PointVectorStrategy(SpatialContext ctx, String fieldNamePrefix, FieldType fieldType) {
        super(ctx, fieldNamePrefix);
        this.fieldNameX = fieldNamePrefix + SUFFIX_X;
        this.fieldNameY = fieldNamePrefix + SUFFIX_Y;
        int numPairs = 0;
        this.hasStored = fieldType.stored();
        if (this.hasStored) {
            ++numPairs;
        }
        if (this.hasDocVals = fieldType.docValuesType() != DocValuesType.NONE) {
            ++numPairs;
        }
        if (this.hasPointVals = fieldType.pointDimensionCount() > 0) {
            ++numPairs;
        }
        if (fieldType.indexOptions() != IndexOptions.NONE && fieldType instanceof LegacyFieldType && ((LegacyFieldType)fieldType).numericType() != null) {
            if (this.hasPointVals) {
                throw new IllegalArgumentException("pointValues and LegacyNumericType are mutually exclusive");
            }
            LegacyFieldType legacyType = (LegacyFieldType)fieldType;
            if (legacyType.numericType() != LegacyNumericType.DOUBLE) {
                throw new IllegalArgumentException(((Object)((Object)this)).getClass() + " does not support " + (Object)((Object)legacyType.numericType()));
            }
            ++numPairs;
            this.legacyNumericFieldType = new LegacyFieldType(LegacyDoubleField.TYPE_NOT_STORED);
            this.legacyNumericFieldType.setNumericPrecisionStep(legacyType.numericPrecisionStep());
            this.legacyNumericFieldType.freeze();
        } else {
            this.legacyNumericFieldType = null;
        }
        this.fieldsLen = numPairs * 2;
    }

    String getFieldNameX() {
        return this.fieldNameX;
    }

    String getFieldNameY() {
        return this.fieldNameY;
    }

    public Field[] createIndexableFields(Shape shape) {
        if (shape instanceof Point) {
            return this.createIndexableFields((Point)shape);
        }
        throw new UnsupportedOperationException("Can only index Point, not " + shape);
    }

    public Field[] createIndexableFields(Point point) {
        Field[] fields = new Field[this.fieldsLen];
        int idx = -1;
        if (this.hasStored) {
            fields[++idx] = new StoredField(this.fieldNameX, point.getX());
            fields[++idx] = new StoredField(this.fieldNameY, point.getY());
        }
        if (this.hasDocVals) {
            fields[++idx] = new DoubleDocValuesField(this.fieldNameX, point.getX());
            fields[++idx] = new DoubleDocValuesField(this.fieldNameY, point.getY());
        }
        if (this.hasPointVals) {
            fields[++idx] = new DoublePoint(this.fieldNameX, new double[]{point.getX()});
            fields[++idx] = new DoublePoint(this.fieldNameY, new double[]{point.getY()});
        }
        if (this.legacyNumericFieldType != null) {
            fields[++idx] = new LegacyDoubleField(this.fieldNameX, point.getX(), this.legacyNumericFieldType);
            fields[++idx] = new LegacyDoubleField(this.fieldNameY, point.getY(), this.legacyNumericFieldType);
        }
        assert (idx == fields.length - 1);
        return fields;
    }

    public DoubleValuesSource makeDistanceValueSource(Point queryPoint, double multiplier) {
        return new DistanceValueSource(this, queryPoint, multiplier);
    }

    public ConstantScoreQuery makeQuery(SpatialArgs args) {
        if (!SpatialOperation.is((SpatialOperation)args.getOperation(), (SpatialOperation[])new SpatialOperation[]{SpatialOperation.Intersects, SpatialOperation.IsWithin})) {
            throw new UnsupportedSpatialOperation(args.getOperation());
        }
        Shape shape = args.getShape();
        if (shape instanceof Rectangle) {
            Rectangle bbox = (Rectangle)shape;
            return new ConstantScoreQuery(this.makeWithin(bbox));
        }
        if (shape instanceof Circle) {
            Circle circle = (Circle)shape;
            Rectangle bbox = circle.getBoundingBox();
            Query approxQuery = this.makeWithin(bbox);
            BooleanQuery.Builder bqBuilder = new BooleanQuery.Builder();
            double r = circle.getRadius();
            FunctionMatchQuery vsMatchQuery = new FunctionMatchQuery(this.makeDistanceValueSource(circle.getCenter()), v -> 0.0 <= v && v <= r);
            bqBuilder.add(approxQuery, BooleanClause.Occur.FILTER);
            bqBuilder.add((Query)vsMatchQuery, BooleanClause.Occur.FILTER);
            return new ConstantScoreQuery((Query)bqBuilder.build());
        }
        throw new UnsupportedOperationException("Only Rectangles and Circles are currently supported, found [" + shape.getClass() + "]");
    }

    private Query makeWithin(Rectangle bbox) {
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        BooleanClause.Occur MUST = BooleanClause.Occur.MUST;
        if (bbox.getCrossesDateLine()) {
            bq.add(this.rangeQuery(this.fieldNameX, null, bbox.getMaxX()), BooleanClause.Occur.SHOULD);
            bq.add(this.rangeQuery(this.fieldNameX, bbox.getMinX(), null), BooleanClause.Occur.SHOULD);
            bq.setMinimumNumberShouldMatch(1);
        } else {
            bq.add(this.rangeQuery(this.fieldNameX, bbox.getMinX(), bbox.getMaxX()), MUST);
        }
        bq.add(this.rangeQuery(this.fieldNameY, bbox.getMinY(), bbox.getMaxY()), MUST);
        return bq.build();
    }

    private Query rangeQuery(String fieldName, Double min, Double max) {
        if (this.hasPointVals) {
            if (min == null) {
                min = Double.NEGATIVE_INFINITY;
            }
            if (max == null) {
                max = Double.POSITIVE_INFINITY;
            }
            return DoublePoint.newRangeQuery((String)fieldName, (double)min, (double)max);
        }
        if (this.legacyNumericFieldType != null) {
            return LegacyNumericRangeQuery.newDoubleRange(fieldName, this.legacyNumericFieldType.numericPrecisionStep(), min, max, true, true);
        }
        throw new UnsupportedOperationException("An index is required for this operation.");
    }

    static {
        FieldType type = new FieldType();
        type.setDimensions(1, 8);
        type.setDocValuesType(DocValuesType.NUMERIC);
        type.setStored(false);
        type.freeze();
        DEFAULT_FIELDTYPE = type;
        LegacyFieldType legacyType = new LegacyFieldType();
        legacyType.setIndexOptions(IndexOptions.DOCS);
        legacyType.setNumericType(LegacyNumericType.DOUBLE);
        legacyType.setNumericPrecisionStep(8);
        legacyType.setDocValuesType(DocValuesType.NONE);
        legacyType.setStored(false);
        legacyType.freeze();
        LEGACY_FIELDTYPE = legacyType;
    }
}

