/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.HTMLTable;

public class FlexTable
extends HTMLTable {
    private static native void addCells(Element var0, int var1, int var2);

    public FlexTable() {
        this.setCellFormatter(new FlexCellFormatter());
        this.setRowFormatter(new HTMLTable.RowFormatter(this));
        this.setColumnFormatter(new HTMLTable.ColumnFormatter(this));
    }

    public void addCell(int row) {
        this.insertCell(row, this.getCellCount(row));
    }

    public int getCellCount(int row) {
        this.checkRowBounds(row);
        return super.getDOMCellCount(this.getBodyElement(), row);
    }

    public FlexCellFormatter getFlexCellFormatter() {
        return (FlexCellFormatter)this.getCellFormatter();
    }

    public int getRowCount() {
        return this.getDOMRowCount();
    }

    public void insertCell(int beforeRow, int beforeColumn) {
        super.insertCell(beforeRow, beforeColumn);
    }

    public int insertRow(int beforeRow) {
        return super.insertRow(beforeRow);
    }

    public void removeCell(int row, int col) {
        super.removeCell(row, col);
    }

    public void removeCells(int row, int column, int num) {
        for (int i = 0; i < num; ++i) {
            this.removeCell(row, column);
        }
    }

    public void removeRow(int row) {
        super.removeRow(row);
    }

    protected void prepareCell(int row, int column) {
        this.prepareRow(row);
        if (column < 0) {
            throw new IndexOutOfBoundsException("Cannot create a column with a negative index: " + column);
        }
        int cellCount = this.getCellCount(row);
        int required = column + 1 - cellCount;
        if (required > 0) {
            FlexTable.addCells(this.getBodyElement(), row, required);
        }
    }

    protected void prepareRow(int row) {
        int rowCount;
        if (row < 0) {
            throw new IndexOutOfBoundsException("Cannot create a row with a negative index: " + row);
        }
        for (int i = rowCount = this.getRowCount(); i <= row; ++i) {
            this.insertRow(i);
        }
    }

    public class FlexCellFormatter
    extends HTMLTable.CellFormatter {
        public FlexCellFormatter() {
            super(FlexTable.this);
        }

        public int getColSpan(int row, int column) {
            return DOM.getIntAttribute(this.getElement(row, column), "colSpan");
        }

        public int getRowSpan(int row, int column) {
            return DOM.getIntAttribute(this.getElement(row, column), "rowSpan");
        }

        public void setColSpan(int row, int column, int colSpan) {
            DOM.setIntAttribute(this.ensureElement(row, column), "colSpan", colSpan);
        }

        public void setRowSpan(int row, int column, int rowSpan) {
            DOM.setIntAttribute(this.ensureElement(row, column), "rowSpan", rowSpan);
        }
    }
}

