/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc.impl;

import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.SerializationStreamWriter;
import com.google.gwt.user.client.rpc.impl.AbstractSerializationStreamWriter;
import com.google.gwt.user.server.rpc.impl.ServerSerializableTypeOracle;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;

public final class ServerSerializationStreamWriter
extends AbstractSerializationStreamWriter {
    private static final int NUMBER_OF_JS_ESCAPED_CHARS = 128;
    private static final char[] JS_CHARS_ESCAPED;
    private static final char JS_ESCAPE_CHAR = '\\';
    private static final char JS_QUOTE_CHAR = '\"';
    private int objectCount;
    private IdentityHashMap objectMap = new IdentityHashMap();
    private ServerSerializableTypeOracle serializableTypeOracle;
    private HashMap stringMap = new HashMap();
    private ArrayList stringTable = new ArrayList();
    private ArrayList tokenList = new ArrayList();
    private int tokenListCharCount;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static String escapeString(String toEscape) {
        char[] input = toEscape.toCharArray();
        char[] output = new char[input.length * 2 + 2];
        int j = 0;
        output[j] = 34;
        int n = input.length;
        for (int i = 0; i < n; ++i) {
            char c = input[i];
            if (c < '\u0080' && JS_CHARS_ESCAPED[c] != '\u0000') {
                output[++j] = 92;
                output[++j] = JS_CHARS_ESCAPED[c];
                continue;
            }
            output[++j] = c;
        }
        output[++j] = 34;
        return String.valueOf(output, 0, ++j);
    }

    public ServerSerializationStreamWriter(ServerSerializableTypeOracle serializableTypeOracle) {
        this.serializableTypeOracle = serializableTypeOracle;
    }

    public void prepareToWrite() {
        this.objectCount = 0;
        this.objectMap.clear();
        this.tokenList.clear();
        this.tokenListCharCount = 0;
        this.stringMap.clear();
        this.stringTable.clear();
    }

    public void serializeValue(Object value, Class type) throws SerializationException {
        if (type == Boolean.TYPE) {
            this.writeBoolean((Boolean)value);
        } else if (type == Byte.TYPE) {
            this.writeByte((Byte)value);
        } else if (type == Character.TYPE) {
            this.writeChar(((Character)value).charValue());
        } else if (type == Double.TYPE) {
            this.writeDouble((Double)value);
        } else if (type == Float.TYPE) {
            this.writeFloat(((Float)value).floatValue());
        } else if (type == Integer.TYPE) {
            this.writeInt((Integer)value);
        } else if (type == Long.TYPE) {
            this.writeLong((Long)value);
        } else if (type == Short.TYPE) {
            this.writeShort((Short)value);
        } else if (type == String.class) {
            this.writeString((String)value);
        } else {
            this.writeObject(value);
        }
    }

    public String toString() {
        int capacityGuess = 2 * this.tokenListCharCount + 2 * this.tokenList.size();
        StringBuffer buffer = new StringBuffer(capacityGuess);
        buffer.append("[");
        this.writePayload(buffer);
        this.writeStringTable(buffer);
        this.writeHeader(buffer);
        buffer.append("]");
        return buffer.toString();
    }

    protected int addString(String string) {
        if (string == null) {
            return 0;
        }
        Integer o = (Integer)this.stringMap.get(string);
        if (o != null) {
            return o;
        }
        this.stringTable.add(string);
        int index = this.stringTable.size();
        this.stringMap.put(string, new Integer(index));
        return index;
    }

    protected void append(String token) {
        this.tokenList.add(token);
        if (token != null) {
            this.tokenListCharCount += token.length();
        }
    }

    protected int getIndexForObject(Object instance) {
        Integer o = (Integer)this.objectMap.get(instance);
        if (o != null) {
            return o;
        }
        return -1;
    }

    protected String getObjectTypeSignature(Object instance) {
        if (this.shouldEnforceTypeVersioning()) {
            return this.serializableTypeOracle.encodeSerializedInstanceReference(instance.getClass());
        }
        return this.serializableTypeOracle.getSerializedTypeName(instance.getClass());
    }

    protected void saveIndexForObject(Object instance) {
        this.objectMap.put(instance, new Integer(this.objectCount++));
    }

    protected void serialize(Object instance, String typeSignature) throws SerializationException {
        this.serializeImpl(instance, instance.getClass());
    }

    private void serializeClass(Object instance, Class instanceClass) throws SerializationException {
        if (!$assertionsDisabled && instance == null) {
            throw new AssertionError();
        }
        Field[] declFields = instanceClass.getDeclaredFields();
        Field[] serializableFields = this.serializableTypeOracle.applyFieldSerializationPolicy(declFields);
        for (int index = 0; index < serializableFields.length; ++index) {
            boolean needsAccessOverride;
            Field declField = serializableFields[index];
            if (!$assertionsDisabled && declField == null) {
                throw new AssertionError();
            }
            boolean isAccessible = declField.isAccessible();
            boolean bl = needsAccessOverride = !isAccessible && !Modifier.isPublic(declField.getModifiers());
            if (needsAccessOverride) {
                declField.setAccessible(true);
            }
            try {
                Object value = declField.get(instance);
                this.serializeValue(value, declField.getType());
            }
            catch (IllegalArgumentException e) {
                throw new SerializationException(e);
            }
            catch (IllegalAccessException e) {
                throw new SerializationException(e);
            }
            if (!needsAccessOverride) continue;
            declField.setAccessible(isAccessible);
        }
        Class superClass = instanceClass.getSuperclass();
        if (superClass != null && this.serializableTypeOracle.isSerializable(superClass)) {
            this.serializeImpl(instance, superClass);
        }
    }

    private void serializeImpl(Object instance, Class instanceClass) throws SerializationException {
        if (!$assertionsDisabled && instance == null) {
            throw new AssertionError();
        }
        Class customSerializer = this.serializableTypeOracle.hasCustomFieldSerializer(instanceClass);
        if (customSerializer != null) {
            this.serializeWithCustomSerializer(customSerializer, instance, instanceClass);
        } else {
            if (!$assertionsDisabled && instanceClass.isArray()) {
                throw new AssertionError();
            }
            this.serializeClass(instance, instanceClass);
        }
    }

    private void serializeWithCustomSerializer(Class customSerializer, Object instance, Class instanceClass) throws SerializationException {
        try {
            Class<?> componentType;
            if (instanceClass.isArray() && !(componentType = instanceClass.getComponentType()).isPrimitive()) {
                instanceClass = Class.forName("[Ljava.lang.Object;");
            }
            Method serialize = customSerializer.getMethod("serialize", SerializationStreamWriter.class, instanceClass);
            serialize.invoke(null, this, instance);
        }
        catch (SecurityException e) {
            throw new SerializationException(e);
        }
        catch (NoSuchMethodException e) {
            throw new SerializationException(e);
        }
        catch (IllegalArgumentException e) {
            throw new SerializationException(e);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException(e);
        }
        catch (InvocationTargetException e) {
            throw new SerializationException(e);
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException(e);
        }
    }

    private void writeHeader(StringBuffer buffer) {
        buffer.append(",");
        buffer.append(this.getFlags());
        buffer.append(",");
        buffer.append(2);
    }

    private void writePayload(StringBuffer buffer) {
        for (int i = this.tokenList.size() - 1; i >= 0; --i) {
            String token = (String)this.tokenList.get(i);
            buffer.append(token);
            if (i <= 0) continue;
            buffer.append(",");
        }
    }

    private void writeStringTable(StringBuffer buffer) {
        if (this.tokenList.size() > 0) {
            buffer.append(",");
        }
        buffer.append("[");
        int c = this.stringTable.size();
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(ServerSerializationStreamWriter.escapeString((String)this.stringTable.get(i)));
        }
        buffer.append("]");
    }

    static {
        $assertionsDisabled = !ServerSerializationStreamWriter.class.desiredAssertionStatus();
        JS_CHARS_ESCAPED = new char[128];
        ServerSerializationStreamWriter.JS_CHARS_ESCAPED[0] = 48;
        ServerSerializationStreamWriter.JS_CHARS_ESCAPED[8] = 98;
        ServerSerializationStreamWriter.JS_CHARS_ESCAPED[9] = 116;
        ServerSerializationStreamWriter.JS_CHARS_ESCAPED[10] = 110;
        ServerSerializationStreamWriter.JS_CHARS_ESCAPED[11] = 118;
        ServerSerializationStreamWriter.JS_CHARS_ESCAPED[12] = 102;
        ServerSerializationStreamWriter.JS_CHARS_ESCAPED[13] = 114;
        ServerSerializationStreamWriter.JS_CHARS_ESCAPED[92] = 92;
        ServerSerializationStreamWriter.JS_CHARS_ESCAPED[34] = 34;
    }
}

