/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.io;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.BufferingWriter;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.io.Writer2;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.riot.out.CharSpace;
import org.apache.jena.riot.system.IRILib;

public class IO {
    public static final int EOF = -1;
    public static final int UNSET = -2;
    private static Charset utf8 = StandardCharsets.UTF_8;
    private static Charset ascii = StandardCharsets.US_ASCII;
    private static final int BUFFER_SIZE = 32768;

    public static InputStream openFile(String filename) {
        try {
            return IO.openFileEx(filename);
        }
        catch (Exception ex) {
            throw new RuntimeIOException(ex);
        }
    }

    public static InputStream openFileEx(String filename) throws IOException, FileNotFoundException {
        if (filename == null || filename.equals("-")) {
            return System.in;
        }
        if (filename.startsWith("file:")) {
            filename = filename.substring("file:".length());
            filename = IRILib.decode(filename);
        }
        InputStream in = new FileInputStream(filename);
        if (filename.endsWith(".gz")) {
            in = new GZIPInputStream(in);
        }
        return in;
    }

    public static Reader openFileUTF8(String filename) {
        return IO.openFileReader(filename, utf8);
    }

    public static Reader openFileASCII(String filename) {
        return IO.openFileReader(filename, ascii);
    }

    private static Reader openFileReader(String filename, Charset charset) {
        InputStream in = IO.openFile(filename);
        return new InputStreamReader(in, charset);
    }

    public static Reader asUTF8(InputStream in) {
        return new InputStreamReader(in, utf8.newDecoder());
    }

    public static Reader asASCII(InputStream in) {
        return new InputStreamReader(in, ascii.newDecoder());
    }

    public static BufferedReader asBufferedUTF8(InputStream in) {
        return new BufferedReader(IO.asUTF8(in));
    }

    public static Writer asUTF8(OutputStream out) {
        return new OutputStreamWriter(out, utf8.newEncoder());
    }

    public static Writer asASCII(OutputStream out) {
        return new OutputStreamWriter(out, ascii.newEncoder());
    }

    public static Writer asBufferedUTF8(OutputStream out) {
        OutputStreamWriter w = new OutputStreamWriter(out, utf8.newEncoder());
        return new BufferingWriter(w);
    }

    public static OutputStream openOutputFile(String filename) {
        try {
            return IO.openOutputFileEx(filename);
        }
        catch (IOException ex) {
            IO.exception(ex);
            return null;
        }
    }

    public static OutputStream openOutputFileEx(String filename) throws FileNotFoundException, IOException {
        if (filename == null || filename.equals("-")) {
            return System.out;
        }
        if (filename.startsWith("file:")) {
            filename = filename.substring("file:".length());
            filename = IRILib.decode(filename);
        }
        OutputStream out = new FileOutputStream(filename);
        if (filename.endsWith(".gz")) {
            out = new GZIPOutputStream(out);
        }
        return out;
    }

    public static AWriter wrap(Writer w) {
        return Writer2.wrap(w);
    }

    public static AWriter wrapUTF8(OutputStream out) {
        return IO.wrap(out, CharSpace.UTF8);
    }

    public static AWriter wrapASCII(OutputStream out) {
        return IO.wrap(out, CharSpace.ASCII);
    }

    public static AWriter wrap(OutputStream out, CharSpace charSpace) {
        switch (charSpace) {
            case UTF8: {
                return IO.wrap(IO.asUTF8(out));
            }
            case ASCII: {
                return IO.wrap(IO.asASCII(out));
            }
        }
        return null;
    }

    public static PrintWriter asPrintWriterUTF8(OutputStream out) {
        return new PrintWriter(IO.asUTF8(out));
    }

    public static void close(Closeable resource) {
        resource.close();
    }

    public static void closeSilent(Closeable resource) {
        try {
            resource.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(java.io.Closeable resource) {
        if (resource == null) {
            return;
        }
        try {
            resource.close();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    public static void closeSilent(java.io.Closeable resource) {
        if (resource == null) {
            return;
        }
        try {
            resource.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(AWriter resource) {
        if (resource == null) {
            return;
        }
        resource.close();
    }

    public static void closeSilent(AWriter resource) {
        if (resource == null) {
            return;
        }
        try {
            resource.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(IndentedWriter resource) {
        if (resource == null) {
            return;
        }
        resource.close();
    }

    public static void closeSilent(IndentedWriter resource) {
        if (resource == null) {
            return;
        }
        try {
            resource.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void exception(IOException ex) {
        throw new RuntimeIOException(ex);
    }

    public static void exception(String msg, IOException ex) {
        throw new RuntimeIOException(msg, ex);
    }

    public static void flush(OutputStream out) {
        if (out == null) {
            return;
        }
        try {
            out.flush();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    public static void flush(Writer out) {
        if (out == null) {
            return;
        }
        try {
            out.flush();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    public static void flush(AWriter out) {
        if (out == null) {
            return;
        }
        out.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readWholeFile(InputStream in) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream(32768);){
            byte[] buff = new byte[32768];
            while (true) {
                int l;
                if ((l = in.read(buff)) <= 0) {
                    byte[] byArray = out.toByteArray();
                    return byArray;
                }
                out.write(buff, 0, l);
            }
        }
        catch (IOException ex) {
            IO.exception(ex);
            return null;
        }
    }

    public static String readWholeFileAsUTF8(String filename) throws IOException {
        try (FileInputStream in = new FileInputStream(filename);){
            String string = IO.readWholeFileAsUTF8(in);
            return string;
        }
    }

    public static String readWholeFileAsUTF8(InputStream in) throws IOException {
        try (Reader r = IO.asUTF8(in);){
            String string = IO.readWholeFileAsUTF8(r);
            return string;
        }
    }

    private static String readWholeFileAsUTF8(Reader r) throws IOException {
        try (StringWriter sw = new StringWriter(32768);){
            int l;
            char[] buff = new char[32768];
            while ((l = r.read(buff)) >= 0) {
                sw.write(buff, 0, l);
            }
            String string = sw.toString();
            return string;
        }
    }

    public static String uniqueFilename(String directory, String base, String ext) {
        File d = new File(directory);
        if (!d.exists()) {
            throw new IllegalArgumentException("Not found: " + directory);
        }
        try {
            String fn0;
            String fn = fn0 = d.getCanonicalPath() + File.separator + base;
            int x = 1;
            while (true) {
                File f;
                if (ext != null) {
                    fn = fn + "." + ext;
                }
                if (!(f = new File(fn)).exists()) {
                    return fn;
                }
                fn = fn0 + "-" + x++;
            }
        }
        catch (IOException e2) {
            IO.exception(e2);
            return null;
        }
    }
}

