/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model.impl;

import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.expression.Expression;
import com.thoughtworks.qdox.model.impl.AbstractJavaEntity;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJavaField
extends AbstractJavaEntity
implements JavaField {
    private JavaClass type;
    private String initializationExpression;
    private boolean enumConstant;
    private JavaClass enumConstantClass;
    private List<Expression> enumConstantArguments;

    public DefaultJavaField(String name) {
        this.setName(name);
    }

    public DefaultJavaField(JavaClass type, String name) {
        this(name);
        this.type = type;
    }

    @Override
    public JavaClass getType() {
        return this.type;
    }

    @Override
    public String getCodeBlock() {
        return this.getModelWriter().writeField(this).toString();
    }

    public void setType(JavaClass type) {
        this.type = type;
    }

    @Override
    public String getInitializationExpression() {
        return this.initializationExpression;
    }

    public void setInitializationExpression(String initializationExpression) {
        this.initializationExpression = initializationExpression;
    }

    @Override
    public boolean isEnumConstant() {
        return this.enumConstant;
    }

    public void setEnumConstant(boolean enumConstant) {
        this.enumConstant = enumConstant;
    }

    @Override
    public List<Expression> getEnumConstantArguments() {
        return this.enumConstantArguments;
    }

    public void setEnumConstantArguments(List<Expression> enumConstantArguments) {
        this.enumConstantArguments = enumConstantArguments;
    }

    @Override
    public JavaClass getEnumConstantClass() {
        return this.enumConstantClass;
    }

    public void setEnumConstantClass(JavaClass enumConstantClass) {
        this.enumConstantClass = enumConstantClass;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.isPrivate()) {
            result.append("private ");
        } else if (this.isProtected()) {
            result.append("protected ");
        } else if (this.isPublic()) {
            result.append("public ");
        }
        if (this.isStatic()) {
            result.append("static ");
        }
        if (this.isFinal()) {
            result.append("final ");
        }
        if (this.isTransient()) {
            result.append("transient ");
        }
        if (this.isVolatile()) {
            result.append("volatile ");
        }
        result.append(this.type.getValue()).append(' ');
        result.append(this.getDeclaringClass().getFullyQualifiedName()).append('.').append(this.getName());
        return result.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JavaField)) {
            return false;
        }
        JavaField fld = (JavaField)obj;
        if (!fld.getDeclaringClass().equals(this.getDeclaringClass())) {
            return false;
        }
        if (!fld.isEnumConstant() == this.isEnumConstant()) {
            return false;
        }
        return fld.getName().equals(this.getName());
    }

    public int hashCode() {
        int hashCode = 5;
        if (this.getDeclaringClass() != null) {
            hashCode *= 31 + this.getDeclaringClass().hashCode();
        }
        if (this.getName() != null) {
            hashCode *= 37 + this.getName().hashCode();
        }
        return hashCode;
    }
}

