/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.geohash.util;

import ch.hsr.geohash.GeoHash;
import ch.hsr.geohash.util.TwoGeoHashBoundingBox;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public class BoundingBoxSampler {
    private TwoGeoHashBoundingBox boundingBox;
    private Set<Integer> alreadyUsed = new HashSet<Integer>();
    private int maxSamples;
    private Random rand = new Random();

    public BoundingBoxSampler(TwoGeoHashBoundingBox bbox) {
        this.boundingBox = bbox;
        long maxSamplesLong = GeoHash.stepsBetween(bbox.getBottomLeft(), bbox.getTopRight());
        if (maxSamplesLong > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("This bounding box is too big too sample using this algorithm");
        }
        this.maxSamples = (int)maxSamplesLong;
    }

    public BoundingBoxSampler(TwoGeoHashBoundingBox bbox, long seed) {
        this(bbox);
        this.rand = new Random(seed);
    }

    public TwoGeoHashBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public GeoHash next() {
        if (this.alreadyUsed.size() == this.maxSamples) {
            return null;
        }
        int idx = this.rand.nextInt(this.maxSamples + 1);
        while (this.alreadyUsed.contains(idx)) {
            idx = this.rand.nextInt(this.maxSamples + 1);
        }
        this.alreadyUsed.add(idx);
        GeoHash gh = this.boundingBox.getBottomLeft().next(idx);
        if (!this.boundingBox.getBoundingBox().contains(gh.getPoint())) {
            return this.next();
        }
        return gh;
    }
}

