/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.index.processor;

import org.apache.log4j.Logger;
import org.dataone.cn.index.processor.IndexTaskProcessor;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.InterruptableJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

@DisallowConcurrentExecution
public class IndexTaskProcessorJob
implements InterruptableJob {
    private static Logger logger = Logger.getLogger((String)IndexTaskProcessorJob.class.getName());
    private static ApplicationContext context;
    private static IndexTaskProcessor processor;
    private static int jobIdentityHash;

    public void execute(JobExecutionContext arg0) throws JobExecutionException {
        logger.warn((Object)("processing job [" + jobIdentityHash + "/" + this + "] executing index task with processor [" + processor + "]"));
        IndexTaskProcessorJob.setContext();
        processor.processIndexTaskQueue();
        logger.warn((Object)("processing job [" + this + "] finished execution of index task processor [" + processor + "]"));
    }

    private static void setContext() {
        if (context == null || processor == null) {
            context = new ClassPathXmlApplicationContext("processor-daemon-context.xml");
            processor = (IndexTaskProcessor)context.getBean("indexTaskProcessor");
        }
    }

    public void interrupt() throws UnableToInterruptJobException {
        logger.warn((Object)("IndexTaskProcessorJob [" + this + "] interrupted, shutting down processor [" + processor + "]"));
        IndexTaskProcessorJob.interruptCurrent();
    }

    public static void interruptCurrent() throws UnableToInterruptJobException {
        try {
            logger.warn((Object)("IndexTaskProcessorJob class [" + jobIdentityHash + "] interruptCurrent called, shutting down processor [" + processor + "]"));
            processor.shutdownExecutor();
        }
        catch (Throwable t) {
            UnableToInterruptJobException e = new UnableToInterruptJobException("Unable to shutdown the executorService that is processing index tasks.");
            e.initCause(t);
            throw e;
        }
    }

    static {
        jobIdentityHash = System.identityHashCode(IndexTaskProcessorJob.class);
    }
}

