/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import org.apache.solr.common.AlreadyClosedException;
import org.apache.solr.common.cloud.ConnectionManager;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkOperation;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

public class ZkCmdExecutor {
    private long retryDelay = 1500L;
    private int retryCount;
    private double timeouts;
    private ConnectionManager.IsClosed isClosed;

    public ZkCmdExecutor(int timeoutms) {
        this(timeoutms, null);
    }

    public ZkCmdExecutor(int timeoutms, ConnectionManager.IsClosed isClosed) {
        this.timeouts = (double)timeoutms / 1000.0;
        this.retryCount = Math.round(0.5f * ((float)Math.sqrt(8.0 * this.timeouts + 1.0) - 1.0f)) + 1;
        this.isClosed = isClosed;
    }

    public long getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(long retryDelay) {
        this.retryDelay = retryDelay;
    }

    public <T> T retryOperation(ZkOperation operation) throws KeeperException, InterruptedException {
        KeeperException.ConnectionLossException exception = null;
        for (int i = 0; i < this.retryCount; ++i) {
            try {
                if (i > 0 && this.isClosed()) {
                    throw new AlreadyClosedException();
                }
                return (T)operation.execute();
            }
            catch (KeeperException.ConnectionLossException e) {
                if (exception == null) {
                    exception = e;
                }
                if (Thread.currentThread().isInterrupted()) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedException();
                }
                if (i == this.retryCount - 1) continue;
                this.retryDelay(i);
                continue;
            }
        }
        throw exception;
    }

    private boolean isClosed() {
        return this.isClosed != null && this.isClosed.isClosed();
    }

    public void ensureExists(String path, SolrZkClient zkClient) throws KeeperException, InterruptedException {
        this.ensureExists(path, null, CreateMode.PERSISTENT, zkClient, 0);
    }

    public void ensureExists(String path, byte[] data, SolrZkClient zkClient) throws KeeperException, InterruptedException {
        this.ensureExists(path, data, CreateMode.PERSISTENT, zkClient, 0);
    }

    public void ensureExists(String path, byte[] data, CreateMode createMode, SolrZkClient zkClient) throws KeeperException, InterruptedException {
        this.ensureExists(path, data, createMode, zkClient, 0);
    }

    public void ensureExists(String path, byte[] data, CreateMode createMode, SolrZkClient zkClient, int skipPathParts) throws KeeperException, InterruptedException {
        if (zkClient.exists(path, true).booleanValue()) {
            return;
        }
        try {
            zkClient.makePath(path, data, createMode, null, true, true, skipPathParts);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            // empty catch block
        }
    }

    protected void retryDelay(int attemptCount) throws InterruptedException {
        Thread.sleep((long)(attemptCount + 1) * this.retryDelay);
    }
}

