/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.classdiagram.command.CommandCreateEntityClass2;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;
import net.sourceforge.plantuml.cucadiagram.Entity;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.skin.VisibilityModifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandCreateEntityClassMultilines2
extends CommandMultilines2<ClassDiagram> {
    public CommandCreateEntityClassMultilines2(ClassDiagram classDiagram) {
        super(classDiagram, CommandCreateEntityClassMultilines2.getRegexConcat(), "(?i)^\\s*\\}\\s*$");
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("TYPE", "(interface|enum|abstract\\s+class|abstract|class)\\s+"), new RegexOr(new RegexLeaf("NAME1", "(?:\"([^\"]+)\"\\s+as\\s+)?(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)"), new RegexLeaf("NAME2", "(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)\\s+as\\s+\"([^\"]+)\""), new RegexLeaf("NAME3", "\"([^\"]+)\"")), new RegexLeaf("STEREO", "(?:\\s*([\\<\\[]{2}.*[\\>\\]]{2}))?"), new RegexLeaf("EXTENDS", "(\\s+(extends|implements)\\s+(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*))?"), new RegexLeaf("\\s*\\{\\s*$"));
    }

    @Override
    public CommandExecutionResult execute(List<String> list) {
        StringUtils.trim(list, true);
        Map<String, RegexPartialMatch> map = this.getStartingPattern().matcher(list.get(0).trim());
        Entity entity = this.executeArg0(map);
        if (entity == null) {
            return CommandExecutionResult.error("No such entity");
        }
        for (String string : list.subList(1, list.size() - 1)) {
            assert (string.length() > 0);
            if (VisibilityModifier.isVisibilityCharacter(string.charAt(0))) {
                ((ClassDiagram)this.getSystem()).setVisibilityModifierPresent(true);
            }
            entity.addFieldOrMethod(string);
        }
        CommandCreateEntityClass2.manageExtends((ClassDiagram)this.getSystem(), map, entity);
        return CommandExecutionResult.ok();
    }

    private Entity executeArg0(Map<String, RegexPartialMatch> map) {
        String string;
        String string2;
        EntityType entityType = EntityType.getEntityType(map.get("TYPE").get(0).toUpperCase());
        if (map.get("NAME1").get(1) != null) {
            string2 = map.get("NAME1").get(1);
            string = map.get("NAME1").get(0);
        } else if (map.get("NAME3").get(0) != null) {
            string2 = map.get("NAME3").get(0);
            string = map.get("NAME3").get(0);
        } else {
            string2 = map.get("NAME2").get(0);
            string = map.get("NAME2").get(1);
        }
        String string3 = map.get("STEREO").get(0);
        if (((ClassDiagram)this.getSystem()).entityExist(string2)) {
            Entity entity = (Entity)((ClassDiagram)this.getSystem()).getOrCreateClass(string2);
            entity.muteToType(entityType);
            return entity;
        }
        Entity entity = ((ClassDiagram)this.getSystem()).createEntity(string2, string, entityType);
        if (string3 != null) {
            entity.setStereotype(new Stereotype(string3, ((ClassDiagram)this.getSystem()).getSkinParam().getCircledCharacterRadius(), ((ClassDiagram)this.getSystem()).getSkinParam().getFont(FontParam.CIRCLED_CHARACTER, null)));
        }
        return entity;
    }
}

