/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.PSystem;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommandMultilines<S extends PSystem>
implements Command {
    private final S system;
    private final Pattern starting;
    private final Pattern ending;

    public CommandMultilines(S s, String string, String string2) {
        if (!string.startsWith("(?i)^") || !string.endsWith("$")) {
            throw new IllegalArgumentException("Bad pattern " + string);
        }
        if (!string2.startsWith("(?i)^") || !string2.endsWith("$")) {
            throw new IllegalArgumentException("Bad pattern " + string2);
        }
        this.system = s;
        this.starting = Pattern.compile(string);
        this.ending = Pattern.compile(string2);
    }

    @Override
    public String[] getDescription() {
        return new String[]{"START: " + this.starting.pattern(), "END: " + this.ending.pattern()};
    }

    @Override
    public final CommandControl isValid(List<String> list) {
        if (this.isCommandForbidden()) {
            return CommandControl.NOT_OK;
        }
        Matcher matcher = this.starting.matcher(list.get(0).trim());
        if (!matcher.matches()) {
            return CommandControl.NOT_OK;
        }
        if (list.size() == 1) {
            return CommandControl.OK_PARTIAL;
        }
        matcher = this.ending.matcher(list.get(list.size() - 1).trim());
        if (!matcher.matches()) {
            return CommandControl.OK_PARTIAL;
        }
        this.actionIfCommandValid();
        return CommandControl.OK;
    }

    protected boolean isCommandForbidden() {
        return false;
    }

    protected void actionIfCommandValid() {
    }

    protected S getSystem() {
        return this.system;
    }

    protected final Pattern getStartingPattern() {
        return this.starting;
    }

    protected final Pattern getEnding() {
        return this.ending;
    }

    @Override
    public boolean isDeprecated(List<String> list) {
        return false;
    }

    @Override
    public String getHelpMessageForDeprecated(List<String> list) {
        return null;
    }
}

