/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentRoseReference
extends AbstractTextualComponent {
    private final HtmlColor backgroundHeader;
    private final HtmlColor borderColor;
    private final HtmlColor background;
    private final int cornersize = 10;
    private final TextBlock textHeader;
    private final double heightFooter = 5.0;
    private final double xMargin = 2.0;
    private final HorizontalAlignement position;

    public ComponentRoseReference(HtmlColor htmlColor, HtmlColor htmlColor2, UFont uFont, HtmlColor htmlColor3, HtmlColor htmlColor4, HtmlColor htmlColor5, UFont uFont2, List<? extends CharSequence> list, HorizontalAlignement horizontalAlignement) {
        super(list.subList(1, list.size()), htmlColor, uFont, HorizontalAlignement.LEFT, 4, 4, 4);
        this.position = horizontalAlignement;
        this.backgroundHeader = htmlColor4;
        this.background = htmlColor5;
        this.borderColor = htmlColor3;
        this.textHeader = TextBlockUtils.create(list.subList(0, 1), new FontConfiguration(uFont2, htmlColor2), HorizontalAlignement.LEFT);
    }

    @Override
    protected void drawInternalU(UGraphic uGraphic, Dimension2D dimension2D) {
        double d;
        StringBounder stringBounder = uGraphic.getStringBounder();
        int n = (int)this.getHeaderWidth(stringBounder);
        int n2 = (int)this.getHeaderHeight(stringBounder);
        uGraphic.getParam().setStroke(new UStroke(2.0));
        URectangle uRectangle = new URectangle(dimension2D.getWidth() - 4.0, dimension2D.getHeight() - 5.0);
        uGraphic.getParam().setColor(this.borderColor);
        uGraphic.getParam().setBackcolor(this.background);
        uGraphic.draw(2.0, 0.0, uRectangle);
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(n, 0.0);
        uPolygon.addPoint(n, n2 - 10);
        uPolygon.addPoint(n - 10, n2);
        uPolygon.addPoint(0.0, n2);
        uPolygon.addPoint(0.0, 0.0);
        uGraphic.getParam().setColor(this.borderColor);
        uGraphic.getParam().setBackcolor(this.backgroundHeader);
        uGraphic.draw(2.0, 0.0, uPolygon);
        uGraphic.getParam().setStroke(new UStroke());
        this.textHeader.drawU(uGraphic, 15.0, 2.0);
        if (this.position == HorizontalAlignement.CENTER) {
            double d2 = this.getTextBlock().calculateDimension(stringBounder).getWidth();
            d = (dimension2D.getWidth() - d2) / 2.0;
        } else if (this.position == HorizontalAlignement.RIGHT) {
            double d3 = this.getTextBlock().calculateDimension(stringBounder).getWidth();
            d = dimension2D.getWidth() - d3 - (double)this.getMarginX2() - 2.0;
        } else {
            d = (double)this.getMarginX1() + 2.0;
        }
        this.getTextBlock().drawU(uGraphic, d, this.getMarginY() + n2);
    }

    private double getHeaderHeight(StringBounder stringBounder) {
        Dimension2D dimension2D = this.textHeader.calculateDimension(stringBounder);
        return dimension2D.getHeight() + 2.0;
    }

    private double getHeaderWidth(StringBounder stringBounder) {
        Dimension2D dimension2D = this.textHeader.calculateDimension(stringBounder);
        return dimension2D.getWidth() + 30.0 + 15.0;
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + this.getHeaderHeight(stringBounder) + 5.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return Math.max(this.getTextWidth(stringBounder), this.getHeaderWidth(stringBounder)) + 4.0;
    }
}

