/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svg;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.cucadiagram.dot.CucaDiagramFileMaker;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.VerticalPosition;
import net.sourceforge.plantuml.svg.SvgData;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.svg.UGraphicSvg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SvgTitler {
    private final List<String> text;
    private final HorizontalAlignement horizontalAlignement;
    private final VerticalPosition verticalPosition;
    private final int margin;
    private final TextBlock textBloc;
    private final ColorMapper colorMapper;

    public SvgTitler(ColorMapper colorMapper, HtmlColor htmlColor, List<String> list, int n, String string, HorizontalAlignement horizontalAlignement, VerticalPosition verticalPosition, int n2) {
        this.text = list;
        this.colorMapper = colorMapper;
        this.horizontalAlignement = horizontalAlignement;
        this.verticalPosition = verticalPosition;
        this.margin = n2;
        if (list == null || list.size() == 0) {
            this.textBloc = null;
        } else {
            UFont uFont = new UFont(string, 0, n);
            this.textBloc = TextBlockUtils.create(list, new FontConfiguration(uFont, htmlColor), HorizontalAlignement.LEFT);
        }
    }

    public SvgData addTitle(SvgData svgData) throws IOException {
        int n;
        double d;
        if (this.text == null || this.text.size() == 0) {
            return svgData;
        }
        UGraphicSvg uGraphicSvg = new UGraphicSvg(this.colorMapper, false);
        Dimension2D dimension2D = this.textBloc.calculateDimension(uGraphicSvg.getStringBounder());
        double d2 = svgData.getWidth();
        double d3 = svgData.getHeight();
        if (this.horizontalAlignement == HorizontalAlignement.LEFT) {
            d = 2.0;
        } else if (this.horizontalAlignement == HorizontalAlignement.RIGHT) {
            d = d2 - dimension2D.getWidth() - 2.0;
        } else if (this.horizontalAlignement == HorizontalAlignement.CENTER) {
            d = (d2 - dimension2D.getWidth()) / 2.0;
        } else {
            d = 0.0;
            assert (false);
        }
        double d4 = 0.0;
        if (dimension2D.getWidth() > d2) {
            d4 = dimension2D.getWidth() - d2;
        }
        double d5 = this.verticalPosition == VerticalPosition.TOP ? 0.0 : d3 + (double)this.margin;
        this.textBloc.drawU(uGraphicSvg, d, d5);
        String string = CucaDiagramFileMaker.getSvg(uGraphicSvg);
        string = string.replaceFirst("(?i)<g>", "<g transform=\"translate(0 0)\">");
        String string2 = svgData.getSvg();
        if (this.verticalPosition == VerticalPosition.TOP) {
            Pattern pattern = Pattern.compile("(?i)translate\\((\\d+)\\s+(\\d+)");
            Matcher matcher = pattern.matcher(string2);
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                int n2 = Integer.parseInt(matcher.group(1));
                int n3 = Integer.parseInt(matcher.group(2)) + (int)dimension2D.getHeight() + this.margin;
                matcher.appendReplacement(stringBuffer, "translate(" + n2 + " " + n3);
            }
            matcher.appendTail(stringBuffer);
            string2 = stringBuffer.toString();
        }
        if ((n = string2.indexOf("<g ")) == -1) {
            throw new IllegalStateException();
        }
        string2 = string2.substring(0, n) + string + string2.substring(n);
        return svgData.mutateFromSvgTitler(string2, dimension2D.getHeight() + (double)this.margin, d4);
    }
}

