/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.swing;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.sourceforge.plantuml.GeneratedImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimpleLine2
implements Comparable<SimpleLine2> {
    private final File file;
    private final GeneratedImage generatedImage;
    private final Future<List<GeneratedImage>> future;

    public SimpleLine2(File file, GeneratedImage generatedImage, Future<List<GeneratedImage>> future) {
        this.generatedImage = generatedImage;
        this.file = file;
        this.future = future;
    }

    public File getFile() {
        return this.file;
    }

    public boolean pendingAndFinished() {
        return this.generatedImage == null && this.future.isDone();
    }

    public List<SimpleLine2> getFutureTerminated() throws InterruptedException, ExecutionException {
        if (this.future == null) {
            throw new IllegalStateException();
        }
        List<GeneratedImage> list = this.future.get();
        if (list == null) {
            return null;
        }
        ArrayList<SimpleLine2> arrayList = new ArrayList<SimpleLine2>();
        for (GeneratedImage generatedImage : list) {
            arrayList.add(new SimpleLine2(this.file, generatedImage, null));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public String toString() {
        if (this.generatedImage == null) {
            return this.file.getName() + " (...pending...)";
        }
        StringBuilder stringBuilder = new StringBuilder(this.generatedImage.getPngFile().getName());
        stringBuilder.append(" ");
        stringBuilder.append(this.generatedImage.getDescription());
        return stringBuilder.toString();
    }

    public Future<List<GeneratedImage>> getFuture() {
        return this.future;
    }

    @Override
    public int compareTo(SimpleLine2 simpleLine2) {
        return this.toString().compareTo(simpleLine2.toString());
    }

    public GeneratedImage getGeneratedImage() {
        return this.generatedImage;
    }
}

