/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.UncommentReadLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    public static String getPlateformDependentAbsolutePath(File file) {
        return file.getAbsolutePath();
    }

    public static List<String> getWithNewlines(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\' && i < string.length() + 1) {
                char c2 = string.charAt(i + 1);
                ++i;
                if (c2 == 'n') {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    continue;
                }
                if (c2 == 't') {
                    stringBuilder.append('\t');
                    continue;
                }
                if (c2 != '\\') continue;
                stringBuilder.append(c2);
                continue;
            }
            stringBuilder.append(c);
        }
        arrayList.add(stringBuilder.toString());
        return Collections.unmodifiableList(arrayList);
    }

    public static String getMergedLines(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append(list.get(i));
            if (i >= list.size() - 1) continue;
            stringBuilder.append("\\n");
        }
        return stringBuilder.toString();
    }

    public static final List<String> getSplit(Pattern pattern, String string) {
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 1; i <= matcher.groupCount(); ++i) {
            arrayList.add(matcher.group(i));
        }
        return arrayList;
    }

    public static boolean isNotEmpty(String string) {
        return string != null && string.trim().length() > 0;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static String manageHtml(String string) {
        string = string.replace("<", "&lt;");
        string = string.replace(">", "&gt;");
        return string;
    }

    public static String manageArrowForSequence(String string) {
        string = string.replace('=', '-');
        return string;
    }

    public static String manageArrowForCuca(String string) {
        Direction direction = StringUtils.getArrowDirection(string);
        string = string.replace('=', '-');
        string = string.replaceAll("\\w*", "");
        if (direction == Direction.LEFT || direction == Direction.RIGHT) {
            string = string.replaceAll("-+", "-");
        }
        if (string.length() == 2 && (direction == Direction.UP || direction == Direction.DOWN)) {
            string = string.replaceFirst("-", "--");
        }
        return string;
    }

    public static String manageQueueForCuca(String string) {
        Direction direction = StringUtils.getQueueDirection(string);
        string = string.replace('=', '-');
        string = string.replaceAll("\\w*", "");
        if (direction == Direction.LEFT || direction == Direction.RIGHT) {
            string = string.replaceAll("-+", "-");
        }
        if (string.length() == 1 && (direction == Direction.UP || direction == Direction.DOWN)) {
            string = string.replaceFirst("-", "--");
        }
        return string;
    }

    public static Direction getArrowDirection(String string) {
        if (string.endsWith(">")) {
            return StringUtils.getQueueDirection(string.substring(0, string.length() - 1));
        }
        if (string.startsWith("<")) {
            if (string.length() == 2) {
                return Direction.LEFT;
            }
            return Direction.UP;
        }
        throw new IllegalArgumentException(string);
    }

    public static Direction getQueueDirection(String string) {
        if (string.indexOf(60) != -1 || string.indexOf(62) != -1) {
            throw new IllegalArgumentException(string);
        }
        if ((string = string.toLowerCase()).contains("left")) {
            return Direction.LEFT;
        }
        if (string.contains("right")) {
            return Direction.RIGHT;
        }
        if (string.contains("up")) {
            return Direction.UP;
        }
        if (string.contains("down")) {
            return Direction.DOWN;
        }
        if (string.contains("l")) {
            return Direction.LEFT;
        }
        if (string.contains("r")) {
            return Direction.RIGHT;
        }
        if (string.contains("u")) {
            return Direction.UP;
        }
        if (string.contains("d")) {
            return Direction.DOWN;
        }
        if (string.length() == 1) {
            return Direction.RIGHT;
        }
        return Direction.DOWN;
    }

    public static String eventuallyRemoveStartingAndEndingDoubleQuote(String string) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        if (string.startsWith("(") && string.endsWith(")")) {
            return string.substring(1, string.length() - 1);
        }
        if (string.startsWith("[") && string.endsWith("]")) {
            return string.substring(1, string.length() - 1);
        }
        if (string.startsWith(":") && string.endsWith(":")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static boolean isCJK(char c) {
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
        System.err.println(unicodeBlock);
        return false;
    }

    public static char hiddenLesserThan() {
        return '\u0005';
    }

    public static char hiddenBiggerThan() {
        return '\u0006';
    }

    public static String hideComparatorCharacters(String string) {
        string = string.replace('<', StringUtils.hiddenLesserThan());
        string = string.replace('>', StringUtils.hiddenBiggerThan());
        return string;
    }

    public static String showComparatorCharacters(String string) {
        string = string.replace(StringUtils.hiddenLesserThan(), '<');
        string = string.replace(StringUtils.hiddenBiggerThan(), '>');
        return string;
    }

    public static int getWidth(List<? extends CharSequence> list) {
        int n = 1;
        for (CharSequence charSequence : list) {
            if (n >= charSequence.length()) continue;
            n = charSequence.length();
        }
        return n;
    }

    public static int getHeight(List<? extends CharSequence> list) {
        return list.size();
    }

    private static boolean firstColumnRemovable(List<String> list) {
        boolean bl = true;
        for (String string : list) {
            if (string.length() == 0) continue;
            bl = false;
            char c = string.charAt(0);
            if (c == ' ' || c == '\t') continue;
            return false;
        }
        return !bl;
    }

    private static void removeFirstColumn(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (string.length() <= 0) continue;
            list.set(i, string.substring(1));
        }
    }

    public static List<String> removeEmptyColumns(List<String> list) {
        if (!StringUtils.firstColumnRemovable(list)) {
            return list;
        }
        ArrayList<String> arrayList = new ArrayList<String>(list);
        do {
            StringUtils.removeFirstColumn(arrayList);
        } while (StringUtils.firstColumnRemovable(arrayList));
        return Collections.unmodifiableList(arrayList);
    }

    public static void trim(List<String> list, boolean bl) {
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            list.set(i, string.trim());
        }
        if (bl) {
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().length() != 0) continue;
                iterator.remove();
            }
        }
    }

    public static String uncommentSource(String string) {
        StringReader stringReader = new StringReader(string);
        UncommentReadLine uncommentReadLine = new UncommentReadLine(new ReadLineReader(stringReader));
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = null;
        try {
            while ((string2 = uncommentReadLine.readLine()) != null) {
                stringBuilder.append(string2);
                stringBuilder.append('\n');
            }
        }
        catch (IOException iOException) {
            Log.error("Error " + iOException);
            throw new IllegalStateException(iOException.toString());
        }
        stringReader.close();
        return stringBuilder.toString();
    }

    public static boolean isDiagramCacheable(String string) {
        if ((string = string.toLowerCase()).startsWith("@startuml\nversion\n")) {
            return false;
        }
        if (string.startsWith("@startuml\ntestdot\n")) {
            return false;
        }
        return !string.startsWith("@startuml\nsudoku\n");
    }

    public static List<String> splitComma(String string) {
        if (!(string = string.trim()).matches("([\\p{L}0-9_.]+|\"[^\"]+\")(\\s*,\\s*([\\p{L}0-9_.]+|\"[^\"]+\"))*")) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Pattern pattern = Pattern.compile("([\\p{L}0-9_.]+|\"[^\"]+\")");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            arrayList.add(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(matcher.group(0)));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static String getAsHtml(Color color) {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        int n = 0xFFFFFF & color.getRGB();
        String string = "000000" + Integer.toHexString(n).toUpperCase();
        string = string.substring(string.length() - 6);
        return "#" + string;
    }
}

