/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmbededDiagram;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.EmbededSystemLine;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.FontStyle;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.Line;
import net.sourceforge.plantuml.graphic.SingleLine;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UGraphic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TextBlockSimple
implements TextBlock {
    private final List<Line> lines = new ArrayList<Line>();

    protected TextBlockSimple(List<? extends CharSequence> list, FontConfiguration fontConfiguration, HorizontalAlignement horizontalAlignement) {
        for (CharSequence charSequence : list) {
            if (charSequence instanceof Stereotype) {
                this.lines.add(this.createLineForStereotype(fontConfiguration, (Stereotype)charSequence, horizontalAlignement));
                continue;
            }
            if (charSequence instanceof EmbededDiagram) {
                this.lines.add(new EmbededSystemLine((EmbededDiagram)charSequence));
                continue;
            }
            this.lines.add(new SingleLine(((Object)charSequence).toString(), fontConfiguration, horizontalAlignement));
        }
    }

    private SingleLine createLineForStereotype(FontConfiguration fontConfiguration, Stereotype stereotype, HorizontalAlignement horizontalAlignement) {
        assert (stereotype.getLabel() != null);
        return new SingleLine(stereotype.getLabel(), fontConfiguration.add(FontStyle.ITALIC), horizontalAlignement);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.getTextDimension(stringBounder);
    }

    protected final Dimension2D getTextDimension(StringBounder stringBounder) {
        double d = 0.0;
        double d2 = 0.0;
        for (Line line : this.lines) {
            Dimension2D dimension2D = line.calculateDimension(stringBounder);
            d2 += dimension2D.getHeight();
            d = Math.max(d, dimension2D.getWidth());
        }
        return new Dimension2DDouble(d, d2);
    }

    @Override
    public void drawTOBEREMOVED(ColorMapper colorMapper, Graphics2D graphics2D, double d, double d2) {
        Dimension2D dimension2D = this.getTextDimension(StringBounderUtils.asStringBounder(graphics2D));
        for (Line line : this.lines) {
            HorizontalAlignement horizontalAlignement = line.getHorizontalAlignement();
            double d3 = 0.0;
            if (horizontalAlignement == HorizontalAlignement.CENTER) {
                double d4 = dimension2D.getWidth() - line.calculateDimension(StringBounderUtils.asStringBounder(graphics2D)).getWidth();
                d3 = d4 / 2.0;
            }
            line.draw(colorMapper, graphics2D, d + d3, d2);
            d2 += line.calculateDimension(StringBounderUtils.asStringBounder(graphics2D)).getHeight();
        }
    }

    @Override
    public void drawU(UGraphic uGraphic, double d, double d2) {
        Dimension2D dimension2D = this.getTextDimension(uGraphic.getStringBounder());
        for (Line line : this.lines) {
            HorizontalAlignement horizontalAlignement = line.getHorizontalAlignement();
            double d3 = 0.0;
            if (horizontalAlignement == HorizontalAlignement.CENTER) {
                double d4 = dimension2D.getWidth() - line.calculateDimension(uGraphic.getStringBounder()).getWidth();
                d3 = d4 / 2.0;
            }
            line.drawU(uGraphic, d + d3, d2);
            d2 += line.calculateDimension(uGraphic.getStringBounder()).getHeight();
        }
    }
}

